/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.policies;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.BendpointConnectionRouter;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.tools.DragEditPartsTracker;
import org.eclipse.stardust.modeling.core.editors.figures.AbstractConnectionSymbolFigure;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.AbstractConnectionSymbolEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.AbstractNodeSymbolEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.policies.ConnectionBendpointEditPolicy;

public class DragEditPartsTrackerWithExplicitBendpoints
extends DragEditPartsTracker {
    public DragEditPartsTrackerWithExplicitBendpoints(EditPart editPart) {
        super(editPart);
    }

    protected Command getCommand() {
        if (this.isMove() && this.getTargetRequest() instanceof ChangeBoundsRequest) {
            CompoundCommand command = new CompoundCommand();
            Iterator iter = this.getOperationSet().iterator();
            ChangeBoundsRequest request = (ChangeBoundsRequest)this.getTargetRequest();
            while (iter.hasNext()) {
                EditPart editPart = (EditPart)iter.next();
                command.add(editPart.getCommand((Request)request));
            }
            for (AbstractConnectionSymbolEditPart conn : this.getBendpointConnectionEditParts(this.getOperationSet())) {
                AbstractConnectionSymbolFigure figure = (AbstractConnectionSymbolFigure)conn.getFigure();
                int pointNumber = 2;
                while (pointNumber <= figure.getPoints().size() - 1) {
                    int bendpointIdx = pointNumber - 2;
                    ConnectionBendpointEditPolicy.DummyBendpointRequest bpRequest = new ConnectionBendpointEditPolicy.DummyBendpointRequest();
                    bpRequest.setType("move bendpoint");
                    bpRequest.setSource((ConnectionEditPart)conn);
                    bpRequest.setIndex(bendpointIdx);
                    Point location = figure.getPoints().getPoint(pointNumber - 1);
                    ScalableFreeformRootEditPart root = (ScalableFreeformRootEditPart)conn.getRoot();
                    ZoomManager manager = root.getZoomManager();
                    location.performScale(manager.getZoom());
                    Point delta = request.getMoveDelta();
                    location.performTranslate(delta.x, delta.y);
                    location.performScale(1.0 / manager.getZoom());
                    bpRequest.setLocation(location);
                    command.add(conn.getCommand((Request)bpRequest));
                    ++pointNumber;
                }
            }
            return command;
        }
        return super.getCommand();
    }

    private List getBendpointConnectionEditParts(List editParts) {
        ArrayList result = new ArrayList();
        for (Object rawEditPart : editParts) {
            AbstractGraphicalEditPart node;
            if (!(rawEditPart instanceof AbstractNodeSymbolEditPart)) continue;
            AbstractNodeSymbolEditPart nodeSymbolEditPart = (AbstractNodeSymbolEditPart)rawEditPart;
            for (AbstractConnectionSymbolEditPart conn : nodeSymbolEditPart.getSourceConnections()) {
                node = (AbstractGraphicalEditPart)conn.getTarget();
                this.addBendpointEditPart(result, editParts, conn, node);
            }
            for (AbstractConnectionSymbolEditPart conn : nodeSymbolEditPart.getTargetConnections()) {
                node = (AbstractGraphicalEditPart)conn.getSource();
                this.addBendpointEditPart(result, editParts, conn, node);
            }
        }
        return result;
    }

    private void addBendpointEditPart(List result, List editParts, AbstractConnectionSymbolEditPart conn, AbstractGraphicalEditPart node) {
        AbstractConnectionSymbolFigure figure = (AbstractConnectionSymbolFigure)conn.getFigure();
        if (editParts.contains(node) && !result.contains(conn) && figure.getConnectionRouter() instanceof BendpointConnectionRouter) {
            result.add(conn);
        }
    }

    protected boolean handleDragInProgress() {
        this.updateAutoexposeHelper();
        return super.handleDragInProgress();
    }

    protected void handleAutoexpose() {
        try {
            super.handleAutoexpose();
        }
        catch (NullPointerException nullPointerException) {}
    }
}

