/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.policies;

import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editpolicies.GraphicalNodeEditPolicy;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.stardust.model.xpdl.carnot.ActivityImplementationType;
import org.eclipse.stardust.model.xpdl.carnot.ActivitySymbolType;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.AnnotationSymbolType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationSymbolType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelFactory;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.DataSymbolType;
import org.eclipse.stardust.model.xpdl.carnot.EndEventSymbol;
import org.eclipse.stardust.model.xpdl.carnot.FlowControlType;
import org.eclipse.stardust.model.xpdl.carnot.GatewaySymbol;
import org.eclipse.stardust.model.xpdl.carnot.IConnectionSymbol;
import org.eclipse.stardust.model.xpdl.carnot.IFlowObjectSymbol;
import org.eclipse.stardust.model.xpdl.carnot.IModelParticipant;
import org.eclipse.stardust.model.xpdl.carnot.IModelParticipantSymbol;
import org.eclipse.stardust.model.xpdl.carnot.INodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ISymbolContainer;
import org.eclipse.stardust.model.xpdl.carnot.JoinSplitType;
import org.eclipse.stardust.model.xpdl.carnot.LinkTypeType;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.OrganizationSymbolType;
import org.eclipse.stardust.model.xpdl.carnot.OrganizationType;
import org.eclipse.stardust.model.xpdl.carnot.ParticipantType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessSymbolType;
import org.eclipse.stardust.model.xpdl.carnot.RefersToConnectionType;
import org.eclipse.stardust.model.xpdl.carnot.RoleSymbolType;
import org.eclipse.stardust.model.xpdl.carnot.RoleType;
import org.eclipse.stardust.model.xpdl.carnot.StartEventSymbol;
import org.eclipse.stardust.model.xpdl.carnot.TextSymbolType;
import org.eclipse.stardust.model.xpdl.carnot.TransitionConnectionType;
import org.eclipse.stardust.model.xpdl.carnot.TransitionType;
import org.eclipse.stardust.model.xpdl.carnot.XmlTextNode;
import org.eclipse.stardust.model.xpdl.carnot.util.ActivityUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.common.ui.IdFactory;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.DynamicConnectionFactory;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.AbstractConnectionSymbolEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.AbstractNodeSymbolEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.CreateConnectionSymbolCommand;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.DelegateCommand;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.DeleteConnectionSymbolCmd;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.DeleteValueCmd;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.IConnectionCommand;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.ModifyConnectionSymbolCommand;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.ReloadConnectionCommandFactory;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.SetActivityControlFlowCmd;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.SetValueCmd;
import org.eclipse.stardust.modeling.core.editors.parts.properties.ActivityCommandFactory;
import org.eclipse.stardust.modeling.core.properties.LinkTypeGeneralPropertyPage;
import org.eclipse.ui.PlatformUI;

public class NodeSymbolGraphicalNodeEditPolicy
extends GraphicalNodeEditPolicy {
    private WorkflowModelEditor editor;

    public NodeSymbolGraphicalNodeEditPolicy(WorkflowModelEditor editor) {
        this.editor = editor;
    }

    protected AbstractNodeSymbolEditPart getFlowObjectEditPart() {
        return (AbstractNodeSymbolEditPart)this.getHost();
    }

    protected INodeSymbol getFlowObjectModel() {
        return (INodeSymbol)this.getFlowObjectEditPart().getModel();
    }

    protected Command getConnectionCreateCommand(CreateConnectionRequest request) {
        Command result = null;
        INodeSymbol sourceSymbol = (INodeSymbol)this.getHost().getModel();
        ISymbolContainer symbolContainer = (ISymbolContainer)sourceSymbol.eContainer();
        Object part = request.getNewObject();
        if (part instanceof IConnectionCommand) {
            CompoundCommand compound = new CompoundCommand();
            if (this.canStartConnection(request.getNewObjectType(), sourceSymbol, (IConnectionCommand)part, compound)) {
                ((IConnectionCommand)part).setParent((EObject)symbolContainer);
                ((IConnectionCommand)part).setSourceSymbol(sourceSymbol);
                CompoundCommand cmds = new CompoundCommand();
                cmds.add((Command)part);
                Iterator iter = compound.getCommands().iterator();
                while (iter.hasNext()) {
                    cmds.add((Command)iter.next());
                }
                request.setStartCommand((Command)cmds);
                result = cmds.unwrap();
            }
        } else if (request.getNewObject() instanceof DynamicConnectionFactory) {
            return ((DynamicConnectionFactory)request.getNewObject()).getStartCommand(sourceSymbol);
        }
        return result;
    }

    private boolean canStartConnection(Object newObjectType, INodeSymbol sourceSymbol, IConnectionCommand command, CompoundCommand compound) {
        boolean canStart = false;
        if (newObjectType.equals(CarnotWorkflowModelPackage.eINSTANCE.getTransitionConnectionType())) {
            if (sourceSymbol instanceof ActivitySymbolType) {
                ActivitySymbolType activitySymbol = (ActivitySymbolType)sourceSymbol;
                ActivityType activity = (ActivityType)activitySymbol.getModelElement();
                boolean bl = canStart = activity.getSplit().getValue() == 0 && activity.getOutTransitions().size() < 2;
                if (compound != null) {
                    this.createAutomaticSplitCmd(sourceSymbol, compound);
                }
            } else if (sourceSymbol instanceof GatewaySymbol) {
                GatewaySymbol gateway = (GatewaySymbol)sourceSymbol;
                ActivitySymbolType activitySymbol = gateway.getActivitySymbol();
                ActivityType activity = (ActivityType)activitySymbol.getModelElement();
                boolean bl = canStart = gateway.getFlowKind().getValue() == 2 && activity.getSplit().getValue() != 0;
            }
            if (sourceSymbol instanceof StartEventSymbol) {
                StartEventSymbol startEventSymbol = (StartEventSymbol)sourceSymbol;
                canStart = startEventSymbol.getOutTransitions().size() == 0;
            }
        } else if (newObjectType.equals(CarnotWorkflowModelPackage.eINSTANCE.getRefersToConnectionType())) {
            canStart = sourceSymbol instanceof AnnotationSymbolType;
        } else if (newObjectType.equals(CarnotWorkflowModelPackage.eINSTANCE.getDataMappingConnectionType())) {
            canStart = sourceSymbol instanceof ActivitySymbolType || sourceSymbol instanceof DataSymbolType;
        } else if (newObjectType.equals(CarnotWorkflowModelPackage.eINSTANCE.getWorksForConnectionType())) {
            canStart = sourceSymbol instanceof RoleSymbolType;
        } else if (newObjectType.equals(CarnotWorkflowModelPackage.eINSTANCE.getPartOfConnectionType())) {
            canStart = sourceSymbol instanceof OrganizationSymbolType;
        } else if (newObjectType.equals(CarnotWorkflowModelPackage.eINSTANCE.getExecutedByConnectionType())) {
            canStart = sourceSymbol instanceof ApplicationSymbolType;
        } else if (newObjectType.equals(CarnotWorkflowModelPackage.eINSTANCE.getPerformsConnectionType())) {
            canStart = sourceSymbol instanceof IModelParticipantSymbol;
        } else if (newObjectType.equals(CarnotWorkflowModelPackage.eINSTANCE.getGenericLinkConnectionType()) && command instanceof CreateConnectionSymbolCommand) {
            canStart = this.isCompatible(sourceSymbol, ((LinkTypeType)((CreateConnectionSymbolCommand)command).getIdFactory().getReferingElement()).getSourceClass());
        }
        return canStart;
    }

    private boolean isCompatible(INodeSymbol sourceSymbol, String sourceClass) {
        return LinkTypeGeneralPropertyPage.TYPE_LABELS[0][0].equals(sourceClass) && sourceSymbol instanceof ActivitySymbolType || LinkTypeGeneralPropertyPage.TYPE_LABELS[1][0].equals(sourceClass) && sourceSymbol instanceof DataSymbolType || LinkTypeGeneralPropertyPage.TYPE_LABELS[2][0].equals(sourceClass) && sourceSymbol instanceof RoleSymbolType || LinkTypeGeneralPropertyPage.TYPE_LABELS[3][0].equals(sourceClass) && sourceSymbol instanceof ProcessSymbolType || LinkTypeGeneralPropertyPage.TYPE_LABELS[4][0].equals(sourceClass) && sourceSymbol instanceof TransitionConnectionType || LinkTypeGeneralPropertyPage.TYPE_LABELS[5][0].equals(sourceClass) && sourceSymbol instanceof OrganizationSymbolType || LinkTypeGeneralPropertyPage.TYPE_LABELS[6][0].equals(sourceClass) && sourceSymbol instanceof IModelParticipantSymbol;
    }

    protected Command getConnectionCompleteCommand(CreateConnectionRequest request) {
        CompoundCommand compound;
        Object newObjectType;
        Object part;
        INodeSymbol targetSymbol;
        CompoundCommand result = null;
        INodeSymbol sourceSymbol = (INodeSymbol)request.getSourceEditPart().getModel();
        if (sourceSymbol != (targetSymbol = (INodeSymbol)this.getHost().getModel()) && (part = request.getNewObject()) instanceof IConnectionCommand && this.canEndConnection(newObjectType = request.getNewObjectType(), targetSymbol, sourceSymbol, (IConnectionCommand)part, compound = new CompoundCommand())) {
            ((IConnectionCommand)part).setTargetSymbol(targetSymbol);
            CompoundCommand cmds = new CompoundCommand();
            cmds.add((Command)part);
            CompoundCommand starter = (CompoundCommand)request.getStartCommand();
            for (Command x : starter.getCommands()) {
                if (x == part) continue;
                cmds.add(x);
            }
            Iterator iter = compound.getCommands().iterator();
            while (iter.hasNext()) {
                cmds.add((Command)iter.next());
            }
            result = cmds;
        }
        if (request.getNewObject() instanceof DynamicConnectionFactory) {
            return ((DynamicConnectionFactory)request.getNewObject()).getCompleteCommand(targetSymbol);
        }
        return result;
    }

    private boolean canEndConnection(Object newObjectType, INodeSymbol targetSymbol, INodeSymbol sourceSymbol, IConnectionCommand command, CompoundCommand compound) {
        boolean canEnd = false;
        if (newObjectType.equals(CarnotWorkflowModelPackage.eINSTANCE.getTransitionConnectionType()) && !this.transitionExists(sourceSymbol, targetSymbol)) {
            if (targetSymbol instanceof ActivitySymbolType) {
                ActivitySymbolType activitySymbol = (ActivitySymbolType)targetSymbol;
                ActivityType activity = (ActivityType)activitySymbol.getModelElement();
                boolean bl = canEnd = activity.getJoin().getValue() == 0 && ((sourceSymbol instanceof ActivitySymbolType || sourceSymbol instanceof GatewaySymbol) && activity.getInTransitions().size() < 2 || activity.getInTransitions().size() == 0) && this.checkStartEvents(activitySymbol, sourceSymbol, compound);
                boolean bl2 = canEnd && sourceSymbol instanceof ActivitySymbolType ? !((ActivitySymbolType)sourceSymbol).getActivity().equals(activity) : (canEnd = canEnd);
                if (compound != null) {
                    this.createAutomaticJoinCmd(activity, sourceSymbol, compound);
                }
            } else if (targetSymbol instanceof GatewaySymbol) {
                GatewaySymbol gateway = (GatewaySymbol)targetSymbol;
                ActivitySymbolType activitySymbol = gateway.getActivitySymbol();
                ActivityType activity = (ActivityType)activitySymbol.getModelElement();
                canEnd = gateway.getFlowKind().getValue() == 1 && activity.getJoin().getValue() != 0 && !this.hasTransition(sourceSymbol, activity) && !(sourceSymbol instanceof StartEventSymbol);
            } else if (targetSymbol instanceof EndEventSymbol) {
                EndEventSymbol endEventSymbol = (EndEventSymbol)targetSymbol;
                canEnd = endEventSymbol.getInTransitions().size() == 0 && sourceSymbol instanceof ActivitySymbolType && (((ActivitySymbolType)sourceSymbol).getOutTransitions().isEmpty() || command == null);
            }
        } else if (newObjectType.equals(CarnotWorkflowModelPackage.eINSTANCE.getRefersToConnectionType())) {
            canEnd = (targetSymbol instanceof INodeSymbol || targetSymbol instanceof IConnectionSymbol) && !(targetSymbol instanceof TextSymbolType) && !(targetSymbol instanceof AnnotationSymbolType) && !(targetSymbol instanceof RefersToConnectionType);
        } else if (newObjectType.equals(CarnotWorkflowModelPackage.eINSTANCE.getDataMappingConnectionType())) {
            canEnd = sourceSymbol instanceof ActivitySymbolType && targetSymbol instanceof DataSymbolType || sourceSymbol instanceof DataSymbolType && targetSymbol instanceof ActivitySymbolType;
        } else if (newObjectType.equals(CarnotWorkflowModelPackage.eINSTANCE.getWorksForConnectionType())) {
            if (targetSymbol instanceof OrganizationSymbolType) {
                OrganizationType target;
                RoleType source = (RoleType)((RoleSymbolType)sourceSymbol).getModelElement();
                canEnd = !this.isContained((IModelParticipant)source, target = (OrganizationType)((OrganizationSymbolType)targetSymbol).getModelElement());
            }
        } else if (newObjectType.equals(CarnotWorkflowModelPackage.eINSTANCE.getPartOfConnectionType())) {
            if (targetSymbol instanceof OrganizationSymbolType) {
                OrganizationType source = (OrganizationType)((OrganizationSymbolType)sourceSymbol).getModelElement();
                OrganizationType target = (OrganizationType)((OrganizationSymbolType)targetSymbol).getModelElement();
                ModelType model = ModelUtils.findContainingModel((EObject)targetSymbol);
                canEnd = !source.equals(target) && !this.isContained((IModelParticipant)source, target) && !this.isPartOf(model, target, source);
            }
        } else if (newObjectType.equals(CarnotWorkflowModelPackage.eINSTANCE.getExecutedByConnectionType())) {
            if (targetSymbol instanceof ActivitySymbolType) {
                ActivityType activity = ((ActivitySymbolType)targetSymbol).getActivity();
                canEnd = activity != null && ActivityUtil.isApplicationActivity((ActivityType)activity) && activity.getApplication() == null;
            }
        } else if (newObjectType.equals(CarnotWorkflowModelPackage.eINSTANCE.getPerformsConnectionType())) {
            if (targetSymbol instanceof ActivitySymbolType) {
                ActivityType activity = ((ActivitySymbolType)targetSymbol).getActivity();
                boolean bl = canEnd = activity != null && ActivityUtil.isInteractive((ActivityType)activity) && activity.getPerformer() == null;
                if (!canEnd && (!ActivityUtil.isInteractive((ActivityType)activity) || ActivityImplementationType.APPLICATION_LITERAL.equals((Object)activity.getImplementation()) && activity.getApplication() == null) && compound != null) {
                    this.createChangeActivityImplTypeCmd(activity, compound, (ActivitySymbolType)targetSymbol, command);
                    canEnd = true;
                }
            }
        } else if (newObjectType.equals(CarnotWorkflowModelPackage.eINSTANCE.getGenericLinkConnectionType()) && command instanceof CreateConnectionSymbolCommand) {
            canEnd = this.isCompatible(targetSymbol, ((LinkTypeType)((CreateConnectionSymbolCommand)command).getIdFactory().getReferingElement()).getTargetClass());
        }
        return canEnd;
    }

    private void createChangeActivityImplTypeCmd(ActivityType activity, CompoundCommand compound, final ActivitySymbolType activitySymbol, final IConnectionCommand command) {
        DelegateCommand delegate = new DelegateCommand(){

            @Override
            public void execute() {
                boolean canSwitch;
                MessageDialogWithToggle dialog = null;
                if (PlatformUI.getPreferenceStore().getBoolean("org.eclipse.stardust.modeling.common.projectnature.warnSwitchActivityType") && (dialog = MessageDialogWithToggle.openYesNoQuestion(null, (String)Diagram_Messages.TITLE_ChangeToManualActivity, (String)Diagram_Messages.MSG_ChangeImplTypeActivity, (String)Diagram_Messages.LB_RememberDecision, (boolean)false, (IPreferenceStore)PlatformUI.getPreferenceStore(), (String)"org.eclipse.stardust.modeling.common.projectnature.warnSwitchActivityType")).getToggleState()) {
                    PlatformUI.getPreferenceStore().setValue("org.eclipse.stardust.modeling.common.projectnature.warnSwitchActivityType", false);
                    PlatformUI.getPreferenceStore().setValue("org.eclipse.stardust.modeling.common.projectnature.alwaysSwitchActivityType", 2 == dialog.getReturnCode());
                    PlatformUI.getPreferenceStore().setValue("org.eclipse.stardust.modeling.common.projectnature.neverSwitchActivityType", 3 == dialog.getReturnCode());
                }
                boolean bl = PlatformUI.getPreferenceStore().getBoolean("org.eclipse.stardust.modeling.common.projectnature.warnSwitchActivityType") ? 2 == dialog.getReturnCode() : (canSwitch = PlatformUI.getPreferenceStore().getBoolean("org.eclipse.stardust.modeling.common.projectnature.alwaysSwitchActivityType"));
                if (canSwitch) {
                    super.execute();
                } else if (activitySymbol.getPerformsConnections().size() == 1) {
                    ((CreateConnectionSymbolCommand)command).undo();
                }
            }
        };
        delegate.setDelegate(ActivityCommandFactory.getSetImplementationCommand(ActivityImplementationType.MANUAL_LITERAL, activity));
        compound.add((Command)delegate);
    }

    private boolean transitionExists(INodeSymbol sourceSymbol, INodeSymbol targetSymbol) {
        boolean transitionExists = false;
        ActivityType srcActicity = null;
        if (sourceSymbol instanceof ActivitySymbolType) {
            srcActicity = ((ActivitySymbolType)sourceSymbol).getActivity();
        } else if (sourceSymbol instanceof GatewaySymbol && ((GatewaySymbol)sourceSymbol).getActivitySymbol() != null) {
            srcActicity = ((GatewaySymbol)sourceSymbol).getActivitySymbol().getActivity();
        }
        ActivityType tgtActicity = null;
        if (targetSymbol instanceof ActivitySymbolType) {
            tgtActicity = ((ActivitySymbolType)targetSymbol).getActivity();
        } else if (targetSymbol instanceof GatewaySymbol && ((GatewaySymbol)targetSymbol).getActivitySymbol() != null) {
            tgtActicity = ((GatewaySymbol)targetSymbol).getActivitySymbol().getActivity();
        }
        if (srcActicity != null && tgtActicity != null) {
            for (TransitionType transition : srcActicity.getOutTransitions()) {
                if (tgtActicity != transition.getTo()) continue;
                transitionExists = true;
                break;
            }
        }
        return transitionExists;
    }

    private void createAutomaticJoinCmd(ActivityType activity, INodeSymbol sourceSymbol, CompoundCommand cmd) {
        if (!(sourceSymbol instanceof StartEventSymbol) && activity.getInTransitions().size() == 1) {
            cmd.add((Command)new SetActivityControlFlowCmd(this.editor, activity, FlowControlType.JOIN_LITERAL, JoinSplitType.AND_LITERAL){

                @Override
                public void execute() {
                    this.canExecute();
                    super.execute();
                }
            });
        }
    }

    private void createAutomaticSplitCmd(INodeSymbol sourceSymbol, CompoundCommand cmd) {
        ActivityType sourceActivity;
        if (sourceSymbol instanceof ActivitySymbolType && (sourceActivity = ((ActivitySymbolType)sourceSymbol).getActivity()).getOutTransitions().size() == 1) {
            cmd.add((Command)new SetActivityControlFlowCmd(this.editor, sourceActivity, FlowControlType.SPLIT_LITERAL, JoinSplitType.AND_LITERAL){

                @Override
                public void execute() {
                    this.canExecute();
                    super.execute();
                }
            });
        }
    }

    private boolean checkStartEvents(ActivitySymbolType activitySymbol, INodeSymbol sourceSymbol, CompoundCommand compound) {
        block6: {
            block5: {
                if (!(sourceSymbol instanceof StartEventSymbol) || ((StartEventSymbol)sourceSymbol).getTrigger() != null) break block5;
                for (TransitionConnectionType conn : activitySymbol.getInTransitions()) {
                    if (!(conn.getSourceNode() instanceof StartEventSymbol) || ((StartEventSymbol)conn.getSourceNode()).getTrigger() != null) continue;
                    return false;
                }
                break block6;
            }
            if (!(sourceSymbol instanceof ActivitySymbolType)) break block6;
            int i = 0;
            while (i < activitySymbol.getInConnectionFeatures().size()) {
                EStructuralFeature feature = (EStructuralFeature)activitySymbol.getInConnectionFeatures().get(i);
                Object connection = activitySymbol.eGet(feature);
                if (connection instanceof List) {
                    List connectionList = (List)connection;
                    int j = 0;
                    while (j < connectionList.size()) {
                        if (connectionList.get(j) instanceof TransitionConnectionType && ((TransitionConnectionType)connectionList.get(j)).getSourceNode() instanceof StartEventSymbol) {
                            compound.add((Command)new DeleteConnectionSymbolCmd((IConnectionSymbol)((TransitionConnectionType)connectionList.get(j))));
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return true;
    }

    private boolean hasTransition(INodeSymbol sourceSymbol, ActivityType target) {
        ActivityType source = NodeSymbolGraphicalNodeEditPolicy.getActivityType(sourceSymbol);
        if (source != null && target != null) {
            ProcessDefinitionType process = ModelUtils.findContainingProcess((EObject)sourceSymbol);
            EList transitions = process.getTransition();
            int i = 0;
            while (i < transitions.size()) {
                TransitionType type = (TransitionType)transitions.get(i);
                if (type.getFrom().equals(source) && type.getTo().equals(target)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private static ActivityType getActivityType(INodeSymbol symbol) {
        if (symbol instanceof GatewaySymbol) {
            symbol = ((GatewaySymbol)symbol).getActivitySymbol();
        }
        return symbol instanceof ActivitySymbolType ? ((ActivitySymbolType)symbol).getActivity() : null;
    }

    private boolean isPartOf(ModelType model, OrganizationType child, OrganizationType parent) {
        if (this.isContained((IModelParticipant)child, parent)) {
            return true;
        }
        for (ParticipantType participantRef : parent.getParticipant()) {
            IModelParticipant participant = participantRef.getParticipant();
            if (!(participant instanceof OrganizationType) || !this.isPartOf(model, child, (OrganizationType)participant)) continue;
            return true;
        }
        return false;
    }

    private boolean isContained(IModelParticipant child, OrganizationType parent) {
        for (ParticipantType participant : parent.getParticipant()) {
            if (participant.getParticipant() != child) continue;
            return true;
        }
        return false;
    }

    protected Command getReconnectSourceCommand(ReconnectRequest request) {
        CompoundCommand cmds = new CompoundCommand();
        CompoundCommand compound = new CompoundCommand();
        AbstractNodeSymbolEditPart target = (AbstractNodeSymbolEditPart)request.getTarget();
        AbstractConnectionSymbolEditPart connectionPart = (AbstractConnectionSymbolEditPart)request.getConnectionEditPart();
        EditPart currentSource = connectionPart.getSource();
        EditPart currentTarget = connectionPart.getTarget();
        EditPart otherPoint = connectionPart.getTarget();
        if (connectionPart.getModel() instanceof TransitionConnectionType && (target.getModel().equals(connectionPart.getConnectionSymbolModel().getSourceNode()) || this.canStartConnection(connectionPart.getConnectionSymbolModel().eClass(), (INodeSymbol)target.getModel(), null, compound))) {
            TransitionConnectionType connection = (TransitionConnectionType)connectionPart.getConnectionSymbolModel();
            if (!target.equals(currentTarget) && (target == currentSource || this.isValidReconnect(connection))) {
                ModifyConnectionSymbolCommand modifyCmd = new ModifyConnectionSymbolCommand();
                modifyCmd.setAnchorType((String)request.getExtendedData().get("org.eclipse.stardust.modeling.core.sourceAnchor"));
                modifyCmd.setSource((INodeSymbol)target.getModel());
                modifyCmd.setConnection((IConnectionSymbol)connectionPart.getModel());
                boolean needTransition = this.isActivityRelated((IFlowObjectSymbol)target.getModel()) && this.isActivityRelated((IFlowObjectSymbol)otherPoint.getModel()) && this.isNoGatewayTransition((IFlowObjectSymbol)target.getModel(), (IFlowObjectSymbol)otherPoint.getModel(), connection);
                if (connection.getTransition() != null) {
                    TransitionType transition = connection.getTransition();
                    if (needTransition) {
                        cmds.add((Command)new SetValueCmd((EObject)transition, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getTransitionType_From(), (Object)NodeSymbolGraphicalNodeEditPolicy.getActivityType((INodeSymbol)target.getModel())));
                        if (target != currentSource) {
                            this.deleteTransitionConnections(cmds, connection, transition);
                        }
                    } else {
                        this.deleteTransition(cmds, connection, transition, (EditPart)target, otherPoint, true);
                    }
                } else if (needTransition) {
                    this.createTransition(cmds, (EditPart)target, otherPoint, connection, true);
                }
                cmds.add((Command)modifyCmd);
                Iterator iter = compound.getCommands().iterator();
                while (iter.hasNext()) {
                    cmds.add((Command)iter.next());
                }
                return cmds;
            }
        }
        return UnexecutableCommand.INSTANCE;
    }

    private boolean isNoGatewayTransition(IFlowObjectSymbol sourceSymbol, IFlowObjectSymbol targetSymbol, TransitionConnectionType connection) {
        boolean isNoGatewayTransition = true;
        if (sourceSymbol instanceof ActivitySymbolType && targetSymbol instanceof ActivitySymbolType || sourceSymbol instanceof GatewaySymbol && targetSymbol instanceof GatewaySymbol) {
            isNoGatewayTransition = true;
        } else {
            ActivitySymbolType activitySymbol = (ActivitySymbolType)(sourceSymbol instanceof ActivitySymbolType ? sourceSymbol : targetSymbol);
            GatewaySymbol gateway = (GatewaySymbol)(sourceSymbol instanceof GatewaySymbol ? sourceSymbol : targetSymbol);
            if (activitySymbol.getGatewaySymbols().contains((Object)gateway)) {
                if (!JoinSplitType.NONE_LITERAL.equals((Object)activitySymbol.getActivity().getSplit())) {
                    isNoGatewayTransition = connection.getTargetActivitySymbol().equals(activitySymbol);
                }
                if (isNoGatewayTransition && !JoinSplitType.NONE_LITERAL.equals((Object)activitySymbol.getActivity().getJoin())) {
                    isNoGatewayTransition = connection.getSourceActivitySymbol().equals(activitySymbol);
                }
            } else {
                isNoGatewayTransition = true;
            }
        }
        return isNoGatewayTransition;
    }

    private boolean isActivityRelated(IFlowObjectSymbol symbol) {
        return symbol instanceof ActivitySymbolType || symbol instanceof GatewaySymbol;
    }

    protected Command getReconnectTargetCommand(ReconnectRequest request) {
        CompoundCommand cmds = new CompoundCommand();
        CompoundCommand compound = new CompoundCommand();
        AbstractNodeSymbolEditPart target = (AbstractNodeSymbolEditPart)request.getTarget();
        AbstractConnectionSymbolEditPart connectionPart = (AbstractConnectionSymbolEditPart)request.getConnectionEditPart();
        EditPart currentTarget = connectionPart.getTarget();
        EditPart otherPoint = connectionPart.getSource();
        if (connectionPart.getModel() instanceof TransitionConnectionType && (target.getModel().equals(connectionPart.getConnectionSymbolModel().getTargetNode()) || this.canEndConnection(connectionPart.getConnectionSymbolModel().eClass(), (INodeSymbol)target.getModel(), connectionPart.getConnectionSymbolModel().getSourceNode(), null, compound))) {
            TransitionConnectionType connection = (TransitionConnectionType)connectionPart.getConnectionSymbolModel();
            if (target == currentTarget || this.isValidReconnect(connection)) {
                ModifyConnectionSymbolCommand modifyCmd = new ModifyConnectionSymbolCommand();
                modifyCmd.setAnchorType((String)request.getExtendedData().get("org.eclipse.stardust.modeling.core.targetAnchor"));
                modifyCmd.setTarget((INodeSymbol)target.getModel());
                modifyCmd.setConnection((IConnectionSymbol)connectionPart.getModel());
                boolean needTransition = this.isActivityRelated((IFlowObjectSymbol)target.getModel()) && this.isActivityRelated((IFlowObjectSymbol)otherPoint.getModel()) && this.isNoGatewayTransition((IFlowObjectSymbol)target.getModel(), (IFlowObjectSymbol)otherPoint.getModel(), connection);
                if (connection.getTransition() != null) {
                    TransitionType transition = connection.getTransition();
                    if (needTransition) {
                        cmds.add((Command)new SetValueCmd((EObject)transition, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getTransitionType_To(), (Object)NodeSymbolGraphicalNodeEditPolicy.getActivityType((INodeSymbol)target.getModel())));
                        if (target != currentTarget) {
                            this.deleteTransitionConnections(cmds, connection, transition);
                        }
                    } else if (!needTransition) {
                        this.deleteTransition(cmds, connection, transition, (EditPart)target, otherPoint, false);
                    }
                } else if (needTransition) {
                    this.createTransition(cmds, (EditPart)target, otherPoint, connection, false);
                }
                cmds.add((Command)modifyCmd);
                Iterator iter = compound.getCommands().iterator();
                while (iter.hasNext()) {
                    cmds.add((Command)iter.next());
                }
                return cmds;
            }
        }
        return UnexecutableCommand.INSTANCE;
    }

    private void deleteTransitionConnections(CompoundCommand cmds, TransitionConnectionType connection, TransitionType transition) {
        for (TransitionConnectionType conn : transition.getSymbols()) {
            if (conn.equals(connection)) continue;
            cmds.add((Command)new DeleteConnectionSymbolCmd((IConnectionSymbol)conn));
        }
    }

    private void createTransition(CompoundCommand cmds, EditPart target, EditPart otherPoint, TransitionConnectionType connection, boolean isSource) {
        CarnotWorkflowModelFactory factory = CarnotWorkflowModelFactory.eINSTANCE;
        TransitionType transitionModelElement = factory.createTransitionType();
        ModelUtils.findContainingModel((EObject)connection);
        IdFactory idFactory = new IdFactory("Transition", Diagram_Messages.BASENAME_Transition);
        ProcessDefinitionType process = ModelUtils.findContainingProcess((EObject)connection);
        idFactory.computeNames((List)process.getTransition());
        transitionModelElement.setId(idFactory.getId());
        transitionModelElement.setName(idFactory.getName());
        transitionModelElement.setCondition("CONDITION");
        XmlTextNode expression = factory.createXmlTextNode();
        transitionModelElement.setExpression(expression);
        ModelUtils.setCDataString((FeatureMap)expression.getMixed(), (String)"true", (boolean)true);
        cmds.add((Command)new SetValueCmd((EObject)process, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getProcessDefinitionType_Transition(), (Object)transitionModelElement));
        if (isSource) {
            EditPart tmp = target;
            target = otherPoint;
            otherPoint = tmp;
        }
        cmds.add((Command)new SetValueCmd((EObject)transitionModelElement, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getTransitionType_From(), (Object)NodeSymbolGraphicalNodeEditPolicy.getActivityType((INodeSymbol)otherPoint.getModel())));
        cmds.add((Command)new SetValueCmd((EObject)transitionModelElement, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getTransitionType_To(), (Object)NodeSymbolGraphicalNodeEditPolicy.getActivityType((INodeSymbol)target.getModel())));
        cmds.add((Command)new SetValueCmd((EObject)connection, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getTransitionConnectionType_Transition(), (Object)transitionModelElement));
    }

    private void deleteTransition(CompoundCommand cmds, TransitionConnectionType connection, TransitionType transition, EditPart target, EditPart otherPoint, boolean isSource) {
        if (isSource) {
            EditPart tmp = target;
            target = otherPoint;
            otherPoint = tmp;
        }
        cmds.add((Command)new DeleteValueCmd((EObject)connection, transition, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getTransitionConnectionType_Transition()));
        cmds.add((Command)new DeleteValueCmd((EObject)transition, NodeSymbolGraphicalNodeEditPolicy.getActivityType((INodeSymbol)target.getModel()), (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getTransitionType_To()));
        cmds.add((Command)new DeleteValueCmd((EObject)transition, NodeSymbolGraphicalNodeEditPolicy.getActivityType((INodeSymbol)otherPoint.getModel()), (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getTransitionType_From()));
        ProcessDefinitionType process = ModelUtils.findContainingProcess((EObject)connection);
        cmds.add((Command)new DeleteValueCmd((EObject)process, transition, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getProcessDefinitionType_Transition()));
    }

    private boolean isValidReconnect(TransitionConnectionType connection) {
        boolean validReconnect = false;
        if (connection.getTransition() != null || connection.getTargetActivitySymbol() instanceof EndEventSymbol || connection.getSourceActivitySymbol() instanceof StartEventSymbol) {
            validReconnect = true;
        }
        return validReconnect;
    }

    public boolean understandsRequest(Request request) {
        if ("org.eclipse.stardust.modeling.core.reloadConnections".equals(request.getType())) {
            return true;
        }
        return super.understandsRequest(request);
    }

    public Command getCommand(Request request) {
        if ("org.eclipse.stardust.modeling.core.reloadConnections".equals(request.getType())) {
            return this.getReloadConnectionsCommand();
        }
        return super.getCommand(request);
    }

    private Command getReloadConnectionsCommand() {
        UnexecutableCommand command = UnexecutableCommand.INSTANCE;
        EditPart part = this.getHost();
        Object model = part.getModel();
        if (model instanceof INodeSymbol) {
            command = ReloadConnectionCommandFactory.INSTANCE.createReloadConnectionCmd((INodeSymbol)model);
        }
        return command;
    }

    protected IFigure getFeedbackLayer() {
        return this.getLayer("Scaled Feedback Layer");
    }
}

