/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.policies;

import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.ContainerEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.DiagramModeType;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.IGraphicalObject;
import org.eclipse.stardust.model.xpdl.carnot.INodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ISwimlaneSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ISymbolContainer;
import org.eclipse.stardust.model.xpdl.carnot.PoolSymbol;
import org.eclipse.stardust.model.xpdl.carnot.util.DiagramUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.AbstractNodeSymbolEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.AbstractSwimlaneEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.DiagramEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.LaneEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.PoolEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.CreateSymbolCommand;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.IDiagramCommand;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.MoveLaneCommand;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.MoveNodeSymbolCommand;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.MoveSymbolCommandUtils;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.SetSymbolContainerCommand;
import org.eclipse.stardust.modeling.core.utils.PoolLaneUtils;

public class SymbolContainerEditPolicy
extends ContainerEditPolicy {
    private Rectangle bounds = new Rectangle(0, 0, 0, 0);
    private static CarnotWorkflowModelPackage PKG = CarnotWorkflowModelPackage.eINSTANCE;

    protected Command getAddCommand(GroupRequest request) {
        UnexecutableCommand result = UnexecutableCommand.INSTANCE;
        if (this.getHost().getModel() instanceof ISymbolContainer) {
            EditPart hostEP = this.getHost();
            ISymbolContainer symbolContainer = (ISymbolContainer)hostEP.getModel();
            DiagramType diagram = null;
            diagram = symbolContainer instanceof DiagramType ? (DiagramType)symbolContainer : ModelUtils.findContainingDiagram((IGraphicalObject)((IGraphicalObject)symbolContainer));
            Point mouseLocation = ((ChangeBoundsRequest)request).getLocation().getCopy();
            ISymbolContainer container = (ISymbolContainer)this.getHost().getModel();
            final IFigure hostFigure = ((AbstractGraphicalEditPart)this.getHost()).getFigure();
            final Point moveDelta = ((ChangeBoundsRequest)request).getMoveDelta();
            List parts = request.getEditParts();
            CompoundCommand addCmds = new CompoundCommand();
            int i = 0;
            while (i < parts.size()) {
                final Object part = parts.get(i);
                if ((this.getHost() instanceof AbstractSwimlaneEditPart || this.getHost() instanceof DiagramEditPart) && diagram.getMode().equals((Object)DiagramModeType.MODE_450_LITERAL) && DiagramUtil.getDefaultPool((DiagramType)diagram) != null && (part instanceof LaneEditPart ? this.getHost() instanceof DiagramEditPart : this.getHost() instanceof AbstractSwimlaneEditPart && PoolLaneUtils.containsLanes(this.getHost()))) {
                    return result;
                }
                if (this.getHost() instanceof PoolEditPart && part instanceof PoolEditPart) {
                    return result;
                }
                if (this.getHost() instanceof LaneEditPart && ((LaneEditPart)this.getHost()).getLaneFigure().isCollapsed()) {
                    return result;
                }
                if (part instanceof LaneEditPart) {
                    if (this.getRealContainer(container) instanceof ISwimlaneSymbol) {
                        MoveLaneCommand cmd = new MoveLaneCommand();
                        cmd.setTarget(((LaneEditPart)part).getLaneModel());
                        cmd.setContainer((ISwimlaneSymbol)this.getRealContainer(container));
                        addCmds.add((Command)cmd);
                        if (diagram.getMode().equals((Object)DiagramModeType.MODE_450_LITERAL) && DiagramUtil.getDefaultPool((DiagramType)diagram) != null) {
                            if (this.getHost() instanceof LaneEditPart && !PoolLaneUtils.canMove((LaneEditPart)this.getHost(), (LaneEditPart)part)) {
                                return UnexecutableCommand.INSTANCE;
                            }
                            if (PoolLaneUtils.containsLanes(this.getHost())) {
                                mouseLocation = PoolLaneUtils.getLocation((GraphicalEditPart)this.getHost(), (IFigure)((AbstractSwimlaneEditPart)this.getHost()).getSwimlaneFigure(), mouseLocation, true);
                                if (!PoolLaneUtils.isSensitiveArea((AbstractSwimlaneEditPart)this.getHost(), mouseLocation)) {
                                    return UnexecutableCommand.INSTANCE;
                                }
                            } else {
                                PoolLaneUtils.containsOthers((AbstractSwimlaneEditPart)this.getHost());
                            }
                        }
                        MoveNodeSymbolCommand moveCmd = new MoveNodeSymbolCommand();
                        moveCmd.setPart((INodeSymbol)((AbstractNodeSymbolEditPart)part).getModel());
                        moveCmd.setLocation(mouseLocation);
                        addCmds.add((Command)moveCmd);
                    } else {
                        addCmds.add((Command)UnexecutableCommand.INSTANCE);
                    }
                } else if (part instanceof AbstractNodeSymbolEditPart) {
                    boolean isValid = true;
                    if (this.checkMoveCollision((ChangeBoundsRequest)request)) {
                        isValid = false;
                    }
                    if (isValid) {
                        SetSymbolContainerCommand addCmd = new SetSymbolContainerCommand(){
                            private MoveNodeSymbolCommand cmd;

                            @Override
                            public void execute() {
                                Point oldLocation = ((GraphicalEditPart)part).getFigure().getBounds().getLocation().getCopy();
                                Point newLocation = moveDelta.getCopy();
                                newLocation = PoolLaneUtils.getLocation((GraphicalEditPart)part, hostFigure, newLocation, false);
                                newLocation.x += oldLocation.x;
                                newLocation.y += oldLocation.y;
                                this.cmd = new MoveNodeSymbolCommand();
                                this.cmd.setPart((INodeSymbol)((AbstractNodeSymbolEditPart)part).getModel());
                                this.cmd.setLocation(newLocation);
                                SymbolContainerEditPolicy.this.getHost().getViewer().getEditDomain().getCommandStack().execute((Command)this.cmd);
                                super.execute();
                            }

                            @Override
                            public void undo() {
                                this.cmd.undo();
                                super.undo();
                            }

                            @Override
                            public void redo() {
                                this.cmd.redo();
                                super.redo();
                            }
                        };
                        addCmd.setContainer(this.getRealContainer(container), this.getHost());
                        addCmd.setSymbol((IGraphicalObject)((AbstractNodeSymbolEditPart)part).getModel());
                        addCmds.add((Command)addCmd);
                    } else {
                        addCmds.add((Command)UnexecutableCommand.INSTANCE);
                    }
                } else {
                    addCmds.add((Command)UnexecutableCommand.INSTANCE);
                }
                ++i;
            }
            result = addCmds.unwrap();
        }
        return result;
    }

    private ISymbolContainer getRealContainer(ISymbolContainer container) {
        PoolSymbol defaultPool;
        if (container instanceof DiagramType && (defaultPool = DiagramUtil.getDefaultPool((DiagramType)((DiagramType)container))) != null) {
            container = defaultPool;
        }
        return container;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Command getCreateCommand(CreateRequest request) {
        UnexecutableCommand cmd = UnexecutableCommand.INSTANCE;
        if (!(this.getHost().getModel() instanceof ISymbolContainer)) return cmd;
        EditPart hostEP = this.getHost();
        ISymbolContainer symbolContainer = (ISymbolContainer)hostEP.getModel();
        DiagramType diagram = null;
        diagram = symbolContainer instanceof DiagramType ? (DiagramType)symbolContainer : ModelUtils.findContainingDiagram((IGraphicalObject)((IGraphicalObject)symbolContainer));
        Object part = request.getNewObject();
        if (part instanceof IDiagramCommand) {
            ((IDiagramCommand)part).setParent((EObject)this.getRealContainer(symbolContainer));
            cmd = null;
        }
        if (hostEP instanceof LaneEditPart && ((LaneEditPart)hostEP).getLaneFigure().isCollapsed()) {
            return UnexecutableCommand.INSTANCE;
        }
        if (!(hostEP instanceof AbstractSwimlaneEditPart) && !(hostEP instanceof DiagramEditPart) || !(request instanceof CreateRequest)) return cmd;
        CreateSymbolCommand createSymbolCommand = null;
        Command command = (Command)request.getNewObject();
        if (command instanceof CompoundCommand) {
            List commands = ((CompoundCommand)command).getCommands();
            int i = 0;
            while (i < commands.size()) {
                Command singleCommand = (Command)commands.get(i);
                if (singleCommand instanceof CreateSymbolCommand) {
                    createSymbolCommand = (CreateSymbolCommand)singleCommand;
                    break;
                }
                ++i;
            }
        } else if (command instanceof CreateSymbolCommand) {
            createSymbolCommand = (CreateSymbolCommand)command;
        }
        if (!diagram.getMode().equals((Object)DiagramModeType.MODE_450_LITERAL) || DiagramUtil.getDefaultPool((DiagramType)diagram) == null) return cmd;
        boolean isLane = false;
        EClass eClass = createSymbolCommand.getEClass();
        if (eClass.equals(PKG.getLaneSymbol())) {
            isLane = true;
        }
        if (isLane) {
            if (hostEP instanceof DiagramEditPart) return UnexecutableCommand.INSTANCE;
            if (!PoolLaneUtils.containsLanes(this.getHost())) return cmd;
            Point location = request.getLocation();
            location = PoolLaneUtils.getLocation((GraphicalEditPart)hostEP, (IFigure)((AbstractSwimlaneEditPart)hostEP).getSwimlaneFigure(), location, true);
            if (PoolLaneUtils.isSensitiveArea((AbstractSwimlaneEditPart)hostEP, location)) return cmd;
            return UnexecutableCommand.INSTANCE;
        }
        if (hostEP instanceof DiagramEditPart) {
            return UnexecutableCommand.INSTANCE;
        }
        if (!PoolLaneUtils.containsLanes((EditPart)((AbstractSwimlaneEditPart)this.getHost()))) return cmd;
        return UnexecutableCommand.INSTANCE;
    }

    public Command getCommand(Request request) {
        if ("move children".equals(request.getType())) {
            this.checkMoveCollision((ChangeBoundsRequest)request);
        }
        return super.getCommand(request);
    }

    private boolean checkMoveCollision(ChangeBoundsRequest request) {
        boolean isCollision = false;
        for (AbstractNodeSymbolEditPart part : request.getEditParts()) {
            this.bounds = part.getFigure().getBounds().getCopy();
            part.getFigure().translateToAbsolute((Translatable)this.bounds);
            this.bounds = request.getTransformedRectangle(this.bounds);
            ((GraphicalEditPart)this.getHost()).getContentPane().translateToRelative((Translatable)this.bounds);
            ((GraphicalEditPart)this.getHost()).getContentPane().translateFromParent((Translatable)this.bounds);
            this.bounds.translate(((GraphicalEditPart)this.getHost()).getContentPane().getClientArea().getLocation().getNegated());
            isCollision = MoveSymbolCommandUtils.isSymbolCollision(Collections.singletonList(part), this.getHost(), (EditPart)part, this.bounds);
        }
        return isCollision;
    }
}

