/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.highlighting;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.IHighliteableGraphicalObject;
import org.eclipse.stardust.modeling.core.highlighting.ColorFactory;
import org.eclipse.stardust.modeling.core.highlighting.HighlightState;
import org.eclipse.stardust.modeling.core.highlighting.IColorFactory;

public class HighlightUtils {

    public static class GraphicalObjectHighlighter
    implements Runnable {
        private final IHighliteableGraphicalObject graphicalObject;
        private final HighlightState state;
        private final IColorFactory colorFactory;
        private RuntimeException exception;

        public GraphicalObjectHighlighter(IHighliteableGraphicalObject graphicalObject, HighlightState state) {
            this(graphicalObject, state, null);
        }

        public GraphicalObjectHighlighter(IHighliteableGraphicalObject graphicalObject, HighlightState state, IColorFactory colorFactory) {
            this.graphicalObject = graphicalObject;
            this.state = state;
            this.colorFactory = colorFactory == null ? new ColorFactory(ColorConstants.black) : colorFactory;
        }

        @Override
        public void run() {
            try {
                switch (this.state.getValue()) {
                    case 0: {
                        this.graphicalObject.resetHighliteBorderColor();
                        break;
                    }
                    case 3: {
                        this.graphicalObject.setHighliteBorderColor(this.colorFactory.createColor(this.state));
                        break;
                    }
                    case 2: {
                        this.graphicalObject.setHighliteBorderColor(this.colorFactory.createColor(this.state));
                        break;
                    }
                    case 1: {
                        this.graphicalObject.setHighliteBorderColor(this.colorFactory.createColor(this.state));
                        break;
                    }
                    case 4: {
                        this.graphicalObject.setHighliteBorderColor(this.colorFactory.createColor(this.state));
                        break;
                    }
                }
            }
            catch (RuntimeException e) {
                this.exception = e;
            }
        }

        public RuntimeException getException() {
            return this.exception;
        }
    }
}

