/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.properties;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.stardust.model.xpdl.carnot.AccessPointType;
import org.eclipse.stardust.model.xpdl.carnot.ActivityImplementationType;
import org.eclipse.stardust.model.xpdl.carnot.ActivitySymbolType;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationContextTypeType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.DirectionType;
import org.eclipse.stardust.model.xpdl.carnot.EndEventSymbol;
import org.eclipse.stardust.model.xpdl.carnot.FlowControlType;
import org.eclipse.stardust.model.xpdl.carnot.GatewaySymbol;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ISymbolContainer;
import org.eclipse.stardust.model.xpdl.carnot.JoinSplitType;
import org.eclipse.stardust.model.xpdl.carnot.LoopType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.StartEventSymbol;
import org.eclipse.stardust.model.xpdl.carnot.SubProcessModeType;
import org.eclipse.stardust.model.xpdl.carnot.TransitionConnectionType;
import org.eclipse.stardust.model.xpdl.carnot.util.ActivityUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.DiagramUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.xpdl2.LoopMultiInstanceType;
import org.eclipse.stardust.model.xpdl.xpdl2.LoopStandardType;
import org.eclipse.stardust.model.xpdl.xpdl2.LoopTypeType;
import org.eclipse.stardust.model.xpdl.xpdl2.MIOrderingType;
import org.eclipse.stardust.model.xpdl.xpdl2.TestTimeType;
import org.eclipse.stardust.model.xpdl.xpdl2.XpdlFactory;
import org.eclipse.stardust.model.xpdl.xpdl2.XpdlPackage;
import org.eclipse.stardust.model.xpdl.xpdl2.extensions.ExtensionFactory;
import org.eclipse.stardust.model.xpdl.xpdl2.extensions.ExtensionPackage;
import org.eclipse.stardust.model.xpdl.xpdl2.extensions.LoopDataRefType;
import org.eclipse.stardust.model.xpdl.xpdl2.util.XpdlUtil;
import org.eclipse.stardust.modeling.common.ui.jface.databinding.EFeatureAdapter;
import org.eclipse.stardust.modeling.common.ui.jface.databinding.EObjectAdapter;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.common.ui.jface.utils.LabeledText;
import org.eclipse.stardust.modeling.common.ui.jface.utils.LabeledViewer;
import org.eclipse.stardust.modeling.common.ui.jface.widgets.LabelWithStatus;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.SetActivityControlFlowCmd;
import org.eclipse.stardust.modeling.core.editors.ui.IdentifiableLabelProvider;
import org.eclipse.stardust.modeling.core.properties.AbstractModelElementPropertyPage;
import org.eclipse.stardust.modeling.core.utils.WidgetBindingManager;
import org.eclipse.stardust.modeling.core.utils.XpdlFeatureAdapter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.MessageBox;

public class ActivityControlFlowPropertyPage
extends AbstractModelElementPropertyPage {
    private static final int JOIN = 0;
    private static final int SPLIT = 1;
    private static final int LOOP = 2;
    private static final String[] NAMES = new String[]{Diagram_Messages.LB_TITLE_Join, Diagram_Messages.LB_TITLE_Split, Diagram_Messages.LB_TITLE_Loop};
    private Button[] joinButtons;
    private Button[] splitButtons;
    private Button[] loopButtons;
    private Button[] standardLoopButtons;
    private Button[] multiLoopButtons;
    private LabeledText loopConditionText;
    private Composite standardLoopGroup;
    private Composite multiLoopGroup;
    private org.eclipse.stardust.model.xpdl.xpdl2.LoopType loop;
    private LoopMultiInstanceType loopMulti;
    private LoopStandardType loopStandard;
    private Group loopGroup;
    private LabeledViewer inputViewer;
    private LabeledViewer counterViewer;
    private LabeledViewer outputViewer;
    private String inContext;
    private String outContext;
    private Button limitCheckBox;
    private LabeledText maxBatchSizeText;

    @Override
    protected void performDefaults() {
        super.performDefaults();
        this.setSelectedButton(this.joinButtons, this.getActivity().getJoin().getValue());
        this.setSelectedButton(this.splitButtons, this.getActivity().getSplit().getValue());
        this.setSelectedButton(this.loopButtons, this.getLoopButtonIndex());
        this.updateLimitCheckBox();
    }

    @Override
    public void loadFieldsFromElement(IModelElementNodeSymbol symbol, IModelElement element) {
        WidgetBindingManager wBndMgr = this.getWidgetBindingManager();
        this.getActivity();
        this.setSelectedButton(this.joinButtons, this.getActivity().getJoin().getValue());
        this.setSelectedButton(this.splitButtons, this.getActivity().getSplit().getValue());
        this.setSelectedButton(this.loopButtons, this.getLoopButtonIndex());
        if (element instanceof GatewaySymbol) {
            switch (((GatewaySymbol)element).getFlowKind().getValue()) {
                case 1: {
                    this.disableButtons(this.splitButtons);
                    break;
                }
                case 2: {
                    this.disableButtons(this.joinButtons);
                }
            }
            this.setLoopType(null);
            this.disableButtons(this.loopButtons);
        } else {
            this.enableLoopGroup();
            TestTimeType test = this.loopStandard.getTestTime();
            if (test != null) {
                this.standardLoopButtons[test.getValue()].setSelection(true);
            }
            wBndMgr.bind(this.loopConditionText, (EObject)this.loopStandard, (EStructuralFeature)XpdlPackage.eINSTANCE.getLoopStandardType_LoopCondition(), XpdlFeatureAdapter.INSTANCE);
            MIOrderingType ordering = this.loopMulti.getMIOrdering();
            if (ordering != null) {
                this.multiLoopButtons[ordering.getValue()].setSelection(true);
                this.updateLimitVisibility(ordering);
            }
            wBndMgr.bind(this.inputViewer, (EObject)this.loopMulti.getLoopDataRef(), (EStructuralFeature)ExtensionPackage.eINSTANCE.getLoopDataRefType_InputItemRef(), (EFeatureAdapter)new AccessPointFeatureAdapter(this.inputViewer, this.inContext));
            wBndMgr.bind(this.counterViewer, (EObject)this.loopMulti.getLoopDataRef(), (EStructuralFeature)ExtensionPackage.eINSTANCE.getLoopDataRefType_LoopCounterRef(), (EFeatureAdapter)new AccessPointFeatureAdapter(this.counterViewer, this.inContext));
            wBndMgr.bind(this.outputViewer, (EObject)this.loopMulti.getLoopDataRef(), (EStructuralFeature)ExtensionPackage.eINSTANCE.getLoopDataRefType_OutputItemRef(), (EFeatureAdapter)new AccessPointFeatureAdapter(this.outputViewer, this.outContext));
            wBndMgr.bind(this.maxBatchSizeText, (IExtensibleElement)this.getActivity(), "carnot:engine:mi:size");
            this.updateLimitCheckBox();
        }
        if (this.isStartActivity()) {
            this.disableButtons(this.joinButtons);
        }
        if (this.isEndActivity()) {
            this.disableButtons(this.splitButtons);
        }
    }

    private void updateLimitCheckBox() {
        try {
            this.limitCheckBox.setSelection(Integer.parseInt(AttributeUtil.getAttributeValue((IExtensibleElement)this.getActivity(), (String)"carnot:engine:mi:size")) > 0);
        }
        catch (Exception exception) {
            this.limitCheckBox.setSelection(false);
            this.maxBatchSizeText.getText().setText("");
        }
        this.maxBatchSizeText.getText().setEnabled(this.limitCheckBox.getSelection());
    }

    private boolean isEndActivity() {
        ActivityType activity = this.getActivity();
        ProcessDefinitionType process = (ProcessDefinitionType)activity.eContainer();
        EList diagramList = process.getDiagram();
        int i = 0;
        while (i < diagramList.size()) {
            DiagramType diagram = (DiagramType)diagramList.get(i);
            List activitySymbolList = DiagramUtil.getSymbols((ISymbolContainer)diagram, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getISymbolContainer_ActivitySymbol(), (IModelElement)activity);
            for (ActivitySymbolType activitySymbol : activitySymbolList) {
                EList outTransitions = activitySymbol.getOutTransitions();
                for (TransitionConnectionType connection : outTransitions) {
                    if (!(connection.getTargetActivitySymbol() instanceof EndEventSymbol)) continue;
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    private boolean isStartActivity() {
        ActivityType activity = this.getActivity();
        ProcessDefinitionType process = (ProcessDefinitionType)activity.eContainer();
        EList diagramList = process.getDiagram();
        int i = 0;
        while (i < diagramList.size()) {
            DiagramType diagram = (DiagramType)diagramList.get(i);
            List activitySymbolList = DiagramUtil.getSymbols((ISymbolContainer)diagram, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getISymbolContainer_ActivitySymbol(), (IModelElement)activity);
            for (ActivitySymbolType activitySymbol : activitySymbolList) {
                EList inTransitions = activitySymbol.getInTransitions();
                for (TransitionConnectionType connection : inTransitions) {
                    if (!(connection.getSourceActivitySymbol() instanceof StartEventSymbol)) continue;
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    private void setSelectedButton(Button[] buttons, int value) {
        int i = 0;
        while (i < buttons.length) {
            if (buttons[i] != null) {
                buttons[i].setSelection(i == value);
            }
            ++i;
        }
    }

    private void disableButtons(Button[] buttons) {
        int i = 0;
        while (i < buttons.length) {
            if (buttons[i] != null) {
                buttons[i].setEnabled(false);
            }
            ++i;
        }
    }

    @Override
    public void loadElementFromFields(IModelElementNodeSymbol symbol, IModelElement element) {
    }

    private void setJoinSplitType(int flowType, int gatewayType) {
        SetActivityControlFlowCmd cmd = new SetActivityControlFlowCmd(this.getEditor(), this.getActivity(), FlowControlType.get((int)flowType), JoinSplitType.get((int)gatewayType));
        if (cmd.canExecute()) {
            cmd.execute();
        }
    }

    private ActivityType getActivity() {
        return (ActivityType)this.getModelElement();
    }

    private int getLoopButtonIndex() {
        LoopTypeType type;
        if (this.getActivity().getLoop() != null && (type = this.loop.getLoopType()) != null) {
            return type.getValue() + 1;
        }
        return 0;
    }

    private void setLoopType(LoopTypeType type) {
        ActivityType activity = this.getActivity();
        if (type == null) {
            activity.setLoop(null);
        } else {
            if (activity.getLoop() != this.loop) {
                activity.setLoop(this.loop);
            }
            if (type != this.loop.getLoopType()) {
                this.loop.setLoopType(type);
            }
            this.setLoopStandard(type == LoopTypeType.STANDARD ? this.loopStandard : null);
            this.setLoopMulti(type == LoopTypeType.MULTI_INSTANCE ? this.loopMulti : null);
        }
    }

    private void setLoopStandard(LoopStandardType loopStandard) {
        if (this.loop.getLoopStandard() != loopStandard) {
            this.loop.setLoopStandard(loopStandard);
        }
    }

    private void setLoopMulti(LoopMultiInstanceType loopMulti) {
        if (this.loop.getLoopMultiInstance() != loopMulti) {
            this.loop.setLoopMultiInstance(loopMulti);
        }
    }

    @Override
    public Control createBody(Composite parent) {
        this.update2LoopStandard();
        this.initLoopData();
        Composite composite = FormBuilder.createComposite((Composite)parent, (int)1);
        this.createGroup(composite, 0, JoinSplitType.VALUES);
        this.createGroup(composite, 1, JoinSplitType.VALUES);
        this.createLoopGroup(composite);
        return composite;
    }

    private void initLoopData() {
        this.loop = this.getActivity().getLoop();
        if (this.loop == null) {
            this.loop = XpdlFactory.eINSTANCE.createLoopType();
        }
        this.loopStandard = this.loop.getLoopStandard();
        if (this.loopStandard == null) {
            this.loopStandard = XpdlFactory.eINSTANCE.createLoopStandardType();
            this.loopStandard.setTestTime(TestTimeType.BEFORE);
        }
        this.loopMulti = this.loop.getLoopMultiInstance();
        if (this.loopMulti == null) {
            this.loopMulti = XpdlFactory.eINSTANCE.createLoopMultiInstanceType();
            this.loopMulti.setMIOrdering(MIOrderingType.SEQUENTIAL);
            LoopDataRefType dataRef = this.loopMulti.getLoopDataRef();
            if (dataRef == null) {
                dataRef = ExtensionFactory.eINSTANCE.createLoopDataRefType();
                this.loopMulti.setLoopDataRef(dataRef);
            }
        }
    }

    private void createLoopGroup(Composite composite) {
        ArrayList<LoopType> loopTypes = new ArrayList<LoopType>();
        loopTypes.add(LoopType.NONE_LITERAL);
        loopTypes.addAll(LoopTypeType.VALUES);
        this.loopGroup = this.createGroup(composite, 2, loopTypes);
        this.standardLoopGroup = this.createStandardLoopGroup(this.loopGroup);
        this.standardLoopGroup.setLayoutData((Object)FormBuilder.createDefaultSingleLineWidgetGridData((int)loopTypes.size()));
        this.multiLoopGroup = this.createMultiLoopGroup(this.loopGroup);
        this.multiLoopGroup.setLayoutData((Object)FormBuilder.createDefaultSingleLineWidgetGridData((int)loopTypes.size()));
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActivityControlFlowPropertyPage.this.enableLoopGroup();
            }
        };
        Button[] buttonArray = this.loopButtons;
        int n = this.loopButtons.length;
        int n2 = 0;
        while (n2 < n) {
            Button loopButton = buttonArray[n2];
            loopButton.addSelectionListener((SelectionListener)listener);
            ++n2;
        }
    }

    private Composite createStandardLoopGroup(Group loopGroup) {
        int cols = TestTimeType.values().length + 1;
        Composite standardGroup = this.createLoopTypePanel(loopGroup, cols);
        FormBuilder.createLabel((Composite)standardGroup, (String)" ");
        this.standardLoopButtons = new Button[TestTimeType.values().length];
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestTimeType[] testTimeTypeArray = TestTimeType.values();
                int n = testTimeTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TestTimeType test = testTimeTypeArray[n2];
                    if (ActivityControlFlowPropertyPage.this.standardLoopButtons[test.getValue()].getSelection() && ActivityControlFlowPropertyPage.this.loopStandard.getTestTime() != test) {
                        ActivityControlFlowPropertyPage.this.loopStandard.setTestTime(test);
                    }
                    ++n2;
                }
            }
        };
        TestTimeType[] testTimeTypeArray = TestTimeType.values();
        int n = testTimeTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            TestTimeType test = testTimeTypeArray[n2];
            Button button = FormBuilder.createRadioButton((Composite)standardGroup, (String)ModelUtils.getFlowTypeText((String)test.getLiteral()));
            button.addSelectionListener((SelectionListener)listener);
            this.standardLoopButtons[test.getValue()] = button;
            ++n2;
        }
        Composite conditionComposite = FormBuilder.createComposite((Composite)standardGroup, (int)2, (int)cols);
        this.loopConditionText = FormBuilder.createLabeledText((Composite)conditionComposite, (String)Diagram_Messages.LB_FORMBUILDER_LoopCondition);
        return standardGroup;
    }

    private Composite createLoopTypePanel(Group loopGroup, int cols) {
        Composite panel = FormBuilder.createComposite((Composite)loopGroup, (int)cols, (int)3);
        ((GridLayout)panel.getLayout()).makeColumnsEqualWidth = true;
        ((GridLayout)panel.getLayout()).marginWidth = 0;
        Composite separator = FormBuilder.createComposite((Composite)panel, (int)1, (int)cols);
        ((GridLayout)separator.getLayout()).marginWidth = 10;
        ((GridData)separator.getLayoutData()).grabExcessVerticalSpace = false;
        FormBuilder.createHorizontalSeparator((Composite)separator, (int)1);
        return panel;
    }

    private Composite createMultiLoopGroup(Group loopGroup) {
        Composite multiGroup = this.createLoopTypePanel(loopGroup, 3);
        FormBuilder.createLabel((Composite)multiGroup, (String)" ");
        this.multiLoopButtons = new Button[MIOrderingType.values().length];
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MIOrderingType[] mIOrderingTypeArray = MIOrderingType.values();
                int n = mIOrderingTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MIOrderingType ordering = mIOrderingTypeArray[n2];
                    if (ActivityControlFlowPropertyPage.this.multiLoopButtons[ordering.getValue()].getSelection() && ActivityControlFlowPropertyPage.this.loopMulti.getMIOrdering() != ordering) {
                        ActivityControlFlowPropertyPage.this.loopMulti.setMIOrdering(ordering);
                        if (ordering == MIOrderingType.PARALLEL && ActivityControlFlowPropertyPage.this.getActivity().getImplementation() == ActivityImplementationType.SUBPROCESS_LITERAL && ActivityControlFlowPropertyPage.this.getActivity().getSubProcessMode() == SubProcessModeType.SYNC_SHARED_LITERAL) {
                            MessageBox mb = new MessageBox(ActivityControlFlowPropertyPage.this.getShell(), 40);
                            mb.setText("Incompatible subprocess execution mode");
                            mb.setMessage("Sub process execution mode will be changed to " + ModelUtils.getSubprocessModeTypeText((SubProcessModeType)SubProcessModeType.SYNC_SEPARATE_LITERAL));
                            mb.open();
                            ActivityControlFlowPropertyPage.this.getActivity().setSubProcessMode(SubProcessModeType.SYNC_SEPARATE_LITERAL);
                        }
                        ActivityControlFlowPropertyPage.this.updateLimitVisibility(ordering);
                    }
                    ++n2;
                }
            }
        };
        MIOrderingType[] mIOrderingTypeArray = MIOrderingType.values();
        int n = mIOrderingTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            MIOrderingType ordering = mIOrderingTypeArray[n2];
            Button button = FormBuilder.createRadioButton((Composite)multiGroup, (String)ModelUtils.getFlowTypeText((String)ordering.getLiteral()));
            button.addSelectionListener((SelectionListener)listener);
            this.multiLoopButtons[ordering.getValue()] = button;
            ++n2;
        }
        IdentifiableLabelProvider labelProvider = new IdentifiableLabelProvider(this.getEditor());
        LabelWithStatus inputLabel = FormBuilder.createLabelWithRightAlignedStatus((Composite)multiGroup, (String)"Input:");
        LabelWithStatus counterLabel = FormBuilder.createLabelWithRightAlignedStatus((Composite)multiGroup, (String)"Counter:");
        LabelWithStatus outputLabel = FormBuilder.createLabelWithRightAlignedStatus((Composite)multiGroup, (String)"Output:");
        List inContexts = ActivityUtil.getContextTypes((ActivityType)this.getActivity(), (DirectionType)DirectionType.IN_LITERAL);
        this.inContext = this.filterContext(inContexts);
        List inAPs = this.inContext == null ? Collections.emptyList() : ActivityUtil.getAccessPoints((ActivityType)this.getActivity(), (boolean)true, (String)this.inContext);
        List outContexts = ActivityUtil.getContextTypes((ActivityType)this.getActivity(), (DirectionType)DirectionType.OUT_LITERAL);
        this.outContext = this.filterContext(outContexts);
        List outAPs = this.outContext == null ? Collections.emptyList() : ActivityUtil.getAccessPoints((ActivityType)this.getActivity(), (boolean)false, (String)this.outContext);
        this.inputViewer = this.createCombo(multiGroup, labelProvider, inputLabel, inAPs);
        this.counterViewer = this.createCombo(multiGroup, labelProvider, counterLabel, inAPs);
        this.outputViewer = this.createCombo(multiGroup, labelProvider, outputLabel, outAPs);
        this.limitCheckBox = FormBuilder.createCheckBox((Composite)multiGroup, (String)"Limit Transaction Batch Size", (int)3);
        this.limitCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.selectionChanged();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.selectionChanged();
            }

            private void selectionChanged() {
                boolean enabled = ActivityControlFlowPropertyPage.this.limitCheckBox.getSelection();
                ActivityControlFlowPropertyPage.this.maxBatchSizeText.getText().setEnabled(enabled);
                if (enabled) {
                    if (ActivityControlFlowPropertyPage.this.maxBatchSizeText.getText().getText().trim().isEmpty()) {
                        ActivityControlFlowPropertyPage.this.maxBatchSizeText.getText().setText("1");
                    }
                } else {
                    ActivityControlFlowPropertyPage.this.maxBatchSizeText.getText().setText("");
                }
            }
        });
        Composite maxBatchSizePanel = FormBuilder.createComposite((Composite)multiGroup, (int)2, (int)3);
        ((GridLayout)maxBatchSizePanel.getLayout()).marginWidth = 0;
        ((GridLayout)maxBatchSizePanel.getLayout()).marginRight = 10;
        this.maxBatchSizeText = FormBuilder.createLabeledText((Composite)maxBatchSizePanel, (String)"Maximum Batch Size:");
        this.maxBatchSizeText.getText().setEnabled(false);
        return multiGroup;
    }

    private String filterContext(List<ApplicationContextTypeType> contexts) {
        int i = contexts.size() - 1;
        while (i >= 0) {
            String context = contexts.get(i).getId();
            if (!"default".equals(context) && !"engine".equals(context)) {
                return context;
            }
            --i;
        }
        return null;
    }

    private LabeledViewer createCombo(Composite parent, IdentifiableLabelProvider labelProvider, LabelWithStatus label, List<?> values) {
        Composite panel = FormBuilder.createComposite((Composite)parent, (int)1, (int)1);
        ((GridLayout)panel.getLayout()).marginWidth = 0;
        ((GridLayout)panel.getLayout()).marginRight = 10;
        ComboViewer inputCombo = FormBuilder.createComboViewer((Composite)panel, values);
        inputCombo.setLabelProvider((IBaseLabelProvider)labelProvider);
        return new LabeledViewer((StructuredViewer)inputCombo, label);
    }

    private void update2LoopStandard() {
        LoopType loopType;
        ActivityType activity = this.getActivity();
        if (activity.getLoop() == null && ((loopType = activity.getLoopType()) == LoopType.WHILE_LITERAL || loopType == LoopType.REPEAT_LITERAL)) {
            this.setLoopType(LoopTypeType.STANDARD);
            switch (loopType) {
                case WHILE_LITERAL: {
                    this.loopStandard.setTestTime(TestTimeType.BEFORE);
                    break;
                }
                case REPEAT_LITERAL: {
                    this.loopStandard.setTestTime(TestTimeType.AFTER);
                }
            }
            activity.setLoopType(null);
            String condition = activity.getLoopCondition();
            if (condition != null) {
                XpdlUtil.setLoopStandardCondition((LoopStandardType)this.loopStandard, (String)condition);
                activity.setLoopCondition(null);
            }
        }
    }

    private void enableLoopGroup() {
        boolean s = false;
        boolean m = false;
        if (this.loopButtons[0].getSelection()) {
            this.setLoopType(null);
        } else if (this.loopButtons[1].getSelection()) {
            this.setLoopType(LoopTypeType.STANDARD);
            s = true;
        } else if (this.loopButtons[2].getSelection()) {
            this.setLoopType(LoopTypeType.MULTI_INSTANCE);
            m = true;
        }
        ActivityControlFlowPropertyPage.setVisible((Control)this.standardLoopGroup, s);
        ActivityControlFlowPropertyPage.setVisible((Control)this.multiLoopGroup, m);
        this.loopGroup.layout();
    }

    private static void setVisible(Control control, boolean visible) {
        control.setVisible(visible);
        ((GridData)control.getLayoutData()).exclude = !visible;
    }

    private Group createGroup(Composite composite, int type, List<? extends Enumerator> enums) {
        Button[] buttons = new Button[enums.size()];
        Group group = FormBuilder.createGroup((Composite)composite, (String)NAMES[type], (int)enums.size());
        group.setLayoutData((Object)FormBuilder.createDefaultSingleLineWidgetGridData());
        ((GridLayout)group.getLayout()).makeColumnsEqualWidth = true;
        int i = 0;
        while (i < enums.size()) {
            Enumerator rawEnum = enums.get(i);
            buttons[i] = this.createRadioButton(group, String.valueOf(ModelUtils.getFlowTypeText((String)rawEnum.getLiteral())) + "  ", rawEnum.getValue(), type);
            ((GridData)buttons[i].getLayoutData()).horizontalAlignment = 16384;
            ++i;
        }
        switch (type) {
            case 0: {
                this.joinButtons = buttons;
                break;
            }
            case 1: {
                this.splitButtons = buttons;
                break;
            }
            case 2: {
                this.loopButtons = buttons;
            }
        }
        return group;
    }

    private Button createRadioButton(Group group, String name, final int value, final int type) {
        Button button = FormBuilder.createRadioButton((Composite)group, (String)name);
        if (type != 2) {
            SelectionAdapter listener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (((Button)e.widget).getSelection()) {
                        switch (type) {
                            case 0: {
                                ActivityControlFlowPropertyPage.this.setJoinSplitType(1, value);
                                break;
                            }
                            case 1: {
                                ActivityControlFlowPropertyPage.this.setJoinSplitType(2, value);
                            }
                        }
                    }
                }
            };
            button.addSelectionListener((SelectionListener)listener);
        }
        return button;
    }

    private void updateLimitVisibility(MIOrderingType ordering) {
        this.limitCheckBox.setVisible(ordering == MIOrderingType.SEQUENTIAL);
        this.maxBatchSizeText.getLabel().setVisible(ordering == MIOrderingType.SEQUENTIAL);
        this.maxBatchSizeText.getText().setVisible(ordering == MIOrderingType.SEQUENTIAL);
    }

    private static class AccessPointFeatureAdapter
    extends EFeatureAdapter {
        private LabeledViewer viewer;
        private String prefix;

        private AccessPointFeatureAdapter(LabeledViewer viewer, String context) {
            this.viewer = viewer;
            this.prefix = context == null ? "" : String.valueOf(context) + ':';
        }

        public Object fromModel(EObjectAdapter binding, Object value) {
            if (value instanceof String && ((String)value).startsWith(this.prefix)) {
                List accessPoints = (List)this.viewer.getViewer().getInput();
                return ModelUtils.findIdentifiableElement((List)accessPoints, (String)((String)value).substring(this.prefix.length()));
            }
            return super.fromModel(binding, value);
        }

        public Object toModel(EObjectAdapter binding, Object value) {
            if (value instanceof AccessPointType) {
                return String.valueOf(this.prefix) + ((AccessPointType)value).getId();
            }
            return super.toModel(binding, value);
        }
    }
}

