/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.properties;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.stardust.common.CompareHelper;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationContextTypeType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelFactory;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.ContextType;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.spi.SpiExtensionRegistry;
import org.eclipse.stardust.model.xpdl.carnot.util.ActivityUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.CreateMetaTypeCommand;
import org.eclipse.stardust.modeling.core.editors.ui.CarnotPreferenceNode;
import org.eclipse.stardust.modeling.core.editors.ui.ConfigurationElementLabelProvider;
import org.eclipse.stardust.modeling.core.editors.ui.TableManager;
import org.eclipse.stardust.modeling.core.properties.AbstractModelElementPropertyPage;
import org.eclipse.stardust.modeling.core.properties.ModelElementAdaptable;
import org.eclipse.stardust.modeling.core.spi.ConfigurationElement;
import org.eclipse.stardust.modeling.core.spi.SpiPropertyPage;
import org.eclipse.stardust.modeling.core.utils.MetaTypeModelingUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchPropertyPage;

public class ApplicationInteractivePropertyPage
extends AbstractModelElementPropertyPage {
    public static final String INTERACTIVE_ID = "_cwm_interactive_";
    public static final String INTERACTIVE_LABEL = Diagram_Messages.INTERACTIVE_LABEL;
    private HashMap newContexts = new HashMap();
    private TableManager tableManager;
    private IModelElementNodeSymbol savedSymbol;
    private IModelElement savedElement;

    @Override
    public void loadFieldsFromElement(IModelElementNodeSymbol symbol, IModelElement node) {
        this.savedSymbol = symbol;
        this.savedElement = node;
        this.resetContent();
        ApplicationType application = (ApplicationType)node;
        ModelType model = ModelUtils.findContainingModel((EObject)application);
        Map types = this.collectModelContextTypes(model);
        Map items = this.collectSpiContextTypes();
        Iterator iterator = items.keySet().iterator();
        while (iterator.hasNext()) {
            this.tableManager.addElement(items.get(iterator.next()));
        }
        for (ContextType contextType : application.getContext()) {
            ApplicationContextTypeType type = contextType.getType();
            if (type == null) continue;
            ConfigurationElement config = this.getCreate(type.getId(), items, types);
            boolean hasPage = items.containsKey(type.getId());
            this.tableManager.setGrayed(config, !hasPage);
            this.tableManager.setChecked(config, true);
            if (!hasPage) continue;
            this.updateContexts(true, type.getId());
        }
    }

    private Map collectSpiContextTypes() {
        TreeMap<String, ConfigurationElement> items = new TreeMap<String, ConfigurationElement>();
        SpiExtensionRegistry registry = SpiExtensionRegistry.instance();
        Map extensions = registry.getExtensions("contextTypes");
        for (String id : extensions.keySet()) {
            if (ActivityUtil.isImplicitContext((String)id)) continue;
            IConfigurationElement element = (IConfigurationElement)extensions.get(id);
            items.put(id, new ConfigurationElement(element));
        }
        return items;
    }

    private Map collectModelContextTypes(ModelType model) {
        HashMap<String, ApplicationContextTypeType> types = new HashMap<String, ApplicationContextTypeType>();
        for (ApplicationContextTypeType type : model.getApplicationContextType()) {
            types.put(type.getId(), type);
        }
        return types;
    }

    @Override
    protected void performDefaults() {
        this.loadFieldsFromElement(this.savedSymbol, this.savedElement);
    }

    private void resetContent() {
        this.removePreferenceNodes(INTERACTIVE_ID);
        this.tableManager.removeAll();
    }

    private ConfigurationElement getCreate(String id, Map items, Map types) {
        ConfigurationElement config = (ConfigurationElement)items.get(id);
        if (config == null) {
            ApplicationContextTypeType type = (ApplicationContextTypeType)types.get(id);
            config = ConfigurationElement.createPageConfiguration(id, type.getName(), "", "");
            this.tableManager.addElement(config);
        }
        return config;
    }

    @Override
    public void loadElementFromFields(IModelElementNodeSymbol symbol, IModelElement element) {
        ApplicationType application = (ApplicationType)element;
        ModelType model = ModelUtils.findContainingModel((EObject)application);
        Map types = this.collectModelContextTypes(model);
        EList contexts = application.getContext();
        int i = 0;
        while (i < this.tableManager.getRowCount()) {
            block4: {
                String type;
                block3: {
                    ConfigurationElement item = (ConfigurationElement)this.tableManager.getElementAt(new int[]{i});
                    type = item.getAttribute("id");
                    if (!this.tableManager.getChecked(i)) break block3;
                    ContextType ctx = (ContextType)this.newContexts.get(type);
                    if (ctx == null) break block4;
                    contexts.add(ctx);
                    if (types.containsKey(type)) break block4;
                    this.addContextType(model, item);
                    break block4;
                }
                int j = 0;
                while (j < contexts.size()) {
                    ContextType ctx = (ContextType)contexts.get(j);
                    if (ctx.getType() != null && CompareHelper.areEqual((Object)ctx.getType().getId(), (Object)type)) {
                        contexts.remove(j);
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private void addContextType(ModelType model, ConfigurationElement config) {
        Map extensions = SpiExtensionRegistry.instance().getExtensions("contextTypes");
        IConfigurationElement cfgContext = (IConfigurationElement)extensions.get(config.getAttribute("id"));
        CreateMetaTypeCommand cmd = MetaTypeModelingUtils.getCreateContextTypeCmd(cfgContext);
        cmd.setParent((EObject)model);
        cmd.execute();
    }

    @Override
    public Control createBody(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout compositeLayout = new GridLayout(1, false);
        composite.setLayout((Layout)compositeLayout);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        composite.setLayoutData((Object)gridData);
        Table table = new Table(composite, 67616);
        table.setHeaderVisible(true);
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem item = (TableItem)e.item;
                if (item != null && !item.getGrayed()) {
                    ApplicationInteractivePropertyPage.this.updateContexts(item.getChecked(), item.getText());
                }
            }
        });
        GridData tableGridData = new GridData();
        tableGridData.grabExcessHorizontalSpace = true;
        tableGridData.grabExcessVerticalSpace = true;
        tableGridData.horizontalAlignment = 4;
        tableGridData.verticalAlignment = 4;
        table.setLayoutData((Object)tableGridData);
        this.tableManager = new TableManager(table);
        this.tableManager.setColumnSizes(new int[]{25, 75});
        this.tableManager.setColumnNames(new String[]{Diagram_Messages.COL_NAME_Context, Diagram_Messages.COL_NAME_Name});
        this.tableManager.setAttributeNames(new String[]{"id", "name"});
        this.tableManager.addLabelProvider(ConfigurationElementLabelProvider.instance());
        this.tableManager.setDefaultIcon("icons/full/obj16/application.gif");
        return composite;
    }

    private void updateContexts(boolean checked, String id) {
        ContextType contextType;
        ContextType ctx = null;
        ApplicationType application = (ApplicationType)this.getModelElement();
        EList contexts = application.getContext();
        int i = 0;
        while (i < contexts.size()) {
            contextType = (ContextType)contexts.get(i);
            if (contextType.getType() != null && CompareHelper.areEqual((Object)contextType.getType().getId(), (Object)id)) {
                ctx = contextType;
                break;
            }
            ++i;
        }
        if (ctx == null && (ctx = (ContextType)this.newContexts.get(id)) == null) {
            ctx = CarnotWorkflowModelFactory.eINSTANCE.createContextType();
            ModelType model = (ModelType)application.eContainer();
            contextType = ApplicationInteractivePropertyPage.getApplicationContextType(model, id);
            if (contextType == null) {
                Map items = this.collectSpiContextTypes();
                ConfigurationElement cfgContext = (ConfigurationElement)items.get(id);
                this.addContextType(model, cfgContext);
                contextType = ApplicationInteractivePropertyPage.getApplicationContextType(model, id);
            }
            ctx.setType((ApplicationContextTypeType)contextType);
            this.newContexts.put(id, ctx);
        }
        String prefid = this.composePageId(INTERACTIVE_ID, id);
        if (checked) {
            if (this.getNode(prefid) == null) {
                SpiExtensionRegistry registry = SpiExtensionRegistry.instance();
                Map extensions = registry.getExtensions("contextTypes");
                IConfigurationElement template = (IConfigurationElement)extensions.get(id);
                ContextType context = ctx;
                final ConfigurationElement config = new ConfigurationElement(template);
                CarnotPreferenceNode node = new CarnotPreferenceNode(config, new ModelElementAdaptable(IModelElement.class, context, EditPart.class, this.getElement())){

                    @Override
                    public void createPage() {
                        try {
                            SpiPropertyPage page = new SpiPropertyPage(config);
                            this.internalSetPage((IWorkbenchPropertyPage)page);
                        }
                        catch (CoreException e) {
                            ErrorDialog.openError((Shell)ApplicationInteractivePropertyPage.this.getShell(), (String)Diagram_Messages.ERROR_DIA_EXC, (String)e.getMessage(), (IStatus)e.getStatus());
                        }
                    }
                };
                this.addNodeTo(INTERACTIVE_ID, node, null);
            }
        } else {
            this.removePreferenceNodes(prefid, true);
        }
        this.refreshTree();
    }

    private static ApplicationContextTypeType getApplicationContextType(ModelType model, String id) {
        return (ApplicationContextTypeType)ModelUtils.findIdentifiableElement((EObject)model, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getModelType_ApplicationContextType(), (String)id);
    }
}

