/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.properties;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.common.ui.jface.utils.LabeledText;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.properties.IdentifiablePropertyPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public class ProcessDefinitionGeneralPropertyPage
extends IdentifiablePropertyPage {
    private static final int DEFAULT_PRIORITY = 1;
    private LabeledText priorityText;
    private Button auditTrailPersistenceCheckBox;
    private String auditTrailPersistence = null;
    private ComboViewer comboViewer;
    private boolean isAuditTrailPersistent;

    @Override
    public void loadFieldsFromElement(IModelElementNodeSymbol symbol, IModelElement element) {
        super.loadFieldsFromElement(symbol, element);
        ProcessDefinitionType pd = (ProcessDefinitionType)element;
        this.priorityText.getText().setText(Integer.toString(pd.getDefaultPriority()));
        AttributeType auditTrailPersistenceAttribute = AttributeUtil.getAttribute((IExtensibleElement)((IExtensibleElement)this.getModelElement()), (String)"carnot:engine:auditTrailPersistence");
        if (auditTrailPersistenceAttribute != null) {
            this.auditTrailPersistence = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)this.getModelElement()), (String)"carnot:engine:auditTrailPersistence");
            this.auditTrailPersistenceCheckBox.setSelection(true);
            this.isAuditTrailPersistent = true;
            this.comboViewer.setSelection((ISelection)new StructuredSelection((Object)this.auditTrailPersistence));
        } else {
            this.comboViewer.getCombo().select(0);
        }
        this.comboViewer.getCombo().setEnabled(this.isAuditTrailPersistent);
    }

    @Override
    public void loadElementFromFields(IModelElementNodeSymbol symbol, IModelElement element) {
        super.loadElementFromFields(symbol, element);
        ProcessDefinitionType pd = (ProcessDefinitionType)element;
        try {
            String priority = this.priorityText.getText().getText().trim();
            if (StringUtils.isEmpty((String)priority)) {
                pd.setDefaultPriority(1);
            } else {
                pd.setDefaultPriority(Integer.parseInt(priority));
            }
        }
        catch (Exception exception) {}
        if (!this.isAuditTrailPersistent) {
            AttributeUtil.setAttribute((IExtensibleElement)this.modelElement, (String)"carnot:engine:auditTrailPersistence", null);
        }
    }

    @Override
    public void contributeExtraControls(Composite composite) {
        this.priorityText = FormBuilder.createLabeledText((Composite)composite, (String)Diagram_Messages.LBL_TXT_DEFAULT_PRIORITY);
        this.auditTrailPersistenceCheckBox = FormBuilder.createCheckBox((Composite)composite, (String)Diagram_Messages.LBL_AUDITTRAIL_PERSISTENCE, (int)1);
        ArrayList list = ModelUtils.getPersistenceOptions((ProcessDefinitionType)((ProcessDefinitionType)this.getModelElement()));
        this.comboViewer = FormBuilder.createComboViewer((Composite)composite, (List)list);
        this.comboViewer.getCombo().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection value = (IStructuredSelection)ProcessDefinitionGeneralPropertyPage.this.comboViewer.getSelection();
                AttributeUtil.setAttribute((IExtensibleElement)ProcessDefinitionGeneralPropertyPage.this.modelElement, (String)"carnot:engine:auditTrailPersistence", (String)value.getFirstElement().toString());
            }
        });
        this.comboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ModelUtils.getPersistenceOptionsText((String)element.toString());
            }
        });
        this.auditTrailPersistenceCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProcessDefinitionGeneralPropertyPage.this.isAuditTrailPersistent = !ProcessDefinitionGeneralPropertyPage.this.isAuditTrailPersistent;
                ProcessDefinitionGeneralPropertyPage.this.comboViewer.getCombo().setEnabled(ProcessDefinitionGeneralPropertyPage.this.isAuditTrailPersistent);
                if (ProcessDefinitionGeneralPropertyPage.this.isAuditTrailPersistent) {
                    IStructuredSelection value = (IStructuredSelection)ProcessDefinitionGeneralPropertyPage.this.comboViewer.getSelection();
                    AttributeUtil.setAttribute((IExtensibleElement)ProcessDefinitionGeneralPropertyPage.this.modelElement, (String)"carnot:engine:auditTrailPersistence", (String)value.getFirstElement().toString());
                }
            }
        });
    }
}

