/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.wizards;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.common.config.CurrentVersion;
import org.eclipse.stardust.common.reflect.Reflect;
import org.eclipse.stardust.engine.core.model.beans.XMLConstants;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelFactory;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.DataTypeType;
import org.eclipse.stardust.model.xpdl.carnot.DiagramModeType;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.OrientationType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.RoleType;
import org.eclipse.stardust.model.xpdl.carnot.spi.SpiExtensionRegistry;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.DiagramUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelVariable;
import org.eclipse.stardust.model.xpdl.carnot.util.VariableContext;
import org.eclipse.stardust.model.xpdl.carnot.util.VariableContextHelper;
import org.eclipse.stardust.model.xpdl.carnot.util.WorkflowModelManager;
import org.eclipse.stardust.model.xpdl.xpdl2.ScriptType;
import org.eclipse.stardust.model.xpdl.xpdl2.XpdlFactory;
import org.eclipse.stardust.modeling.common.projectnature.BpmProjectNature;
import org.eclipse.stardust.modeling.common.projectnature.classpath.BpmClasspathUtils;
import org.eclipse.stardust.modeling.common.ui.IdFactory;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.CreateMetaTypeCommand;
import org.eclipse.stardust.modeling.core.wizards.NewWorkflowDiagramWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class NewWorkflowDiagramWizard
extends Wizard
implements INewWizard {
    private ISelection selection;
    private IPreferenceStore pStore;
    private static final String[] defaultDataTypes = new String[]{"primitive", "serializable", "entity", "plainXML", "dmsDocument", "dmsDocumentList", "dmsFolder", "dmsFolderList", "struct"};
    private static final String[] defaultApplicationTypes = new String[]{"sessionBean", "plainJava", "jms", "webservice"};
    private static final String[] defaultContextTypes = new String[]{"default", "engine", "application", "jfc", "jsp", "processInterface", "externalWebApp"};
    private static final String[] defaultTriggerTypes = new String[]{"manual", "jms", "mail", "timer"};
    private static final String[] defaultConditionTypes = new String[]{"timer", "exception", "statechange", "processStatechange", "onAssignment"};
    private static final String[] defaultActionTypes = new String[]{"trigger", "mail", "abortProcess", "completeActivity", "activateActivity", "delegateActivity", "scheduleActivity", "excludeUser", "setData"};

    public NewWorkflowDiagramWizard() {
        this.setWindowTitle(Diagram_Messages.TITLE_NewCarnotWorkflowModel);
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.addPage((IWizardPage)new NewWorkflowDiagramWizardPage(this.selection));
    }

    public boolean performFinish() {
        final boolean[] result = new boolean[1];
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    IFile file = NewWorkflowDiagramWizard.this.getResourceContainer(monitor);
                    if (file.exists() && !MessageDialog.openQuestion((Shell)NewWorkflowDiagramWizard.this.getShell(), (String)file.getName(), (String)Diagram_Messages.MSG_AnotherFileAlreadyExists)) {
                        return;
                    }
                    try {
                        URI fileURI = URI.createPlatformResourceURI((String)file.getFullPath().toOSString(), (boolean)false);
                        WorkflowModelManager manager = new WorkflowModelManager();
                        manager.createModel(fileURI);
                        monitor.worked(1);
                        NewWorkflowDiagramWizard.this.createContent(manager.getModel());
                        monitor.worked(1);
                        manager.save(fileURI);
                        monitor.worked(1);
                        NewWorkflowDiagramWizard.this.openEditor(monitor, file);
                        result[0] = true;
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                    catch (IOException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(false, false, op);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)Diagram_Messages.ERR_Error, (String)realException.getMessage());
        }
        return result[0];
    }

    private void createContent(ModelType model) {
        NewWorkflowDiagramWizardPage props = (NewWorkflowDiagramWizardPage)this.getStartingPage();
        this.setModelAttributes(model, props.getModelId(), props.getModelName(), props.getModelDescription(), props.getModelAuthor());
        this.pStore = PlatformUI.getPreferenceStore();
        this.createDefaultDiagrams(model);
        this.createDefaultTypes(model);
        this.createDefaultData(model);
        this.createDefaultPerformers(model);
        this.createDefaultProcess(model);
        this.createDefaultCriticalityAttributes(model);
    }

    private void createDefaultProcess(ModelType model) {
        CarnotWorkflowModelFactory factory = CarnotWorkflowModelFactory.eINSTANCE;
        ProcessDefinitionType process = factory.createProcessDefinitionType();
        IdFactory idFactory = new IdFactory("ProcessDefinition", Diagram_Messages.BASENAME_ProcessDefinition);
        idFactory.computeNames((List)model.getProcessDefinition());
        process.setId(idFactory.getId());
        process.setName(idFactory.getName());
        model.getProcessDefinition().add((Object)process);
        DiagramType diagram = factory.createDiagramType();
        diagram.setName(Diagram_Messages.DIAGRAM_NAME_Default);
        String modelingDirection = this.pStore.contains("org.eclipse.stardust.modeling.common.projectnature.modelingDirection") ? this.pStore.getString("org.eclipse.stardust.modeling.common.projectnature.modelingDirection") : "Vertical";
        diagram.setOrientation(OrientationType.VERTICAL_LITERAL.toString().equals(modelingDirection) ? OrientationType.VERTICAL_LITERAL : OrientationType.HORIZONTAL_LITERAL);
        boolean classicMode = this.pStore.contains("org.eclipse.stardust.modeling.common.projectnature.classicMode") ? this.pStore.getBoolean("org.eclipse.stardust.modeling.common.projectnature.classicMode") : true;
        DiagramModeType defaultMode = classicMode ? DiagramModeType.MODE_400_LITERAL : DiagramModeType.MODE_450_LITERAL;
        diagram.setMode(defaultMode);
        process.getDiagram().add((Object)diagram);
        DiagramUtil.createDefaultPool((DiagramType)diagram);
    }

    private void createDefaultPerformers(ModelType model) {
        CarnotWorkflowModelFactory factory = CarnotWorkflowModelFactory.eINSTANCE;
        RoleType administrator = factory.createRoleType();
        administrator.setId("Administrator");
        administrator.setName(Diagram_Messages.BASENAME_Administrator);
        administrator.setDescription(ModelUtils.createDescription((String)Diagram_Messages.DESC_InChargeAdministrationActivities));
        model.getRole().add((Object)administrator);
    }

    private void createDefaultData(ModelType model) {
        DataTypeType dataType0 = (DataTypeType)ModelUtils.findIdentifiableElement((EObject)model, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getModelType_DataType(), (String)defaultDataTypes[0]);
        DataTypeType dataType1 = (DataTypeType)ModelUtils.findIdentifiableElement((EObject)model, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getModelType_DataType(), (String)defaultDataTypes[1]);
        DataTypeType dataType2 = (DataTypeType)ModelUtils.findIdentifiableElement((EObject)model, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getModelType_DataType(), (String)defaultDataTypes[2]);
        DataType lastActivityPerformer = this.createData(model, dataType2, "LAST_ACTIVITY_PERFORMER", Diagram_Messages.NAME_LastActivityPerformer, Diagram_Messages.DESC_LastActivityPerformer);
        this.createAttribute(lastActivityPerformer, "carnot:engine:browsable", "boolean", "true");
        this.createAttribute(lastActivityPerformer, "carnot:engine:homeInterface", null, "org.eclipse.stardust.engine.api.runtime.UserHome");
        this.createAttribute(lastActivityPerformer, "carnot:engine:isLocal", "boolean", "true");
        this.createAttribute(lastActivityPerformer, "carnot:engine:jndiPath", null, "org.eclipse.stardust.engine.api.runtime.User");
        this.createAttribute(lastActivityPerformer, "carnot:engine:primaryKey", null, "org.eclipse.stardust.engine.api.runtime.UserPK");
        this.createAttribute(lastActivityPerformer, "carnot:engine:remoteInterface", null, "org.eclipse.stardust.engine.core.runtime.beans.IUser");
        DataType startingUser = this.createData(model, dataType2, "STARTING_USER", Diagram_Messages.NAME_StartingUser, Diagram_Messages.DESC_StartingUser);
        this.createAttribute(startingUser, "carnot:engine:browsable", "boolean", "true");
        this.createAttribute(startingUser, "carnot:engine:homeInterface", null, "org.eclipse.stardust.engine.api.runtime.UserHome");
        this.createAttribute(startingUser, "carnot:engine:isLocal", "boolean", "true");
        this.createAttribute(startingUser, "carnot:engine:jndiPath", null, "ag.carnot.workflow.runtime.User");
        this.createAttribute(startingUser, "carnot:engine:primaryKey", null, "org.eclipse.stardust.engine.api.runtime.UserPK");
        this.createAttribute(startingUser, "carnot:engine:remoteInterface", null, "org.eclipse.stardust.engine.core.runtime.beans.IUser");
        DataType currentUser = this.createData(model, dataType2, "CURRENT_USER", Diagram_Messages.NAME_CurrentUser, Diagram_Messages.DESC_CurrentUser);
        this.createAttribute(currentUser, "carnot:engine:browsable", "boolean", "true");
        this.createAttribute(currentUser, "carnot:engine:homeInterface", null, "org.eclipse.stardust.engine.api.runtime.UserHome");
        this.createAttribute(currentUser, "carnot:engine:isLocal", "boolean", "true");
        this.createAttribute(currentUser, "carnot:engine:jndiPath", null, "org.eclipse.stardust.engine.api.runtime.User");
        this.createAttribute(currentUser, "carnot:engine:primaryKey", null, "org.eclipse.stardust.engine.api.runtime.UserPK");
        this.createAttribute(currentUser, "carnot:engine:remoteInterface", null, "org.eclipse.stardust.engine.core.runtime.beans.IUser");
        DataType processId = this.createData(model, dataType0, "PROCESS_ID", Diagram_Messages.NAME_ProcessOID, Diagram_Messages.DESC_ProcessOID);
        this.createAttribute(processId, "carnot:engine:browsable", "boolean", "true");
        this.createAttribute(processId, "carnot:engine:type", "ag.carnot.workflow.spi.providers.data.java.Type", "long");
        DataType processPriority = this.createData(model, dataType0, "PROCESS_PRIORITY", Diagram_Messages.NAME_ProcessPriority, Diagram_Messages.DESC_ProcessPriority);
        this.createAttribute(processPriority, "carnot:engine:type", "ag.carnot.workflow.spi.providers.data.java.Type", "int");
        DataType rootProcessId = this.createData(model, dataType0, "ROOT_PROCESS_ID", Diagram_Messages.NAME_RootProcessOID, Diagram_Messages.DESC_RootProcessOID);
        this.createAttribute(rootProcessId, "carnot:engine:browsable", "boolean", "true");
        this.createAttribute(rootProcessId, "carnot:engine:type", "ag.carnot.workflow.spi.providers.data.java.Type", "long");
        DataType currentDate = this.createData(model, dataType0, "CURRENT_DATE", Diagram_Messages.NAME_CurrentDate, Diagram_Messages.DESC_CurrentDate);
        this.createAttribute(currentDate, "carnot:engine:browsable", "boolean", "true");
        this.createAttribute(currentDate, "carnot:engine:type", "ag.carnot.workflow.spi.providers.data.java.Type", "Calendar");
        DataType currentLocale = this.createData(model, dataType0, "CURRENT_LOCALE", Diagram_Messages.NAME_CurrentLocale, Diagram_Messages.DESC_CurrentLocale);
        this.createAttribute(currentLocale, "carnot:engine:browsable", "boolean", "true");
        this.createAttribute(currentLocale, "carnot:engine:type", "ag.carnot.workflow.spi.providers.data.java.Type", "String");
        DataType currentModel = this.createData(model, dataType1, "CURRENT_MODEL", Diagram_Messages.NAME_CurrentModel, Diagram_Messages.DESC_CurrentModel);
        this.createAttribute(currentModel, "carnot:engine:browsable", "boolean", "true");
        this.createAttribute(currentModel, "carnot:engine:className", null, "org.eclipse.stardust.engine.api.runtime.DeployedModelDescription");
    }

    private void createDefaultCriticalityAttributes(ModelType model) {
        VariableContextHelper.getInstance().createContext(model);
        VariableContext context = VariableContextHelper.getInstance().getContext(model);
        context.initializeVariables(model);
        ModelVariable modelVariable = new ModelVariable("${TDefault}", "86400", Diagram_Messages.CRITICALITY_TARGET_EXECUTION_TIME);
        context.createAttributeSet(modelVariable, 0);
        modelVariable = new ModelVariable("${CLow}", "0", Diagram_Messages.CRITICALITY_INITIAL_CRITICALITY_LOW);
        context.createAttributeSet(modelVariable, 1);
        modelVariable = new ModelVariable("${CMed}", "0.33", Diagram_Messages.CRITICALITY_INITIAL_CRITICALITY_MEDIUM);
        context.createAttributeSet(modelVariable, 2);
        modelVariable = new ModelVariable("${CHigh}", "0.66", Diagram_Messages.CRITICALITY_INITIAL_CRITICALITY_HIGH);
        context.createAttributeSet(modelVariable, 3);
        modelVariable = new ModelVariable("${MLow}", "10", Diagram_Messages.CRITICALITY_MULTIPLE_TARGET_EXECUTION_LOW);
        context.createAttributeSet(modelVariable, 4);
        modelVariable = new ModelVariable("${MMed}", "10", Diagram_Messages.CRITICALITY_MULTIPLE_TARGET_EXECUTION_MEDIUM);
        context.createAttributeSet(modelVariable, 5);
        modelVariable = new ModelVariable("${MHigh}", "10", Diagram_Messages.CRITICALITY_MULTIPLE_TARGET_EXECUTION_HIGH);
        context.createAttributeSet(modelVariable, 6);
        String formula = "if(activityInstance.getActivity().getTargetExecutionTime() == 0)\n{\n  T = ${TDefault};\n}\nelse\n{\n  T = activityInstance.getActivity().getTargetExecutionTime();\n}\nif(PROCESS_PRIORITY == -1)\n{\n  Cp = ${CLow};\n  Mp = ${MLow};\n}\nif(PROCESS_PRIORITY == 0)\n{\n   Cp = ${CMed};\n   Mp = ${MMed};\n}\nif(PROCESS_PRIORITY == 1)\n{\n   Cp = ${CHigh};\n   Mp = ${MHigh};\n}\nt = activityInstance.getAge() / 1000;\n\nCp + (1- Cp) * t/(Mp * T);\n";
        AttributeUtil.setAttribute((IExtensibleElement)model, (String)"ipp:criticalityFormula", (String)"String", (String)formula);
    }

    private void createAttribute(DataType data, String name, String type, String value) {
        CarnotWorkflowModelFactory factory = CarnotWorkflowModelFactory.eINSTANCE;
        AttributeType attribute = factory.createAttributeType();
        attribute.setName(name);
        if (type != null) {
            attribute.setType(type);
        }
        attribute.setValue(value);
        data.getAttribute().add((Object)attribute);
    }

    private DataType createData(ModelType model, DataTypeType type, String id, String name, String description) {
        CarnotWorkflowModelFactory factory = CarnotWorkflowModelFactory.eINSTANCE;
        DataType data = factory.createDataType();
        data.setId(id);
        data.setName(name);
        data.setType(type);
        data.setDescription(ModelUtils.createDescription((String)description));
        data.setPredefined(true);
        model.getData().add((Object)data);
        return data;
    }

    private void createDefaultTypes(ModelType model) {
        model.setTypeDeclarations(XpdlFactory.eINSTANCE.createTypeDeclarationsType());
        this.addMetaTypes(model, defaultDataTypes, "dataTypes", CarnotWorkflowModelPackage.eINSTANCE.getDataTypeType(), new EStructuralFeature[0]);
        this.addMetaTypes(model, defaultApplicationTypes, "applicationTypes", CarnotWorkflowModelPackage.eINSTANCE.getApplicationTypeType(), new EStructuralFeature[]{CarnotWorkflowModelPackage.eINSTANCE.getApplicationTypeType_Synchronous()});
        this.addMetaTypes(model, defaultContextTypes, "contextTypes", CarnotWorkflowModelPackage.eINSTANCE.getApplicationContextTypeType(), new EStructuralFeature[]{CarnotWorkflowModelPackage.eINSTANCE.getApplicationContextTypeType_HasMappingId(), CarnotWorkflowModelPackage.eINSTANCE.getApplicationContextTypeType_HasApplicationPath()});
        this.addMetaTypes(model, defaultTriggerTypes, "triggerTypes", CarnotWorkflowModelPackage.eINSTANCE.getTriggerTypeType(), new EStructuralFeature[]{CarnotWorkflowModelPackage.eINSTANCE.getTriggerTypeType_PullTrigger()});
        this.addMetaTypes(model, defaultConditionTypes, "conditionTypes", CarnotWorkflowModelPackage.eINSTANCE.getEventConditionTypeType(), new EStructuralFeature[]{CarnotWorkflowModelPackage.eINSTANCE.getEventConditionTypeType_Implementation(), CarnotWorkflowModelPackage.eINSTANCE.getEventConditionTypeType_ActivityCondition(), CarnotWorkflowModelPackage.eINSTANCE.getEventConditionTypeType_ProcessCondition()});
        this.addMetaTypes(model, defaultActionTypes, "actionTypes", CarnotWorkflowModelPackage.eINSTANCE.getEventActionTypeType(), new EStructuralFeature[]{CarnotWorkflowModelPackage.eINSTANCE.getEventActionTypeType_ActivityAction(), CarnotWorkflowModelPackage.eINSTANCE.getEventActionTypeType_ProcessAction(), CarnotWorkflowModelPackage.eINSTANCE.getEventActionTypeType_SupportedConditionTypes(), CarnotWorkflowModelPackage.eINSTANCE.getEventActionTypeType_UnsupportedContexts()});
    }

    private void addMetaTypes(ModelType model, String[] ids, String extensionPointId, EClass type, EStructuralFeature[] features) {
        Map extensions = SpiExtensionRegistry.instance().getExtensions(extensionPointId);
        int i = 0;
        while (i < ids.length) {
            IConfigurationElement config = (IConfigurationElement)extensions.get(ids[i]);
            CreateMetaTypeCommand command = new CreateMetaTypeCommand(config, type, features);
            command.setParent((EObject)model);
            command.execute();
            ++i;
        }
    }

    private void createDefaultDiagrams(ModelType model) {
        CarnotWorkflowModelFactory factory = CarnotWorkflowModelFactory.eINSTANCE;
        DiagramType diagram = factory.createDiagramType();
        diagram.setName(Diagram_Messages.NAME_DefaultDiagram);
        String modelingDirection = this.pStore.contains("org.eclipse.stardust.modeling.common.projectnature.modelingDirection") ? this.pStore.getString("org.eclipse.stardust.modeling.common.projectnature.modelingDirection") : "Vertical";
        diagram.setOrientation(OrientationType.VERTICAL_LITERAL.toString().equals(modelingDirection) ? OrientationType.VERTICAL_LITERAL : OrientationType.HORIZONTAL_LITERAL);
        boolean classicMode = this.pStore.contains("org.eclipse.stardust.modeling.common.projectnature.classicMode") ? this.pStore.getBoolean("org.eclipse.stardust.modeling.common.projectnature.classicMode") : true;
        DiagramModeType defaultMode = classicMode ? DiagramModeType.MODE_400_LITERAL : DiagramModeType.MODE_450_LITERAL;
        diagram.setMode(defaultMode);
        model.getDiagram().add((Object)diagram);
    }

    private ModelType setModelAttributes(ModelType model, String id, String name, String description, String author) {
        CarnotWorkflowModelFactory factory = CarnotWorkflowModelFactory.eINSTANCE;
        model.setId(id);
        model.setName(name);
        if (description.length() > 0) {
            model.setDescription(ModelUtils.createDescription((String)description));
        }
        model.setOid(0L);
        model.setAuthor(author);
        model.setCreated(new Date().toString());
        model.setCarnotVersion(CurrentVersion.getVersionName());
        model.setVendor(XMLConstants.VENDOR_NAME);
        model.setModelOID(0);
        ScriptType script = XpdlFactory.eINSTANCE.createScriptType();
        script.setType("text/ecmascript");
        model.setScript(script);
        AttributeType attrIsReleased = factory.createAttributeType();
        attrIsReleased.setName("carnot:engine:released");
        attrIsReleased.setType(Reflect.getAbbreviatedName(Boolean.TYPE));
        attrIsReleased.setValue(Reflect.convertObjectToString((Object)Boolean.FALSE));
        model.getAttribute().add((Object)attrIsReleased);
        AttributeType attrRevision = factory.createAttributeType();
        attrRevision.setName("carnot:engine:revision");
        attrRevision.setType(Reflect.getAbbreviatedName(Integer.TYPE));
        attrRevision.setValue(Reflect.convertObjectToString((Object)new Integer(0)));
        model.getAttribute().add((Object)attrRevision);
        AttributeType attrVersion = factory.createAttributeType();
        attrVersion.setName("carnot:engine:version");
        attrVersion.setValue(Reflect.convertObjectToString((Object)"1"));
        model.getAttribute().add((Object)attrVersion);
        return model;
    }

    private void openEditor(IProgressMonitor monitor, final IFile file) {
        monitor.setTaskName(Diagram_Messages.TASK_OpeningFileForEditing);
        this.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                }
                catch (PartInitException partInitException) {}
            }
        });
        monitor.worked(2);
    }

    private IFile getResourceContainer(IProgressMonitor monitor) throws CoreException {
        NewWorkflowDiagramWizardPage page = (NewWorkflowDiagramWizardPage)this.getStartingPage();
        monitor.beginTask(String.valueOf(Diagram_Messages.TASK_Creating) + page.getFileName(), 6);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = null;
        if (!StringUtils.isEmpty((String)page.getContainerName())) {
            resource = root.findMember((IPath)new Path(page.getContainerName()));
        } else {
            IProject project = this.createNewProject(root);
            resource = root.findMember((IPath)new Path(project.getName()));
        }
        if (!resource.isAccessible()) {
            Status status = new Status(4, "org.eclipse.stardust.modeling.core", 0, MessageFormat.format(Diagram_Messages.MSG_ProjectNotOpen, resource.getName()), null);
            throw new CoreException((IStatus)status);
        }
        IFile file = ((IContainer)resource).getFile((IPath)new Path(page.getFileName()));
        monitor.worked(1);
        return file;
    }

    private IProject createNewProject(IWorkspaceRoot root) throws CoreException, JavaModelException {
        IProject project = root.getProject("carnot-bpm");
        if (!project.exists()) {
            project.create(null);
            project.open(null);
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IProjectDescription description = project.getDescription();
            description.setNatureIds(new String[]{"org.eclipse.jdt.core.javanature"});
            project.setDescription(description, null);
            javaProject.setRawClasspath(new IClasspathEntry[]{JavaRuntime.getDefaultJREContainerEntry()}, null);
            BpmProjectNature.enableBpmNature((IProject)project);
            BpmClasspathUtils.addBpmCoreLibsContainer((IProject)project);
        }
        return project;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }
}

