/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.debug.debugger;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.stardust.common.Assert;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.common.config.Parameters;
import org.eclipse.stardust.common.config.ParametersFacade;
import org.eclipse.stardust.common.config.PropertyLayerFactory;
import org.eclipse.stardust.common.error.InternalException;
import org.eclipse.stardust.common.error.ObjectNotFoundException;
import org.eclipse.stardust.common.error.PublicException;
import org.eclipse.stardust.common.log.LogManager;
import org.eclipse.stardust.common.log.Logger;
import org.eclipse.stardust.engine.api.model.IActivity;
import org.eclipse.stardust.engine.api.model.IApplicationContextType;
import org.eclipse.stardust.engine.api.model.IData;
import org.eclipse.stardust.engine.api.model.IDataMapping;
import org.eclipse.stardust.engine.api.model.IDataType;
import org.eclipse.stardust.engine.api.model.IExternalPackage;
import org.eclipse.stardust.engine.api.model.IModel;
import org.eclipse.stardust.engine.api.model.IProcessDefinition;
import org.eclipse.stardust.engine.api.model.ImplementationType;
import org.eclipse.stardust.engine.api.model.Inconsistency;
import org.eclipse.stardust.engine.api.runtime.ActivityInstance;
import org.eclipse.stardust.engine.api.runtime.ProcessInstance;
import org.eclipse.stardust.engine.api.runtime.Service;
import org.eclipse.stardust.engine.api.runtime.WorkflowService;
import org.eclipse.stardust.engine.core.model.beans.DefaultXMLReader;
import org.eclipse.stardust.engine.core.model.xpdl.XpdlUtils;
import org.eclipse.stardust.engine.core.pojo.data.Type;
import org.eclipse.stardust.engine.core.runtime.beans.BpmRuntimeEnvironment;
import org.eclipse.stardust.engine.core.runtime.beans.IActivityInstance;
import org.eclipse.stardust.engine.core.runtime.beans.IProcessInstance;
import org.eclipse.stardust.engine.core.runtime.beans.ModelManagerLoader;
import org.eclipse.stardust.engine.core.runtime.beans.NullWatcher;
import org.eclipse.stardust.engine.core.runtime.beans.ProcessInstanceBean;
import org.eclipse.stardust.engine.core.runtime.beans.TransitionTokenBean;
import org.eclipse.stardust.engine.core.runtime.beans.interceptors.PropertyLayerProviderInterceptor;
import org.eclipse.stardust.engine.core.runtime.beans.removethis.ItemDescription;
import org.eclipse.stardust.engine.core.runtime.beans.removethis.ItemLoader;
import org.eclipse.stardust.engine.core.runtime.beans.removethis.ItemLocatorUtils;
import org.eclipse.stardust.modeling.debug.Internal_Debugger_Messages;
import org.eclipse.stardust.modeling.debug.debugger.DebuggerArgument;
import org.eclipse.stardust.modeling.debug.debugger.types.ActivityInstanceDigest;
import org.eclipse.stardust.modeling.debug.debugger.types.TransitionTokenDigest;
import org.eclipse.stardust.modeling.debug.engine.DebugActivityThreadContext;
import org.eclipse.stardust.modeling.debug.engine.DebugServiceFactory;
import org.eclipse.stardust.modeling.debug.engine.DebugSession;
import org.eclipse.stardust.modeling.debug.engine.WorkflowCompletionWaiter;
import org.eclipse.stardust.modeling.debug.engine.WorkflowEventListener;

public class Debugger {
    private static final String CARNOT_SPRING_DEBUGGING_CONTEXT_XML = "carnot-spring-debugging-context.xml";
    private static final Logger trace = LogManager.getLogger(Debugger.class);
    private static final String unsupportedImplType = Internal_Debugger_Messages.getString("MSG_UnsupportedActivityImplType");
    private static Object syncObject = new Object();
    private List<IModel> oldStyleModels;
    private IProcessDefinition oldStyleProcessDefinition;
    private DebugServiceFactory debugServiceFactory;
    private DebugActivityThreadContext activityThreadContext;
    private WorkflowEventListenerImpl workflowEventListener;
    private ThreadGroup helperThreadGroup;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Debugger instance = null;
        try {
            try {
                instance = new Debugger(new DebuggerArgument(args));
                ProcessInstantiatorThread thread = new ProcessInstantiatorThread(instance);
                thread.start();
                Object object = syncObject;
                synchronized (object) {
                    syncObject.wait();
                }
            }
            catch (Throwable x) {
                x.printStackTrace();
                throw new InternalException("", x);
            }
        }
        finally {
            if (instance != null) {
                instance.stop();
            }
        }
    }

    public Debugger(DebuggerArgument arg) throws CoreException {
        boolean analystView = "analyst".equals(arg.getViewType());
        Parameters.instance().setBoolean("Carnot.Internal.EnableDebuggerHacks", analystView);
        List<String> deps = arg.getDependencyPaths();
        List paths = CollectionUtils.newList((int)(deps.size() + 1));
        paths.add(arg.getModelPath());
        paths.addAll(deps);
        this.oldStyleModels = CollectionUtils.newList((int)paths.size());
        for (String modelPath : paths) {
            System.err.println("Bootstrap: loading model from: " + modelPath);
            File modelFile = new File(modelPath);
            try {
                IModel oldStyleModel = this.importModel(modelFile);
                if (analystView) {
                    this.fixModel(oldStyleModel);
                }
                this.oldStyleModels.add(oldStyleModel);
            }
            catch (FileNotFoundException x) {
                throw new PublicException(Internal_Debugger_Messages.getString("MSG_FileForCurrentModelNotFound"), (Throwable)x);
            }
        }
        this.oldStyleProcessDefinition = this.oldStyleModels.get(0).findProcessDefinition(arg.getProcessDefinitionId());
        if (this.oldStyleProcessDefinition == null) {
            throw new ObjectNotFoundException(MessageFormat.format(Internal_Debugger_Messages.getString("EXP_ProcessDefinitionNotFoundInModel"), arg.getProcessDefinitionId()));
        }
        if (!this.init()) {
            throw new CoreException((IStatus)new Status(8, "org.eclipse.stardust.modeling.debug", 0, Internal_Debugger_Messages.getString("EXP_DebuggingCanceled"), null));
        }
    }

    private void fixModel(IModel model) {
        this.fixData(model);
        this.fixProcesses(model);
    }

    private void fixProcesses(IModel model) {
        Iterator i = model.getAllProcessDefinitions();
        while (i.hasNext()) {
            IProcessDefinition definition = (IProcessDefinition)i.next();
            this.fixActivities(model, definition);
        }
    }

    private void fixActivities(IModel model, IProcessDefinition definition) {
        Iterator i = definition.getAllActivities();
        while (i.hasNext()) {
            IActivity activity = (IActivity)i.next();
            ImplementationType implementation = activity.getImplementationType();
            if (!ImplementationType.SubProcess.equals((Object)implementation)) {
                activity.setImplementationType(activity.getPerformer() == null ? ImplementationType.Route : ImplementationType.Manual);
            }
            if (!activity.getAllDataMappings().hasNext()) continue;
            this.fixDataMappings(model, activity);
        }
    }

    private void fixDataMappings(IModel model, IActivity activity) {
        if (ImplementationType.Manual.equals((Object)activity.getImplementationType())) {
            ArrayList<String> contexts = new ArrayList<String>();
            Iterator i = activity.getAllDataMappings();
            while (i.hasNext()) {
                IDataMapping mapping = (IDataMapping)i.next();
                if (mapping.getContext().equals("default")) {
                    return;
                }
                if (contexts.contains(mapping.getContext())) continue;
                contexts.add(mapping.getContext());
            }
            i = model.getAllApplicationContextTypes();
            while (i.hasNext()) {
                IApplicationContextType type = (IApplicationContextType)i.next();
                if (!contexts.contains(type.getId())) continue;
                this.replaceContext(activity, type.getId());
                return;
            }
            this.replaceContext(activity, (String)contexts.get(0));
        }
    }

    private void replaceContext(IActivity activity, String id) {
        if (!"engine".equals(id)) {
            Iterator i = activity.getAllDataMappings();
            while (i.hasNext()) {
                IDataMapping mapping = (IDataMapping)i.next();
                if (!id.equals(mapping.getContext())) continue;
                mapping.setContext("default");
            }
        }
    }

    private void fixData(IModel model) {
        IDataType primitive = null;
        IDataType serializable = null;
        Iterator i = model.getAllDataTypes();
        while (i.hasNext()) {
            IDataType type = (IDataType)i.next();
            if ("primitive".equals(type.getId()) && primitive == null) {
                primitive = type;
            }
            if (!"serializable".equals(type.getId()) || serializable != null) continue;
            serializable = type;
        }
        i = model.getAllData();
        block1: while (i.hasNext()) {
            IData data = (IData)i.next();
            if (data.getType() == null) {
                String hint = (String)data.getAttribute("carnot:engine:typeHint");
                if ("text".equals(hint) && primitive != null) {
                    trace.debug((Object)("Setting data type primitive string for " + data));
                    data.setDataType(primitive);
                    data.setAttribute("carnot:engine:type", (Object)Type.String);
                    data.setAttribute("carnot:engine:browsable", (Object)Boolean.TRUE);
                    continue;
                }
                if ("numeric".equals(hint) && primitive != null) {
                    trace.debug((Object)("Setting data type primitive double for " + data));
                    data.setDataType(primitive);
                    data.setAttribute("carnot:engine:type", (Object)Type.Double);
                    data.setAttribute("carnot:engine:browsable", (Object)Boolean.TRUE);
                    continue;
                }
                if ("complex".equals(hint) && serializable != null) {
                    trace.debug((Object)("Setting data type serializable for " + data));
                    data.setDataType(serializable);
                    data.setAttribute("carnot:engine:className", (Object)"java.io.Serializable");
                    data.setAttribute("carnot:engine:browsable", (Object)Boolean.FALSE);
                    continue;
                }
                if (primitive != null) {
                    trace.debug((Object)("Setting data type primitive string for " + data));
                    data.setDataType(primitive);
                    data.setAttribute("carnot:engine:type", (Object)Type.String);
                    data.setAttribute("carnot:engine:browsable", (Object)Boolean.FALSE);
                    continue;
                }
                if (serializable != null) {
                    trace.debug((Object)("Setting data type serializable for " + data));
                    data.setDataType(serializable);
                    data.setAttribute("carnot:engine:className", (Object)"java.io.Serializable");
                    data.setAttribute("carnot:engine:browsable", (Object)Boolean.FALSE);
                    continue;
                }
                trace.warn((Object)("No suitable data type found for " + data));
                continue;
            }
            ArrayList inc = new ArrayList();
            data.checkConsistency(inc);
            for (Inconsistency element : inc) {
                if (element.getSeverity() != 1) continue;
                if (primitive.equals(data.getType())) {
                    data.setAttribute("carnot:engine:type", (Object)Type.String);
                    data.setAttribute("carnot:engine:browsable", (Object)Boolean.FALSE);
                    continue block1;
                }
                if (serializable.equals(data.getType())) {
                    data.setAttribute("carnot:engine:className", (Object)"java.io.Serializable");
                    continue block1;
                }
                if (data.getAttribute("carnot:engine:className") != null) {
                    data.setDataType(serializable);
                    continue block1;
                }
                data.setDataType(serializable);
                data.setAttribute("carnot:engine:className", (Object)"java.io.Serializable");
                continue block1;
            }
        }
    }

    public boolean init() {
        try {
            ItemLocatorUtils.registerDescription((String)"model.manager", (ItemDescription)new ItemDescription((ItemLoader)new ModelManagerLoader(), Parameters.instance().getString("Model.Watcher", NullWatcher.class.getName())));
            Parameters.instance().setBoolean(String.valueOf(new char[]{'E', 'n', 'g', 'i', 'n', 'e', '.', 'B', 'o', 'o', 't', 's', 't', 'r', 'a', 'p', 'p', 'e', 'd'}), true);
            Parameters.instance().set("CARNOT.Debugger", (Object)this);
            this.helperThreadGroup = new ThreadGroup("Infinity Helper Thread");
            Parameters.instance().set("ThreadGroup.Infinity Helper Thread", (Object)this.helperThreadGroup);
            Parameters.instance().set("ThreadGroup.Infinity Activity Thread", (Object)new ThreadGroup("Infinity Activity Thread"));
            Parameters.instance().set("ThreadGroup.Infinity On Completion Thread", (Object)new ThreadGroup("Infinity On Completion Thread"));
            DebugSession debugSession = new DebugSession();
            Parameters.instance().set("AuditTrail.Session", (Object)debugSession);
            BpmRuntimeEnvironment rtEnv = (BpmRuntimeEnvironment)ParametersFacade.pushLayer((Parameters)Parameters.instance(), (PropertyLayerFactory)PropertyLayerProviderInterceptor.BPM_RT_ENV_LAYER_FACTORY, (Map)CollectionUtils.newMap());
            Map overrides = CollectionUtils.newMap();
            for (IModel oldStyleModel : this.oldStyleModels) {
                overrides.put(oldStyleModel.getId(), oldStyleModel);
            }
            rtEnv.setModelOverrides(overrides);
            PropertyLayerProviderInterceptor.setCurrent((BpmRuntimeEnvironment)rtEnv);
            for (IModel model : this.oldStyleModels) {
                List packages = model.getExternalPackages();
                if (packages == null) continue;
                for (IExternalPackage pkg : packages) {
                    IModel ref = pkg.getReferencedModel();
                    System.err.println("Bootstrap: " + model + " uses " + ref);
                }
            }
            this.debugServiceFactory = new DebugServiceFactory(this.oldStyleModels);
            Parameters.instance().set("CARNOT.WorkflowServiceFactory", (Object)this.debugServiceFactory);
            this.activityThreadContext = this.debugServiceFactory.getActivityThreadContext();
            this.workflowEventListener = new WorkflowEventListenerImpl();
            this.activityThreadContext.addToWorkflowEventListeners(this.workflowEventListener);
            this.initSpringEnvironment();
        }
        catch (Exception e) {
            try {
                this.stop();
            }
            catch (Exception ex) {
                trace.warn((Object)Internal_Debugger_Messages.getString("MSG_UnexpectedExceptionWhileStoppingDebugger"), (Throwable)ex);
            }
            throw new InternalException((Throwable)e);
        }
        return true;
    }

    public void addWorkflowEventListener(WorkflowEventListener listener) {
        this.activityThreadContext.addToWorkflowEventListeners(listener);
    }

    public void start() {
        try {
            ProcessInstance processInstance;
            WorkflowService workflowService = this.debugServiceFactory.getWorkflowService();
            try {
                IModel model = this.oldStyleModels.get(0);
                String qualifiedId = String.valueOf('{') + model.getId() + '}' + this.oldStyleProcessDefinition.getId();
                System.err.println("Bootstrap: starting process " + qualifiedId);
                processInstance = workflowService.startProcess(qualifiedId, null, false);
            }
            finally {
                this.debugServiceFactory.release((Service)workflowService);
            }
            if (processInstance != null) {
                ProcessInstanceBean rootProcInst = ProcessInstanceBean.findByOID((long)processInstance.getRootProcessInstanceOID());
                WorkflowCompletionWaiter runnable = new WorkflowCompletionWaiter(this, (IProcessInstance)rootProcInst);
                ThreadGroup group = (ThreadGroup)Parameters.instance().get("ThreadGroup.Infinity On Completion Thread");
                new Thread(group, runnable).start();
            }
        }
        catch (Exception e) {
            try {
                this.stop();
            }
            catch (Exception ex) {
                trace.warn((Object)Internal_Debugger_Messages.getString("MSG_UnexpectedExceptionWhileStoppingDebugger"), (Throwable)ex);
            }
            throw new PublicException((Throwable)e);
        }
    }

    public void stop() {
        if (this.debugServiceFactory != null) {
            this.debugServiceFactory.close();
        }
    }

    public static void completeActivityInstance(WorkflowService service, ActivityInstance activityInstance) {
        Assert.isNotNull((Object)service);
        ImplementationType type = activityInstance.getActivity().getImplementationType();
        if (type != ImplementationType.Manual) {
            throw new InternalException(MessageFormat.format(unsupportedImplType, type));
        }
        service.complete(activityInstance.getOID(), "default", Debugger.processManualOutDataMappings(activityInstance.getActivity().getApplicationContext("default").getAllOutDataMappings().iterator()));
    }

    public IActivityInstance getNextActivityInstance() {
        return this.workflowEventListener.getNextActivityInstance();
    }

    public static List getAllDataMappings(ActivityInstance activityInstance) {
        if (activityInstance == null) {
            throw new PublicException(Internal_Debugger_Messages.getString("EXP_NoActivityInstanceSetOnWorkflowSession"));
        }
        ImplementationType implementationType = activityInstance.getActivity().getImplementationType();
        if (implementationType == ImplementationType.Manual) {
            return activityInstance.getActivity().getApplicationContext("default").getAllDataMappings();
        }
        throw new InternalException(MessageFormat.format(unsupportedImplType, implementationType));
    }

    public Map getInDataValues(IActivityInstance activityInstance) {
        WorkflowService workflowService = this.debugServiceFactory.getWorkflowService();
        try {
            Map map = workflowService.getInDataValues(activityInstance.getOID(), "default", null);
            return map;
        }
        finally {
            this.debugServiceFactory.release((Service)workflowService);
        }
    }

    public ThreadGroup getHelperThreadGroup() {
        return this.helperThreadGroup;
    }

    private static Map processManualOutDataMappings(Iterator outMappings) {
        HashMap outData = new HashMap();
        return outData;
    }

    private void initSpringEnvironment() {
        boolean springInitiated = false;
        try {
            boolean hasSpringContext = false;
            Class<?> clsSpringUtils = null;
            try {
                clsSpringUtils = Class.forName("org.eclipse.stardust.engine.api.spring.SpringUtils");
                File file = new File(CARNOT_SPRING_DEBUGGING_CONTEXT_XML);
                if (file.exists()) {
                    hasSpringContext = true;
                }
            }
            catch (Exception exception) {}
            if (hasSpringContext) {
                Object context;
                Parameters.instance().set("Carnot.Spring.ApplicationContextFile", (Object)CARNOT_SPRING_DEBUGGING_CONTEXT_XML);
                Method mthdGetAppContext = clsSpringUtils.getDeclaredMethod("getApplicationContext", new Class[0]);
                if (mthdGetAppContext != null && (context = mthdGetAppContext.invoke(null, new Object[0])) != null) {
                    Parameters.instance().set("ag.carnot.workflow.runtime.spring.applicationContext", context);
                    springInitiated = true;
                }
            }
        }
        catch (Exception e) {
            trace.warn((Object)"", (Throwable)e);
        }
        if (springInitiated) {
            trace.info((Object)"Spring RT support is available.");
        } else {
            trace.info((Object)"Spring RT support is not available.");
        }
    }

    private IModel importModel(File modelFile) throws FileNotFoundException {
        if (modelFile.getName().endsWith("xpdl")) {
            return XpdlUtils.loadXpdlModel((File)modelFile);
        }
        return new DefaultXMLReader(true).importFromXML((InputStream)new FileInputStream(modelFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        Object object = syncObject;
        synchronized (object) {
            syncObject.notifyAll();
        }
    }

    public static class ProcessInstantiatorThread
    extends Thread {
        private Debugger debugger;

        public ProcessInstantiatorThread(Debugger debugger) {
            super(debugger.getHelperThreadGroup(), "ProcessInstantiator");
            this.debugger = debugger;
        }

        @Override
        public void run() {
            this.debugger.start();
        }
    }

    public static class WorkflowEventListenerImpl
    implements WorkflowEventListener {
        public static String performedTransitionMethodName = "performedTransition";
        public static String appendedToWorklistMethodName = "appendedToWorklist";
        public static String startedActivityInstanceMethodName = "startedActivityInstance";
        public static String completedActivityInstanceMethodName = "completedActivityInstance";
        private Map threadMap = new HashMap();

        private void performedTransition(TransitionTokenDigest transToken) {
        }

        private void appendedToWorklist(ActivityInstanceDigest activityInstance) {
        }

        private void startedActivityInstance(ActivityInstanceDigest activityInstance) {
        }

        private void completedActivityInstance(ActivityInstanceDigest activityInstance) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void recordActivityInstance(IActivityInstance activityInstance) {
            Thread thread = Thread.currentThread();
            Map map = this.threadMap;
            synchronized (map) {
                ArrayList<IActivityInstance> activityInstances = (ArrayList<IActivityInstance>)this.threadMap.get(thread);
                if (activityInstances == null) {
                    activityInstances = new ArrayList<IActivityInstance>();
                    this.threadMap.put(thread, activityInstances);
                }
                activityInstances.add(activityInstance);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void deleteActivityInstance(IActivityInstance activityInstance) {
            Thread currentThread = Thread.currentThread();
            Map map = this.threadMap;
            synchronized (map) {
                List activityInstances = (List)this.threadMap.get(currentThread);
                if (activityInstances == null || !activityInstances.contains(activityInstance)) {
                    List temp = null;
                    for (Map.Entry entry : this.threadMap.entrySet()) {
                        temp = (List)entry.getValue();
                        if (!temp.contains(activityInstance)) continue;
                        Thread creatingThread = (Thread)entry.getKey();
                        trace.info((Object)MessageFormat.format(Internal_Debugger_Messages.getString("MSG_ActivityInstanceCompletedByDifferentThread"), activityInstance, currentThread, creatingThread));
                        activityInstances = temp;
                        break;
                    }
                }
                if (activityInstances != null) {
                    activityInstances.remove(activityInstance);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IActivityInstance getNextActivityInstance() {
            Thread thread = Thread.currentThread();
            IActivityInstance ai = null;
            Map map = this.threadMap;
            synchronized (map) {
                List activityInstances = (List)this.threadMap.get(thread);
                if (activityInstances != null && activityInstances.size() > 0) {
                    ai = (IActivityInstance)activityInstances.get(activityInstances.size() - 1);
                }
            }
            return ai;
        }

        @Override
        public void performedTransition(TransitionTokenBean transitionToken) {
            this.performedTransition(new TransitionTokenDigest(transitionToken));
        }

        @Override
        public void appendedToWorklist(IActivityInstance activityInstance) {
            this.appendedToWorklist(new ActivityInstanceDigest(activityInstance));
        }

        public void startedActivityInstance(IActivityInstance activityInstance) {
            this.recordActivityInstance(activityInstance);
            this.startedActivityInstance(new ActivityInstanceDigest(activityInstance));
        }

        public void completedActivityInstance(IActivityInstance activityInstance) {
            this.deleteActivityInstance(activityInstance);
            this.completedActivityInstance(new ActivityInstanceDigest(activityInstance));
        }
    }
}

