/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.debug.engine;

import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.stardust.common.Assert;
import org.eclipse.stardust.common.FilteringIterator;
import org.eclipse.stardust.common.Functor;
import org.eclipse.stardust.common.OneElementIterator;
import org.eclipse.stardust.common.Predicate;
import org.eclipse.stardust.common.TransformingIterator;
import org.eclipse.stardust.common.error.InternalException;
import org.eclipse.stardust.common.log.LogManager;
import org.eclipse.stardust.common.log.Logger;
import org.eclipse.stardust.engine.api.dto.ActivityInstanceDetails;
import org.eclipse.stardust.engine.core.persistence.AndTerm;
import org.eclipse.stardust.engine.core.persistence.ClosableIterator;
import org.eclipse.stardust.engine.core.persistence.ClosableIteratorUtils;
import org.eclipse.stardust.engine.core.persistence.ComparisonTerm;
import org.eclipse.stardust.engine.core.persistence.DefaultPersistentVector;
import org.eclipse.stardust.engine.core.persistence.FetchPredicate;
import org.eclipse.stardust.engine.core.persistence.FieldRef;
import org.eclipse.stardust.engine.core.persistence.IdentifiablePersistent;
import org.eclipse.stardust.engine.core.persistence.Join;
import org.eclipse.stardust.engine.core.persistence.Joins;
import org.eclipse.stardust.engine.core.persistence.Operator;
import org.eclipse.stardust.engine.core.persistence.PersistenceController;
import org.eclipse.stardust.engine.core.persistence.Persistent;
import org.eclipse.stardust.engine.core.persistence.PersistentVector;
import org.eclipse.stardust.engine.core.persistence.PredicateTerm;
import org.eclipse.stardust.engine.core.persistence.Predicates;
import org.eclipse.stardust.engine.core.persistence.QueryExtension;
import org.eclipse.stardust.engine.core.persistence.ResultIterator;
import org.eclipse.stardust.engine.core.persistence.Session;
import org.eclipse.stardust.engine.core.runtime.beans.AuditTrailPartitionBean;
import org.eclipse.stardust.engine.core.runtime.beans.DetailsFactory;
import org.eclipse.stardust.engine.core.runtime.beans.IActivityInstance;
import org.eclipse.stardust.engine.core.runtime.beans.IAuditTrailPartition;
import org.eclipse.stardust.engine.core.runtime.beans.IDataValue;
import org.eclipse.stardust.engine.core.runtime.beans.IProcessInstance;
import org.eclipse.stardust.engine.core.runtime.beans.ProcessInstanceBean;
import org.eclipse.stardust.engine.core.runtime.setup.DataClusterInstance;
import org.eclipse.stardust.modeling.debug.Internal_Debugger_Messages;
import org.eclipse.stardust.modeling.debug.engine.TransientPersistenceController;
import org.eclipse.stardust.modeling.debug.engine.TypeFilterIterator;

public class DebugSession
implements Session,
Session.NotJoinEnabled {
    private static final Logger trace = LogManager.getLogger(DebugSession.class);
    private static final String debugModeLimitation = Internal_Debugger_Messages.getString("MSG_DebugModelLimitation");
    private Map objects = new HashMap();
    private long oidCounter = 0L;
    private short partitionOidCounter = 0;

    public void connect() {
    }

    public void disconnect() {
    }

    public void cluster(Persistent object) {
        this.registerObject(object);
    }

    public boolean exists(Class type, QueryExtension queryExtension) {
        return this.findFirst(type, queryExtension) != null;
    }

    public long getCount(Class type) {
        return this.getCount(type, NO_QUERY_EXTENSION, null, 0);
    }

    public long getCount(Class type, QueryExtension queryExtension) {
        return this.getCount(type, queryExtension, null, 0);
    }

    public long getCount(Class type, QueryExtension queryExtension, int timeout) {
        return this.getCount(type, queryExtension, null, timeout);
    }

    public long getCount(Class type, QueryExtension queryExtension, boolean mayFail) {
        return this.getCount(type, queryExtension, null, 0);
    }

    public long getCount(Class type, QueryExtension queryExtension, FetchPredicate fetchPredicate, int timeout) {
        return this.getCount(type, queryExtension, fetchPredicate, timeout, Long.MAX_VALUE);
    }

    public long getCount(Class type, QueryExtension queryExtension, FetchPredicate fetchPredicate, int timeout, long totalCountThreshold) {
        if (!queryExtension.getJoins().isEmpty()) {
            throw new UnsupportedOperationException(debugModeLimitation);
        }
        TypeFilterIterator items = null;
        try {
            items = new TypeFilterIterator(this.getValuesIterator(), type, new Filter(queryExtension));
            long count = 0L;
            while (items.hasNext()) {
                Object item = items.next();
                if (fetchPredicate != null && !fetchPredicate.accept(item)) continue;
                ++count;
            }
            long l = count;
            return l;
        }
        finally {
            if (items != null) {
                items.close();
            }
        }
    }

    private Iterator getValuesIterator() {
        return new HashMap(this.objects).values().iterator();
    }

    public ResultIterator getIterator(Class type) {
        return new TypeFilterIterator(this.getValuesIterator(), type);
    }

    public ResultIterator getIterator(Class type, QueryExtension queryExtension) {
        return new TypeFilterIterator(this.getValuesIterator(), type, new Filter(queryExtension));
    }

    public ResultIterator getIterator(Class type, QueryExtension queryExtension, int startIndex, int extent) {
        return new SubsetIterator(this.getIterator(type, queryExtension), startIndex, extent);
    }

    public ResultIterator getIterator(Class type, QueryExtension queryExtension, int startIndex, int extent, int timeout) {
        if (!queryExtension.getJoins().isEmpty()) {
            throw new UnsupportedOperationException(debugModeLimitation);
        }
        return new SubsetIterator(this.getIterator(type, queryExtension), startIndex, extent);
    }

    public ResultIterator getIterator(Class type, QueryExtension queryExtension, int startIndex, int extent, FetchPredicate fetchPredicate, boolean countAll, int timeout) {
        if (!queryExtension.getJoins().isEmpty()) {
            throw new UnsupportedOperationException(debugModeLimitation);
        }
        return new SubsetIterator(new TypeFilterIterator((Iterator)this.getIterator(type, queryExtension), type, (Predicate)fetchPredicate), startIndex, extent);
    }

    public Vector getVector(Class type) {
        return (Vector)ClosableIteratorUtils.copyResult(new Vector(), (ClosableIterator)this.getIterator(type));
    }

    public Vector getVector(Class type, QueryExtension queryExtension) {
        return (Vector)ClosableIteratorUtils.copyResult(new Vector(), (ClosableIterator)this.getIterator(type, queryExtension));
    }

    public Persistent findByOID(Class type, long oid) {
        Persistent persistent = null;
        if (IdentifiablePersistent.class.isAssignableFrom(type)) {
            persistent = this.lookupObjectByOID(oid);
        } else if (IAuditTrailPartition.class.isAssignableFrom(type)) {
            persistent = this.findFirst(type, QueryExtension.where((PredicateTerm)Predicates.isEqual((FieldRef)AuditTrailPartitionBean.FR__OID, (long)oid)));
        }
        return persistent;
    }

    public Persistent findFirst(Class type, QueryExtension queryExtension) {
        return this.findFirst(type, queryExtension, 0);
    }

    public Persistent findFirst(Class type, QueryExtension queryExtension, int timeout) {
        Persistent persistent = null;
        ResultIterator i = this.getIterator(type, queryExtension);
        try {
            Filter filter = new Filter(queryExtension);
            while (i.hasNext()) {
                persistent = (Persistent)i.next();
                if (filter.accept(persistent)) {
                    break;
                }
                persistent = null;
            }
        }
        finally {
            i.close();
        }
        return persistent;
    }

    public void save() {
    }

    public void rollback() {
    }

    private void registerObject(Persistent object) {
        Assert.isNotNull((Object)object);
        if (object instanceof IdentifiablePersistent) {
            IdentifiablePersistent ip = (IdentifiablePersistent)object;
            if (ip.getOID() == 0L) {
                ip.setOID(this.generateOID());
            }
            trace.debug((Object)MessageFormat.format(Internal_Debugger_Messages.getString("MSG_AddObjectWithOid"), object, new Long(ip.getOID())));
            this.objects.put(Long.toString(ip.getOID()), object);
        } else {
            IAuditTrailPartition partition;
            if (object instanceof IAuditTrailPartition && (partition = (IAuditTrailPartition)object).getOID() == 0) {
                partition.setOID(this.generatePartitionOID());
            }
            this.objects.put(object, object);
        }
        object.setPersistenceController((PersistenceController)new TransientPersistenceController(object));
    }

    private Persistent lookupObjectByOID(long oid) {
        return (Persistent)this.objects.get(Long.toString(oid));
    }

    public PersistentVector createPersistentVector() {
        return new DefaultPersistentVector();
    }

    public Persistent fetchLink(Persistent persistent, String linkName) {
        return null;
    }

    public void deleteAllInstances(Class type, boolean delay) {
        throw new UnsupportedOperationException(debugModeLimitation);
    }

    public void deleteObjectByOID(long oid) {
        trace.debug((Object)MessageFormat.format(Internal_Debugger_Messages.getString("MSG_DeleteObjectWithOid"), new Long(oid)));
        this.objects.remove(Long.toString(oid));
    }

    private long generateOID() {
        return ++this.oidCounter;
    }

    private short generatePartitionOID() {
        this.partitionOidCounter = (short)(this.partitionOidCounter + 1);
        return this.partitionOidCounter;
    }

    public Iterator getWorklist() {
        return new TransformingIterator((Iterator)this.getIterator(IActivityInstance.class), new Functor(){

            public Object execute(Object source) {
                return DetailsFactory.create((Object)source, IActivityInstance.class, ActivityInstanceDetails.class);
            }
        }, new Predicate(){

            public boolean accept(Object o) {
                return ((IActivityInstance)o).getCurrentPerformer() != null;
            }
        });
    }

    public Iterator getProcessInstanceData(long processInstanceOID) {
        IProcessInstance pi = (IProcessInstance)this.findByOID(ProcessInstanceBean.class, processInstanceOID);
        final IProcessInstance rootPI = pi.getRootProcessInstance();
        return new FilteringIterator((Iterator)this.getIterator(IDataValue.class), new Predicate(){

            public boolean accept(Object o) {
                return ((IDataValue)o).getProcessInstance() == rootPI;
            }
        });
    }

    public void delete(Class type, PredicateTerm predicate, boolean delay) {
        this.delete(type, predicate, (Join)null, delay);
    }

    public void delete(Class type, PredicateTerm predicate, Join join, boolean delay) {
    }

    public void delete(Class type, PredicateTerm predicate, Joins join, boolean delay) {
    }

    public void lock(Class type, long oid) {
    }

    public void lock(Class type, long oid, long timeOut) {
    }

    public void lock(Class type, long oid, int timeOut) {
    }

    public boolean isSynchronized(Persistent persistent) {
        return true;
    }

    public void setSynchronized(Persistent persistent) {
    }

    public Persistent findObjectByPK(Class type, Object pk) {
        return null;
    }

    public boolean existsInCache(Class type, Object identityKey) {
        return this.objects.containsKey(identityKey);
    }

    public boolean isReadOnly() {
        return false;
    }

    public void cluster(DataClusterInstance cluster) {
    }

    public <T> Iterator<T> getSessionCacheIterator(Class<T> type, Session.FilterOperation<T> op) {
        HashSet persistents = new HashSet();
        for (Object o : this.objects.values()) {
            Object t;
            Session.FilterOperation.FilterResult result;
            if (!type.isAssignableFrom(o.getClass()) || (result = op.filter(t = o)) != Session.FilterOperation.FilterResult.ADD) continue;
            persistents.add(t);
        }
        return persistents.iterator();
    }

    private class Filter
    implements Predicate {
        private final QueryExtension queryExtension;
        private final List predicates;

        private Filter(QueryExtension queryExtension) {
            this.queryExtension = queryExtension;
            if (queryExtension != null) {
                Object parts;
                if (queryExtension.getPredicateTerm() instanceof AndTerm) {
                    AndTerm andTerm = (AndTerm)queryExtension.getPredicateTerm();
                    parts = andTerm.getParts().iterator();
                } else {
                    parts = new OneElementIterator((Object)queryExtension.getPredicateTerm());
                }
                this.predicates = new ArrayList();
                Object i = parts;
                while (i.hasNext()) {
                    PredicateTerm predicateTerm = (PredicateTerm)i.next();
                    if (predicateTerm instanceof ComparisonTerm) {
                        ComparisonTerm currentTerm = (ComparisonTerm)predicateTerm;
                        String attrName = currentTerm.getLhsField().fieldName;
                        Assert.condition((currentTerm.getValueExpr() instanceof Long || this.isSimpleArray(currentTerm.getValueExpr(), true) || currentTerm.getValueExpr() instanceof String || this.isSimpleArray(currentTerm.getValueExpr(), false) ? 1 : 0) != 0, (String)MessageFormat.format(Internal_Debugger_Messages.getString("EXP_UnsupportedPerdicateTerm_0"), queryExtension.getPredicateTerm()));
                        Object value = currentTerm.getValueExpr();
                        try {
                            Assert.condition((Operator.IS_EQUAL == currentTerm.getOperator() || Operator.IN == currentTerm.getOperator() || Operator.NOT_IN == currentTerm.getOperator() || Operator.NOT_EQUAL == currentTerm.getOperator() ? 1 : 0) != 0, (String)MessageFormat.format(Internal_Debugger_Messages.getString("EXP_UnsupportedPerdicateTerm_0_1_2"), attrName, currentTerm.getOperator(), value));
                        }
                        catch (Exception exception) {}
                        this.predicates.add(new Match(attrName, value));
                        continue;
                    }
                    Assert.lineNeverReached((String)MessageFormat.format(Internal_Debugger_Messages.getString("EXP_UnsupportedPerdicateTerm_0"), queryExtension.getPredicateTerm()));
                }
            } else {
                this.predicates = Collections.EMPTY_LIST;
            }
        }

        private boolean isSimpleArray(Object value, boolean isLong) {
            if (!(value instanceof ArrayList)) {
                return false;
            }
            ArrayList list = (ArrayList)value;
            int i = 0;
            while (i < list.size()) {
                if (isLong) {
                    if (!(list.get(i) instanceof Long)) {
                        return false;
                    }
                    if (!(list.get(i) instanceof String)) {
                        return false;
                    }
                }
                ++i;
            }
            return true;
        }

        public String toString() {
            return this.queryExtension.toString();
        }

        public boolean accept(Object o) {
            boolean accepted = true;
            try {
                for (Match match : this.predicates) {
                    Field attr = null;
                    Class<?> clazz = o.getClass();
                    while (clazz != null && attr == null) {
                        try {
                            trace.debug((Object)MessageFormat.format(Internal_Debugger_Messages.getString("MSG_LookingUpAttributeInClass"), match.getAttrName(), clazz.getName()));
                            attr = clazz.getDeclaredField(match.getAttrName());
                        }
                        catch (NoSuchFieldException e) {
                            clazz = clazz.getSuperclass();
                            if (clazz != null) continue;
                            throw e;
                        }
                    }
                    if (attr != null) {
                        String key;
                        attr.setAccessible(true);
                        if (IdentifiablePersistent.class.isAssignableFrom(attr.getType())) {
                            IdentifiablePersistent persistent = (IdentifiablePersistent)attr.get(o);
                            key = Long.toString(persistent.getOID());
                        } else if (IAuditTrailPartition.class.isAssignableFrom(attr.getType())) {
                            IAuditTrailPartition partition = (IAuditTrailPartition)attr.get(o);
                            key = Long.toString(partition.getOID());
                        } else {
                            key = attr.get(o).toString();
                        }
                        if (match.getValue() instanceof List) {
                            boolean matchedInClause = false;
                            Iterator in = ((List)match.getValue()).iterator();
                            while (in.hasNext()) {
                                if (!key.equals(in.next().toString())) continue;
                                matchedInClause = true;
                                break;
                            }
                            accepted &= matchedInClause;
                            continue;
                        }
                        accepted &= key.equals(match.getStringValue());
                        continue;
                    }
                    accepted &= match.getValue() == null || "null".equals(match.getValue()) || "NULL".equals(match.getValue());
                }
                return accepted;
            }
            catch (Exception e) {
                throw new InternalException((Throwable)e);
            }
        }

        private class Match {
            private final String attrName;
            private final Object value;

            private Match(String attrName, Object value) {
                this.attrName = attrName;
                this.value = value;
            }

            public Object getStringValue() {
                if (this.value == null) {
                    return null;
                }
                return this.value.toString();
            }

            public String getAttrName() {
                return this.attrName;
            }

            public Object getValue() {
                return this.value;
            }
        }
    }

    private class SubsetIterator
    implements ResultIterator {
        private final ResultIterator source;
        private final int startIndex;
        private final int extent;
        private int currentIndex;

        private SubsetIterator(ResultIterator source, int startIndex, int extent) {
            this.source = source;
            this.startIndex = startIndex;
            this.extent = extent;
            this.currentIndex = 0;
            while (this.currentIndex <= startIndex) {
                if (source.hasNext()) {
                    source.next();
                }
                ++this.currentIndex;
            }
        }

        public boolean hasNext() {
            return this.currentIndex < this.startIndex + this.extent && this.source.hasNext();
        }

        public Object next() {
            ++this.currentIndex;
            return this.source.next();
        }

        public void remove() {
            throw new UnsupportedOperationException(Internal_Debugger_Messages.getString("EXP_ImmutableIterator"));
        }

        public void close() {
            this.source.close();
        }

        public int getStartIndex() {
            return this.startIndex;
        }

        public int getMaxSize() {
            return this.extent;
        }

        public boolean hasMore() {
            return this.source.getMaxSize() >= this.startIndex + this.extent;
        }

        public boolean hasTotalCount() {
            return this.source.hasTotalCount();
        }

        public long getTotalCount() throws UnsupportedOperationException {
            return this.source.getTotalCount();
        }

        public long getTotalCountThreshold() {
            return this.source.getTotalCountThreshold();
        }
    }
}

