/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.debug.engine;

import java.awt.Frame;
import java.awt.Toolkit;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.eclipse.stardust.common.Action;
import org.eclipse.stardust.common.Direction;
import org.eclipse.stardust.common.config.Parameters;
import org.eclipse.stardust.common.config.PropertyLayer;
import org.eclipse.stardust.common.error.InternalException;
import org.eclipse.stardust.common.error.InvalidValueException;
import org.eclipse.stardust.common.error.ObjectNotFoundException;
import org.eclipse.stardust.common.log.LogManager;
import org.eclipse.stardust.common.log.Logger;
import org.eclipse.stardust.engine.api.dto.ActivityInstanceDetails;
import org.eclipse.stardust.engine.api.model.IActivity;
import org.eclipse.stardust.engine.api.model.IDataMapping;
import org.eclipse.stardust.engine.api.model.ImplementationType;
import org.eclipse.stardust.engine.api.runtime.ActivityInstance;
import org.eclipse.stardust.engine.api.runtime.Service;
import org.eclipse.stardust.engine.api.runtime.ServiceFactory;
import org.eclipse.stardust.engine.api.runtime.WorkflowService;
import org.eclipse.stardust.engine.core.runtime.beans.ActivityInstanceBean;
import org.eclipse.stardust.engine.core.runtime.beans.ForkingService;
import org.eclipse.stardust.engine.core.runtime.beans.IActivityInstance;
import org.eclipse.stardust.engine.core.runtime.beans.IUser;
import org.eclipse.stardust.engine.core.runtime.beans.ProcessInstanceBean;
import org.eclipse.stardust.engine.core.runtime.beans.interceptors.PropertyLayerProviderInterceptor;
import org.eclipse.stardust.modeling.debug.Internal_Debugger_Messages;
import org.eclipse.stardust.modeling.debug.debugger.Debugger;
import org.eclipse.stardust.modeling.debug.debugger.types.ActivityInstanceDigest;
import org.eclipse.stardust.modeling.debug.debugger.types.ProcessInstanceDigest;
import org.eclipse.stardust.modeling.debug.debugger.ui.ApplicationFrame;
import org.eclipse.stardust.modeling.debug.debugger.ui.WorkflowGUIAdapter;
import org.eclipse.stardust.modeling.debug.engine.ActivityThreadCarrier;
import org.eclipse.stardust.modeling.debug.engine.ManagedRunnerHelper;

public class ManagedRunner
implements Runnable {
    private static final Logger trace = LogManager.getLogger(ManagedRunner.class);
    private static final int PREFERRED_FRAME_Y_OFFSET = 25;
    private static final int PREFERRED_APP_FRAME_WIDTH = 500;
    private static final int PREFERRED_APP_FRAME_HEIGHT = 500;
    private static final int PREFERRED_DATA_FRAME_HEIGHT = 150;
    private static final int PREFERRED_WORKLIST_FRAME_HEIGHT = 150;
    private Action managedRunnable;
    private final ForkingService service;
    private final boolean isActivityThread;
    private IActivityInstance nextActivityInstance;
    private IUser inheritedUser;

    public ManagedRunner(Action managedRunnable, ForkingService service, boolean isActivityThread) {
        this(null, managedRunnable, service, isActivityThread);
    }

    public ManagedRunner(IUser inheritedUser, Action managedRunnable, ForkingService service, boolean isActivityThread) {
        this.inheritedUser = inheritedUser;
        this.managedRunnable = managedRunnable;
        this.service = service;
        this.isActivityThread = isActivityThread;
        this.nextActivityInstance = null;
    }

    @Override
    public void run() {
        block11: {
            Thread thread = Thread.currentThread();
            if (this.inheritedUser != null) {
                PropertyLayer layer = (PropertyLayer)Parameters.instance().get(PropertyLayerProviderInterceptor.PROPERTY_LAYER);
                if (layer != null) {
                    layer.setProperty("Current.User", (Object)this.inheritedUser);
                } else {
                    Parameters.instance().set("Current.User", (Object)this.inheritedUser);
                }
            }
            try {
                try {
                    this.service.isolate(this.managedRunnable);
                    do {
                        if (!this.isActivityThread) continue;
                        Debugger debugger = (Debugger)Parameters.instance().get("CARNOT.Debugger");
                        if (debugger == null) {
                            throw new InternalException(Internal_Debugger_Messages.getString("EXP_NoCurrentDebuggerInstanceFound"));
                        }
                        this.nextActivityInstance = debugger.getNextActivityInstance();
                        if (this.nextActivityInstance == null || ManagedRunner.isSubProcess(this.nextActivityInstance) || this.nextActivityInstance.isTerminated()) continue;
                        boolean completionDone = false;
                        while (!completionDone) {
                            trace.info((Object)MessageFormat.format(Internal_Debugger_Messages.getString("MSG_AboutToEnterCommunicationMethod"), thread, this.nextActivityInstance));
                            completionDone = this.communicateWithSuspendedActivityInstance(new ActivityInstanceDigest(this.nextActivityInstance), false);
                        }
                    } while (this.nextActivityInstance != null);
                }
                catch (Throwable e) {
                    trace.warn((Object)Internal_Debugger_Messages.getString("WARN_ExceptionallyTerminatingManagedRunnable"), e);
                    trace.info((Object)MessageFormat.format(Internal_Debugger_Messages.getString("MSG_TerminationOfJavaThread"), thread));
                    break block11;
                }
            }
            catch (Throwable throwable) {
                trace.info((Object)MessageFormat.format(Internal_Debugger_Messages.getString("MSG_TerminationOfJavaThread"), thread));
                throw throwable;
            }
            trace.info((Object)MessageFormat.format(Internal_Debugger_Messages.getString("MSG_TerminationOfJavaThread"), thread));
        }
    }

    private boolean communicateWithSuspendedActivityInstance(ActivityInstanceDigest activityInstance, boolean reloadValues) {
        ManagedRunnerHelper.suspendThread();
        activityInstance.updateDataMappings();
        ProcessInstanceDigest processInstance = activityInstance.getProcessInstance();
        if (processInstance != null) {
            processInstance.updateDataValues();
        }
        if (reloadValues) {
            return false;
        }
        Map data = new HashMap();
        ActivityThreadCarrier carrier = new ActivityThreadCarrier();
        if (ImplementationType.Application.getId().equals(activityInstance.getImplementationTypeId())) {
            ServiceFactory sf = (ServiceFactory)Parameters.instance().get("CARNOT.WorkflowServiceFactory");
            WorkflowService workflowService = sf.getWorkflowService();
            try {
                ActivityInstanceDetails aiDetails = new ActivityInstanceDetails(this.nextActivityInstance);
                WorkflowGUIAdapter guiAdapter = new WorkflowGUIAdapter();
                JPanel activityPanel = guiAdapter.getPanel(workflowService, (ActivityInstance)aiDetails);
                if (!this.showApplicationFrame(aiDetails.getActivity().getName(), activityPanel)) {
                    return false;
                }
                data = guiAdapter.processApplicationOutDataMappings(workflowService, (ActivityInstance)aiDetails);
                this.setOutDataValues("jfc", data, aiDetails.getOID());
            }
            finally {
                sf.release((Service)workflowService);
            }
        }
        carrier.setProcessInstance(this.nextActivityInstance.getProcessInstance());
        carrier.setActivity(this.nextActivityInstance.getActivity());
        carrier.setActivityInstance(this.nextActivityInstance);
        this.service.isolate(carrier.createAction());
        return true;
    }

    private void setOutDataValues(String context, Map values, long activityInstanceOID) throws ObjectNotFoundException, InvalidValueException {
        ActivityInstanceBean activityInstance = ActivityInstanceBean.findByOID((long)activityInstanceOID);
        if (context == null) {
            context = "default";
        }
        IActivity activity = activityInstance.getActivity();
        if (values != null && !values.isEmpty()) {
            for (Map.Entry entry : values.entrySet()) {
                IDataMapping dm = activity.findDataMappingById((String)entry.getKey(), Direction.OUT, context);
                if (dm == null) {
                    throw new ObjectNotFoundException(MessageFormat.format(Internal_Debugger_Messages.getString("EXP_NoDataMappingWithIdForContext"), entry.getKey(), context));
                }
                Object value = entry.getValue();
                this.setOutDataValue(dm, value, activityInstance.getProcessInstanceOID());
            }
        }
    }

    private void setOutDataValue(IDataMapping mapping, Object value, long processInstanceOID) throws ObjectNotFoundException, InvalidValueException {
        ProcessInstanceBean processInstance = ProcessInstanceBean.findByOID((long)processInstanceOID);
        processInstance.setOutDataValue(mapping.getData(), mapping.getDataPath(), value);
    }

    private boolean showApplicationFrame(String name, JPanel panel) {
        JFrame frame = new JFrame(name);
        frame.setVisible(true);
        ApplicationFrame applicationFrame = new ApplicationFrame((Frame)frame, name, panel);
        applicationFrame.setBounds(Toolkit.getDefaultToolkit().getScreenSize().width - 500, 325, 500, 500);
        applicationFrame.setVisible(true);
        frame.setVisible(true);
        boolean doComplete = applicationFrame.getDoComplete();
        frame.dispose();
        return doComplete;
    }

    private static boolean isSubProcess(IActivityInstance activityInstance) {
        return ImplementationType.SubProcess.equals((Object)activityInstance.getActivity().getImplementationType());
    }
}

