/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.integration.mail.application;

import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.spi.IApplicationPropertyPage;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.common.ui.jface.utils.LabeledCombo;
import org.eclipse.stardust.modeling.common.ui.jface.utils.LabeledText;
import org.eclipse.stardust.modeling.common.ui.swt.ComplexAttributeUtils;
import org.eclipse.stardust.modeling.common.ui.swt.ObjectTable;
import org.eclipse.stardust.modeling.core.properties.AbstractModelElementPropertyPage;
import org.eclipse.stardust.modeling.core.utils.WidgetBindingManager;
import org.eclipse.stardust.modeling.integration.mail.Mail_Messages;
import org.eclipse.stardust.modeling.integration.mail.application.OutputValue;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class MailPropertyPage
extends AbstractModelElementPropertyPage
implements IApplicationPropertyPage {
    private TabItem htmlItem;
    private LabeledText mailServerText;
    private LabeledText jndiSessionText;
    private LabeledText urlPrefixText;
    private Button htmlButton;
    private Button createProcessHistoryLinkButton;
    private LabeledText defaultFromText;
    private LabeledText defaultToText;
    private LabeledText defaultSubjectText;
    private LabeledText defaultCC;
    private LabeledText defaultBCC;
    private LabeledCombo defaultPriority;
    private LabeledText plainTextTemplateText;
    private LabeledText htmlHeaderText;
    private LabeledText htmlTemplateText;
    private LabeledText htmlFooterText;
    private ObjectTable outputValues;
    private Button subjectUniqueIdentified;

    public void loadFieldsFromElement(IModelElementNodeSymbol symbol, IModelElement element) {
        ApplicationType app = (ApplicationType)element;
        this.mailServerText.getText().setText(MailPropertyPage.nullSafe((IExtensibleElement)app, "carnot:engine:mail:defaultMailServer"));
        this.jndiSessionText.getText().setText(MailPropertyPage.nullSafe((IExtensibleElement)app, "carnot:engine:mail:defaultJNDISession"));
        this.urlPrefixText.getText().setText(MailPropertyPage.nullSafe((IExtensibleElement)app, "carnot:engine:mail:urlPrefix"));
        this.defaultCC.getText().setText(MailPropertyPage.nullSafe((IExtensibleElement)app, "carnot:engine:mail:defaultMailCC"));
        this.defaultBCC.getText().setText(MailPropertyPage.nullSafe((IExtensibleElement)app, "carnot:engine:mail:defaultMailBCC"));
        this.defaultPriority.getCombo().setText(MailPropertyPage.nullSafe((IExtensibleElement)app, "carnot:engine:mail:defaultMailPriority"));
        this.defaultSubjectText.getText().setText(MailPropertyPage.nullSafe((IExtensibleElement)app, "carnot:engine:mail:defaultMailSubject"));
        if (AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:mail:subjectIncludeUniqueIdentified") == null) {
            this.subjectUniqueIdentified.setSelection(true);
        } else {
            this.subjectUniqueIdentified.setSelection(AttributeUtil.getBooleanValue((IExtensibleElement)app, (String)"carnot:engine:mail:subjectIncludeUniqueIdentified"));
        }
        this.plainTextTemplateText.getText().setText(MailPropertyPage.nullSafe((IExtensibleElement)app, "carnot:engine:mail:plainTextTemplate"));
        this.htmlHeaderText.getText().setText(MailPropertyPage.nullSafe((IExtensibleElement)app, "carnot:engine:mail:htmlHeader"));
        this.htmlTemplateText.getText().setText(MailPropertyPage.nullSafe((IExtensibleElement)app, "carnot:engine:mail:htmlTemplate"));
        this.htmlFooterText.getText().setText(MailPropertyPage.nullSafe((IExtensibleElement)app, "carnot:engine:mail:htmlFooter"));
        this.htmlButton.setSelection(AttributeUtil.getBooleanValue((IExtensibleElement)app, (String)"carnot:engine:mail:useHTML"));
        if (this.htmlButton.getSelection()) {
            this.htmlHeaderText.getText().setEnabled(true);
            this.htmlTemplateText.getText().setEnabled(true);
            this.htmlFooterText.getText().setEnabled(true);
        } else {
            this.htmlHeaderText.getText().setEnabled(false);
            this.htmlTemplateText.getText().setEnabled(false);
            this.htmlFooterText.getText().setEnabled(false);
        }
        this.createProcessHistoryLinkButton.setSelection(AttributeUtil.getBooleanValue((IExtensibleElement)app, (String)"carnot:engine:mail:createProcessHistoryLink"));
        WidgetBindingManager wBndMgr = this.getWidgetBindingManager();
        wBndMgr.bind(this.defaultToText, (IExtensibleElement)app, "carnot:engine:mail:defaultMailTo");
        wBndMgr.bind(this.defaultFromText, (IExtensibleElement)app, "carnot:engine:mail:defaultMailFrom");
        wBndMgr.bind(this.mailServerText, (IExtensibleElement)app, "carnot:engine:mail:defaultMailServer");
        wBndMgr.bind(this.jndiSessionText, (IExtensibleElement)app, "carnot:engine:mail:defaultJNDISession");
        ComplexAttributeUtils.setValuesInObjectTable((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:mail:outputValues", (ObjectTable)this.outputValues);
    }

    public void loadElementFromFields(IModelElementNodeSymbol symbol, IModelElement element) {
        ApplicationType app = (ApplicationType)element;
        AttributeUtil.setAttribute((IExtensibleElement)app, (String)"carnot:engine:mail:defaultMailServer", (String)this.mailServerText.getText().getText());
        AttributeUtil.setAttribute((IExtensibleElement)app, (String)"carnot:engine:mail:defaultJNDISession", (String)this.jndiSessionText.getText().getText());
        AttributeUtil.setAttribute((IExtensibleElement)app, (String)"carnot:engine:mail:urlPrefix", (String)this.urlPrefixText.getText().getText());
        AttributeUtil.setAttribute((IExtensibleElement)app, (String)"carnot:engine:mail:defaultMailSubject", (String)this.defaultSubjectText.getText().getText());
        AttributeUtil.setBooleanAttribute((IExtensibleElement)app, (String)"carnot:engine:mail:subjectIncludeUniqueIdentified", (Boolean)this.subjectUniqueIdentified.getSelection());
        AttributeUtil.setAttribute((IExtensibleElement)app, (String)"carnot:engine:mail:defaultMailCC", (String)this.defaultCC.getText().getText());
        AttributeUtil.setAttribute((IExtensibleElement)app, (String)"carnot:engine:mail:defaultMailBCC", (String)this.defaultBCC.getText().getText());
        AttributeUtil.setAttribute((IExtensibleElement)app, (String)"carnot:engine:mail:defaultMailPriority", (String)this.defaultPriority.getCombo().getText());
        if (this.htmlButton.getSelection()) {
            AttributeUtil.setBooleanAttribute((IExtensibleElement)app, (String)"carnot:engine:mail:useHTML", (Boolean)true);
            AttributeUtil.setAttribute((IExtensibleElement)app, (String)"carnot:engine:mail:htmlHeader", (String)this.htmlHeaderText.getText().getText());
            AttributeUtil.setAttribute((IExtensibleElement)app, (String)"carnot:engine:mail:htmlTemplate", (String)this.htmlTemplateText.getText().getText());
            AttributeUtil.setAttribute((IExtensibleElement)app, (String)"carnot:engine:mail:htmlFooter", (String)this.htmlFooterText.getText().getText());
        } else {
            AttributeUtil.setBooleanAttribute((IExtensibleElement)app, (String)"carnot:engine:mail:useHTML", (Boolean)false);
        }
        AttributeUtil.setAttribute((IExtensibleElement)app, (String)"carnot:engine:mail:plainTextTemplate", (String)this.plainTextTemplateText.getText().getText());
        AttributeUtil.setBooleanAttribute((IExtensibleElement)app, (String)"carnot:engine:mail:createProcessHistoryLink", (Boolean)this.createProcessHistoryLinkButton.getSelection());
        ComplexAttributeUtils.getValuesFromObjectTable((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:mail:outputValues", (ObjectTable)this.outputValues);
    }

    public Control createBody(Composite parent) {
        Font courier9pt = new Font((Device)parent.getDisplay(), "Courier", 9, 0);
        Composite mainComposite = new Composite(parent, 0);
        mainComposite.setLayout((Layout)new FormLayout());
        Composite composite = FormBuilder.createComposite((Composite)mainComposite, (int)1);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 5);
        data.top = new FormAttachment(0, 5);
        composite.setLayoutData((Object)data);
        this.mailServerText = FormBuilder.createLabeledText((Composite)composite, (String)Mail_Messages.MAIL_SERVER_LABEL);
        this.jndiSessionText = FormBuilder.createLabeledText((Composite)composite, (String)Mail_Messages.JNDI_SESSION_LABEL);
        this.urlPrefixText = FormBuilder.createLabeledText((Composite)composite, (String)Mail_Messages.URL_PREFIX_LABEL);
        this.htmlButton = FormBuilder.createCheckBox((Composite)composite, (String)Mail_Messages.BOX_HTML);
        this.createProcessHistoryLinkButton = FormBuilder.createCheckBox((Composite)composite, (String)Mail_Messages.CREATE_PROCESS_HISTORY_LINK_LABEL);
        TabFolder tabFolder = new TabFolder(mainComposite, 0);
        data = new FormData();
        data.left = new FormAttachment(0, 5);
        data.top = new FormAttachment((Control)composite, 5, 1024);
        data.bottom = new FormAttachment(100, 5);
        tabFolder.setLayoutData((Object)data);
        TabItem item = new TabItem(tabFolder, 0);
        item.setText(Mail_Messages.TXT_DEFAULT_SETTINGS);
        composite = FormBuilder.createComposite((Composite)tabFolder, (int)1);
        item.setControl((Control)composite);
        String[] priorities = new String[]{Mail_Messages.PRIORITY_HIGHEST_VALUE, Mail_Messages.PRIORITY_HIGH_VALUE, Mail_Messages.PRIORITY_NORMAL_VALUE, Mail_Messages.PRIORITY_LOW_VALUE, Mail_Messages.PRIORITY_LOWEST_VALUE};
        this.defaultFromText = FormBuilder.createLabeledTextLeftAlignedStatus((Composite)composite, (String)Mail_Messages.DEFAULT_FROM_LABEL);
        this.defaultToText = FormBuilder.createLabeledTextLeftAlignedStatus((Composite)composite, (String)Mail_Messages.DEFAULT_TO_LABEL);
        this.defaultCC = FormBuilder.createLabeledText((Composite)composite, (String)Mail_Messages.DEFAULT_CC_LABEL);
        this.defaultBCC = FormBuilder.createLabeledText((Composite)composite, (String)Mail_Messages.DEFAULT_BCC_LABEL);
        this.defaultPriority = FormBuilder.createLabeledCombo((Composite)composite, (String)Mail_Messages.DEFAULT_PRIORITY_LABEL);
        this.defaultPriority.getCombo().setItems(priorities);
        this.defaultPriority.getCombo().setText(Mail_Messages.COMBO_BOX_NORMAL);
        this.defaultSubjectText = FormBuilder.createLabeledText((Composite)composite, (String)Mail_Messages.DEFAULT_SUBJECT_LABEL);
        this.subjectUniqueIdentified = FormBuilder.createCheckBox((Composite)composite, (String)Mail_Messages.SUBJECT_INCLUDE_UNIQUE_IDENTIFIED);
        FormBuilder.createButton((Composite)composite, (String)Mail_Messages.BUT_TEST, (SelectionListener)new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                MailPropertyPage.this.testDefaultMailSettings();
            }
        });
        this.htmlItem = item = new TabItem(tabFolder, 0);
        this.htmlItem.setText(Mail_Messages.TXT_HTML_TEMPLATE);
        this.htmlButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                if (MailPropertyPage.this.htmlButton.getSelection()) {
                    MailPropertyPage.this.htmlHeaderText.getText().setEnabled(true);
                    MailPropertyPage.this.htmlTemplateText.getText().setEnabled(true);
                    MailPropertyPage.this.htmlFooterText.getText().setEnabled(true);
                } else {
                    MailPropertyPage.this.htmlHeaderText.getText().setEnabled(false);
                    MailPropertyPage.this.htmlTemplateText.getText().setEnabled(false);
                    MailPropertyPage.this.htmlFooterText.getText().setEnabled(false);
                }
            }
        });
        composite = FormBuilder.createComposite((Composite)tabFolder, (int)1);
        item.setControl((Control)composite);
        this.htmlHeaderText = FormBuilder.createLabeledTextArea((Composite)composite, (String)Mail_Messages.HTML_HEADER_LABEL);
        this.htmlHeaderText.getText().setFont(courier9pt);
        this.htmlTemplateText = FormBuilder.createLabeledTextArea((Composite)composite, (String)Mail_Messages.HTML_TEMPLATE_LABEL);
        this.htmlTemplateText.getText().setFont(courier9pt);
        this.htmlFooterText = FormBuilder.createLabeledTextArea((Composite)composite, (String)Mail_Messages.HTML_FOOTER_LABEL);
        this.htmlFooterText.getText().setFont(courier9pt);
        item = new TabItem(tabFolder, 0);
        item.setText(Mail_Messages.TExT_PLAIN_TEXT_TEMPLATE);
        composite = FormBuilder.createComposite((Composite)tabFolder, (int)1);
        item.setControl((Control)composite);
        FormBuilder.createButton((Composite)composite, (String)Mail_Messages.BUT_TEST, (SelectionListener)new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                MailPropertyPage.this.testHTMLText();
            }
        });
        this.plainTextTemplateText = FormBuilder.createLabeledTextArea((Composite)composite, (String)Mail_Messages.PLAIN_TEXT_TEMPLATE_LABEL);
        this.plainTextTemplateText.getText().setFont(courier9pt);
        item = new TabItem(tabFolder, 0);
        item.setText(Mail_Messages.TXT_OUTPUT_VALUES);
        composite = FormBuilder.createComposite((Composite)tabFolder, (int)1);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        item.setControl((Control)composite);
        this.outputValues = new ObjectTable(composite, 61, 67586, OutputValue.class, new String[]{"name", "value"}, new String[]{Mail_Messages.COL_NAME, Mail_Messages.COL_VALUE}, new int[]{16384, 16384}, new int[]{200, 200}, new Image[2]);
        this.outputValues.setObjects(CollectionUtils.newList());
        this.outputValues.setLayoutData((Object)gridData);
        return mainComposite;
    }

    private void testHTMLText() {
    }

    private void testDefaultMailSettings() {
        try {
            Properties props = new Properties();
            props.put("mail.smtp.host", this.mailServerText.getText().getText());
            props.put("mail.debug", "true");
            Session session = Session.getInstance((Properties)props, null);
            MimeMessage msg = new MimeMessage(session);
            InternetAddress fromAddress = new InternetAddress(this.defaultFromText.getText().getText());
            msg.setFrom((Address)fromAddress);
            msg.addRecipients(Message.RecipientType.TO, (Address[])this.parseRecipientList(this.defaultToText.getText().getText()));
            if (!StringUtils.isEmpty((String)this.defaultCC.getText().getText())) {
                msg.addRecipients(Message.RecipientType.CC, (Address[])this.parseRecipientList(this.defaultCC.getText().getText()));
            }
            if (!StringUtils.isEmpty((String)this.defaultBCC.getText().getText())) {
                msg.addRecipients(Message.RecipientType.BCC, (Address[])this.parseRecipientList(this.defaultBCC.getText().getText()));
            }
            if (!StringUtils.isEmpty((String)this.defaultPriority.getCombo().getText())) {
                int prioValue = this.defaultPriority.getCombo().getSelectionIndex() + 1;
                String prioString = String.valueOf(prioValue);
                msg.addHeader("X-Priority", prioString);
            }
            msg.setSubject(this.defaultSubjectText.getText().getText());
            msg.setText(Mail_Messages.MSG_TXT_TEST_MESSAGE_FOR_INFINITY_MAIL_APPLICATION_TYPE);
            Transport.send((Message)msg);
        }
        catch (AddressException e) {
            e.printStackTrace();
        }
        catch (MessagingException e) {
            e.printStackTrace();
        }
    }

    private InternetAddress[] parseRecipientList(String recipientsSpec) throws AddressException {
        List recipients = CollectionUtils.newList();
        if (!StringUtils.isEmpty((String)recipientsSpec)) {
            Iterator i = StringUtils.split((String)recipientsSpec, (char)';');
            while (i.hasNext()) {
                recipients.add(new InternetAddress((String)i.next()));
            }
        }
        return recipients.toArray(new InternetAddress[recipients.size()]);
    }

    private static String nullSafe(IExtensibleElement element, String key) {
        String value = AttributeUtil.getAttributeValue((IExtensibleElement)element, (String)key);
        return StringUtils.isEmpty((String)value) ? "" : value;
    }
}

