/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.integration.spring.application;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.model.xpdl.carnot.DirectionType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.spi.IApplicationPropertyPage;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.common.ui.jface.utils.LabeledText;
import org.eclipse.stardust.modeling.common.ui.jface.widgets.LabelWithStatus;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.ui.DereferencePathBrowserComposite;
import org.eclipse.stardust.modeling.core.editors.ui.TypeSelectionComposite;
import org.eclipse.stardust.modeling.core.properties.AbstractModelElementPropertyPage;
import org.eclipse.stardust.modeling.core.utils.WidgetBindingManager;
import org.eclipse.stardust.modeling.integration.spring.application.BeanBrowser;
import org.eclipse.stardust.modeling.validation.util.TypeFinder;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class SpringBeanPropertyPage
extends AbstractModelElementPropertyPage
implements IApplicationPropertyPage {
    private LabeledText beanIdText;
    private LabeledText classText;
    private LabeledText methodText;
    private TypeSelectionComposite classBrowser;
    private DereferencePathBrowserComposite methodBrowser;

    public void loadFieldsFromElement(IModelElementNodeSymbol symbol, IModelElement element) {
        TypeFinder finder = new TypeFinder((EObject)element);
        this.classBrowser.setTypeFinder(finder);
        this.classBrowser.setModel((ModelType)element.eContainer());
        this.methodBrowser.setTypeFinder(finder);
        WidgetBindingManager wBndMgr = this.getWidgetBindingManager();
        wBndMgr.bind(this.beanIdText, (IExtensibleElement)element, "carnot:engine:spring::beanId");
        wBndMgr.bind(this.classText, (IExtensibleElement)element, "carnot:engine:className");
        wBndMgr.bind(this.methodText, (IExtensibleElement)element, "carnot:engine:methodName");
    }

    public void loadElementFromFields(IModelElementNodeSymbol symbol, IModelElement element) {
    }

    public Control createBody(Composite parent) {
        Composite composite = FormBuilder.createComposite((Composite)parent, (int)3);
        this.beanIdText = FormBuilder.createLabeledText((Composite)composite, (String)Diagram_Messages.LB_BeanId);
        FormBuilder.createButton((Composite)composite, (String)Diagram_Messages.LB_Browse, (SelectionListener)new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SpringBeanPropertyPage.this.browseSpringBean();
            }
        });
        LabelWithStatus classLabel = FormBuilder.createLabelWithRightAlignedStatus((Composite)composite, (String)Diagram_Messages.LB_Class);
        this.classBrowser = new TypeSelectionComposite(composite, Diagram_Messages.PlainJavaPropertyPage_LB_Plain_Java, 2);
        this.classText = new LabeledText(this.classBrowser.getText(), classLabel);
        LabelWithStatus methodLabel = FormBuilder.createLabelWithRightAlignedStatus((Composite)composite, (String)Diagram_Messages.LB_CompletionMethod);
        this.methodBrowser = new DereferencePathBrowserComposite(composite, Diagram_Messages.PlainJavaPropertyPage_LB_Method, 2);
        this.methodBrowser.setDirection(DirectionType.INOUT_LITERAL);
        this.methodBrowser.setDeep(false);
        this.methodText = new LabeledText(this.methodBrowser.getMethodText(), methodLabel);
        this.classBrowser.setDereferencePathBrowser(new DereferencePathBrowserComposite[]{this.methodBrowser});
        return composite;
    }

    private void browseSpringBean() {
        BeanBrowser dlg = new BeanBrowser(null);
        if (dlg.open() == 0) {
            String beanId = dlg.getBeanId();
            this.beanIdText.getText().setText(beanId == null ? "" : beanId);
            String beanType = dlg.getBeanType();
            this.classText.getText().setText(beanType == null ? "" : beanType);
        }
    }
}

