/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.integration.webservices.properties;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.common.error.InternalException;
import org.eclipse.stardust.engine.core.model.xpdl.XpdlUtils;
import org.eclipse.stardust.engine.core.runtime.utils.XmlUtils;
import org.eclipse.stardust.engine.ws.processinterface.WSDLGenerator;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.modeling.common.platform.validation.IQuickValidationStatus;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.properties.IProcessInterfaceInvocationGenerator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.w3c.dom.Document;

public class ProcessInterfaceInvocationGenerator
implements IProcessInterfaceInvocationGenerator {
    private Text textArea;
    private Button generateButton;

    public Composite createExposeComposite(Composite wsdlComposite, IProcessInterfaceInvocationGenerator.IProcessDefinitionTypeProvider processProvider) {
        this.textArea = FormBuilder.createTextArea((Composite)wsdlComposite, (int)3);
        this.textArea.setVisible(false);
        this.generateButton = new Button(wsdlComposite, 0);
        this.generateButton.setText(Diagram_Messages.BUT_TXT_GENERATE_WSDL);
        this.generateButton.setVisible(false);
        this.generateButton.addSelectionListener((SelectionListener)new WsdlButtonSelectionListener(processProvider, this.textArea));
        return null;
    }

    public void setComponentVisibility(String externalInvocationType) {
        if (externalInvocationType == null || externalInvocationType.equalsIgnoreCase("REST")) {
            this.textArea.setVisible(false);
            this.generateButton.setVisible(false);
        } else if (externalInvocationType.equalsIgnoreCase("BOTH") || externalInvocationType.equalsIgnoreCase("SOAP")) {
            this.textArea.setVisible(true);
            this.generateButton.setVisible(true);
        }
    }

    public void handleValidationStatusFromParent(IQuickValidationStatus status) {
        if (status != null && this.generateButton != null) {
            this.generateButton.setEnabled(status != IQuickValidationStatus.ERRORS);
        }
    }

    private static final class WsdlButtonSelectionListener
    implements SelectionListener {
        private final IProcessInterfaceInvocationGenerator.IProcessDefinitionTypeProvider processProvider;
        private final Text textArea;

        WsdlButtonSelectionListener(IProcessInterfaceInvocationGenerator.IProcessDefinitionTypeProvider processProvider, Text targetTextArea) {
            this.processProvider = processProvider;
            this.textArea = targetTextArea;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            String result = "";
            ModelType model = (ModelType)this.processProvider.getProcessDefinitionType().eContainer();
            Map options = CollectionUtils.newMap();
            options.put("ENCODING", "ISO-8859-1");
            Document domCwm = ((XMLResource)model.eResource()).save(null, options, null);
            if (domCwm != null) {
                StreamSource xsltSource = null;
                try {
                    URL xsltURL = XpdlUtils.getCarnot2XpdlStylesheet();
                    if (xsltURL == null) {
                        throw new InternalException(Diagram_Messages.EXC_UNABLE_TO_FIND_XPDL_EXPORT_STYLESHEET);
                    }
                    xsltSource = new StreamSource(xsltURL.openStream());
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                try {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    StreamResult target = new StreamResult(bos);
                    TransformerFactory transformerFactory = XmlUtils.newTransformerFactory();
                    Transformer xpdlTrans = transformerFactory.newTransformer(xsltSource);
                    XmlUtils.transform((Source)new DOMSource(domCwm), (Transformer)xpdlTrans, (Result)target, null, (int)3, (String)"UTF-8");
                    WSDLGenerator wsdlgen = new WSDLGenerator(bos.toByteArray());
                    result = new String(wsdlgen.generateFormatted());
                }
                catch (Throwable em) {
                    em.printStackTrace();
                }
            }
            this.textArea.setText(result);
        }
    }
}

