/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.javascript.editor;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.stardust.common.reflect.Reflect;
import org.eclipse.stardust.model.xpdl.carnot.AccessPointType;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.modeling.common.ui.jface.utils.CodeCompletionHelper;
import org.eclipse.stardust.modeling.javascript.editor.JSCompletionProposalLabelProvider;
import org.eclipse.stardust.modeling.javascript.editor.JavaScriptEditorPlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.jsdt.internal.ui.text.java.AbstractJavaCompletionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.java.JavaCompletionProcessor;
import org.eclipse.wst.jsdt.internal.ui.text.java.JavaMethodCompletionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.java.LazyJavaTypeCompletionProposal;
import org.eclipse.wst.jsdt.ui.text.java.CompletionProposalLabelProvider;
import org.eclipse.wst.jsdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.wst.jsdt.ui.text.java.JavaContentAssistInvocationContext;

public class EditorCompletionProcessor
extends JavaCompletionProcessor {
    private Map<String, Object> typeMap;
    private static final Image primitiveImage;
    private static final Image legoImage;
    private static final Image primitiveBpImage;
    private static final Image legoBpImage;
    private static final Image serializableImage;
    private static final Image entityImage;
    private static final Image libraryImage;
    private String[] badGlobalProposals = new String[]{"Window", "ippInitialize", "ippImport", "Global", "[ECMA", "[JavaScript", "[Common", "debugger", "prototype"};
    private String[] badProposals = new String[]{"Class    String - Object", "constructor    Function - Object", "prototype - String", "Value    Number - Object", "CanPut(String property)  Boolean - Object", "charAt(Number pos)  String - String", "charCodeAt(Number pos)  Number - String", "DefaultValue()  void - Object", "Delete(String property)  void - Object", "Get(String property)  Object - Object", "hasOwnProperty(Object V)  Boolean - Object", "HasProperty(String property)  Boolean - Object", "indexOf(String searchString, Number position)  Number - String", "isPrototypeOf(Object V)  Boolean - Object", "lastIndexOf(String searchString, Number position)  Number - String", "localeCompare(String otherString)  Number - String", "match(String regexp)  any[] - String", "Match(String value, String index)  Object - Object", "propertyIsEnumerable(Object V)  Boolean - Object", "Put(String property, String value)  void - Object", "replace(String searchValue, String replaceValue)  String - String", "search(String regexp)  Number - String", "slice(Number start, Number end)  String - String", "split(String separator, Number limit)  any[] - String", "valueOf()  Object - Object", "fromCharCode(Number charCode) - String", "concat(Array args)  any[] - Array", "join(String seperator)  any[] - Array", "pop()  Object - Array", "push(Array args)  void - Array", "reverse()  any[] - Array", "shift()  Object - Array", "slice(Number start, Number end)  any[] - Array", "sort(Function funct)  any[] - Array", "splice(Number start, Number deletecount, Array items)  any[] - Array", "unshift(Array start)  any[] - Array"};

    static {
        JavaScriptEditorPlugin.getDefault();
        primitiveImage = JavaScriptEditorPlugin.getImageDescriptor("icons/primitive_data.JPG").createImage();
        JavaScriptEditorPlugin.getDefault();
        legoImage = JavaScriptEditorPlugin.getImageDescriptor("icons/lego_icon.JPG").createImage();
        JavaScriptEditorPlugin.getDefault();
        primitiveBpImage = JavaScriptEditorPlugin.getImageDescriptor("icons/primitive_data_bp.JPG").createImage();
        JavaScriptEditorPlugin.getDefault();
        legoBpImage = JavaScriptEditorPlugin.getImageDescriptor("icons/lego_icon_bp.JPG").createImage();
        JavaScriptEditorPlugin.getDefault();
        serializableImage = JavaScriptEditorPlugin.getImageDescriptor("icons/serializable_data.JPG").createImage();
        JavaScriptEditorPlugin.getDefault();
        entityImage = JavaScriptEditorPlugin.getImageDescriptor("icons/entity_data.JPG").createImage();
        JavaScriptEditorPlugin.getDefault();
        libraryImage = JavaScriptEditorPlugin.getImageDescriptor("icons/jarlibrary.JPG").createImage();
    }

    public EditorCompletionProcessor(IEditorPart editor, ContentAssistant assistant, String partition) {
        super(editor, assistant, partition);
    }

    protected List filterAndSortProposals(List proposals, IProgressMonitor monitor, ContentAssistInvocationContext context) {
        this.typeMap = CodeCompletionHelper.getInstance().getTypeMap();
        List proposalList = super.filterAndSortProposals(proposals, monitor, context);
        boolean root = this.isRootProposals(proposalList);
        ArrayList<AbstractJavaCompletionProposal> newProposalList = new ArrayList<AbstractJavaCompletionProposal>();
        for (AbstractJavaCompletionProposal proposal : proposalList) {
            if (!this.isProposalValid(proposal)) continue;
            if (proposal instanceof JavaMethodCompletionProposal) {
                Reflect.setFieldValue((Object)proposal, (String)"fProposalInfoComputed", (Object)true);
            }
            if (root && !this.isIppProposal(proposal)) continue;
            this.adaptDisplayString(proposal);
            try {
                this.setLabelProvider(context);
                newProposalList.add(proposal);
            }
            catch (Throwable throwable) {}
        }
        return newProposalList;
    }

    private void setLabelProvider(ContentAssistInvocationContext context) {
        JavaContentAssistInvocationContext invocationContext = (JavaContentAssistInvocationContext)context;
        CompletionProposalLabelProvider actLabelProvider = invocationContext.getLabelProvider();
        Object fContext = Reflect.getFieldValue((Object)actLabelProvider, (String)"fContext");
        JSCompletionProposalLabelProvider lp = new JSCompletionProposalLabelProvider();
        Reflect.setFieldValue((Object)((Object)lp), (String)"fContext", (Object)fContext);
        Reflect.setFieldValue((Object)invocationContext, (String)"fLabelProvider", (Object)((Object)lp));
    }

    private boolean isIppProposal(AbstractJavaCompletionProposal proposal) {
        Object ippType = this.typeMap.get(proposal.getReplacementString());
        return ippType != null;
    }

    private boolean isRootProposals(List<AbstractJavaCompletionProposal> newProposalList) {
        for (AbstractJavaCompletionProposal proposal : newProposalList) {
            Object ippType = this.typeMap.get(proposal.getReplacementString());
            if (ippType == null) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isProposalValid(AbstractJavaCompletionProposal proposal) {
        try {
            int i = 0;
            while (i < this.badGlobalProposals.length) {
                if (proposal.getDisplayString().indexOf(this.badGlobalProposals[i]) > -1) {
                    return false;
                }
                ++i;
            }
            i = 0;
            while (i < this.badProposals.length) {
                if (proposal.getDisplayString().equalsIgnoreCase(this.badProposals[i])) {
                    return false;
                }
                ++i;
            }
            return !(proposal instanceof LazyJavaTypeCompletionProposal);
        }
        catch (Throwable throwable) {
            return true;
        }
    }

    private void adaptDisplayString(AbstractJavaCompletionProposal proposal) {
        Object ippType = this.typeMap.get(proposal.getReplacementString());
        if (ippType != null) {
            String ippTypeName;
            String displayString;
            if (ippType instanceof AccessPointType) {
                displayString = proposal.getDisplayString();
                ((AccessPointType)ippType).getId();
                ippTypeName = ((AccessPointType)ippType).getMetaType().getName();
                displayString = displayString.replace("any", ippTypeName);
                Reflect.setFieldValue((Object)proposal, (String)"fDisplayString", (Object)displayString);
                proposal.setImage(this.getImageByType(ippType, proposal));
            }
            if (ippType instanceof DataType) {
                displayString = proposal.getDisplayString();
                ((DataType)ippType).getType().getId();
                ippTypeName = ((DataType)ippType).getType().getName();
                displayString = CodeCompletionHelper.getInstance().getExternalTypeMap().containsKey(((DataType)ippType).getId()) ? displayString.replace("any", "External Class") : displayString.replace("any", ippTypeName);
                Reflect.setFieldValue((Object)proposal, (String)"fDisplayString", (Object)displayString);
                proposal.setImage(this.getImageByType(ippType, proposal));
            }
        }
    }

    private Image getImageByType(Object ippType, AbstractJavaCompletionProposal proposal) {
        Image image = proposal.getImage();
        if (ippType instanceof AccessPointType) {
            AccessPointType apt = (AccessPointType)ippType;
            image = apt.getType().getId().equalsIgnoreCase("struct") ? legoImage : primitiveImage;
        } else {
            String ippTypeId = ((DataType)ippType).getType().getId();
            if (ippTypeId.equalsIgnoreCase("serializable")) {
                image = CodeCompletionHelper.getInstance().getExternalTypeMap().containsKey(((DataType)ippType).getId()) ? libraryImage : serializableImage;
            }
            if (ippTypeId.equalsIgnoreCase("primitive")) {
                image = primitiveImage;
            }
            if (ippTypeId.equalsIgnoreCase("entity")) {
                image = entityImage;
            }
            if (ippTypeId.startsWith("struct")) {
                image = legoImage;
            }
        }
        return image;
    }
}

