/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.javascript;

import java.util.Map;
import org.eclipse.wst.jsdt.core.ast.IExpression;
import org.eclipse.wst.jsdt.core.infer.InferredAttribute;
import org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode;
import org.eclipse.wst.jsdt.internal.compiler.ast.ArrayReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.wst.jsdt.internal.compiler.ast.FieldReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.NameReference;
import org.eclipse.wst.jsdt.internal.compiler.impl.Constant;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ClassScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ProblemFieldBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Scope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.util.HashtableOfObject;
import org.eclipse.wst.jsdt.internal.compiler.util.Util;

public class JSFieldReference
extends FieldReference {
    private Expression arrayReceiverReceive;
    private InferredAttribute attribute;
    protected Map arrayMap;

    public JSFieldReference(char[] source, long pos) {
        super(source, pos);
    }

    public TypeBinding resolveType(BlockScope scope, boolean define, TypeBinding useType) {
        if (this.isPrototype()) {
            char[] possibleTypeName = Util.getTypeName((IExpression)this.receiver);
            ReferenceBinding typeBinding = scope.getJavaLangObject();
            if (possibleTypeName != null) {
                Binding possibleTypeBinding = scope.getBinding(possibleTypeName, 4, (InvocationSite)this, true);
                if (possibleTypeBinding.isValidBinding()) {
                    typeBinding = (TypeBinding)possibleTypeBinding;
                }
                char[] fieldname = new char[]{'p', 'r', 'o', 't', 'o', 't', 'y', 'p', 'e'};
                this.binding = scope.getJavaLangObject().getField(fieldname, true);
            }
            this.constant = Constant.NotAConstant;
            this.resolvedType = typeBinding;
            return this.resolvedType;
        }
        if (this.receiverType == null) {
            if (this.receiver instanceof FieldReference && !(this.receiver instanceof JSFieldReference)) {
                this.receiver = this.buildFieldReference(this.receiver);
            }
            if (scope instanceof CompilationUnitScope) {
                ((CompilationUnitScope)scope).typeOrPackageCache = new HashtableOfObject();
            }
            this.receiverType = this.receiver.resolveType(scope);
        }
        if (this.receiverType == null) {
            this.binding = new ProblemFieldBinding(null, this.token, 1);
            this.constant = Constant.NotAConstant;
            this.resolvedType = TypeBinding.ANY;
            return null;
        }
        Binding memberBinding = scope.getFieldOrMethod(this.receiverType, this.token, (InvocationSite)this);
        this.constant = Constant.NotAConstant;
        if (memberBinding instanceof FieldBinding) {
            this.binding = (FieldBinding)memberBinding;
            FieldBinding fieldBinding = this.binding;
            if (!fieldBinding.isValidBinding()) {
                this.binding = fieldBinding;
                this.resolvedType = TypeBinding.ANY;
                if (!define) {
                    this.constant = Constant.NotAConstant;
                    scope.problemReporter().options.enableSemanticValidation = true;
                    scope.problemReporter().invalidField((FieldReference)this, this.receiverType);
                    return null;
                }
            }
            if (this.isFieldUseDeprecated(fieldBinding, (Scope)scope, (this.bits & 0x2000) != 0)) {
                scope.problemReporter().deprecatedField(fieldBinding, (ASTNode)this);
            }
            boolean isImplicitThisRcv = this.receiver.isImplicitThis();
            if (fieldBinding.isStatic()) {
                if (!(isImplicitThisRcv || this.receiver instanceof NameReference && (((NameReference)this.receiver).bits & 4) != 0)) {
                    scope.problemReporter().nonStaticAccessToStaticField((ASTNode)this, fieldBinding);
                }
                if (!isImplicitThisRcv && fieldBinding.declaringClass != this.receiverType && fieldBinding.declaringClass.canBeSeenBy((Scope)scope)) {
                    scope.problemReporter().indirectAccessToStaticField((ASTNode)this, fieldBinding);
                }
            }
            this.resolvedType = (this.bits & 0x2000) == 0 ? fieldBinding.type : fieldBinding.type;
            return this.resolvedType;
        }
        if (memberBinding instanceof MethodBinding) {
            this.resolvedType = scope.getJavaLangFunction();
            this.binding = new ProblemFieldBinding(null, this.token, 1);
            if (memberBinding.isValidBinding()) {
                return this.resolvedType;
            }
            return null;
        }
        return null;
    }

    public TypeBinding resolveType(BlockScope scope) {
        String key = this.receiver.toString();
        key = key.replaceAll("\\[[^\\]]*\\]|\\..*/", "");
        key = key.substring(key.indexOf(46) + 1, key.length());
        key = key.replace(".", "/");
        key = key.replace("(", "");
        key = key.replace(")", "");
        Object value = this.arrayMap.get(key);
        if (this.receiver instanceof ArrayReference) {
            ArrayReference arref = (ArrayReference)this.receiver;
            this.receiver = arref.receiver;
            return super.resolveType(scope);
        }
        if (value != null && value.toString().equalsIgnoreCase("true")) {
            CompilationUnitScope superScope = (CompilationUnitScope)this.getRootScope((Scope)scope);
            this.receiverType = superScope.getJavaLangArray();
        }
        return super.resolveType(scope);
    }

    public TypeBinding resolveType(ClassScope scope) {
        if (this.receiver instanceof ArrayReference) {
            return this.arrayReceiverReceive.resolveType(scope);
        }
        return super.resolveType(scope);
    }

    public void setArrayReceiverReceiver(Expression areceiver) {
        this.arrayReceiverReceive = areceiver;
    }

    public void resolve(BlockScope scope) {
        super.resolve(scope);
    }

    public void setAttribute(InferredAttribute att) {
        this.attribute = att;
    }

    public Map getArrayMap() {
        return this.arrayMap;
    }

    public void setArrayMap(Map arrayMap) {
        this.arrayMap = arrayMap;
    }

    protected Scope getRootScope(Scope scope) {
        if (scope.parent != null) {
            return this.getRootScope(scope.parent);
        }
        return scope;
    }

    protected Expression buildFieldReference(Expression expression) {
        if (expression instanceof FieldReference) {
            FieldReference fieldReference = (FieldReference)expression;
            JSFieldReference fr = new JSFieldReference(fieldReference.token, fieldReference.nameSourcePosition);
            fr.binding = fieldReference.binding;
            fr.bits = fieldReference.bits;
            fr.constant = fieldReference.constant;
            fr.nameSourcePosition = fieldReference.nameSourcePosition;
            fr.receiver = fieldReference.receiver;
            fr.receiverType = fieldReference.receiverType;
            fr.resolvedType = fieldReference.resolvedType;
            fr.sourceEnd = fieldReference.sourceEnd;
            fr.sourceStart = fieldReference.sourceStart;
            fr.statementEnd = fieldReference.statementEnd;
            fr.token = fieldReference.token;
            fr.setArrayMap(this.arrayMap);
            return fr;
        }
        return null;
    }
}

