/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.modelexport;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.modeling.modelexport.Export_Messages;
import org.eclipse.stardust.modeling.repository.common.ExtendedModelManager;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.dialogs.WizardExportResourcesPage;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.model.AdaptableList;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchPartLabelProvider;

public class ExportCarnotModelWizardPage
extends WizardExportResourcesPage {
    private static final String DIRECTORY_LABEL = Export_Messages.LB_ToDir;
    private static final String CONTAINER_BROWSE_BUTTON_LABEL = Export_Messages.Btn_Browse;
    private Composite parent;
    private Text fileNameField;

    public ExportCarnotModelWizardPage(String pageId, IStructuredSelection selection) {
        super(pageId, selection);
    }

    public boolean performFinish() {
        this.checkUnsavedModels();
        for (IResource resource : this.getSelectedResources()) {
            String message;
            boolean answer;
            String modelName = "";
            try {
                modelName = resource.getName().substring(0, resource.getName().lastIndexOf("."));
            }
            catch (Throwable throwable) {}
            if (!"cwm".equals(resource.getFileExtension()) && !"xpdl".equals(resource.getFileExtension())) continue;
            StringBuffer pathBuf = new StringBuffer();
            pathBuf.append(this.fileNameField.getText());
            pathBuf.append('/');
            pathBuf.append(modelName);
            pathBuf.append("cwm".equals(resource.getFileExtension()) ? ".xml" : ".xpdl");
            File targetFile = new File(pathBuf.toString());
            if (targetFile.exists() && !(answer = MessageDialog.openQuestion(null, (String)Export_Messages.ExportCarnotModelWizardPage_OverwriteQuestionTitle, (String)(message = String.valueOf(Export_Messages.ExportCarnotModelWizardPage_OverwriteQuestionString) + pathBuf.toString() + "?")))) continue;
            ExtendedModelManager emm = new ExtendedModelManager();
            try {
                emm.load(URI.createFileURI((String)resource.getLocation().toString()));
                emm.save(URI.createFileURI((String)pathBuf.toString()));
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return true;
    }

    private void checkUnsavedModels() {
        IEditorPart[] dirtyEditors = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getDirtyEditors();
        List saveEditors = CollectionUtils.newList();
        int i = 0;
        while (i < dirtyEditors.length) {
            IFile file;
            String extension;
            IEditorInput editorInput = dirtyEditors[i].getEditorInput();
            if (editorInput instanceof IFileEditorInput && ("cwm".equalsIgnoreCase(extension = (file = ((IFileEditorInput)editorInput).getFile()).getFileExtension()) || "xpdl".equalsIgnoreCase(extension)) && this.getSelectedResources().contains(file)) {
                saveEditors.add(dirtyEditors[i]);
            }
            ++i;
        }
        if (!saveEditors.isEmpty()) {
            ListSelectionDialog modelsToSaveDialog = new ListSelectionDialog(this.getShell(), (Object)new AdaptableList((Collection)saveEditors), (IStructuredContentProvider)new WorkbenchContentProvider(), (ILabelProvider)new WorkbenchPartLabelProvider(), Export_Messages.MSG_SaveModelsBeforeExporting);
            modelsToSaveDialog.setInitialSelections(saveEditors.toArray());
            modelsToSaveDialog.setTitle(Export_Messages.TITLE_SaveModels);
            int result = modelsToSaveDialog.open();
            if (result == 0) {
                final Object[] editorsToSave = modelsToSaveDialog.getResult();
                BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        int i = 0;
                        while (i < editorsToSave.length) {
                            IEditorPart editor = (IEditorPart)editorsToSave[i];
                            editor.doSave((IProgressMonitor)new NullProgressMonitor());
                            ++i;
                        }
                    }
                });
            }
        }
    }

    protected void createDestinationGroup(Composite parent) {
        this.parent = parent;
        Composite containerGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        containerGroup.setLayout((Layout)layout);
        containerGroup.setLayoutData((Object)new GridData(768));
        containerGroup.setFont(parent.getFont());
        Label label = new Label(containerGroup, 0);
        label.setText(DIRECTORY_LABEL);
        label.setFont(parent.getFont());
        this.fileNameField = new Text(containerGroup, 2052);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.fileNameField.setLayoutData((Object)data);
        this.fileNameField.setFont(parent.getFont());
        this.fileNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                if (event.getSource() instanceof Text) {
                    Text source = (Text)event.getSource();
                    if (StringUtils.isEmpty((String)source.getText())) {
                        ExportCarnotModelWizardPage.this.setPageComplete(false);
                    } else {
                        ExportCarnotModelWizardPage.this.setPageComplete(true);
                    }
                }
            }
        });
        Button containerBrowseButton = new Button(containerGroup, 8);
        containerBrowseButton.setText(CONTAINER_BROWSE_BUTTON_LABEL);
        containerBrowseButton.setFont(parent.getFont());
        containerBrowseButton.setLayoutData((Object)new GridData(256));
        containerBrowseButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                ExportCarnotModelWizardPage.this.browseForFile();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                ExportCarnotModelWizardPage.this.browseForFile();
            }
        });
        this.setTitle(Export_Messages.LB_Select);
        this.setDescription(Export_Messages.DESC_ModelsToExport);
        this.setControl((Control)containerGroup);
        ImageDescriptor imageDescrip = WorkbenchImages.getImageDescriptor((String)"IMG_WIZBAN_EXPORT_WIZ");
        this.setImageDescriptor(imageDescrip);
    }

    protected void browseForFile() {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell(), 4096);
        String directory = dialog.open();
        if (directory != null) {
            this.fileNameField.setText(directory);
        }
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.setPageComplete(false);
    }

    protected void createOptionsGroup(Composite parent) {
    }

    public void handleEvent(Event event) {
    }

    public String queryOverwrite(String pathString) {
        return null;
    }

    public boolean isPageComplete() {
        if (StringUtils.isEmpty((String)this.fileNameField.getText())) {
            this.setErrorMessage(Export_Messages.MSG_NoDirectory);
            return false;
        }
        File targetFile = new File(this.fileNameField.getText());
        if (!targetFile.exists()) {
            this.setErrorMessage(Export_Messages.MSG_DirectoryDoesNotExist);
            return false;
        }
        if (this.getSelectedResources().isEmpty()) {
            this.setErrorMessage(Export_Messages.MSG_NoModelSelected);
            return false;
        }
        for (IResource resource : this.getSelectedResources()) {
            if ("cwm".equals(resource.getFileExtension()) || "xpdl".equals(resource.getFileExtension())) continue;
            this.setErrorMessage(Export_Messages.MSG_InvalidResource);
            return false;
        }
        this.setErrorMessage(null);
        return super.isPageComplete();
    }

    public Control getControl() {
        return this.parent;
    }

    protected List<String> getTypesToExport() {
        List list = CollectionUtils.newList();
        list.add("cwm");
        list.add("xpdl");
        return list;
    }
}

