/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.modelimport.elements;

import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.contentmergeviewer.ContentMergeViewer;
import org.eclipse.compare.structuremergeviewer.IStructureComparator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.stardust.modeling.modelimport.elements.AttributeComparator;
import org.eclipse.stardust.modeling.modelimport.elements.ModelElementsSorter;
import org.eclipse.stardust.modeling.modelimport.elements.RootComparator;
import org.eclipse.stardust.modeling.modelimport.elements.StructureComparator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;

public class ContentCompareViewer
extends ContentMergeViewer {
    private static LabelProvider lp = new LabelProvider(){

        public Image getImage(Object element) {
            return ((ITypedElement)element).getImage();
        }

        public String getText(Object element) {
            return ((ITypedElement)element).getName();
        }
    };
    private static ITreeContentProvider cp = new ITreeContentProvider(){

        public Object[] getChildren(Object parentElement) {
            return ((IStructureComparator)parentElement).getChildren();
        }

        public Object getParent(Object element) {
            if (element instanceof AttributeComparator) {
                return ((AttributeComparator)element).getParent();
            }
            if (element instanceof StructureComparator) {
                return ((StructureComparator)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return ((IStructureComparator)element).getChildren().length > 0;
        }

        public Object[] getElements(Object inputElement) {
            return ((IStructureComparator)inputElement).getChildren();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    };
    private TreeViewer left;
    private TreeViewer right;
    private TreeViewer ancestor;

    public ContentCompareViewer(Composite parent, CompareConfiguration config) {
        super(0, null, config);
        this.buildControl(parent);
    }

    protected void copy(boolean leftToRight) {
    }

    protected void createControls(Composite composite) {
        this.ancestor = new TreeViewer(composite, 0);
        this.left = new TreeViewer(composite, 0);
        this.left.setContentProvider((IContentProvider)cp);
        this.left.setLabelProvider((IBaseLabelProvider)lp);
        this.left.setSorter((ViewerSorter)new ModelElementsSorter());
        this.right = new TreeViewer(composite, 0);
        this.right.setContentProvider((IContentProvider)cp);
        this.right.setLabelProvider((IBaseLabelProvider)lp);
        this.right.setSorter((ViewerSorter)new ModelElementsSorter());
    }

    protected byte[] getContents(boolean left) {
        return null;
    }

    protected void handleResizeAncestor(int x, int y, int width, int height) {
        this.ancestor.getControl().setVisible(false);
    }

    protected void handleResizeLeftRight(int x, int y, int leftWidth, int centerWidth, int rightWidth, int height) {
        this.left.getControl().setBounds(x, y, (leftWidth -= centerWidth / 2) - centerWidth, height);
        this.right.getControl().setBounds(x + leftWidth + centerWidth, y, rightWidth, height);
    }

    protected void updateContent(Object ancestor, Object leftInput, Object rightInput) {
        this.setInput(this.left, leftInput);
        this.setInput(this.right, rightInput);
        this.setTitle(lp.getText(leftInput == null ? rightInput : leftInput));
    }

    private void setTitle(String title) {
        this.getControl().setData("org.eclipse.compare.CompareUI.CompareViewerTitle", (Object)title);
    }

    private void setInput(TreeViewer viewer, Object input) {
        viewer.setInput(input);
        if (input != null && input instanceof RootComparator) {
            viewer.expandToLevel(2);
        }
    }
}

