/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.refactoring.operators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.DataPathType;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.DataTypeType;
import org.eclipse.stardust.model.xpdl.carnot.DirectionType;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.modeling.refactoring.operators.IJdtOperator;
import org.eclipse.stardust.modeling.refactoring.operators.OperatorsRegistry;
import org.eclipse.stardust.modeling.refactoring.query.matches.EObjectMatch;
import org.eclipse.stardust.modeling.refactoring.refactoring.changes.EObjectStringValueSubstituteChange;

public class DataPathOperator
implements IJdtOperator {
    @Override
    public List getRefactoringChanges(ModelType model, Object element, RefactoringArguments arguments) {
        String originalClassName = null;
        String newClassName = null;
        if (element instanceof IType) {
            originalClassName = ((IType)element).getFullyQualifiedName();
            newClassName = OperatorsRegistry.getNewClassName((IType)element, arguments);
            if (newClassName.equals(originalClassName)) {
                return Collections.EMPTY_LIST;
            }
        }
        String originalMethodName = null;
        String newMethodName = null;
        if (element instanceof IMethod) {
            originalMethodName = ((IMethod)element).getElementName();
            newMethodName = OperatorsRegistry.getNewMethodName((IMethod)element, arguments);
            if (newMethodName.equals(originalMethodName)) {
                return Collections.EMPTY_LIST;
            }
        }
        if (newClassName == null && newMethodName == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList result = new ArrayList();
        EList processTypes = model.getProcessDefinition();
        int i = 0;
        while (i < processTypes.size()) {
            ProcessDefinitionType process = (ProcessDefinitionType)processTypes.get(i);
            EList dataPaths = process.getDataPath();
            int j = 0;
            while (j < dataPaths.size()) {
                DataPathType path = (DataPathType)dataPaths.get(j);
                if (this.isJavaType(path.getData())) {
                    if (element instanceof IType && DirectionType.OUT_LITERAL.equals((Object)path.getDirection())) {
                        EObjectStringValueSubstituteChange.addParamsSubstitution(result, CarnotWorkflowModelPackage.eINSTANCE.getDataPathType_DataPath().getName(), (EObject)path, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getDataPathType_DataPath(), originalClassName, newClassName);
                    }
                    if (element instanceof IMethod) {
                        EObjectStringValueSubstituteChange.addMethodSubstitution(result, CarnotWorkflowModelPackage.eINSTANCE.getDataPathType_DataPath().getName(), (EObject)path, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getDataPathType_DataPath(), originalMethodName, newMethodName);
                    }
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    @Override
    public List getQueryMatches(IFile file, ModelType model, Object element) {
        String className = null;
        if (element instanceof IType) {
            className = ((IType)element).getFullyQualifiedName();
        }
        String methodName = null;
        if (element instanceof IMethod) {
            methodName = ((IMethod)element).getElementName();
        }
        if (className == null && methodName == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList result = new ArrayList();
        EList processTypes = model.getProcessDefinition();
        int i = 0;
        while (i < processTypes.size()) {
            ProcessDefinitionType process = (ProcessDefinitionType)processTypes.get(i);
            EList dataPaths = process.getDataPath();
            int j = 0;
            while (j < dataPaths.size()) {
                DataPathType path = (DataPathType)dataPaths.get(j);
                if (this.isJavaType(path.getData())) {
                    if (element instanceof IType && DirectionType.OUT_LITERAL.equals((Object)path.getDirection())) {
                        EObjectMatch.addParamsMatch(result, file, (EObject)path, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getDataPathType_DataPath(), className);
                    }
                    if (element instanceof IMethod) {
                        EObjectMatch.addMethodMatch(result, file, (EObject)path, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getDataPathType_DataPath(), methodName);
                    }
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    private boolean isJavaType(DataType data) {
        if (data != null) {
            DataTypeType type = data.getType();
            String id = type.getId();
            return "serializable".equals(id) || "entity".equals(id) || "primitive".equals(id) || "hibernate".equals(id);
        }
        return false;
    }
}

