/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.refactoring.operators;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.ltk.core.refactoring.participants.MoveArguments;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.modeling.core.ui.StringUtils;
import org.eclipse.stardust.modeling.refactoring.operators.ApplicationOperator;
import org.eclipse.stardust.modeling.refactoring.operators.ConditionOperator;
import org.eclipse.stardust.modeling.refactoring.operators.DataActionOperator;
import org.eclipse.stardust.modeling.refactoring.operators.DataMappingOperator;
import org.eclipse.stardust.modeling.refactoring.operators.DataOperator;
import org.eclipse.stardust.modeling.refactoring.operators.DataPathOperator;
import org.eclipse.stardust.modeling.refactoring.operators.IJdtOperator;
import org.eclipse.stardust.modeling.refactoring.operators.InteractiveApplicationOperator;
import org.eclipse.stardust.modeling.refactoring.operators.SetDataActionOperator;
import org.eclipse.stardust.modeling.refactoring.operators.TriggerOperator;

public class OperatorsRegistry {
    private static OperatorsRegistry instance = new OperatorsRegistry();
    private List types = new ArrayList();

    public OperatorsRegistry() {
        this.types.add(new DataOperator("hibernate", new String[]{"carnot:engine:className"}));
        this.types.add(new DataOperator("serializable", new String[]{"carnot:engine:className"}));
        this.types.add(new DataOperator("entity", new String[]{"carnot:engine:remoteInterface", "carnot:engine:homeInterface", "carnot:engine:primaryKey", "carnot:engine:className"}));
        this.types.add(new ApplicationOperator("plainJava", new String[]{"carnot:engine:className"}, new String[]{"carnot:engine:constructorName"}, new String[]{"carnot:engine:methodName"}));
        this.types.add(new ApplicationOperator("sessionBean", new String[]{"carnot:engine:remoteInterface", "carnot:engine:homeInterface", "carnot:engine:className"}, new String[0], new String[]{"carnot:engine:methodName", "carnot:engine:createMethodName"}));
        this.types.add(new ApplicationOperator("springBean", new String[]{"carnot:engine:className"}, new String[]{"carnot:engine:constructorName"}, new String[]{"carnot:engine:methodName"}));
        this.types.add(new ApplicationOperator("jms", new String[0], new String[0], new String[0]));
        this.types.add(new ApplicationOperator("webservice", true, new String[]{"carnot:engine:mapping:"}, new String[0], new String[0]));
        this.types.add(new InteractiveApplicationOperator(new String[]{"Casabac", "jfc", "jsf"}));
        this.types.add(new TriggerOperator("jms"));
        this.types.add(new TriggerOperator("mail"));
        this.types.add(new DataPathOperator());
        this.types.add(new DataMappingOperator());
        this.types.add(new ConditionOperator("exception", new String[]{"carnot:engine:exceptionName"}));
        this.types.add(new SetDataActionOperator());
        this.types.add(new DataActionOperator("excludeUser", new String[]{"carnot:engine:excludedPerformerData", "carnot:engine:excludedPerformerDataPath"}));
        this.types.add(new DataActionOperator("mail", new String[]{"carnot:engine:mailBodyData", "carnot:engine:mailBodyDataPath"}));
    }

    public List populate(ModelType model, Object element, RefactoringArguments arguments) {
        ArrayList result = new ArrayList();
        int i = 0;
        while (i < this.types.size()) {
            IJdtOperator operator = (IJdtOperator)this.types.get(i);
            result.addAll(operator.getRefactoringChanges(model, element, arguments));
            ++i;
        }
        return result;
    }

    public List search(IFile file, ModelType model, Object element) {
        ArrayList result = new ArrayList();
        int i = 0;
        while (i < this.types.size()) {
            IJdtOperator operator = (IJdtOperator)this.types.get(i);
            result.addAll(operator.getQueryMatches(file, model, element));
            ++i;
        }
        return result;
    }

    public static OperatorsRegistry instance() {
        return instance;
    }

    public static String getNewPackageName(IPackageFragment iPackage, RefactoringArguments arguments) {
        if (arguments instanceof RenameArguments) {
            return ((RenameArguments)arguments).getNewName();
        }
        return iPackage.getElementName();
    }

    public static String getNewClassName(IType iType, RefactoringArguments arguments) {
        if (arguments instanceof RenameArguments) {
            if (StringUtils.isEmpty((String)iType.getPackageFragment().getElementName())) {
                return ((RenameArguments)arguments).getNewName();
            }
            return String.valueOf(iType.getPackageFragment().getElementName()) + "." + ((RenameArguments)arguments).getNewName();
        }
        if (arguments instanceof MoveArguments && ((MoveArguments)arguments).getDestination() instanceof IPackageFragment) {
            return String.valueOf(((IPackageFragment)((MoveArguments)arguments).getDestination()).getElementName()) + "." + iType.getElementName();
        }
        return iType.getFullyQualifiedName();
    }

    public static String getNewMethodName(IMethod iMethod, RefactoringArguments arguments) {
        if (arguments instanceof RenameArguments) {
            return ((RenameArguments)arguments).getNewName();
        }
        return iMethod.getElementName();
    }
}

