/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.refactoring.operators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.stardust.model.xpdl.carnot.AbstractEventAction;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.DataTypeType;
import org.eclipse.stardust.model.xpdl.carnot.EventActionTypeType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.refactoring.operators.IJdtOperator;
import org.eclipse.stardust.modeling.refactoring.operators.OperatorsRegistry;
import org.eclipse.stardust.modeling.refactoring.query.matches.EObjectMatch;
import org.eclipse.stardust.modeling.refactoring.refactoring.changes.EObjectStringValueSubstituteChange;

public class SetDataActionOperator
implements IJdtOperator {
    private static final String DATA_ID_ATT = "carnot:engine:dataId";
    private static final String DATA_PATH_ATT = "carnot:engine:dataPath";
    private static final String ATTRIBUTE_PATH_ATT = "carnot:engine:attributePath";

    @Override
    public List getRefactoringChanges(ModelType model, Object element, RefactoringArguments arguments) {
        String originalPackageName = null;
        String newPackageName = null;
        if (element instanceof IPackageFragment) {
            originalPackageName = ((IPackageFragment)element).getElementName();
            newPackageName = OperatorsRegistry.getNewPackageName((IPackageFragment)element, arguments);
            if (newPackageName.equals(originalPackageName)) {
                return Collections.EMPTY_LIST;
            }
        }
        String originalClassName = null;
        String newClassName = null;
        if (element instanceof IType) {
            originalClassName = ((IType)element).getFullyQualifiedName();
            newClassName = OperatorsRegistry.getNewClassName((IType)element, arguments);
            if (newClassName.equals(originalClassName)) {
                return Collections.EMPTY_LIST;
            }
        }
        String originalMethodName = null;
        String newMethodName = null;
        if (element instanceof IMethod) {
            originalMethodName = ((IMethod)element).getElementName();
            newMethodName = OperatorsRegistry.getNewMethodName((IMethod)element, arguments);
            if (newMethodName.equals(originalMethodName)) {
                return Collections.EMPTY_LIST;
            }
        }
        if (newPackageName == null && newClassName == null && newMethodName == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList result = new ArrayList();
        EList actionTypes = model.getEventActionType();
        int i = 0;
        while (i < actionTypes.size()) {
            EventActionTypeType type = (EventActionTypeType)actionTypes.get(i);
            if ("setData".equals(type.getId())) {
                EList actions = type.getActionInstances();
                int j = 0;
                while (j < actions.size()) {
                    AttributeType attribute;
                    AbstractEventAction action = (AbstractEventAction)actions.get(j);
                    String dataId = AttributeUtil.getAttributeValue((IExtensibleElement)action, (String)DATA_ID_ATT);
                    DataType data = (DataType)ModelUtils.findIdentifiableElement((List)model.getData(), (String)dataId);
                    if (this.isJavaType(data) && (attribute = AttributeUtil.getAttribute((IExtensibleElement)action, (String)DATA_PATH_ATT)) != null && !(element instanceof IPackageFragment)) {
                        if (element instanceof IType) {
                            EObjectStringValueSubstituteChange.addParamsSubstitution(result, DATA_PATH_ATT, (EObject)attribute, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getAttributeType_Value(), originalClassName, newClassName);
                        } else if (element instanceof IMethod) {
                            EObjectStringValueSubstituteChange.addMethodSubstitution(result, DATA_PATH_ATT, (EObject)attribute, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getAttributeType_Value(), originalMethodName, newMethodName);
                        }
                    }
                    if ((attribute = AttributeUtil.getAttribute((IExtensibleElement)action, (String)ATTRIBUTE_PATH_ATT)) != null && element instanceof IMethod) {
                        EObjectStringValueSubstituteChange.addMethodSubstitution(result, ATTRIBUTE_PATH_ATT, (EObject)attribute, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getAttributeType_Value(), originalMethodName, newMethodName);
                    }
                    ++j;
                }
                break;
            }
            ++i;
        }
        return result;
    }

    @Override
    public List getQueryMatches(IFile file, ModelType model, Object element) {
        String packageName = null;
        if (element instanceof IPackageFragment) {
            packageName = ((IPackageFragment)element).getElementName();
        }
        String className = null;
        if (element instanceof IType) {
            className = ((IType)element).getFullyQualifiedName();
        }
        String methodName = null;
        if (element instanceof IMethod) {
            methodName = ((IMethod)element).getElementName();
        }
        if (packageName == null && className == null && methodName == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList result = new ArrayList();
        EList actionTypes = model.getEventActionType();
        int i = 0;
        while (i < actionTypes.size()) {
            EventActionTypeType type = (EventActionTypeType)actionTypes.get(i);
            if ("setData".equals(type.getId())) {
                EList actions = type.getActionInstances();
                int j = 0;
                while (j < actions.size()) {
                    AttributeType attribute;
                    AbstractEventAction action = (AbstractEventAction)actions.get(j);
                    String dataId = AttributeUtil.getAttributeValue((IExtensibleElement)action, (String)DATA_ID_ATT);
                    DataType data = (DataType)ModelUtils.findIdentifiableElement((List)model.getData(), (String)dataId);
                    if (this.isJavaType(data) && (attribute = AttributeUtil.getAttribute((IExtensibleElement)action, (String)DATA_PATH_ATT)) != null && !(element instanceof IPackageFragment)) {
                        if (element instanceof IType) {
                            EObjectMatch.addParamsMatch(result, file, attribute, className);
                        } else if (element instanceof IMethod) {
                            EObjectMatch.addMethodMatch(result, file, attribute, methodName);
                        }
                    }
                    if ((attribute = AttributeUtil.getAttribute((IExtensibleElement)action, (String)ATTRIBUTE_PATH_ATT)) != null && element instanceof IMethod) {
                        EObjectMatch.addMethodMatch(result, file, attribute, methodName);
                    }
                    ++j;
                }
                break;
            }
            ++i;
        }
        return result;
    }

    private boolean isJavaType(DataType data) {
        if (data != null) {
            DataTypeType type = data.getType();
            String id = type.getId();
            return "serializable".equals(id) || "entity".equals(id) || "primitive".equals(id) || "hibernate".equals(id);
        }
        return false;
    }
}

