/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.repository.common;

import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.spi.SpiExtensionRegistry;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.util.IConnection;
import org.eclipse.stardust.model.xpdl.util.IConnectionManager;
import org.eclipse.stardust.model.xpdl.util.IObjectReference;
import org.eclipse.stardust.model.xpdl.xpdl2.Extensible;
import org.eclipse.stardust.model.xpdl.xpdl2.ExternalPackage;
import org.eclipse.stardust.model.xpdl.xpdl2.util.ExtendedAttributeUtil;
import org.eclipse.stardust.modeling.repository.common.Attribute;
import org.eclipse.stardust.modeling.repository.common.Connection;
import org.eclipse.stardust.modeling.repository.common.ConnectionHandler;
import org.eclipse.stardust.modeling.repository.common.ExternalPackageResolver;
import org.eclipse.stardust.modeling.repository.common.Repository;
import org.eclipse.stardust.modeling.repository.common.RepositoryFactory;
import org.eclipse.stardust.modeling.repository.common.Repository_Messages;

public class ConnectionManager
implements IConnectionManager {
    private Repository repository;
    private Map<Connection, ConnectionHandler> handlers = CollectionUtils.newMap();
    private ModelType model;

    public ConnectionManager(ModelType model) {
        this.model = model;
        this.model.setConnectionManager((IConnectionManager)this);
        RepositoryFactory factory = RepositoryFactory.eINSTANCE;
        this.repository = factory.createRepository();
        Map infoMap = CollectionUtils.newMap();
        List infoList = CollectionUtils.newList();
        EList list = model.getAttribute();
        int i = 0;
        while (i < list.size()) {
            AttributeType att = (AttributeType)list.get(i);
            String name = att.getName();
            if (name.startsWith("carnot:connection:")) {
                name = name.substring("carnot:connection:".length());
                this.handleAttribute(infoMap, infoList, att, name);
            }
            ++i;
        }
        ExternalPackageResolver externalPackageResolver = new ExternalPackageResolver(model);
        model.eAdapters().add((Object)externalPackageResolver);
        int i2 = 0;
        while (i2 < infoList.size()) {
            String identifier = (String)infoList.get(i2);
            Map attributes = (Map)infoMap.get(identifier);
            Connection connection = factory.createConnection();
            connection.setProperty("ConnectionManager", this);
            connection.setId((String)attributes.get("id"));
            connection.setName((String)attributes.get("name"));
            connection.setType((String)attributes.get("type"));
            Map connectionAttributes = (Map)attributes.get("attribute");
            if (connectionAttributes != null) {
                for (Map.Entry entry : connectionAttributes.entrySet()) {
                    Attribute attr = factory.createAttribute();
                    attr.setName((String)entry.getKey());
                    attr.setValue((String)entry.getValue());
                    connection.getAttributes().add(attr);
                }
            }
            this.repository.getConnection().add(connection);
            connection.eAdapters().add((Object)externalPackageResolver);
            ++i2;
        }
    }

    private void handleAttribute(Map<String, Object> infoMap, List<String> infoList, AttributeType att, String name) {
        int ix = name.indexOf(58);
        if (ix > 0) {
            String identifier = name.substring(0, ix);
            if (infoList != null && !infoList.contains(identifier)) {
                infoList.add(identifier);
            }
            name = name.substring(ix + 1);
            Map map = (Map)infoMap.get(identifier);
            if (map == null) {
                map = CollectionUtils.newMap();
                infoMap.put(identifier, map);
            }
            this.handleAttribute(map, null, att, name);
        } else {
            infoMap.put(name, att.getValue());
        }
    }

    public void close() {
        for (Map.Entry<Connection, ConnectionHandler> entry : this.handlers.entrySet()) {
            try {
                entry.getValue().close(entry.getKey());
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        this.save();
    }

    public void save() {
        EList list = this.model.getAttribute();
        Iterator i = list.iterator();
        while (i.hasNext()) {
            AttributeType att = (AttributeType)i.next();
            String name = att.getName();
            if (!name.startsWith("carnot:connection:")) continue;
            i.remove();
        }
        List<Connection> connections = this.repository.getConnection();
        int i2 = 0;
        while (i2 < connections.size()) {
            Connection connection = connections.get(i2);
            String identifier = "carnot:connection:" + String.valueOf(i2 + 1) + ':';
            AttributeUtil.setAttribute((IExtensibleElement)this.model, (String)(String.valueOf(identifier) + "id"), (String)connection.getId());
            AttributeUtil.setAttribute((IExtensibleElement)this.model, (String)(String.valueOf(identifier) + "name"), (String)connection.getName());
            AttributeUtil.setAttribute((IExtensibleElement)this.model, (String)(String.valueOf(identifier) + "type"), (String)connection.getType());
            List<Attribute> attributes = connection.getAttributes();
            int j = 0;
            while (j < attributes.size()) {
                Attribute attribute = attributes.get(j);
                AttributeUtil.setAttribute((IExtensibleElement)this.model, (String)(String.valueOf(identifier) + "attribute:" + attribute.getName()), (String)attribute.getValue());
                ++j;
            }
            ++i2;
        }
    }

    public void setAllConnections(List<Connection> connections) {
        this.repository.getConnection().addAll(connections);
    }

    public List<Connection> getAllConnections() {
        return this.repository.getConnection();
    }

    public Iterator<Connection> getConnections() {
        return this.repository.getConnection().iterator();
    }

    public Connection getConnection(String id) {
        for (Connection connection : this.repository.getConnection()) {
            if (!id.equals(connection.getId())) continue;
            return connection;
        }
        return null;
    }

    public Connection create(String type) throws CoreException {
        Connection connection = this.createConnection(type);
        connection.setProperty("ConnectionManager.CREATED", "true");
        this.repository.getConnection().add(connection);
        return connection;
    }

    private Connection createConnection(String type) throws CoreException {
        IConfigurationElement config = this.getConfigurationElement(type);
        String baseId = type;
        String baseName = config.getAttribute("name");
        int counter = 0;
        for (Connection connection : this.repository.getConnection()) {
            counter = this.getPostfixNumber(connection.getId(), baseId, '_', counter);
            counter = this.getPostfixNumber(connection.getName(), baseName, ' ', counter);
        }
        RepositoryFactory factory = RepositoryFactory.eINSTANCE;
        Connection connection = factory.createConnection();
        connection.setProperty("ConnectionManager", this);
        connection.setId(counter == 0 ? baseId : String.valueOf(baseId) + '_' + counter);
        connection.setName(counter == 0 ? baseName : String.valueOf(baseName) + ' ' + counter);
        connection.setType(type);
        Attribute attribute = factory.createAttribute();
        attribute.setName("importByReference");
        attribute.setValue("true");
        connection.getAttributes().add(attribute);
        return connection;
    }

    private int getPostfixNumber(String actual, String base, char separator, int c) {
        if (base.equals(actual) && c == 0) {
            c = 1;
        } else if (actual != null && actual.startsWith(String.valueOf(base) + separator)) {
            try {
                int number = Integer.parseInt(actual.substring(base.length() + 1));
                c = Math.max(c, number + 1);
            }
            catch (Exception exception) {}
        }
        return c;
    }

    public ConnectionHandler getConnectionHandler(Connection connection) {
        return this.handlers.get(connection);
    }

    public boolean isOpen(Connection connection) {
        return this.handlers.containsKey(connection);
    }

    public void open(Connection connection) throws CoreException {
        ConnectionHandler handler = this.handlers.get(connection);
        if (handler == null) {
            handler = this.createHandler(connection.getType());
            handler.open(connection);
            this.handlers.put(connection, handler);
        }
    }

    private ConnectionHandler createHandler(String type) throws CoreException {
        IConfigurationElement config = this.getConfigurationElement(type);
        return (ConnectionHandler)config.createExecutableExtension("handler");
    }

    public IConfigurationElement getConfigurationElement(String type) throws CoreException {
        List extensions = SpiExtensionRegistry.instance().getExtensionList("org.eclipse.stardust.modeling.repository.common", "connections");
        int i = 0;
        while (i < extensions.size()) {
            IConfigurationElement config = (IConfigurationElement)extensions.get(i);
            if (config.getAttribute("id").equals(type)) {
                return config;
            }
            ++i;
        }
        String message = MessageFormat.format(Repository_Messages.MSG_FORMAT_NO_HANDLER_FOUND_FOR_CONNECTION_TYPE_NULL, type);
        throw new CoreException((IStatus)new Status(4, "org.eclipse.stardust.modeling.repository.common", 0, message, null));
    }

    public void close(Connection connection) throws CoreException {
        ConnectionHandler handler = this.handlers.get(connection);
        if (handler != null) {
            handler.close(connection);
            this.handlers.remove(connection);
        }
    }

    public Repository getRepository() {
        return this.repository;
    }

    public static URI makeURI(Connection connection) {
        String id = connection.getId();
        return URI.createURI((String)("cnx://" + id + "/"));
    }

    public EObject find(String uri) {
        try {
            return this.find(URI.createURI((String)uri));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public IConnection findConnection(String uri) {
        try {
            return this.findConnection(URI.createURI((String)uri));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public EObject find(URI uri) {
        Connection connection = (Connection)this.findConnection(uri);
        if (connection != null) {
            try {
                this.open(connection);
            }
            catch (CoreException coreException) {}
            ConnectionHandler handler = this.handlers.get(connection);
            if (handler != null) {
                return handler.find(uri);
            }
        }
        return null;
    }

    public IConnection findConnection(URI uri) {
        if ("cnx".equals(uri.scheme())) {
            String id = uri.authority();
            return this.getConnection(id);
        }
        return null;
    }

    public void resolve() {
        for (EObject object : this.model.eContents()) {
            if (!object.eIsProxy() || !(object instanceof EObjectImpl)) continue;
            URI uri = ((EObjectImpl)object).eProxyURI();
            if (uri.opaquePart() != null) {
                try {
                    ExternalPackage pkg;
                    QName qname = QName.valueOf(uri.opaquePart());
                    if (this.model.getExternalPackages() != null && (pkg = this.model.getExternalPackages().getExternalPackage(qname.getNamespaceURI())) != null) {
                        String pkgConnectionUri = ExtendedAttributeUtil.getAttributeValue((Extensible)pkg, (String)"carnot:connection:uri");
                        uri = URI.createURI((String)(String.valueOf(pkgConnectionUri) + uri.scheme() + '/' + qname.getLocalPart()));
                        ((InternalEObject)object).eSetProxyURI(uri);
                    }
                }
                catch (Exception exception) {}
            }
            this.resolve(object, uri);
        }
    }

    private void resolve(EObject object, URI uri) {
        String id;
        Connection connection;
        if ("cnx".equals(uri.scheme()) && (connection = this.getConnection(id = uri.authority())) != null) {
            try {
                this.open(connection);
            }
            catch (CoreException coreException) {}
            ConnectionHandler handler = this.handlers.get(connection);
            if (handler != null) {
                handler.resolve(this.model, object);
            }
        }
    }

    public static URI getURI(EObject object) {
        if (object.eIsProxy() && object instanceof InternalEObject) {
            return ((InternalEObject)object).eProxyURI();
        }
        if (object instanceof IExtensibleElement) {
            String uri = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)object), (String)"carnot:connection:uri");
            try {
                return URI.createURI((String)uri);
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public void setConnectionManager(Connection connection) {
        connection.setProperty("ConnectionManager", this);
    }

    public static ConnectionManager getConnectionManager(Connection connection) {
        return (ConnectionManager)connection.getProperty("ConnectionManager");
    }

    public ModelType find(ExternalPackage pkg) {
        ModelType model;
        if (pkg != null && (model = ModelUtils.findContainingModel((EObject)pkg)) != null) {
            String uri = ExtendedAttributeUtil.getAttributeValue((Extensible)pkg, (String)"carnot:connection:uri");
            EObject eObject = this.find(uri);
            if (eObject instanceof IObjectReference) {
                eObject = ((IObjectReference)eObject).getEObject();
            }
            if (eObject instanceof ModelType) {
                return (ModelType)eObject;
            }
        }
        return null;
    }

    public ModelType getModel() {
        return this.model;
    }
}

