/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.repository.common;

import java.io.File;
import java.io.IOException;
import javax.xml.transform.TransformerFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.common.config.Parameters;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.WorkflowModelManager;
import org.eclipse.stardust.modeling.repository.common.ConnectionManager;

public class ExtendedModelManager
extends WorkflowModelManager {
    private ConnectionManager manager;

    public void resolve(ModelType model) {
        if (model != null) {
            this.manager = new ConnectionManager(model);
            this.manager.resolve();
        }
        super.resolve(model);
    }

    public void save(URI uri) throws IOException {
        if (this.manager == null) {
            ModelType model = this.getModel();
            if (model != null) {
                this.manager = new ConnectionManager(model);
            }
        } else {
            this.manager.save();
        }
        super.save(uri);
    }

    public ConnectionManager getConnectionManager() {
        return this.manager;
    }

    public static ModelType loadModel(File modelXml) throws IOException {
        String ippTraxFactory = Parameters.instance().getString("Carnot.Xml.TrAX.TransformerFactory");
        String traxFactoryOverride = System.getProperty(TransformerFactory.class.getName());
        try {
            if (!StringUtils.isEmpty((String)ippTraxFactory)) {
                System.setProperty(TransformerFactory.class.getName(), ippTraxFactory);
            }
            WorkflowModelManager modelMgr = new WorkflowModelManager();
            modelMgr.load(modelXml);
            ModelType modelType = modelMgr.getModel();
            return modelType;
        }
        finally {
            if (!StringUtils.isEmpty((String)ippTraxFactory) && !StringUtils.isEmpty((String)traxFactoryOverride)) {
                System.setProperty(TransformerFactory.class.getName(), traxFactoryOverride);
            }
        }
    }
}

