/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.repository.common.descriptors;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.merge.LinkAttribute;
import org.eclipse.stardust.model.xpdl.carnot.merge.MergeUtils;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.util.IObjectReference;
import org.eclipse.stardust.model.xpdl.xpdl2.Extensible;
import org.eclipse.stardust.model.xpdl.xpdl2.util.ExtendedAttributeUtil;
import org.eclipse.stardust.modeling.repository.common.IObjectDescriptor;
import org.eclipse.stardust.modeling.repository.common.IconDescriptor;
import org.eclipse.stardust.modeling.repository.common.ImportCancelledException;
import org.eclipse.stardust.modeling.repository.common.ImportStrategy;
import org.eclipse.stardust.modeling.repository.common.ImportableDescriptor;
import org.eclipse.stardust.modeling.repository.common.util.CreateClosures;
import org.eclipse.stardust.modeling.repository.common.util.ImportUtils;

public class EObjectDescriptor
extends EObjectImpl
implements IObjectDescriptor,
IObjectReference,
ImportableDescriptor {
    private static volatile boolean SET_URIS = true;
    protected boolean alwaysReplace = false;
    protected EObject eObject;
    private EClass classifier;
    private String iconBundleId;
    private String iconPath;
    private URI uri;
    private String id;
    private String name;
    private String description = "";

    public EObjectDescriptor(URI uri, EClass classifier, String id, String name, String description, String iconBundleId, String iconPath) {
        this.uri = uri;
        this.classifier = classifier;
        this.id = id;
        this.name = name;
        this.description = description == null ? "" : description;
        this.iconBundleId = iconBundleId;
        this.iconPath = iconPath;
    }

    public EObjectDescriptor(URI uri, EObject eObject, String id, String name, String description, String iconBundleId, String iconPath) {
        this(uri, eObject.eClass(), id, name, description, iconBundleId, iconPath);
        this.eObject = eObject;
        if (SET_URIS) {
            if (this.eObject instanceof Extensible) {
                ExtendedAttributeUtil.setAttribute((Extensible)((Extensible)this.eObject), (String)"carnot:connection:uri", (String)uri.toString());
            } else if (this.eObject instanceof IExtensibleElement) {
                AttributeUtil.setAttribute((IExtensibleElement)((IExtensibleElement)this.eObject), (String)"carnot:connection:uri", (String)uri.toString());
            }
        }
    }

    public static boolean areUrisSet() {
        return SET_URIS;
    }

    public static void setURIS(boolean setUris) {
        SET_URIS = setUris;
    }

    @Override
    public IObjectDescriptor[] getChildren() {
        return null;
    }

    @Override
    public IconDescriptor getIcon() {
        return new IconDescriptor(this.iconBundleId, this.iconPath);
    }

    @Override
    public String getLabel() {
        return this.name == null ? this.id : this.name;
    }

    @Override
    public Object getType() {
        return this.classifier;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public boolean hasChildren() {
        return false;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public String getIconBundleId() {
        return this.iconBundleId;
    }

    public String getIconPath() {
        return this.iconPath;
    }

    @Override
    public boolean isLazyLoading() {
        return false;
    }

    public <T extends EObject> T getEObject() {
        return (T)this.eObject;
    }

    @Override
    public void importElements(ModelType targetModel, ImportStrategy strategy) {
        ModelType thisModel;
        List closure;
        if (strategy.isImportAsLink()) {
            closure = CollectionUtils.newList();
            closure.add(this.eObject);
        } else {
            CreateClosures createClosures = new CreateClosures();
            closure = createClosures.computeClosure(this.eObject, targetModel);
            if (closure.size() > 1 && !strategy.acceptClosure(this.eObject, closure)) {
                throw new ImportCancelledException();
            }
        }
        Map<Object, Object> reuseReplace = Collections.emptyMap();
        Map map = MergeUtils.createClosureMap((List)closure, (ModelType)targetModel);
        if (!map.isEmpty()) {
            reuseReplace = this.alwaysReplace ? ImportUtils.reuseReplaceMap(map) : ImportUtils.reuseReplaceMap(map, strategy);
            if (reuseReplace == null) {
                throw new ImportCancelledException();
            }
            if (this.alwaysReplace) {
                reuseReplace = null;
            }
        }
        LinkAttribute linkAttribute = new LinkAttribute(this.getRootURI(), strategy.isImportAsLink(), this.isQualifyUri(), "carnot:connection:uri");
        if (strategy.isImportAsLink() && !(this.eObject instanceof Extensible) && !(thisModel = ModelUtils.findContainingModel((EObject)this.eObject)).getId().equals(targetModel.getId())) {
            ImportUtils.getPackageRef(this, targetModel, thisModel);
        }
        MergeUtils.importElements((EObject)this.eObject, (ModelType)targetModel, (List)closure, (Map)map, reuseReplace, (LinkAttribute)linkAttribute);
    }

    public boolean isQualifyUri() {
        return true;
    }

    public URI getRootURI() {
        return this.uri.trimSegments(1);
    }

    public EObject resolveElement(EObject eObject) {
        LinkAttribute.setLinkInfoAttr((EObject)eObject, (URI)this.getURI(), (boolean)true, (String)"carnot:connection:uri");
        if (eObject.eIsProxy()) {
            MergeUtils.replace((EObject)eObject, (EObject)this.eObject);
            ((InternalEObject)this.eObject).eSetProxyURI(((InternalEObject)eObject).eProxyURI());
            return this.eObject;
        }
        return eObject;
    }
}

