/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.repository.common.ui;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.change.ChangeDescription;
import org.eclipse.emf.ecore.change.util.ChangeRecorder;
import org.eclipse.gef.commands.Command;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.modeling.repository.common.Connection;
import org.eclipse.stardust.modeling.repository.common.ConnectionHandler;
import org.eclipse.stardust.modeling.repository.common.ConnectionManager;
import org.eclipse.stardust.modeling.repository.common.IObjectDescriptor;
import org.eclipse.stardust.modeling.repository.common.ImportCancelledException;
import org.eclipse.stardust.modeling.repository.common.Repository_Messages;
import org.eclipse.stardust.modeling.repository.common.ui.dialogs.UsageDisplayDialog;

public class ConnectionEditUtils {
    public static boolean mustLink(IObjectDescriptor descriptor, ConnectionManager manager) {
        URI uri = descriptor.getURI();
        String id = uri.authority();
        Connection connection = manager.getConnection(id);
        if (connection == null) {
            return false;
        }
        return "true".equals(connection.getAttribute("importByReference"));
    }

    public static Command linkObject(ModelType model, IObjectDescriptor[] descriptors, ConnectionManager manager) throws CoreException {
        ArrayList<Connection> connections = new ArrayList<Connection>();
        UsageDisplayDialog.setUsage(null);
        ChangeRecorder recorder = new ChangeRecorder((EObject)model);
        Map container = CollectionUtils.newMap();
        ConnectionEditUtils.sortDescriptors(descriptors, container);
        for (Map.Entry entry : container.entrySet()) {
            String id = (String)entry.getKey();
            IObjectDescriptor[] entryValues = ((ArrayList)entry.getValue()).toArray(new IObjectDescriptor[0]);
            Connection connection = manager.getConnection(id);
            if (connection == null) {
                String message = MessageFormat.format(Repository_Messages.MSG_FORMAT_CONNECTION_NULL_DOES_NOT_EXIST, id);
                throw new CoreException((IStatus)new Status(4, "org.eclipse.stardust.modeling.repository.common", 0, message, null));
            }
            connections.add(connection);
            ConnectionHandler handler = manager.getConnectionHandler(connection);
            if (handler == null) continue;
            try {
                handler.importObject(model, entryValues, "true".equals(connection.getAttribute("importByReference")));
            }
            catch (ImportCancelledException importCancelledException) {
                recorder.dispose();
                return null;
            }
        }
        final ChangeDescription changes = recorder.endRecording();
        ConnectionEditUtils.reloadConnections(connections);
        return new Command(){

            public void execute() {
            }

            public void undo() {
                changes.applyAndReverse();
            }

            public void redo() {
                changes.applyAndReverse();
            }
        };
    }

    private static void reloadConnections(ArrayList<Connection> connections) {
        for (Connection connection : connections) {
            ConnectionManager manager = ConnectionManager.getConnectionManager(connection);
            if (manager == null) continue;
            try {
                manager.close(connection);
            }
            catch (CoreException coreException) {}
            connection.eNotify((Notification)new NotificationImpl(4, null, null, 0));
        }
    }

    private static void sortDescriptors(IObjectDescriptor[] descriptors, Map<String, ArrayList<IObjectDescriptor>> container) {
        int i = 0;
        while (i < descriptors.length) {
            ArrayList<Object> descriptorValues;
            IObjectDescriptor descriptor = descriptors[i];
            URI uri = descriptor.getURI();
            String id = uri.authority();
            if (container.containsKey(id)) {
                descriptorValues = container.get(id);
                descriptorValues.add(descriptors[i]);
                container.put(id, descriptorValues);
            } else {
                descriptorValues = new ArrayList();
                descriptorValues.add(descriptors[i]);
                container.put(id, descriptorValues);
            }
            ++i;
        }
    }

    private ConnectionEditUtils() {
    }
}

