/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.repository.common.ui;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationType;
import org.eclipse.stardust.model.xpdl.carnot.ConditionalPerformerType;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.OrganizationType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.RoleType;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.xpdl2.ExtendedAttributeType;
import org.eclipse.stardust.model.xpdl.xpdl2.ExtendedAttributesType;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationType;
import org.eclipse.stardust.model.xpdl.xpdl2.util.ExtendedAttributeUtil;
import org.eclipse.stardust.modeling.repository.common.Connection;
import org.eclipse.stardust.modeling.repository.common.ConnectionHandler;
import org.eclipse.stardust.modeling.repository.common.ConnectionManager;
import org.eclipse.stardust.modeling.repository.common.IFilter;
import org.eclipse.stardust.modeling.repository.common.IObjectDescriptor;
import org.eclipse.stardust.modeling.repository.common.Repository_Messages;
import org.eclipse.stardust.modeling.repository.common.descriptors.EObjectDescriptor;

public class ConnectionQueryUtils {
    private static final IFilter BY_REF_FILTER = new IFilter(){

        @Override
        public boolean accept(Object object) {
            if (object instanceof EObjectDescriptor) {
                ProcessDefinitionType process;
                DataType dataType;
                ConditionalPerformerType conPerfType;
                OrganizationType orgType;
                RoleType roleType;
                ApplicationType applicationType;
                TypeDeclarationType typeDeclaration;
                ExtendedAttributeType visibility;
                EObjectDescriptor eObjectdescriptor = (EObjectDescriptor)object;
                if (eObjectdescriptor.getEObject() instanceof TypeDeclarationType && (visibility = ExtendedAttributeUtil.getAttribute((ExtendedAttributesType)(typeDeclaration = (TypeDeclarationType)eObjectdescriptor.getEObject()).getExtendedAttributes(), (String)"carnot:engine:visibility")) != null && "Private".equals(visibility.getValue())) {
                    return false;
                }
                if (eObjectdescriptor.getEObject() instanceof ApplicationType && (visibility = AttributeUtil.getAttribute((IExtensibleElement)(applicationType = (ApplicationType)eObjectdescriptor.getEObject()), (String)"carnot:engine:visibility")) != null && "Private".equals(visibility.getValue())) {
                    return false;
                }
                if (eObjectdescriptor.getEObject() instanceof RoleType && (visibility = AttributeUtil.getAttribute((IExtensibleElement)(roleType = (RoleType)eObjectdescriptor.getEObject()), (String)"carnot:engine:visibility")) != null && "Private".equals(visibility.getValue())) {
                    return false;
                }
                if (eObjectdescriptor.getEObject() instanceof OrganizationType && (visibility = AttributeUtil.getAttribute((IExtensibleElement)(orgType = (OrganizationType)eObjectdescriptor.getEObject()), (String)"carnot:engine:visibility")) != null && "Private".equals(visibility.getValue())) {
                    return false;
                }
                if (eObjectdescriptor.getEObject() instanceof ConditionalPerformerType && (visibility = AttributeUtil.getAttribute((IExtensibleElement)(conPerfType = (ConditionalPerformerType)eObjectdescriptor.getEObject()), (String)"carnot:engine:visibility")) != null && "Private".equals(visibility.getValue())) {
                    return false;
                }
                if (eObjectdescriptor.getEObject() instanceof DataType && (visibility = AttributeUtil.getAttribute((IExtensibleElement)(dataType = (DataType)eObjectdescriptor.getEObject()), (String)"carnot:engine:visibility")) != null && "Private".equals(visibility.getValue())) {
                    return false;
                }
                if (eObjectdescriptor.getEObject() instanceof ProcessDefinitionType && (process = (ProcessDefinitionType)eObjectdescriptor.getEObject()).getFormalParameters() == null) {
                    return false;
                }
            }
            return true;
        }
    };

    public static List<IObjectDescriptor> select(Connection connection, ConnectionManager connectionManager, IFilter[] filters) throws CoreException {
        filters = ConnectionQueryUtils.getFilters(filters, "true".equals(connection.getAttribute("importByReference")));
        ConnectionHandler handler = connectionManager.getConnectionHandler(connection);
        if (handler != null) {
            List<IObjectDescriptor> result = handler.select(filters);
            return filters == null ? result : ConnectionQueryUtils.decorateWithFilters(result, filters);
        }
        String message = MessageFormat.format(Repository_Messages.MSG_FORMAT_CONNECTION_NULL_IS_CLOSED, connection.getId());
        throw new CoreException((IStatus)new Status(4, "org.eclipse.stardust.modeling.repository.common", 0, message, null));
    }

    private static List<IObjectDescriptor> decorateWithFilters(List<IObjectDescriptor> result, IFilter[] filters) {
        List descriptors = CollectionUtils.newList((int)result.size());
        for (IObjectDescriptor desc : result) {
            descriptors.add(ConnectionQueryUtils.getFilteredObjectDescriptor(desc, filters));
        }
        return descriptors;
    }

    private static IObjectDescriptor getFilteredObjectDescriptor(final IObjectDescriptor desc, final IFilter[] filters) {
        InvocationHandler handler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (IObjectDescriptor.class.equals(method.getDeclaringClass()) && "getChildren".equals(method.getName())) {
                    IObjectDescriptor[] children = desc.getChildren();
                    List filtered = CollectionUtils.newList();
                    int i = 0;
                    while (i < children.length) {
                        if (BY_REF_FILTER.accept(children[i])) {
                            filtered.add(ConnectionQueryUtils.getFilteredObjectDescriptor(children[i], filters));
                        }
                        ++i;
                    }
                    return filtered.toArray(new IObjectDescriptor[filtered.size()]);
                }
                return method.invoke((Object)desc, args);
            }
        };
        ClassLoader classLoader = desc.getClass().getClassLoader();
        Class<?>[] interfaces = ConnectionQueryUtils.getInterfaces(desc);
        return (IObjectDescriptor)Proxy.newProxyInstance(classLoader, interfaces, handler);
    }

    private static Class<?>[] getInterfaces(IObjectDescriptor desc) {
        ArrayList result = new ArrayList();
        Class<?>[] interfaces = desc.getClass().getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            result.add(interfaces[i]);
            ++i;
        }
        if (desc.getClass().getSuperclass() != null) {
            interfaces = desc.getClass().getSuperclass().getInterfaces();
            i = 0;
            while (i < interfaces.length) {
                result.add(interfaces[i]);
                ++i;
            }
        }
        return result.toArray(new Class[result.size()]);
    }

    private static IFilter[] getFilters(IFilter[] filters, boolean byReference) {
        if (filters != null || byReference) {
            List list = CollectionUtils.newList();
            if (filters != null) {
                int i = 0;
                while (i < filters.length) {
                    if (filters[i] != null) {
                        list.add(filters[i]);
                    }
                    ++i;
                }
            }
            if (byReference) {
                list.add(BY_REF_FILTER);
            }
            if (list.size() > 0) {
                return list.toArray(new IFilter[list.size()]);
            }
        }
        return null;
    }

    private ConnectionQueryUtils() {
    }
}

