/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.repository.common.ui;

import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.modeling.repository.common.IObjectDescriptor;
import org.eclipse.stardust.modeling.repository.common.Repository_Messages;

public class ObjectDescriptorListContentProvider
implements ITreeContentProvider {
    private static final Object[] EMPTY = new Object[0];
    private Map<Object, List<IObjectDescriptor>> data;
    private Map<Object, Object> parents;

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IObjectDescriptor) {
            Object[] children = ((IObjectDescriptor)parentElement).getChildren();
            int i = 0;
            while (i < children.length) {
                this.parents.put(children[i], parentElement);
                ++i;
            }
            return children;
        }
        List<IObjectDescriptor> children = this.data.get(parentElement);
        if (children != null) {
            int i = 0;
            while (i < children.size()) {
                this.parents.put(children.get(i), parentElement);
                ++i;
            }
            return children.toArray();
        }
        return EMPTY;
    }

    public Object getParent(Object element) {
        return this.parents.get(element);
    }

    public boolean hasChildren(Object element) {
        if (element instanceof IObjectDescriptor) {
            return ((IObjectDescriptor)element).hasChildren();
        }
        List<IObjectDescriptor> children = this.data.get(element);
        return children != null && !children.isEmpty();
    }

    public Object[] getElements(Object inputElement) {
        return this.data.keySet().toArray();
    }

    public void dispose() {
        if (this.data != null) {
            this.data.clear();
            this.data = null;
        }
        if (this.parents != null) {
            this.parents.clear();
            this.parents = null;
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void reset(Object newInput) {
        if (this.data == null) {
            this.data = CollectionUtils.newMap();
        } else {
            this.data.clear();
        }
        if (this.parents == null) {
            this.parents = CollectionUtils.newMap();
        } else {
            this.parents.clear();
        }
        if (newInput instanceof List) {
            this.createMapData((List)newInput);
        }
    }

    private void createMapData(List<?> list) {
        int i = 0;
        while (i < list.size()) {
            Object object = list.get(i);
            if (object instanceof IObjectDescriptor) {
                List children;
                IObjectDescriptor descriptor = (IObjectDescriptor)object;
                Object key = descriptor.getType();
                if (key == null) {
                    key = this;
                }
                if ((children = this.data.get(key)) == null) {
                    children = CollectionUtils.newList();
                    this.data.put(key, children);
                }
                children.add(descriptor);
            }
            ++i;
        }
    }

    public String toString() {
        return "<" + Repository_Messages.TXT_TYPELESS + ">";
    }
}

