/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.repository.common.ui.parts.tree;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.ComponentEditPolicy;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.stardust.modeling.repository.common.Connection;
import org.eclipse.stardust.modeling.repository.common.ConnectionManager;
import org.eclipse.stardust.modeling.repository.common.IFilter;
import org.eclipse.stardust.modeling.repository.common.IObjectDescriptor;
import org.eclipse.stardust.modeling.repository.common.RepositoryPackage;
import org.eclipse.stardust.modeling.repository.common.Repository_Messages;
import org.eclipse.stardust.modeling.repository.common.ui.ConnectionQueryUtils;
import org.eclipse.stardust.modeling.repository.common.ui.DeleteValueCmd;
import org.eclipse.stardust.modeling.repository.common.ui.ImageUtil;
import org.eclipse.stardust.modeling.repository.common.ui.parts.tree.LazyLoadingTreeEditPart;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class ConnectionTreeEditPart
extends LazyLoadingTreeEditPart
implements DisposeListener {
    private Font alternateFont;

    public ConnectionTreeEditPart(Connection model) {
        super(model);
    }

    @Override
    protected List<IObjectDescriptor> doGetModelChildren() {
        Connection connection = (Connection)this.getModel();
        if ("true".equals(connection.getProperty("ConnectionManager.CREATED"))) {
            return Collections.emptyList();
        }
        try {
            ConnectionManager manager = ConnectionManager.getConnectionManager(connection);
            manager.open(connection);
            return ConnectionQueryUtils.select(connection, manager, (IFilter[])connection.getProperty("filters"));
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.getViewer().getControl().getShell(), (String)Repository_Messages.DIA_ERROR, (String)Repository_Messages.DIA_ERROR_OPENING_CONNECTION, (IStatus)e.getStatus());
            return Collections.emptyList();
        }
        catch (Exception exception) {
            return Collections.emptyList();
        }
    }

    @Override
    public void setWidget(Widget widget) {
        super.setWidget(widget);
        if (this.checkTreeItem()) {
            widget.addDisposeListener((DisposeListener)this);
            TreeItem item = (TreeItem)widget;
            this.setAlternativeFont(item);
        }
    }

    private void setAlternativeFont(TreeItem item) {
        Connection connection = (Connection)this.getModel();
        if ("true".equals(connection.getAttribute("importByReference"))) {
            if (this.alternateFont == null) {
                Font font = item.getFont();
                FontData[] data = font.getFontData();
                int alternateStyle = 2;
                int i = 0;
                while (i < data.length) {
                    int style = data[i].getStyle();
                    style = (style & alternateStyle) == alternateStyle ? (style -= alternateStyle) : (style += alternateStyle);
                    data[i].setStyle(style);
                    ++i;
                }
                this.alternateFont = new Font(font.getDevice(), data);
            }
            item.setFont(this.alternateFont);
        } else {
            item.setFont(null);
        }
    }

    @Override
    protected String doGetText() {
        Connection connection = (Connection)this.getModel();
        String name = connection.getName();
        return name == null ? "" : name;
    }

    @Override
    protected Image doGetImage() {
        Connection connection = (Connection)this.getModel();
        if ("true".equals(connection.getProperty("ConnectionManager.CREATED"))) {
            return null;
        }
        ConnectionManager manager = ConnectionManager.getConnectionManager(connection);
        try {
            IConfigurationElement config = manager.getConfigurationElement(connection.getType());
            String icon = config.getAttribute("icon");
            return icon == null ? null : ImageUtil.getImageManager(config.getContributor().getName()).getPlainIcon(icon);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new ComponentEditPolicy(){

            protected Command createDeleteCommand(GroupRequest deleteRequest) {
                Connection connection = (Connection)this.getHost().getModel();
                return new DeleteValueCmd(connection.eContainer(), (EStructuralFeature)RepositoryPackage.eINSTANCE.getRepository_Connection(), connection);
            }
        });
    }

    public void widgetDisposed(DisposeEvent e) {
        if (this.alternateFont != null) {
            Font x = this.alternateFont;
            this.alternateFont = null;
            x.dispose();
        }
    }

    public void refresh() {
        TreeItem item = (TreeItem)this.widget;
        this.setAlternativeFont(item);
        super.refresh();
    }
}

