/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.repository.file;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.model.xpdl.carnot.DescriptionType;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableModelElement;
import org.eclipse.stardust.model.xpdl.carnot.INodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.core.editors.parts.IconFactory;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.DeleteSymbolCommandFactory;
import org.eclipse.stardust.modeling.repository.common.Connection;
import org.eclipse.stardust.modeling.repository.common.ConnectionHandler;
import org.eclipse.stardust.modeling.repository.common.ConnectionManager;
import org.eclipse.stardust.modeling.repository.common.ExtendedModelManager;
import org.eclipse.stardust.modeling.repository.common.IFilter;
import org.eclipse.stardust.modeling.repository.common.IObjectDescriptor;
import org.eclipse.stardust.modeling.repository.common.ImportCancelledException;
import org.eclipse.stardust.modeling.repository.common.ImportStrategy;
import org.eclipse.stardust.modeling.repository.common.ImportableDescriptor;
import org.eclipse.stardust.modeling.repository.common.descriptors.CategoryDescriptor;
import org.eclipse.stardust.modeling.repository.common.descriptors.EObjectDescriptor;
import org.eclipse.stardust.modeling.repository.common.descriptors.ModelElementDescriptor;
import org.eclipse.stardust.modeling.repository.common.ui.InteractiveImportStrategy;
import org.eclipse.stardust.modeling.repository.common.util.ImportUtils;
import org.eclipse.stardust.modeling.repository.file.FilePathUtil;
import org.eclipse.stardust.modeling.repository.file.File_Messages;

public class FileConnectionHandler
implements ConnectionHandler {
    private boolean open;
    private URI uri;
    private IObjectDescriptor[] children = null;
    private Connection connection;
    private static final List<String> PARTICIPANTS = Arrays.asList("role", "organization", "conditionalPerformer");
    private EObjectDescriptor modelDescriptor;

    public void close(Connection connection) throws CoreException {
        if (!this.open) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.stardust.modeling.repository.common", 0, MessageFormat.format(File_Messages.EXC_ALREADY_CLOSED, connection.getId()), null));
        }
        this.open = false;
        this.connection = null;
    }

    public void open(Connection connection) throws CoreException {
        if (this.open) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.stardust.modeling.repository.common", 0, MessageFormat.format(File_Messages.EXC_ALREADY_OPEN, connection.getId()), null));
        }
        this.uri = ConnectionManager.makeURI((Connection)connection);
        String filename = connection.getAttribute("filename");
        if (filename == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.stardust.modeling.repository.common", 0, File_Messages.EXC_MISSING_FILENAME, null));
        }
        this.connection = connection;
        try {
            this.updateCache(filename);
        }
        catch (IOException ex) {
            throw new CoreException((IStatus)new Status(2, "org.eclipse.stardust.modeling.repository.file", File_Messages.EXC_UNABLE_TO_LOAD_MD, (Throwable)ex));
        }
        this.open = true;
    }

    private void updateCache(String fileName) throws IOException {
        File file = FileConnectionHandler.resolve(this.connection, fileName);
        ExtendedModelManager manager = new ExtendedModelManager();
        manager.load(file);
        ModelType model = manager.getModel();
        IconFactory iconFactory = IconFactory.getDefault();
        iconFactory.keepSimpleIconState();
        this.modelDescriptor = new EObjectDescriptor(this.uri, (EObject)model, model.getId(), model.getName(), ModelUtils.getDescriptionText((DescriptionType)model.getDescription()), "org.eclipse.stardust.modeling.core", iconFactory.getIconFor((EObject)model));
        List descriptors = ImportUtils.createObjectDescriptors((org.eclipse.stardust.model.xpdl.carnot.util.IconFactory)iconFactory, (ModelType)model, (URI)this.uri);
        if (descriptors.size() > 0) {
            this.children = descriptors.toArray(new IObjectDescriptor[0]);
        }
    }

    public List<IObjectDescriptor> select(IFilter[] filters) throws CoreException {
        int i;
        List result = CollectionUtils.newList();
        if (filters == null || filters.length == 0) {
            i = 0;
            while (i < this.children.length) {
                result.add(this.children[i]);
                ++i;
            }
        } else {
            i = 0;
            while (i < this.children.length) {
                IObjectDescriptor descriptor = this.children[i];
                int j = 0;
                while (j < filters.length) {
                    if (filters[j] != null && filters[j].accept((Object)descriptor)) {
                        result.add(descriptor);
                        break;
                    }
                    ++j;
                }
                ++i;
            }
        }
        IObjectDescriptor searchDescriptor = (IObjectDescriptor)this.connection.getProperty("search.result");
        if (searchDescriptor != null) {
            result.add(searchDescriptor);
        }
        return Collections.unmodifiableList(result);
    }

    public void importObject(ModelType model, IObjectDescriptor[] descriptors, boolean asLink) {
        int i = 0;
        while (i < descriptors.length) {
            block4: {
                IObjectDescriptor descriptor = descriptors[i];
                if (descriptor instanceof ImportableDescriptor) {
                    try {
                        ((ImportableDescriptor)descriptor).importElements(model, (ImportStrategy)new InteractiveImportStrategy(asLink, (org.eclipse.stardust.model.xpdl.carnot.util.IconFactory)IconFactory.getDefault()));
                    }
                    catch (Exception f) {
                        Throwable targetException;
                        Throwable undeclaredThrowable;
                        if (!(f instanceof UndeclaredThrowableException ? (undeclaredThrowable = ((UndeclaredThrowableException)f).getUndeclaredThrowable()) instanceof InvocationTargetException && (targetException = ((InvocationTargetException)undeclaredThrowable).getTargetException()) instanceof ImportCancelledException : f instanceof ImportCancelledException)) break block4;
                        throw new ImportCancelledException();
                    }
                }
            }
            ++i;
        }
    }

    public EObject resolve(ModelType model, EObject object) {
        URI uri = ConnectionManager.getURI((EObject)object);
        if (uri != null) {
            IObjectDescriptor node = this.find(uri);
            if (node != null) {
                return ((ModelElementDescriptor)node).resolveElement(object);
            }
            if (object instanceof IIdentifiableModelElement) {
                CompoundCommand cmd = new CompoundCommand();
                EList symbols = ((IIdentifiableModelElement)object).getSymbols();
                for (INodeSymbol symbol : symbols) {
                    cmd.add(DeleteSymbolCommandFactory.createDeleteSymbolCommand((INodeSymbol)symbol));
                }
                cmd.execute();
            }
        }
        return object;
    }

    public IObjectDescriptor find(URI uri) {
        if (uri.equals(this.uri)) {
            return this.modelDescriptor;
        }
        IObjectDescriptor[] iObjectDescriptorArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            URI categoryUri;
            IObjectDescriptor child = iObjectDescriptorArray[n2];
            if (uri.equals(child.getURI())) {
                return child;
            }
            if (child instanceof CategoryDescriptor && this.isChildOf(categoryUri = child.getURI(), uri)) {
                return ((CategoryDescriptor)child).find(uri);
            }
            ++n2;
        }
        return null;
    }

    public boolean isChildOf(URI categoryUri, URI uri) {
        if (uri.toString().startsWith(categoryUri.toString())) {
            return true;
        }
        if ("participants".equals(categoryUri.lastSegment()) && uri.segmentCount() > categoryUri.segmentCount()) {
            return PARTICIPANTS.contains(uri.segment(categoryUri.segmentCount() - 1));
        }
        return false;
    }

    static File resolve(Connection connection, String fileName) {
        File file = null;
        try {
            java.net.URI uri = java.net.URI.create(fileName);
            file = "project".equals(uri.getScheme()) ? FileConnectionHandler.getFile(connection, fileName, uri, false) : ("platform".equals(uri.getScheme()) ? new File(uri.getPath()) : new File(fileName));
            if (!file.isAbsolute()) {
                file = new File(Platform.getLocation().toFile(), file.toString());
            }
            if (!file.exists() && !(file = FileConnectionHandler.getFile(connection, fileName, null, true)).isAbsolute()) {
                file = new File(Platform.getLocation().toFile(), file.toString());
            }
        }
        catch (Exception exception) {
            file = new File(fileName);
        }
        return file;
    }

    private static File getFile(Connection connection, String fileName, java.net.URI uri, boolean convert) {
        URI modelURI;
        File file = null;
        ConnectionManager manager = (ConnectionManager)connection.getProperty("ConnectionManager");
        ModelType model = manager.getModel();
        if (convert) {
            fileName = FilePathUtil.convertPath(model, fileName);
            uri = java.net.URI.create(fileName);
        }
        if ((modelURI = model.eResource().getURI()).isPlatformResource()) {
            file = new File(modelURI.segment(1), uri.getPath());
        } else if (modelURI.isFile()) {
            file = new File(uri.getPath());
        }
        return file;
    }
}

