/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.transformation.debug.model;

import java.util.ArrayList;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.stardust.engine.core.javascript.StructuredDataListAccessor;
import org.eclipse.stardust.engine.core.javascript.StructuredDataMapAccessor;
import org.eclipse.stardust.modeling.transformation.debug.model.JsDebugElement;
import org.eclipse.stardust.modeling.transformation.debug.model.JsDebugTarget;
import org.eclipse.stardust.modeling.transformation.debug.model.NullElementVariable;
import org.eclipse.stardust.modeling.transformation.debug.model.StructuredDataListVariable;
import org.eclipse.stardust.modeling.transformation.debug.model.StructuredDataMapVariable;

public class StructuredDataListValue
extends JsDebugElement
implements IValue {
    private final StructuredDataListVariable variable;

    public StructuredDataListValue(StructuredDataListVariable variable) {
        super((JsDebugTarget)variable.getDebugTarget());
        this.variable = variable;
    }

    public String getReferenceTypeName() throws DebugException {
        return this.variable.getReferenceTypeName();
    }

    public String getValueString() throws DebugException {
        return this.getReferenceTypeName();
    }

    public IVariable[] getVariables() throws DebugException {
        ArrayList<JsDebugElement> variables = new ArrayList<JsDebugElement>();
        StructuredDataListAccessor accessor = this.variable.getAccessor();
        if (accessor != null) {
            Integer size = (Integer)accessor.get("length", null);
            int idx = 0;
            while (idx < size) {
                Object rawValue = accessor.get(idx, null);
                String name = "[" + idx + "]";
                if (rawValue == null) {
                    variables.add(new NullElementVariable(this.variable.getStackFrame(), name));
                } else if (rawValue instanceof StructuredDataMapAccessor) {
                    variables.add(new StructuredDataMapVariable(this.variable.getStackFrame(), this.variable, name, (StructuredDataMapAccessor)rawValue));
                } else {
                    variables.add(new StructuredDataListVariable(this.variable.getStackFrame(), this.variable, name, (StructuredDataListAccessor)rawValue));
                }
                ++idx;
            }
        }
        return variables.isEmpty() ? new IVariable[]{} : variables.toArray(new IVariable[variables.size()]);
    }

    public boolean hasVariables() throws DebugException {
        return this.getVariables().length > 0;
    }

    public boolean isAllocated() throws DebugException {
        return true;
    }
}

