/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.transformation.messaging.modeling.application.serialization;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.stardust.engine.core.struct.IXPathMap;
import org.eclipse.stardust.model.xpdl.carnot.AccessPointType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationType;
import org.eclipse.stardust.model.xpdl.carnot.DataTypeType;
import org.eclipse.stardust.model.xpdl.carnot.DirectionType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.spi.IApplicationPropertyPage;
import org.eclipse.stardust.model.xpdl.carnot.util.AccessPointUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.carnot.util.StructuredTypeUtils;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationType;
import org.eclipse.stardust.modeling.common.platform.utils.WorkspaceUtils;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.core.spi.dataTypes.struct.StructAccessPointType;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.MessageTransformationUtils;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.Modeling_Messages;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.AbstractMessageProcessingPropertyPage;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.widgets.TypesLabelProvider;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;

public class MessageSerializationApplicationPropertyPage
extends AbstractMessageProcessingPropertyPage
implements IApplicationPropertyPage {
    private ModelType modelType;
    private MessageTransformationUtils mtaUtils = new MessageTransformationUtils();

    public void loadFieldsFromElement(IModelElementNodeSymbol symbol, IModelElement element) {
        this.modelType = ModelUtils.findContainingModel((EObject)element);
        this.initializeMessageFormatComboViewer(element);
        this.initializeTypeComboViewer((ApplicationType)element);
        this.initializeTestConfigurationComboViewer(element);
    }

    public void loadElementFromFields(IModelElementNodeSymbol symbol, IModelElement element) {
        ApplicationType application = (ApplicationType)element;
        application.getAccessPoint().clear();
        DataTypeType dataTypeSerializable = ModelUtils.getDataType((IModelElement)application, (String)"serializable");
        AccessPointType apOutputMessage = AccessPointUtil.createAccessPoint((String)"OutputMessageString", (String)"OutputMessageString: java.lang.String", (DirectionType)DirectionType.OUT_LITERAL, (DataTypeType)dataTypeSerializable);
        AttributeUtil.setAttribute((IExtensibleElement)apOutputMessage, (String)"carnot:engine:className", (String)String.class.getName());
        application.getAccessPoint().add((Object)apOutputMessage);
        if (this.messageTypeComboViewer.getSelection() != null && !this.messageTypeComboViewer.getSelection().isEmpty()) {
            DataTypeType structuredDataType = ModelUtils.getDataType((IModelElement)application, (String)"struct");
            TypeDeclarationType selectedTypeDeclaration = (TypeDeclarationType)((IStructuredSelection)this.messageTypeComboViewer.getSelection()).getFirstElement();
            IXPathMap xPathMap = StructuredTypeUtils.getXPathMap((TypeDeclarationType)selectedTypeDeclaration);
            StructAccessPointType apInputMessage = this.mtaUtils.createStructAccessPoint("InputMessage", "InputMessage (" + selectedTypeDeclaration.getId() + ")", DirectionType.IN_LITERAL, structuredDataType, xPathMap.getRootXPath(), xPathMap);
            application.getAccessPoint().add((Object)apInputMessage);
            StructuredTypeUtils.setStructuredAccessPointAttributes((IExtensibleElement)apInputMessage, (TypeDeclarationType)selectedTypeDeclaration);
        }
        this.loadMessageFormat(element);
        this.loadTestConfiguration(element);
    }

    public Control createBody(Composite parent) {
        final Composite composite = FormBuilder.createComposite((Composite)parent, (int)1);
        this.formatComboViewer = (ComboViewer)FormBuilder.createComboViewer((Composite)composite, (String)Modeling_Messages.LBL_TARGET_MSG_FORMAT, new ArrayList()).getViewer();
        this.formatComboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.messageTypeComboViewer = (ComboViewer)FormBuilder.createComboViewer((Composite)composite, (String)Modeling_Messages.LBL_SR_MSG_TYPE, new ArrayList()).getViewer();
        this.messageTypeComboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.messageTypeComboViewer.setLabelProvider((IBaseLabelProvider)new TypesLabelProvider());
        this.createTestGroup(composite);
        this.messageTypeComboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MessageSerializationApplicationPropertyPage.this.enableRunButton();
            }
        });
        this.formatComboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MessageSerializationApplicationPropertyPage.this.enableRunButton();
            }
        });
        this.createConfigurationLink.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ILaunchManager lm = DebugPlugin.getDefault().getLaunchManager();
                ILaunchConfigurationType ct = lm.getLaunchConfigurationType("org.eclipse.stardust.modeling.transformation.application.launch.testType");
                try {
                    FileDialog fd = new FileDialog(composite.getShell(), 8192);
                    fd.setText(Modeling_Messages.TXT_SEL_FILE_CONTAINING_TEST_IP_MSG);
                    fd.setFilterPath("C:/");
                    String sourceFilePath = fd.open();
                    if (sourceFilePath != null) {
                        ILaunchConfiguration[] launchConfigurations = lm.getLaunchConfigurations(ct);
                        ILaunchConfigurationWorkingCopy workingCopy = ct.newInstance(null, "New Messaging Test" + launchConfigurations.length);
                        IProject project = WorkspaceUtils.getProjectFromEObject((EObject)MessageSerializationApplicationPropertyPage.this.modelType);
                        workingCopy.setAttribute("modelUri", MessageSerializationApplicationPropertyPage.this.modelType.eResource().getURI().toString());
                        workingCopy.setAttribute("ippProject", project.getName());
                        workingCopy.setAttribute("modelName", MessageSerializationApplicationPropertyPage.this.modelType.eResource().getURI().lastSegment());
                        if (!MessageSerializationApplicationPropertyPage.this.messageTypeComboViewer.getSelection().isEmpty()) {
                            TypeDeclarationType selectedTypeDeclaration = (TypeDeclarationType)((IStructuredSelection)MessageSerializationApplicationPropertyPage.this.messageTypeComboViewer.getSelection()).getFirstElement();
                            workingCopy.setAttribute("legoData", selectedTypeDeclaration.getId());
                        }
                        workingCopy.setAttribute("sourceFilePath", sourceFilePath);
                        workingCopy.setAttribute("sourceFormat", MessageSerializationApplicationPropertyPage.this.getMessageFormat());
                        workingCopy.setAttribute("targetFormat", MessageSerializationApplicationPropertyPage.this.getMessageFormat());
                        workingCopy.setAttribute("testSerialization", true);
                        workingCopy.setAttribute("screenOnly", true);
                        workingCopy.setAttribute("testParsing", ct.getName());
                        ILaunchConfiguration configuration = workingCopy.doSave();
                        MessageSerializationApplicationPropertyPage.this.refreshTestConfigurationComboViewer();
                        MessageSerializationApplicationPropertyPage.this.testConfigurationsComboViewer.setSelection((ISelection)new StructuredSelection((Object)configuration));
                    }
                }
                catch (CoreException e1) {
                    throw new RuntimeException(Modeling_Messages.EXC_COULD_NOT_CREATE_LAUNCH_CFG, e1);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return composite;
    }
}

