/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation;

import java.text.MessageFormat;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.engine.extensions.transformation.model.mapping.FieldMapping;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.spi.IApplicationPropertyPage;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.AbstractModelElementNodeSymbolEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.tree.IdentifiableModelElementTreeEditPart;
import org.eclipse.stardust.modeling.core.editors.ui.ModelElementPropertyDialog;
import org.eclipse.stardust.modeling.core.properties.AbstractModelElementPropertyPage;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.Modeling_Messages;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.MessageTransformationApplicationControlsManager;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.MessageTransformationController;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;

public class MessageTransformationApplicationPropertyPage
extends AbstractModelElementPropertyPage
implements IApplicationPropertyPage {
    IModelElementNodeSymbol defaultSymbol;
    IModelElement defaultModelElement;
    boolean closeHard;
    boolean removedAll;
    private final MessageTransformationApplicationControlsManager controlsManager = new MessageTransformationApplicationControlsManager();
    private MessageTransformationController controller;
    private boolean isExternalReference;

    public void dispose() {
        this.controlsManager.dispose();
        super.dispose();
    }

    public void loadFieldsFromElement(IModelElementNodeSymbol symbol, IModelElement element) {
        this.controller = this.controlsManager.getController();
        try {
            this.defaultSymbol = symbol;
            this.defaultModelElement = element;
            ModelType model = ModelUtils.findContainingModel((EObject)element);
            this.controller.intializeModel(model, symbol, element);
            this.controlsManager.refreshModel();
            this.controller.initializeMappings(element);
            this.controlsManager.getSourceMessageTreeViewer().refresh(true);
            this.controlsManager.getTargetMessageTreeViewer().refresh(true);
            this.controlsManager.refreshDocument();
            if (this.controller.getAvailableMessageTypes().isEmpty()) {
                this.setErrorMessage(Modeling_Messages.MSG_MD_NOT_CONTAIN_STR_DATA_TYPE_DEFINE_MSG);
            }
        }
        catch (RuntimeException t) {
            t.printStackTrace();
            MessageBox messageBox = this.createMessageBoxByException(t);
            if (messageBox == null) {
                throw t;
            }
            if (messageBox.open() == 256) {
                ModelElementPropertyDialog dialog = (ModelElementPropertyDialog)this.getContainer();
                this.closeHard = true;
                dialog.close();
            }
            this.removedAll = true;
            this.controller.removeInvalidAccessPoints();
            this.loadFieldsFromElement(symbol, element);
        }
    }

    private MessageBox createMessageBoxByException(RuntimeException t) {
        MessageBox messageBox = new MessageBox(Display.getDefault().getActiveShell(), 289);
        if (t.getMessage() == null) {
            return null;
        }
        if (t.getMessage().indexOf("external reference") > 0) {
            messageBox.setText(Modeling_Messages.TXT_MISSING_REF);
            String message = Modeling_Messages.MSG_EXT_REF_REMOVED_CLASSPATH;
            message = String.valueOf(message) + "\n\n" + Modeling_Messages.MSG_ORI_MSG;
            message = String.valueOf(message) + "\n\n" + Modeling_Messages.MSG_REMOVE_INVALID_MSG;
            messageBox.setMessage(MessageFormat.format(message, t.getMessage()));
        } else {
            messageBox.setText(Modeling_Messages.TXT_INVALID_MSG);
            String message = Modeling_Messages.MSG_MSG_TRANS_CONTAINS_INVALID_MSG;
            message = String.valueOf(message) + "\n\n" + Modeling_Messages.MSG_ORI_MSG;
            message = String.valueOf(message) + "\n\n" + Modeling_Messages.MSG_WANT_REMOVE_INVALID;
            messageBox.setMessage(MessageFormat.format(message, t.getMessage()));
        }
        return messageBox;
    }

    public void elementChanged() {
        IModelElementNodeSymbol symbol = (IModelElementNodeSymbol)this.getElement().getAdapter(IModelElementNodeSymbol.class);
        IModelElement modelElement = (IModelElement)(symbol == null ? this.getElement().getAdapter(IModelElement.class) : symbol.getModelElement());
        if (modelElement == null) {
            modelElement = (IModelElement)this.getModelElement();
            this.isExternalReference = true;
        }
        if (modelElement != null) {
            this.loadFieldsFromElement(symbol, modelElement);
        }
        this.removedAll = false;
    }

    public void loadElementFromFields(IModelElementNodeSymbol symbol, IModelElement element) {
        this.controlsManager.getController().saveFields(symbol, element);
    }

    public Control createBody(Composite parent) {
        boolean insta = this.getElement() instanceof IdentifiableModelElementTreeEditPart;
        boolean instb = this.getElement() instanceof AbstractModelElementNodeSymbolEditPart;
        if (!insta && !instb) {
            this.controlsManager.setExternalReference(true);
        }
        return this.controlsManager.create(parent, (IModelElement)this.getModelElement());
    }

    protected void performDefaults() {
        super.performDefaults();
        this.clearMappingStatements();
        this.controlsManager.getController().reset();
        this.loadFieldsFromElement(this.defaultSymbol, this.defaultModelElement);
    }

    private void clearMappingStatements() {
        for (FieldMapping fm : this.controlsManager.getController().getFieldMappings().values()) {
            fm.setMappingExpression("");
        }
        this.controlsManager.getTargetMessageTreeViewer().refresh(true);
    }
}

