/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.widgets;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.stardust.engine.core.struct.TypedXPath;
import org.eclipse.stardust.engine.extensions.transformation.model.mapping.FieldMapping;
import org.eclipse.stardust.engine.extensions.transformation.model.mapping.MappingFactory;
import org.eclipse.stardust.model.xpdl.carnot.AccessPointType;
import org.eclipse.stardust.model.xpdl.carnot.DirectionType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.modeling.core.spi.dataTypes.struct.StructAccessPointType;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.MessageTransformationController;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.widgets.MessagingAccessPathBrowserContentProvider;

public class MultipleAccessPathBrowserContentProvider
extends MessagingAccessPathBrowserContentProvider {
    Map fieldMappings;
    Map fieldPathsToAccessPoints;
    MessageTransformationController controller;
    Map accessPointCache = new HashMap();
    private MessagingAccessPathBrowserContentProvider apc;

    public MultipleAccessPathBrowserContentProvider(DirectionType direction, MessageTransformationController controller) {
        super(direction);
        this.controller = controller;
        this.fieldMappings = controller.getFieldMappings();
        this.fieldPathsToAccessPoints = controller.getFieldPathsToAccessPoints();
    }

    public Object[] getChildren(Object parentElement, boolean caching) {
        if (parentElement instanceof List) {
            List list = (List)parentElement;
            return list.toArray();
        }
        String rootElement = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)parentElement), (String)"RootElement");
        this.setApc((MessagingAccessPathBrowserContentProvider)((Object)this.accessPointCache.get(rootElement)));
        Object[] children = this.getApc().getChildren(parentElement, caching, true);
        int i = 0;
        while (i < children.length) {
            AccessPointType element = (AccessPointType)children[i];
            this.setupAP(parentElement, element, false);
            ++i;
        }
        return children;
    }

    public Object[] getChildrenWithoutSetup(Object parentElement, boolean caching) {
        if (parentElement instanceof List) {
            List list = (List)parentElement;
            return list.toArray();
        }
        String rootElement = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)parentElement), (String)"RootElement");
        this.setApc((MessagingAccessPathBrowserContentProvider)((Object)this.accessPointCache.get(rootElement)));
        Object[] children = this.getApc().getChildren(parentElement, caching, true);
        return children;
    }

    @Override
    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof List) {
            List list = (List)inputElement;
            for (AccessPointType type : list) {
                this.setupAP(null, type, true);
            }
            return list.toArray();
        }
        StructAccessPointType type = (StructAccessPointType)inputElement;
        this.setupAP(null, (AccessPointType)type, false);
        Object[] elements = this.getApc().getElements(inputElement);
        int i = 0;
        while (i < elements.length) {
            StructAccessPointType element = (StructAccessPointType)elements[i];
            this.setupAP(inputElement, (AccessPointType)element, false);
            ++i;
        }
        return elements;
    }

    @Override
    public boolean hasChildren(Object element) {
        if (element instanceof List) {
            List list = (List)element;
            return list.isEmpty();
        }
        if (this.getApc(element) != null) {
            return this.getApc(element).hasChildren(element);
        }
        return false;
    }

    private MessagingAccessPathBrowserContentProvider getApc(Object element) {
        String rootTypeName = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)element), (String)"RootElement").toString();
        return (MessagingAccessPathBrowserContentProvider)((Object)this.accessPointCache.get(rootTypeName));
    }

    private void setupAP(Object parentElement, AccessPointType type, boolean isRootType) {
        String fullXPath = "";
        if (isRootType) {
            this.setApc((MessagingAccessPathBrowserContentProvider)((Object)this.accessPointCache.get(type.getId())));
        }
        String rootTypeName = this.getApc().getRootTypeName();
        if (AttributeUtil.getAttribute((IExtensibleElement)type, (String)"RootElement") == null) {
            AttributeUtil.setAttribute((IExtensibleElement)type, (String)"RootElement", (String)rootTypeName);
        }
        String realXPath = null;
        if (type instanceof StructAccessPointType) {
            StructAccessPointType sapt = (StructAccessPointType)type;
            TypedXPath xpath = sapt.getXPath();
            realXPath = xpath.toString();
            fullXPath = this.isSimpleContentComplexTypeRoot(xpath) ? rootTypeName : String.valueOf(rootTypeName) + "/" + realXPath;
        } else if (this.controller.isSerializable(type)) {
            realXPath = "";
            if (parentElement != null) {
                fullXPath = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)parentElement), (String)"FullXPath");
                fullXPath = String.valueOf(fullXPath) + "/" + type.getId();
            } else {
                fullXPath = type.getId();
            }
        } else {
            realXPath = "";
            fullXPath = String.valueOf(rootTypeName) + "/" + realXPath;
        }
        fullXPath = fullXPath.replaceAll("@", "");
        if (!this.controller.isSimpleMode() && AttributeUtil.getAttribute((IExtensibleElement)type, (String)"FullXPath") == null) {
            AttributeUtil.setAttribute((IExtensibleElement)type, (String)"FullXPath", (String)fullXPath);
        }
        FieldMapping fieldMapping = MappingFactory.eINSTANCE.createFieldMapping();
        fieldMapping.setFieldPath(fullXPath);
        fieldMapping.setMappingExpression("");
        fieldMapping.setAdvancedMapping(false);
        this.fieldPathsToAccessPoints.put(fullXPath, type);
        if (this.fieldMappings.get(fullXPath) == null) {
            this.fieldMappings.put(fullXPath, fieldMapping);
        }
    }

    private boolean isSimpleContentComplexTypeRoot(TypedXPath xpath) {
        return xpath.getParentXPath() == null && xpath.getType() == -1 && xpath.getChildXPath("@") != null;
    }

    @Override
    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput == null) {
            return;
        }
        List list = (List)newInput;
        for (AccessPointType ap : list) {
            this.setApc(new MessagingAccessPathBrowserContentProvider(DirectionType.INOUT_LITERAL, ap.getId()));
            this.accessPointCache.put(ap.getId(), this.getApc());
            this.getApc().inputChanged(viewer, oldInput, ap);
        }
    }

    @Override
    public void dispose() {
        try {
            super.dispose();
        }
        catch (Throwable throwable) {}
    }

    @Override
    public Object[] getChildren(Object parentElement) {
        return this.getChildren(parentElement, false);
    }

    void setApc(MessagingAccessPathBrowserContentProvider apc) {
        this.apc = apc;
    }

    MessagingAccessPathBrowserContentProvider getApc() {
        return this.apc;
    }

    public AccessPointType getChild(AccessPointType parent, String name) {
        Object[] children = this.getChildren(parent);
        int i = 0;
        while (i < children.length) {
            AccessPointType apt = (AccessPointType)children[i];
            if (apt.getName().equalsIgnoreCase(name)) {
                return apt;
            }
            ++i;
        }
        return null;
    }
}

