/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.transformation.messaging.modeling.application.validation;

import java.text.MessageFormat;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.AccessPointType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationType;
import org.eclipse.stardust.model.xpdl.carnot.DataTypeType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.xpdl2.ExternalPackage;
import org.eclipse.stardust.model.xpdl.xpdl2.ExternalPackages;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationType;
import org.eclipse.stardust.model.xpdl.xpdl2.XpdlPackage;
import org.eclipse.stardust.modeling.validation.IModelElementValidator;
import org.eclipse.stardust.modeling.validation.Issue;
import org.eclipse.stardust.modeling.validation.ValidationException;

public class MessageSerializationApplicationValidator
implements IModelElementValidator {
    public Issue[] validate(IModelElement element) throws ValidationException {
        String declaredTypeId;
        List issues = CollectionUtils.newList();
        String messageFormat = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)element), (String)"messageTransformation:MessageFormat");
        if (StringUtils.isEmpty((String)messageFormat)) {
            issues.add(new Issue(2, (EObject)element, MessageFormat.format("Message Format not set for ''{0}''.", ((ApplicationType)element).getId()), (Object)"messageTransformation:MessageFormat"));
        }
        if (StringUtils.isEmpty((String)(declaredTypeId = this.getDeclaredTypeId((ApplicationType)element)))) {
            issues.add(new Issue(2, (EObject)element, MessageFormat.format("No TypeDeclaration set for ''{0}''.", ((ApplicationType)element).getId()), (Object)"carnot:engine:dataType"));
        } else {
            TypeDeclarationType type;
            ModelType otherModel;
            QName qname;
            ExternalPackage pkg;
            ExternalPackages packages;
            ModelType model = ModelUtils.findContainingModel((EObject)element);
            int ix = declaredTypeId.indexOf(":{");
            if (ix > 0 && declaredTypeId.substring(0, ix).equals(XpdlPackage.eINSTANCE.getTypeDeclarationsType_TypeDeclaration().getName()) && (packages = model.getExternalPackages()) != null && (pkg = packages.getExternalPackage((qname = QName.valueOf(declaredTypeId.substring(ix + 1))).getNamespaceURI())) != null && (otherModel = ModelUtils.getExternalModel((ExternalPackage)pkg)) != null) {
                model = otherModel;
                declaredTypeId = qname.getLocalPart();
            }
            if ((type = model.getTypeDeclarations().getTypeDeclaration(declaredTypeId)) == null) {
                issues.add(new Issue(2, (EObject)element, MessageFormat.format("Invalid TypeDeclaration: ''{0}''.", declaredTypeId), (Object)"carnot:engine:dataType"));
            }
        }
        return issues.toArray(new Issue[issues.size()]);
    }

    private String getDeclaredTypeId(ApplicationType application) {
        DataTypeType structuredDataType = ModelUtils.getDataType((IModelElement)application, (String)"struct");
        int i = 0;
        while (i < application.getAccessPoint().size()) {
            AccessPointType accessPoint = (AccessPointType)application.getAccessPoint().get(i);
            if (accessPoint.getType().equals(structuredDataType)) {
                return AttributeUtil.getAttributeValue((IExtensibleElement)accessPoint, (String)"carnot:engine:dataType");
            }
            ++i;
        }
        return null;
    }
}

