/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.validation.util;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameRequestor;
import org.eclipse.stardust.modeling.validation.Validation_Messages;
import org.eclipse.stardust.modeling.validation.util.TypeFinderListener;
import org.eclipse.stardust.modeling.validation.util.TypeRequestor;

public class SearchJob
extends Job {
    private char[] packageName;
    private TypeRequestor requestor;

    public SearchJob(String packageName, String typeName, IJavaSearchScope scope, int pattern, TypeFinderListener listener) {
        super(Validation_Messages.LB_SearchingTypes);
        this.packageName = packageName == null ? null : packageName.toCharArray();
        this.requestor = new TypeRequestor(typeName, scope, pattern, listener);
        this.setUser(true);
    }

    protected IStatus run(IProgressMonitor parent) {
        try {
            try {
                this.requestor.getListener().startSearch();
                SearchEngine engine = new SearchEngine();
                engine.searchAllTypeNames(this.packageName, this.requestor.getTypeName(), this.requestor.getPattern(), 10, this.requestor.getScope(), (TypeNameRequestor)this.requestor, 3, null);
            }
            catch (JavaModelException javaModelException) {
                this.requestor.getListener().endSearch();
            }
        }
        finally {
            this.requestor.getListener().endSearch();
        }
        return Status.OK_STATUS;
    }

    public void stop() {
        this.requestor.stop();
        this.cancel();
    }
}

