/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DragDetectListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.GestureListener;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TouchListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEvent;
import org.eclipse.swt.internal.gtk.GdkEventButton;
import org.eclipse.swt.internal.gtk.GdkEventCrossing;
import org.eclipse.swt.internal.gtk.GdkEventExpose;
import org.eclipse.swt.internal.gtk.GdkEventFocus;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.GdkEventMotion;
import org.eclipse.swt.internal.gtk.GdkEventScroll;
import org.eclipse.swt.internal.gtk.GdkEventVisibility;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.GdkWindowAttr;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.GtkBorder;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk.XWindowChanges;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public abstract class Control
extends Widget
implements Drawable {
    int fixedHandle;
    int redrawWindow;
    int enableWindow;
    int provider;
    int drawCount;
    Composite parent;
    Cursor cursor;
    Menu menu;
    Image backgroundImage;
    Font font;
    Region region;
    String toolTipText;
    Object layoutData;
    Accessible accessible;
    Control labelRelation;

    Control() {
    }

    public Control(Composite parent, int style) {
        super(parent, style);
        this.parent = parent;
        this.createWidget(0);
    }

    Font defaultFont() {
        return this.display.getSystemFont();
    }

    void deregister() {
        int imHandle;
        super.deregister();
        if (this.fixedHandle != 0) {
            this.display.removeWidget(this.fixedHandle);
        }
        if ((imHandle = this.imHandle()) != 0) {
            this.display.removeWidget(imHandle);
        }
    }

    void drawBackground(Control control, int window, int region, int x, int y, int width, int height) {
        this.drawBackground(control, window, 0, region, x, y, width, height);
    }

    void drawBackground(Control control, int window, int cr, int region, int x, int y, int width, int height) {
        if (OS.USE_CAIRO) {
            int cairo;
            int n = cairo = cr != 0 ? cr : OS.gdk_cairo_create(window);
            if (cairo == 0) {
                this.error(2);
            }
            if (region != 0) {
                OS.gdk_cairo_region(cairo, region);
                Cairo.cairo_clip(cairo);
            }
            if (control.backgroundImage != null) {
                Point pt = this.display.map(this, control, 0, 0);
                Cairo.cairo_translate(cairo, -pt.x, -pt.y);
                x += pt.x;
                y += pt.y;
                int pattern = Cairo.cairo_pattern_create_for_surface(control.backgroundImage.surface);
                if (pattern == 0) {
                    this.error(2);
                }
                Cairo.cairo_pattern_set_extend(pattern, 1);
                if ((this.style & 0x8000000) != 0) {
                    double[] matrix = new double[]{-1.0, 0.0, 0.0, 1.0, 0.0, 0.0};
                    Cairo.cairo_pattern_set_matrix(pattern, matrix);
                }
                Cairo.cairo_set_source(cairo, pattern);
                Cairo.cairo_pattern_destroy(pattern);
            } else {
                GdkColor color = control.getBackgroundColor();
                Cairo.cairo_set_source_rgba(cairo, (float)(color.red & 0xFFFF) / 65535.0f, (float)(color.green & 0xFFFF) / 65535.0f, (float)(color.blue & 0xFFFF) / 65535.0f, 1.0);
            }
            Cairo.cairo_rectangle(cairo, x, y, width, height);
            Cairo.cairo_fill(cairo);
            if (cairo != cr) {
                Cairo.cairo_destroy(cairo);
            }
            return;
        }
        int gdkGC = OS.gdk_gc_new(window);
        if (region != 0) {
            OS.gdk_gc_set_clip_region(gdkGC, region);
        }
        if (control.backgroundImage != null) {
            Point pt = this.display.map(this, control, 0, 0);
            OS.gdk_gc_set_fill(gdkGC, 1);
            OS.gdk_gc_set_ts_origin(gdkGC, -pt.x, -pt.y);
            OS.gdk_gc_set_tile(gdkGC, control.backgroundImage.pixmap);
            OS.gdk_draw_rectangle(window, gdkGC, 1, x, y, width, height);
        } else {
            GdkColor color = control.getBackgroundColor();
            OS.gdk_gc_set_foreground(gdkGC, color);
            OS.gdk_draw_rectangle(window, gdkGC, 1, x, y, width, height);
        }
        OS.g_object_unref(gdkGC);
    }

    boolean drawGripper(GC gc, int x, int y, int width, int height, boolean vertical) {
        int orientation;
        int paintHandle = this.paintHandle();
        int window = this.gtk_widget_get_window(paintHandle);
        if (window == 0) {
            return false;
        }
        int n = orientation = vertical ? 0 : 1;
        if ((this.style & 0x8000000) != 0) {
            x = this.getClientWidth() - width - x;
        }
        if (OS.GTK3) {
            int context = OS.gtk_widget_get_style_context(paintHandle);
            OS.gtk_style_context_save(context);
            OS.gtk_style_context_add_class(context, OS.GTK_STYLE_CLASS_PANE_SEPARATOR);
            OS.gtk_style_context_set_state(context, 0);
            OS.gtk_render_handle(context, gc.handle, x, y, width, height);
            OS.gtk_style_context_restore(context);
        } else {
            OS.gtk_paint_handle(OS.gtk_widget_get_style(paintHandle), window, 0, 2, null, paintHandle, new byte[1], x, y, width, height, orientation);
        }
        return true;
    }

    void drawWidget(GC gc) {
    }

    void enableWidget(boolean enabled) {
        OS.gtk_widget_set_sensitive(this.handle, enabled);
    }

    int enterExitHandle() {
        return this.eventHandle();
    }

    int eventHandle() {
        return this.handle;
    }

    int eventWindow() {
        int eventHandle = this.eventHandle();
        OS.gtk_widget_realize(eventHandle);
        return this.gtk_widget_get_window(eventHandle);
    }

    void fixFocus(Control focusControl) {
        Shell shell = this.getShell();
        Control control = this;
        while (control != shell && (control = control.parent) != null) {
            if (!control.setFocus()) continue;
            return;
        }
        shell.setSavedFocus(focusControl);
        int focusHandle = shell.vboxHandle;
        this.gtk_widget_set_can_focus(focusHandle, true);
        OS.gtk_widget_grab_focus(focusHandle);
        if (this.isDisposed()) {
            return;
        }
        this.gtk_widget_set_can_focus(focusHandle, false);
    }

    void fixStyle() {
        if (this.fixedHandle != 0) {
            this.fixStyle(this.fixedHandle);
        }
    }

    void fixStyle(int handle) {
        int childStyle;
        if ((this.state & 0x2000) != 0) {
            return;
        }
        if ((this.state & 0x10000) == 0) {
            return;
        }
        if (!OS.GTK3 && (childStyle = this.parent.childStyle()) != 0) {
            GdkColor color = new GdkColor();
            OS.gtk_style_get_bg(childStyle, 0, color);
            this.setBackgroundColor(color);
        }
    }

    int focusHandle() {
        return this.handle;
    }

    int fontHandle() {
        return this.handle;
    }

    public int getOrientation() {
        this.checkWidget();
        return this.style & 0x6000000;
    }

    public int getTextDirection() {
        this.checkWidget();
        return this.style & 0x6000000;
    }

    boolean hasFocus() {
        return this == this.display.getFocusControl();
    }

    void hookEvents() {
        int focusHandle = this.focusHandle();
        int focusMask = 19456;
        OS.gtk_widget_add_events(focusHandle, focusMask);
        OS.g_signal_connect_closure_by_id(focusHandle, this.display.signalIds[38], 0, this.display.getClosure(38), false);
        OS.g_signal_connect_closure_by_id(focusHandle, this.display.signalIds[46], 0, this.display.getClosure(46), false);
        OS.g_signal_connect_closure_by_id(focusHandle, this.display.signalIds[27], 0, this.display.getClosure(27), false);
        OS.g_signal_connect_closure_by_id(focusHandle, this.display.signalIds[28], 0, this.display.getClosure(28), false);
        OS.g_signal_connect_closure_by_id(focusHandle, this.display.signalIds[20], 0, this.display.getClosure(20), false);
        OS.g_signal_connect_closure_by_id(focusHandle, this.display.signalIds[21], 0, this.display.getClosure(21), false);
        OS.g_signal_connect_closure_by_id(focusHandle, this.display.signalIds[22], 0, this.display.getClosure(22), false);
        int eventHandle = this.eventHandle();
        int eventMask = 10486532;
        OS.gtk_widget_add_events(eventHandle, eventMask);
        OS.g_signal_connect_closure_by_id(eventHandle, this.display.signalIds[2], 0, this.display.getClosure(2), false);
        OS.g_signal_connect_closure_by_id(eventHandle, this.display.signalIds[4], 0, this.display.getClosure(4), false);
        OS.g_signal_connect_closure_by_id(eventHandle, this.display.signalIds[33], 0, this.display.getClosure(33), false);
        OS.g_signal_connect_closure_by_id(eventHandle, this.display.signalIds[43], 0, this.display.getClosure(43), false);
        int enterExitHandle = this.enterExitHandle();
        int enterExitMask = 12288;
        OS.gtk_widget_add_events(enterExitHandle, enterExitMask);
        OS.g_signal_connect_closure_by_id(enterExitHandle, this.display.signalIds[14], 0, this.display.getClosure(14), false);
        OS.g_signal_connect_closure_by_id(enterExitHandle, this.display.signalIds[29], 0, this.display.getClosure(29), false);
        int blockHandle = this.fixedHandle != 0 ? this.fixedHandle : eventHandle;
        OS.g_signal_connect_closure_by_id(blockHandle, this.display.signalIds[2], 0, this.display.getClosure(3), true);
        OS.g_signal_connect_closure_by_id(blockHandle, this.display.signalIds[4], 0, this.display.getClosure(5), true);
        OS.g_signal_connect_closure_by_id(blockHandle, this.display.signalIds[33], 0, this.display.getClosure(34), true);
        OS.g_signal_connect_closure_by_id(eventHandle, this.display.signalIds[16], 0, this.display.getClosure(16), false);
        if (focusHandle != eventHandle) {
            OS.g_signal_connect_closure_by_id(focusHandle, this.display.signalIds[16], 0, this.display.getClosure(16), false);
        }
        int paintHandle = this.paintHandle();
        int paintMask = 131074;
        OS.gtk_widget_add_events(paintHandle, paintMask);
        OS.g_signal_connect_closure_by_id(paintHandle, this.display.signalIds[18], 0, this.display.getClosure(19), false);
        if (OS.GTK_VERSION < OS.VERSION(2, 17, 11)) {
            OS.g_signal_connect_closure_by_id(paintHandle, this.display.signalIds[58], 0, this.display.getClosure(58), false);
        }
        OS.g_signal_connect_closure_by_id(paintHandle, this.display.signalIds[18], 0, this.display.getClosure(18), true);
        OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[40], 0, this.display.getClosure(40), true);
        OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[56], 0, this.display.getClosure(56), false);
        int imHandle = this.imHandle();
        if (imHandle != 0) {
            OS.g_signal_connect_closure(imHandle, OS.commit, this.display.getClosure(9), false);
            OS.g_signal_connect_closure(imHandle, OS.preedit_changed, this.display.getClosure(39), false);
        }
        OS.g_signal_connect_closure_by_id(paintHandle, this.display.signalIds[48], 0, this.display.getClosure(48), false);
        int topHandle = this.topHandle();
        OS.g_signal_connect_closure_by_id(topHandle, this.display.signalIds[30], 0, this.display.getClosure(30), true);
    }

    boolean hooksPaint() {
        return this.hooks(9) || this.filters(9);
    }

    int hoverProc(int widget) {
        int[] x = new int[1];
        int[] y = new int[1];
        int[] mask = new int[1];
        this.gdk_window_get_device_position(0, x, y, mask);
        this.sendMouseEvent(32, 0, 0, x[0], y[0], false, mask[0]);
        return 0;
    }

    int topHandle() {
        if (this.fixedHandle != 0) {
            return this.fixedHandle;
        }
        return super.topHandle();
    }

    int paintHandle() {
        int topHandle = this.topHandle();
        int paintHandle = this.handle;
        while (paintHandle != topHandle) {
            if (this.gtk_widget_get_has_window(paintHandle)) break;
            paintHandle = OS.gtk_widget_get_parent(paintHandle);
        }
        return paintHandle;
    }

    int paintWindow() {
        int paintHandle = this.paintHandle();
        OS.gtk_widget_realize(paintHandle);
        return this.gtk_widget_get_window(paintHandle);
    }

    public boolean print(GC gc) {
        this.checkWidget();
        if (gc == null) {
            this.error(4);
        }
        if (gc.isDisposed()) {
            this.error(5);
        }
        int topHandle = this.topHandle();
        OS.gtk_widget_realize(topHandle);
        if (OS.GTK3) {
            OS.gtk_widget_draw(topHandle, gc.handle);
            return true;
        }
        int window = this.gtk_widget_get_window(topHandle);
        GCData data = gc.getGCData();
        OS.gdk_window_process_updates(window, true);
        int drawable = data.drawable;
        if (drawable == 0) {
            drawable = OS.gdk_get_default_root_window();
        }
        this.printWidget(gc, drawable, OS.gdk_drawable_get_depth(drawable), 0, 0);
        return true;
    }

    void printWidget(GC gc, int drawable, int depth, int x, int y) {
        boolean obscured = (this.state & 0x40) != 0;
        this.state &= 0xFFFFFFBF;
        int topHandle = this.topHandle();
        int window = this.gtk_widget_get_window(topHandle);
        this.printWindow(true, this, gc, drawable, depth, window, x, y);
        if (obscured) {
            this.state |= 0x40;
        }
    }

    void printWindow(boolean first, Control control, GC gc, int drawable, int depth, int window, int x, int y) {
        if (OS.gdk_drawable_get_depth(window) != depth) {
            return;
        }
        GdkRectangle rect = new GdkRectangle();
        int[] width = new int[1];
        int[] height = new int[1];
        this.gdk_window_get_size(window, width, height);
        rect.width = width[0];
        rect.height = height[0];
        OS.gdk_window_begin_paint_rect(window, rect);
        int[] real_drawable = new int[1];
        int[] x_offset = new int[1];
        int[] y_offset = new int[1];
        OS.gdk_window_get_internal_paint_info(window, real_drawable, x_offset, y_offset);
        int[] userData = new int[1];
        OS.gdk_window_get_user_data(window, userData);
        if (userData[0] != 0) {
            int eventPtr = OS.gdk_event_new(2);
            GdkEventExpose event = new GdkEventExpose();
            event.type = 2;
            event.window = OS.g_object_ref(window);
            event.area_width = rect.width;
            event.area_height = rect.height;
            event.region = OS.gdk_region_rectangle(rect);
            OS.memmove(eventPtr, event, GdkEventExpose.sizeof);
            OS.gtk_widget_send_expose(userData[0], eventPtr);
            OS.gdk_event_free(eventPtr);
        }
        int srcX = x_offset[0];
        int srcY = y_offset[0];
        int destX = x;
        int destY = y;
        int destWidth = width[0];
        int destHeight = height[0];
        if (!first) {
            int[] cX = new int[1];
            int[] cY = new int[1];
            OS.gdk_window_get_position(window, cX, cY);
            int parentWindow = OS.gdk_window_get_parent(window);
            int[] pW = new int[1];
            int[] pH = new int[1];
            this.gdk_window_get_size(parentWindow, pW, pH);
            srcX = x_offset[0] - cX[0];
            srcY = y_offset[0] - cY[0];
            destX = x - cX[0];
            destY = y - cY[0];
            destWidth = Math.min(cX[0] + width[0], pW[0]);
            destHeight = Math.min(cY[0] + height[0], pH[0]);
        }
        GCData gcData = gc.getGCData();
        int cairo = gcData.cairo;
        if (cairo != 0) {
            int xDisplay = OS.gdk_x11_display_get_xdisplay(OS.gdk_display_get_default());
            int xVisual = OS.gdk_x11_visual_get_xvisual(OS.gdk_visual_get_system());
            int xDrawable = OS.GDK_PIXMAP_XID(real_drawable[0]);
            int surface = Cairo.cairo_xlib_surface_create(xDisplay, xDrawable, xVisual, width[0], height[0]);
            if (surface == 0) {
                this.error(2);
            }
            Cairo.cairo_save(cairo);
            Cairo.cairo_rectangle(cairo, destX, destY, destWidth, destHeight);
            Cairo.cairo_clip(cairo);
            Cairo.cairo_translate(cairo, destX, destY);
            int pattern = Cairo.cairo_pattern_create_for_surface(surface);
            if (pattern == 0) {
                this.error(2);
            }
            Cairo.cairo_pattern_set_filter(pattern, 2);
            Cairo.cairo_set_source(cairo, pattern);
            if (gcData.alpha != 255) {
                Cairo.cairo_paint_with_alpha(cairo, (float)gcData.alpha / 255.0f);
            } else {
                Cairo.cairo_paint(cairo);
            }
            Cairo.cairo_restore(cairo);
            Cairo.cairo_pattern_destroy(pattern);
            Cairo.cairo_surface_destroy(surface);
        } else {
            OS.gdk_draw_drawable(drawable, gc.handle, real_drawable[0], srcX, srcY, destX, destY, destWidth, destHeight);
        }
        OS.gdk_window_end_paint(window);
        int children = OS.gdk_window_get_children(window);
        if (children != 0) {
            int windows = children;
            while (windows != 0) {
                int child = OS.g_list_data(windows);
                if (OS.gdk_window_is_visible(child)) {
                    Widget widget;
                    int[] data = new int[1];
                    OS.gdk_window_get_user_data(child, data);
                    if (data[0] != 0 && ((widget = this.display.findWidget(data[0])) == null || widget == control)) {
                        int[] x_pos = new int[1];
                        int[] y_pos = new int[1];
                        OS.gdk_window_get_position(child, x_pos, y_pos);
                        this.printWindow(false, control, gc, drawable, depth, child, x + x_pos[0], y + y_pos[0]);
                    }
                }
                windows = OS.g_list_next(windows);
            }
            OS.g_list_free(children);
        }
    }

    public Point computeSize(int wHint, int hHint) {
        return this.computeSize(wHint, hHint, true);
    }

    Widget computeTabGroup() {
        if (this.isTabGroup()) {
            return this;
        }
        return this.parent.computeTabGroup();
    }

    Widget[] computeTabList() {
        if (this.isTabGroup() && this.getVisible() && this.getEnabled()) {
            return new Widget[]{this};
        }
        return new Widget[0];
    }

    Control computeTabRoot() {
        Control[] tabList = this.parent._getTabList();
        if (tabList != null) {
            int index = 0;
            while (index < tabList.length) {
                if (tabList[index] == this) break;
                ++index;
            }
            if (index == tabList.length && this.isTabGroup()) {
                return this;
            }
        }
        return this.parent.computeTabRoot();
    }

    void checkBuffered() {
        this.style |= 0x20000000;
    }

    void checkBackground() {
        Shell shell = this.getShell();
        if (this == shell) {
            return;
        }
        this.state &= 0xFFFF7FFF;
        Composite composite = this.parent;
        while (true) {
            int mode;
            if ((mode = composite.backgroundMode) != 0) {
                if (mode == 1) {
                    Control control = this;
                    do {
                        if ((control.state & 0x10000) != 0) continue;
                        return;
                    } while ((control = control.parent) != composite);
                }
                this.state |= 0x8000;
                return;
            }
            if (composite == shell) break;
            composite = composite.parent;
        }
    }

    void checkForeground() {
        if (OS.GTK3) {
            this.setForegroundColor(this.topHandle(), this.display.COLOR_WIDGET_FOREGROUND);
        }
    }

    void checkBorder() {
        if (this.getBorderWidth() == 0) {
            this.style &= 0xFFFFF7FF;
        }
    }

    void checkMirrored() {
        if ((this.style & 0x4000000) != 0) {
            this.style |= 0x8000000;
        }
    }

    int childStyle() {
        return this.parent.childStyle();
    }

    void createWidget(int index) {
        this.state |= 0x800000;
        this.checkOrientation(this.parent);
        super.createWidget(index);
        this.checkBackground();
        this.checkForeground();
        if ((this.state & 0x8000) != 0) {
            this.setParentBackground();
        }
        this.checkBuffered();
        this.showWidget();
        this.setInitialBounds();
        this.setZOrder(null, false, false);
        this.setRelations();
        this.checkMirrored();
        this.checkBorder();
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        if (wHint != -1 && wHint < 0) {
            wHint = 0;
        }
        if (hHint != -1 && hHint < 0) {
            hHint = 0;
        }
        return this.computeNativeSize(this.handle, wHint, hHint, changed);
    }

    Point computeNativeSize(int h, int wHint, int hHint, boolean changed) {
        int width = wHint;
        int height = hHint;
        if (OS.GTK3) {
            if (wHint == -1 && hHint == -1) {
                GtkRequisition requisition = new GtkRequisition();
                OS.gtk_widget_get_preferred_size(h, requisition, null);
                width = requisition.width;
                height = requisition.height;
            } else if (wHint == -1 || hHint == -1) {
                int[] minimum_size = new int[1];
                if (wHint == -1) {
                    OS.gtk_widget_get_preferred_width_for_height(h, height, minimum_size, null);
                    width = minimum_size[0];
                } else {
                    OS.gtk_widget_get_preferred_height_for_width(h, width, minimum_size, null);
                    height = minimum_size[0];
                }
            }
            return new Point(width, height);
        }
        if (wHint == -1 && hHint == -1) {
            GtkRequisition requisition = new GtkRequisition();
            this.gtk_widget_size_request(h, requisition);
            width = OS.GTK_WIDGET_REQUISITION_WIDTH(h);
            height = OS.GTK_WIDGET_REQUISITION_HEIGHT(h);
        } else if (wHint == -1 || hHint == -1) {
            int[] reqWidth = new int[1];
            int[] reqHeight = new int[1];
            OS.gtk_widget_get_size_request(h, reqWidth, reqHeight);
            OS.gtk_widget_set_size_request(h, wHint, hHint);
            GtkRequisition requisition = new GtkRequisition();
            this.gtk_widget_size_request(h, requisition);
            OS.gtk_widget_set_size_request(h, reqWidth[0], reqHeight[0]);
            width = wHint == -1 ? requisition.width : wHint;
            height = hHint == -1 ? requisition.height : hHint;
        }
        return new Point(width, height);
    }

    void forceResize() {
        int topHandle = this.topHandle();
        GtkRequisition requisition = new GtkRequisition();
        this.gtk_widget_size_request(topHandle, requisition);
        GtkAllocation allocation = new GtkAllocation();
        this.gtk_widget_get_allocation(topHandle, allocation);
        OS.gtk_widget_size_allocate(topHandle, allocation);
    }

    public Accessible getAccessible() {
        this.checkWidget();
        return this._getAccessible();
    }

    Accessible _getAccessible() {
        if (this.accessible == null) {
            this.accessible = Accessible.internal_new_Accessible(this);
        }
        return this.accessible;
    }

    public Rectangle getBounds() {
        int height;
        this.checkWidget();
        int topHandle = this.topHandle();
        GtkAllocation allocation = new GtkAllocation();
        this.gtk_widget_get_allocation(topHandle, allocation);
        int x = allocation.x;
        int y = allocation.y;
        int width = (this.state & 0x200) != 0 ? 0 : allocation.width;
        int n = height = (this.state & 0x400) != 0 ? 0 : allocation.height;
        if ((this.parent.style & 0x8000000) != 0) {
            x = this.parent.getClientWidth() - width - x;
        }
        return new Rectangle(x, y, width, height);
    }

    public void setBounds(Rectangle rect) {
        this.checkWidget();
        if (rect == null) {
            this.error(4);
        }
        this.setBounds(rect.x, rect.y, Math.max(0, rect.width), Math.max(0, rect.height), true, true);
    }

    public void setBounds(int x, int y, int width, int height) {
        this.checkWidget();
        this.setBounds(x, y, Math.max(0, width), Math.max(0, height), true, true);
    }

    void markLayout(boolean changed, boolean all) {
    }

    void modifyStyle(int handle, int style) {
        super.modifyStyle(handle, style);
        if (this.region != null) {
            OS.gdk_window_shape_combine_region(this.gtk_widget_get_window(this.topHandle()), this.region.handle, 0, 0);
        }
    }

    void moveHandle(int x, int y) {
        int topHandle = this.topHandle();
        int parentHandle = this.parent.parentingHandle();
        if (OS.GTK3) {
            OS.swt_fixed_move(parentHandle, topHandle, x, y);
        } else {
            boolean reset = this.gtk_widget_get_visible(parentHandle);
            this.gtk_widget_set_visible(parentHandle, false);
            OS.gtk_fixed_move(parentHandle, topHandle, x, y);
            this.gtk_widget_set_visible(parentHandle, reset);
        }
    }

    void resizeHandle(int width, int height) {
        int topHandle = this.topHandle();
        if (OS.GTK3) {
            OS.swt_fixed_resize(OS.gtk_widget_get_parent(topHandle), topHandle, width, height);
            if (topHandle != this.handle) {
                OS.swt_fixed_resize(OS.gtk_widget_get_parent(this.handle), this.handle, width, height);
            }
        } else {
            OS.gtk_widget_set_size_request(topHandle, width, height);
            if (topHandle != this.handle) {
                OS.gtk_widget_set_size_request(this.handle, width, height);
            }
        }
    }

    int setBounds(int x, int y, int width, int height, boolean move, boolean resize) {
        int oldX;
        int topHandle = this.topHandle();
        boolean sendMove = move;
        GtkAllocation allocation = new GtkAllocation();
        this.gtk_widget_get_allocation(topHandle, allocation);
        if ((this.parent.style & 0x8000000) != 0) {
            int clientWidth = this.parent.getClientWidth();
            int oldWidth = (this.state & 0x200) != 0 ? 0 : allocation.width;
            oldX = clientWidth - oldWidth - allocation.x;
            if (move) {
                sendMove &= x != oldX;
                x = clientWidth - (resize ? width : oldWidth) - x;
            } else {
                move = true;
                x = clientWidth - (resize ? width : oldWidth) - oldX;
                y = allocation.y;
            }
        }
        boolean sameOrigin = true;
        boolean sameExtent = true;
        if (move) {
            oldX = allocation.x;
            int oldY = allocation.y;
            boolean bl = sameOrigin = x == oldX && y == oldY;
            if (!sameOrigin) {
                if (this.enableWindow != 0) {
                    OS.gdk_window_move(this.enableWindow, x, y);
                }
                this.moveHandle(x, y);
            }
        }
        int clientWidth = 0;
        if (resize) {
            int oldWidth = (this.state & 0x200) != 0 ? 0 : allocation.width;
            int oldHeight = (this.state & 0x400) != 0 ? 0 : allocation.height;
            boolean bl = sameExtent = width == oldWidth && height == oldHeight;
            if (!sameExtent && (this.style & 0x8000000) != 0) {
                clientWidth = this.getClientWidth();
            }
            if (!(sameExtent || width == 0 && height == 0)) {
                int newWidth = Math.max(1, width);
                int newHeight = Math.max(1, height);
                if (this.redrawWindow != 0) {
                    OS.gdk_window_resize(this.redrawWindow, newWidth, newHeight);
                }
                if (this.enableWindow != 0) {
                    OS.gdk_window_resize(this.enableWindow, newWidth, newHeight);
                }
                this.resizeHandle(newWidth, newHeight);
            }
        }
        if (!sameOrigin || !sameExtent) {
            GtkRequisition requisition = new GtkRequisition();
            this.gtk_widget_size_request(topHandle, requisition);
            if (move) {
                allocation.x = x;
                allocation.y = y;
            }
            if (resize) {
                allocation.width = width;
                allocation.height = height;
            }
            if (OS.GTK_VERSION >= OS.VERSION(3, 8, 0) && !OS.gtk_widget_get_visible(this.handle)) {
                OS.gtk_widget_show(this.handle);
                OS.gtk_widget_size_allocate(topHandle, allocation);
                OS.gtk_widget_hide(this.handle);
            } else {
                OS.gtk_widget_size_allocate(topHandle, allocation);
            }
        }
        if (!sameExtent) {
            this.state = width == 0 ? this.state | 0x200 : this.state & 0xFFFFFDFF;
            int n = this.state = height == 0 ? this.state | 0x400 : this.state & 0xFFFFFBFF;
            if ((this.state & 0x600) != 0) {
                if (this.enableWindow != 0) {
                    OS.gdk_window_hide(this.enableWindow);
                }
                OS.gtk_widget_hide(topHandle);
            } else if ((this.state & 0x800) == 0) {
                if (this.enableWindow != 0) {
                    OS.gdk_window_show_unraised(this.enableWindow);
                }
                OS.gtk_widget_show(topHandle);
            }
            if ((this.style & 0x8000000) != 0) {
                this.moveChildren(clientWidth);
            }
        }
        int result = 0;
        if (move && !sameOrigin) {
            Control control = this.findBackgroundControl();
            if (control != null && control.backgroundImage != null && this.isVisible()) {
                this.redrawWidget(0, 0, 0, 0, true, true, true);
            }
            if (sendMove) {
                this.sendEvent(10);
            }
            result |= 0x80;
        }
        if (resize && !sameExtent) {
            this.sendEvent(11);
            result |= 0x100;
        }
        return result;
    }

    public Point getLocation() {
        this.checkWidget();
        int topHandle = this.topHandle();
        GtkAllocation allocation = new GtkAllocation();
        this.gtk_widget_get_allocation(topHandle, allocation);
        int x = allocation.x;
        int y = allocation.y;
        if ((this.parent.style & 0x8000000) != 0) {
            int width = (this.state & 0x200) != 0 ? 0 : allocation.width;
            x = this.parent.getClientWidth() - width - x;
        }
        return new Point(x, y);
    }

    public void setLocation(Point location) {
        this.checkWidget();
        if (location == null) {
            this.error(4);
        }
        this.setBounds(location.x, location.y, 0, 0, true, false);
    }

    public void setLocation(int x, int y) {
        this.checkWidget();
        this.setBounds(x, y, 0, 0, true, false);
    }

    public Point getSize() {
        this.checkWidget();
        int topHandle = this.topHandle();
        GtkAllocation allocation = new GtkAllocation();
        this.gtk_widget_get_allocation(topHandle, allocation);
        int width = (this.state & 0x200) != 0 ? 0 : allocation.width;
        int height = (this.state & 0x400) != 0 ? 0 : allocation.height;
        return new Point(width, height);
    }

    public void setSize(Point size) {
        this.checkWidget();
        if (size == null) {
            this.error(4);
        }
        this.setBounds(0, 0, Math.max(0, size.x), Math.max(0, size.y), false, true);
    }

    public void setRegion(Region region) {
        this.checkWidget();
        if (region != null && region.isDisposed()) {
            this.error(5);
        }
        int window = this.gtk_widget_get_window(this.topHandle());
        int shape_region = region == null ? 0 : region.handle;
        OS.gdk_window_shape_combine_region(window, shape_region, 0, 0);
        this.region = region;
    }

    void setRelations() {
        Widget widget;
        int handle;
        int parentHandle = this.parent.parentingHandle();
        int list = OS.gtk_container_get_children(parentHandle);
        if (list == 0) {
            return;
        }
        int count = OS.g_list_length(list);
        if (count > 1 && (handle = OS.g_list_nth_data(list, count - 2)) != 0 && (widget = this.display.getWidget(handle)) != null && widget != this && widget instanceof Control) {
            Control sibling = (Control)widget;
            sibling.addRelation(this);
        }
        OS.g_list_free(list);
    }

    public void setSize(int width, int height) {
        this.checkWidget();
        this.setBounds(0, 0, Math.max(0, width), Math.max(0, height), false, true);
    }

    boolean isActive() {
        return this.getShell().getModalShell() == null && this.display.getModalDialog() == null;
    }

    boolean isDescribedByLabel() {
        return true;
    }

    boolean isFocusHandle(int widget) {
        return widget == this.focusHandle();
    }

    public void moveAbove(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (this.parent != control.parent) {
                return;
            }
            if (this == control) {
                return;
            }
        }
        this.setZOrder(control, true, true);
    }

    public void moveBelow(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (this.parent != control.parent) {
                return;
            }
            if (this == control) {
                return;
            }
        }
        this.setZOrder(control, false, true);
    }

    void moveChildren(int oldWidth) {
    }

    public void pack() {
        this.pack(true);
    }

    public void pack(boolean changed) {
        this.setSize(this.computeSize(-1, -1, changed));
    }

    public void setLayoutData(Object layoutData) {
        this.checkWidget();
        this.layoutData = layoutData;
    }

    public Point toControl(int x, int y) {
        this.checkWidget();
        int window = this.eventWindow();
        int[] origin_x = new int[1];
        int[] origin_y = new int[1];
        OS.gdk_window_get_origin(window, origin_x, origin_y);
        x -= origin_x[0];
        y -= origin_y[0];
        if ((this.style & 0x8000000) != 0) {
            x = this.getClientWidth() - x;
        }
        return new Point(x, y);
    }

    public Point toControl(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        return this.toControl(point.x, point.y);
    }

    public Point toDisplay(int x, int y) {
        this.checkWidget();
        int window = this.eventWindow();
        int[] origin_x = new int[1];
        int[] origin_y = new int[1];
        OS.gdk_window_get_origin(window, origin_x, origin_y);
        if ((this.style & 0x8000000) != 0) {
            x = this.getClientWidth() - x;
        }
        return new Point(x += origin_x[0], y += origin_y[0]);
    }

    public Point toDisplay(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        return this.toDisplay(point.x, point.y);
    }

    public void addControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    public void addDragDetectListener(DragDetectListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(29, typedListener);
    }

    public void addFocusListener(FocusListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(15, typedListener);
        this.addListener(16, typedListener);
    }

    public void addGestureListener(GestureListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(48, typedListener);
    }

    public void addHelpListener(HelpListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(28, typedListener);
    }

    public void addKeyListener(KeyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(2, typedListener);
        this.addListener(1, typedListener);
    }

    public void addMenuDetectListener(MenuDetectListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(35, typedListener);
    }

    public void addMouseListener(MouseListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(3, typedListener);
        this.addListener(4, typedListener);
        this.addListener(8, typedListener);
    }

    public void addMouseMoveListener(MouseMoveListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(5, typedListener);
    }

    public void addMouseTrackListener(MouseTrackListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(6, typedListener);
        this.addListener(7, typedListener);
        this.addListener(32, typedListener);
    }

    public void addMouseWheelListener(MouseWheelListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(37, typedListener);
    }

    public void addPaintListener(PaintListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(9, typedListener);
    }

    void addRelation(Control control) {
    }

    public void addTouchListener(TouchListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(47, typedListener);
    }

    public void addTraverseListener(TraverseListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(31, typedListener);
    }

    public void removeControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(10, listener);
        this.eventTable.unhook(11, listener);
    }

    public void removeDragDetectListener(DragDetectListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(29, listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(15, listener);
        this.eventTable.unhook(16, listener);
    }

    public void removeGestureListener(GestureListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(48, listener);
    }

    public void removeHelpListener(HelpListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(28, listener);
    }

    public void removeKeyListener(KeyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(2, listener);
        this.eventTable.unhook(1, listener);
    }

    public void removeMenuDetectListener(MenuDetectListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(35, listener);
    }

    public void removeMouseListener(MouseListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(3, listener);
        this.eventTable.unhook(4, listener);
        this.eventTable.unhook(8, listener);
    }

    public void removeMouseMoveListener(MouseMoveListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(5, listener);
    }

    public void removeMouseTrackListener(MouseTrackListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(6, listener);
        this.eventTable.unhook(7, listener);
        this.eventTable.unhook(32, listener);
    }

    public void removeMouseWheelListener(MouseWheelListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(37, listener);
    }

    public void removePaintListener(PaintListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(9, listener);
    }

    void removeRelation() {
        if (!this.isDescribedByLabel()) {
            return;
        }
        if (this.labelRelation != null) {
            this._getAccessible().removeRelation(9, this.labelRelation._getAccessible());
            this.labelRelation = null;
        }
    }

    public void removeTouchListener(TouchListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(47, listener);
    }

    public void removeTraverseListener(TraverseListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(31, listener);
    }

    public boolean dragDetect(Event event) {
        this.checkWidget();
        if (event == null) {
            this.error(4);
        }
        return this.dragDetect(event.button, event.count, event.stateMask, event.x, event.y);
    }

    public boolean dragDetect(MouseEvent event) {
        this.checkWidget();
        if (event == null) {
            this.error(4);
        }
        return this.dragDetect(event.button, event.count, event.stateMask, event.x, event.y);
    }

    boolean dragDetect(int button, int count, int stateMask, int x, int y) {
        if (button != 1 || count != 1) {
            return false;
        }
        if (!this.dragDetect(x, y, false, true, null)) {
            return false;
        }
        return this.sendDragEvent(button, stateMask, x, y, true);
    }

    boolean dragDetect(int x, int y, boolean filter, boolean dragOnTimeout, boolean[] consume) {
        boolean quit = false;
        boolean dragging = false;
        while (!quit) {
            int eventPtr = 0;
            long timeout = System.currentTimeMillis() + 500L;
            while (System.currentTimeMillis() < timeout) {
                eventPtr = OS.gdk_event_get();
                if (eventPtr != 0) break;
                try {
                    Thread.sleep(50L);
                }
                catch (Exception exception) {}
            }
            if (eventPtr == 0) {
                return dragOnTimeout;
            }
            switch (OS.GDK_EVENT_TYPE(eventPtr)) {
                case 3: {
                    GdkEventMotion gdkMotionEvent = new GdkEventMotion();
                    OS.memmove(gdkMotionEvent, eventPtr, GdkEventMotion.sizeof);
                    if ((gdkMotionEvent.state & 0x100) != 0) {
                        if (OS.gtk_drag_check_threshold(this.handle, x, y, (int)gdkMotionEvent.x, (int)gdkMotionEvent.y)) {
                            dragging = true;
                            quit = true;
                        }
                    } else {
                        quit = true;
                    }
                    int[] newX = new int[1];
                    int[] newY = new int[1];
                    this.gdk_window_get_device_position(gdkMotionEvent.window, newX, newY, null);
                    break;
                }
                case 8: 
                case 9: {
                    GdkEventKey gdkEvent = new GdkEventKey();
                    OS.memmove(gdkEvent, eventPtr, GdkEventKey.sizeof);
                    if (gdkEvent.keyval != 65307) break;
                    quit = true;
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    OS.gdk_event_put(eventPtr);
                    quit = true;
                    break;
                }
                default: {
                    OS.gtk_main_do_event(eventPtr);
                }
            }
            OS.gdk_event_free(eventPtr);
        }
        return dragging;
    }

    boolean filterKey(int keyval, int event) {
        int imHandle = this.imHandle();
        if (imHandle != 0) {
            return OS.gtk_im_context_filter_keypress(imHandle, event);
        }
        return false;
    }

    Control findBackgroundControl() {
        if ((this.state & 0x2000) != 0 || this.backgroundImage != null) {
            return this;
        }
        return (this.state & 0x8000) != 0 ? this.parent.findBackgroundControl() : null;
    }

    Menu[] findMenus(Control control) {
        if (this.menu != null && this != control) {
            return new Menu[]{this.menu};
        }
        return new Menu[0];
    }

    void fixChildren(Shell newShell, Shell oldShell, Decorations newDecorations, Decorations oldDecorations, Menu[] menus) {
        oldShell.fixShell(newShell, this);
        oldDecorations.fixDecorations(newDecorations, this, menus);
    }

    int fixedMapProc(int widget) {
        this.gtk_widget_set_mapped(widget, true);
        int widgetList = OS.gtk_container_get_children(widget);
        if (widgetList != 0) {
            int widgets = widgetList;
            while (widgets != 0) {
                int child = OS.g_list_data(widgets);
                if (this.gtk_widget_get_visible(child) && OS.gtk_widget_get_child_visible(child) && !this.gtk_widget_get_mapped(child)) {
                    OS.gtk_widget_map(child);
                }
                widgets = OS.g_list_next(widgets);
            }
            OS.g_list_free(widgetList);
        }
        if (this.gtk_widget_get_has_window(widget)) {
            OS.gdk_window_show_unraised(this.gtk_widget_get_window(widget));
        }
        return 0;
    }

    void fixModal(int group, int modalGroup) {
    }

    public boolean forceFocus() {
        this.checkWidget();
        if (this.display.focusEvent == 16) {
            return false;
        }
        Shell shell = this.getShell();
        shell.setSavedFocus(this);
        if (!this.isEnabled() || !this.isVisible()) {
            return false;
        }
        shell.bringToTop(false);
        return this.forceFocus(this.focusHandle());
    }

    boolean forceFocus(int focusHandle) {
        if (this.gtk_widget_has_focus(focusHandle)) {
            return true;
        }
        OS.gtk_widget_realize(focusHandle);
        OS.gtk_widget_grab_focus(focusHandle);
        if (this.isDisposed()) {
            return false;
        }
        Shell shell = this.getShell();
        int shellHandle = shell.shellHandle;
        int handle = OS.gtk_window_get_focus(shellHandle);
        while (handle != 0) {
            if (handle == focusHandle) {
                this.display.ignoreFocus = false;
                return true;
            }
            Widget widget = this.display.getWidget(handle);
            if (widget != null && widget instanceof Control) {
                return widget == this;
            }
            handle = OS.gtk_widget_get_parent(handle);
        }
        return false;
    }

    public Color getBackground() {
        this.checkWidget();
        Control control = this.findBackgroundControl();
        if (control == null) {
            control = this;
        }
        return Color.gtk_new(this.display, control.getBackgroundColor());
    }

    GdkColor getBackgroundColor() {
        return this.getBgColor();
    }

    public Image getBackgroundImage() {
        this.checkWidget();
        Control control = this.findBackgroundControl();
        if (control == null) {
            control = this;
        }
        return control.backgroundImage;
    }

    GdkColor getContextBackground() {
        int fontHandle = this.fontHandle();
        int context = OS.gtk_widget_get_style_context(fontHandle);
        GdkRGBA rgba = new GdkRGBA();
        OS.gtk_style_context_get_background_color(context, 0, rgba);
        if (rgba.alpha == 0.0) {
            return this.display.COLOR_WIDGET_BACKGROUND;
        }
        GdkColor color = new GdkColor();
        color.red = (short)(rgba.red * 65535.0);
        color.green = (short)(rgba.green * 65535.0);
        color.blue = (short)(rgba.blue * 65535.0);
        return color;
    }

    GdkColor getContextColor() {
        int fontHandle = this.fontHandle();
        int context = OS.gtk_widget_get_style_context(fontHandle);
        GdkRGBA rgba = new GdkRGBA();
        OS.gtk_style_context_get_color(context, 0, rgba);
        GdkColor color = new GdkColor();
        color.red = (short)(rgba.red * 65535.0);
        color.green = (short)(rgba.green * 65535.0);
        color.blue = (short)(rgba.blue * 65535.0);
        return color;
    }

    GdkColor getBgColor() {
        if (OS.GTK3) {
            return this.getContextBackground();
        }
        int fontHandle = this.fontHandle();
        OS.gtk_widget_realize(fontHandle);
        GdkColor color = new GdkColor();
        OS.gtk_style_get_bg(OS.gtk_widget_get_style(fontHandle), 0, color);
        return color;
    }

    GdkColor getBaseColor() {
        if (OS.GTK3) {
            return this.getContextBackground();
        }
        int fontHandle = this.fontHandle();
        OS.gtk_widget_realize(fontHandle);
        GdkColor color = new GdkColor();
        OS.gtk_style_get_base(OS.gtk_widget_get_style(fontHandle), 0, color);
        return color;
    }

    public int getBorderWidth() {
        this.checkWidget();
        return 0;
    }

    int getClientWidth() {
        return 0;
    }

    public Cursor getCursor() {
        this.checkWidget();
        return this.cursor;
    }

    public boolean getDragDetect() {
        this.checkWidget();
        return (this.state & 0x800000) != 0;
    }

    public boolean getEnabled() {
        this.checkWidget();
        return (this.state & 0x10) == 0;
    }

    public Font getFont() {
        this.checkWidget();
        return this.font != null ? this.font : this.defaultFont();
    }

    int getFontDescription() {
        int fontHandle = this.fontHandle();
        if (OS.GTK3) {
            int context = OS.gtk_widget_get_style_context(fontHandle);
            return OS.gtk_style_context_get_font(context, 0);
        }
        OS.gtk_widget_realize(fontHandle);
        return OS.gtk_style_get_font_desc(OS.gtk_widget_get_style(fontHandle));
    }

    public Color getForeground() {
        this.checkWidget();
        return Color.gtk_new(this.display, this.getForegroundColor());
    }

    GdkColor getForegroundColor() {
        return this.getFgColor();
    }

    GdkColor getFgColor() {
        if (OS.GTK3) {
            return this.getContextColor();
        }
        int fontHandle = this.fontHandle();
        OS.gtk_widget_realize(fontHandle);
        GdkColor color = new GdkColor();
        OS.gtk_style_get_fg(OS.gtk_widget_get_style(fontHandle), 0, color);
        return color;
    }

    Point getIMCaretPos() {
        return new Point(0, 0);
    }

    GdkColor getTextColor() {
        if (OS.GTK3) {
            return this.getContextColor();
        }
        int fontHandle = this.fontHandle();
        OS.gtk_widget_realize(fontHandle);
        GdkColor color = new GdkColor();
        OS.gtk_style_get_text(OS.gtk_widget_get_style(fontHandle), 0, color);
        return color;
    }

    public Object getLayoutData() {
        this.checkWidget();
        return this.layoutData;
    }

    public Menu getMenu() {
        this.checkWidget();
        return this.menu;
    }

    public Monitor getMonitor() {
        this.checkWidget();
        Monitor monitor = null;
        int screen = OS.gdk_screen_get_default();
        if (screen != 0) {
            int monitorNumber = OS.gdk_screen_get_monitor_at_window(screen, this.paintWindow());
            GdkRectangle dest = new GdkRectangle();
            OS.gdk_screen_get_monitor_geometry(screen, monitorNumber, dest);
            monitor = new Monitor();
            monitor.handle = monitorNumber;
            monitor.x = dest.x;
            monitor.y = dest.y;
            monitor.width = dest.width;
            monitor.height = dest.height;
            Rectangle workArea = null;
            if (monitorNumber == 0) {
                workArea = this.display.getWorkArea();
            }
            if (workArea != null) {
                monitor.clientX = workArea.x;
                monitor.clientY = workArea.y;
                monitor.clientWidth = workArea.width;
                monitor.clientHeight = workArea.height;
            } else {
                monitor.clientX = monitor.x;
                monitor.clientY = monitor.y;
                monitor.clientWidth = monitor.width;
                monitor.clientHeight = monitor.height;
            }
        } else {
            monitor = this.display.getPrimaryMonitor();
        }
        return monitor;
    }

    public Composite getParent() {
        this.checkWidget();
        return this.parent;
    }

    Control[] getPath() {
        int count = 0;
        Shell shell = this.getShell();
        Control control = this;
        while (control != shell) {
            ++count;
            control = control.parent;
        }
        control = this;
        Control[] result = new Control[count];
        while (control != shell) {
            result[--count] = control;
            control = control.parent;
        }
        return result;
    }

    public Region getRegion() {
        this.checkWidget();
        return this.region;
    }

    public Shell getShell() {
        this.checkWidget();
        return this._getShell();
    }

    Shell _getShell() {
        return this.parent._getShell();
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public boolean getTouchEnabled() {
        this.checkWidget();
        return false;
    }

    public boolean getVisible() {
        this.checkWidget();
        return (this.state & 0x800) == 0;
    }

    Point getThickness(int widget) {
        if (OS.GTK3) {
            int xthickness = 0;
            int ythickness = 0;
            GtkBorder tmp = new GtkBorder();
            int context = OS.gtk_widget_get_style_context(widget);
            OS.gtk_style_context_save(context);
            OS.gtk_style_context_add_class(context, OS.GTK_STYLE_CLASS_FRAME);
            OS.gtk_style_context_get_padding(context, 0, tmp);
            xthickness += tmp.left;
            ythickness += tmp.top;
            OS.gtk_style_context_get_border(context, 0, tmp);
            OS.gtk_style_context_restore(context);
            return new Point(xthickness += tmp.left, ythickness += tmp.top);
        }
        int style = OS.gtk_widget_get_style(widget);
        return new Point(OS.gtk_style_get_xthickness(style), OS.gtk_style_get_ythickness(style));
    }

    int gtk_button_press_event(int widget, int event) {
        return this.gtk_button_press_event(widget, event, true);
    }

    int gtk_button_press_event(int widget, int event, boolean sendMouseDown) {
        GdkEventButton gdkEvent = new GdkEventButton();
        OS.memmove(gdkEvent, event, GdkEventButton.sizeof);
        if (gdkEvent.type == 6) {
            return 0;
        }
        Shell shell = this._getShell();
        if ((shell.style & 0x4000) != 0 && ((shell.style & 0x80000) == 0 || (this.style & 0x80000) == 0)) {
            shell.forceActive();
        }
        int result = 0;
        if (gdkEvent.type == 4) {
            this.display.clickCount = 1;
            int nextEvent = OS.gdk_event_peek();
            if (nextEvent != 0) {
                int eventType = OS.GDK_EVENT_TYPE(nextEvent);
                if (eventType == 5) {
                    this.display.clickCount = 2;
                }
                if (eventType == 6) {
                    this.display.clickCount = 3;
                }
                OS.gdk_event_free(nextEvent);
            }
            boolean dragging = false;
            if ((this.state & 0x800000) != 0 && this.hooks(29) && gdkEvent.button == 1) {
                boolean[] consume = new boolean[1];
                if (this.dragDetect((int)gdkEvent.x, (int)gdkEvent.y, true, true, consume)) {
                    dragging = true;
                    if (consume[0]) {
                        result = 1;
                    }
                }
                if (this.isDisposed()) {
                    return 1;
                }
            }
            if (sendMouseDown && !this.sendMouseEvent(3, gdkEvent.button, this.display.clickCount, 0, false, gdkEvent.time, gdkEvent.x_root, gdkEvent.y_root, false, gdkEvent.state)) {
                result = 1;
            }
            if (this.isDisposed()) {
                return 1;
            }
            if (dragging) {
                this.sendDragEvent(gdkEvent.button, gdkEvent.state, (int)gdkEvent.x, (int)gdkEvent.y, false);
                if (this.isDisposed()) {
                    return 1;
                }
            }
            if ((this.state & 0x20) != 0 && gdkEvent.button == 3 && this.showMenu((int)gdkEvent.x_root, (int)gdkEvent.y_root)) {
                result = 1;
            }
        } else {
            this.display.clickCount = 2;
            int n = result = this.sendMouseEvent(8, gdkEvent.button, this.display.clickCount, 0, false, gdkEvent.time, gdkEvent.x_root, gdkEvent.y_root, false, gdkEvent.state) ? 0 : 1;
            if (this.isDisposed()) {
                return 1;
            }
        }
        if (!shell.isDisposed()) {
            shell.setActiveControl(this, 3);
        }
        return result;
    }

    int gtk_button_release_event(int widget, int event) {
        GdkEventButton gdkEvent = new GdkEventButton();
        OS.memmove(gdkEvent, event, GdkEventButton.sizeof);
        return this.sendMouseEvent(4, gdkEvent.button, this.display.clickCount, 0, false, gdkEvent.time, gdkEvent.x_root, gdkEvent.y_root, false, gdkEvent.state) ? 0 : 1;
    }

    int gtk_commit(int imcontext, int text) {
        if (text == 0) {
            return 0;
        }
        int length = OS.strlen(text);
        if (length == 0) {
            return 0;
        }
        byte[] buffer = new byte[length];
        OS.memmove(buffer, text, length);
        char[] chars = Converter.mbcsToWcs(null, buffer);
        this.sendIMKeyEvent(1, null, chars);
        return 0;
    }

    int gtk_enter_notify_event(int widget, int event) {
        if (OS.GTK_VERSION >= OS.VERSION(2, 12, 0)) {
            byte[] buffer = null;
            if (this.toolTipText != null && this.toolTipText.length() != 0) {
                char[] chars = this.fixMnemonic(this.toolTipText, false);
                buffer = Converter.wcsToMbcs(null, chars, true);
            }
            int toolHandle = this.getShell().handle;
            OS.gtk_widget_set_tooltip_text(toolHandle, buffer);
        }
        if (this.display.currentControl == this) {
            return 0;
        }
        GdkEventCrossing gdkEvent = new GdkEventCrossing();
        OS.memmove(gdkEvent, event, GdkEventCrossing.sizeof);
        if (gdkEvent.subwindow != 0 && this.checkSubwindow()) {
            return 0;
        }
        if (gdkEvent.mode != 0 && gdkEvent.mode != 2) {
            return 0;
        }
        if ((gdkEvent.state & 0x700) != 0) {
            return 0;
        }
        if (this.display.currentControl != null && !this.display.currentControl.isDisposed()) {
            this.display.removeMouseHoverTimeout(this.display.currentControl.handle);
            this.display.currentControl.sendMouseEvent(7, 0, gdkEvent.time, gdkEvent.x_root, gdkEvent.y_root, false, gdkEvent.state);
        }
        if (!this.isDisposed()) {
            this.display.currentControl = this;
            return this.sendMouseEvent(6, 0, gdkEvent.time, gdkEvent.x_root, gdkEvent.y_root, false, gdkEvent.state) ? 0 : 1;
        }
        return 0;
    }

    boolean checkSubwindow() {
        return false;
    }

    int gtk_event_after(int widget, int gdkEvent) {
        GdkEvent event = new GdkEvent();
        OS.memmove(event, gdkEvent, GdkEvent.sizeof);
        switch (event.type) {
            case 4: {
                if (widget != this.eventHandle() || (this.state & 0x20) != 0) break;
                GdkEventButton gdkEventButton = new GdkEventButton();
                OS.memmove(gdkEventButton, gdkEvent, GdkEventButton.sizeof);
                if (gdkEventButton.button != 3) break;
                this.showMenu((int)gdkEventButton.x_root, (int)gdkEventButton.y_root);
                break;
            }
            case 12: {
                if (!this.isFocusHandle(widget)) break;
                GdkEventFocus gdkEventFocus = new GdkEventFocus();
                OS.memmove(gdkEventFocus, gdkEvent, GdkEventFocus.sizeof);
                Display display = this.display;
                if (gdkEventFocus.in != 0) {
                    if (display.ignoreFocus) {
                        display.ignoreFocus = false;
                        break;
                    }
                } else {
                    display.ignoreFocus = false;
                    int grabHandle = OS.gtk_grab_get_current();
                    if (grabHandle != 0 && OS.G_OBJECT_TYPE(grabHandle) == OS.GTK_TYPE_MENU()) {
                        display.ignoreFocus = true;
                        break;
                    }
                }
                this.sendFocusEvent(gdkEventFocus.in != 0 ? 15 : 16);
            }
        }
        return 0;
    }

    int gtk_draw(int widget, int cairo) {
        if ((this.state & 0x40) != 0) {
            return 0;
        }
        if (!this.hooksPaint()) {
            return 0;
        }
        GdkRectangle rect = new GdkRectangle();
        OS.gdk_cairo_get_clip_rectangle(cairo, rect);
        Event event = new Event();
        event.count = 1;
        event.x = rect.x;
        event.y = rect.y;
        event.width = rect.width;
        event.height = rect.height;
        if ((this.style & 0x8000000) != 0) {
            event.x = this.getClientWidth() - event.width - event.x;
        }
        GCData data = new GCData();
        if (OS.GTK_VERSION <= OS.VERSION(3, 9, 0)) {
            data.cairo = cairo;
        }
        GC gc = event.gc = GC.gtk_new(this, data);
        gc.setClipping(rect.x, rect.y, rect.width, rect.height);
        this.drawWidget(gc);
        this.sendEvent(9, event);
        gc.dispose();
        event.gc = null;
        return 0;
    }

    int gtk_expose_event(int widget, int eventPtr) {
        if ((this.state & 0x40) != 0) {
            return 0;
        }
        if (!this.hooksPaint()) {
            return 0;
        }
        GdkEventExpose gdkEvent = new GdkEventExpose();
        OS.memmove(gdkEvent, eventPtr, GdkEventExpose.sizeof);
        Event event = new Event();
        event.count = gdkEvent.count;
        event.x = gdkEvent.area_x;
        event.y = gdkEvent.area_y;
        event.width = gdkEvent.area_width;
        event.height = gdkEvent.area_height;
        if ((this.style & 0x8000000) != 0) {
            event.x = this.getClientWidth() - event.width - event.x;
        }
        GCData data = new GCData();
        data.damageRgn = gdkEvent.region;
        GC gc = event.gc = GC.gtk_new(this, data);
        this.drawWidget(gc);
        this.sendEvent(9, event);
        gc.dispose();
        event.gc = null;
        return 0;
    }

    int gtk_focus(int widget, int directionType) {
        return 1;
    }

    int gtk_focus_in_event(int widget, int event) {
        if (this.handle != 0) {
            int imHandle;
            int oldIMHandle;
            Control oldControl = this.display.imControl;
            if (oldControl != this && oldControl != null && !oldControl.isDisposed() && (oldIMHandle = oldControl.imHandle()) != 0) {
                OS.gtk_im_context_reset(oldIMHandle);
            }
            if ((this.hooks(1) || this.hooks(2)) && (imHandle = this.imHandle()) != 0) {
                OS.gtk_im_context_focus_in(imHandle);
            }
        }
        return 0;
    }

    int gtk_focus_out_event(int widget, int event) {
        int imHandle;
        if (this.handle != 0 && (this.hooks(1) || this.hooks(2)) && (imHandle = this.imHandle()) != 0) {
            OS.gtk_im_context_focus_out(imHandle);
        }
        return 0;
    }

    int gtk_key_press_event(int widget, int event) {
        if (!this.hasFocus()) {
            if (this.display.getActiveShell() == null) {
                GdkEventKey gdkEvent = new GdkEventKey();
                OS.memmove(gdkEvent, event, GdkEventKey.sizeof);
                if (this.filterKey(gdkEvent.keyval, event)) {
                    return 1;
                }
            }
            return 0;
        }
        GdkEventKey gdkEvent = new GdkEventKey();
        OS.memmove(gdkEvent, event, GdkEventKey.sizeof);
        if (this.translateMnemonic(gdkEvent.keyval, gdkEvent)) {
            return 1;
        }
        if (this.isDisposed()) {
            return 0;
        }
        if (this.filterKey(gdkEvent.keyval, event)) {
            return 1;
        }
        if (this.isDisposed()) {
            return 0;
        }
        if (this.translateTraversal(gdkEvent)) {
            return 1;
        }
        if (this.isDisposed()) {
            return 0;
        }
        return super.gtk_key_press_event(widget, event);
    }

    int gtk_key_release_event(int widget, int event) {
        if (!this.hasFocus()) {
            return 0;
        }
        int imHandle = this.imHandle();
        if (imHandle != 0 && OS.gtk_im_context_filter_keypress(imHandle, event)) {
            return 1;
        }
        return super.gtk_key_release_event(widget, event);
    }

    int gtk_leave_notify_event(int widget, int event) {
        if (this.display.currentControl != this) {
            return 0;
        }
        this.display.removeMouseHoverTimeout(this.handle);
        int result = 0;
        if (this.sendLeaveNotify() || this.display.getCursorControl() == null) {
            GdkEventCrossing gdkEvent = new GdkEventCrossing();
            OS.memmove(gdkEvent, event, GdkEventCrossing.sizeof);
            if (gdkEvent.mode != 0 && gdkEvent.mode != 2) {
                return 0;
            }
            if ((gdkEvent.state & 0x700) != 0) {
                return 0;
            }
            result = this.sendMouseEvent(7, 0, gdkEvent.time, gdkEvent.x_root, gdkEvent.y_root, false, gdkEvent.state) ? 0 : 1;
            this.display.currentControl = null;
        }
        return result;
    }

    int gtk_mnemonic_activate(int widget, int arg1) {
        int result = 0;
        int eventPtr = OS.gtk_get_current_event();
        if (eventPtr != 0) {
            GdkEventKey keyEvent = new GdkEventKey();
            OS.memmove(keyEvent, eventPtr, GdkEventKey.sizeof);
            if (keyEvent.type == 8) {
                int focusHandle;
                Control focusControl = this.display.getFocusControl();
                int n = focusHandle = focusControl != null ? focusControl.focusHandle() : 0;
                if (focusHandle != 0) {
                    this.display.mnemonicControl = this;
                    OS.gtk_widget_event(focusHandle, eventPtr);
                    this.display.mnemonicControl = null;
                }
                result = 1;
            }
            OS.gdk_event_free(eventPtr);
        }
        return result;
    }

    int gtk_motion_notify_event(int widget, int event) {
        GdkEventMotion gdkEvent = new GdkEventMotion();
        OS.memmove(gdkEvent, event, GdkEventMotion.sizeof);
        if (this == this.display.currentControl && (this.hooks(32) || this.filters(32))) {
            this.display.addMouseHoverTimeout(this.handle);
        }
        double x = gdkEvent.x_root;
        double y = gdkEvent.y_root;
        int state = gdkEvent.state;
        if (gdkEvent.is_hint != 0) {
            int[] pointer_x = new int[1];
            int[] pointer_y = new int[1];
            int[] mask = new int[1];
            int window = this.eventWindow();
            this.gdk_window_get_device_position(window, pointer_x, pointer_y, mask);
            x = pointer_x[0];
            y = pointer_y[0];
            state = mask[0];
        }
        if (OS.GTK3 && this != this.display.currentControl) {
            if (this.display.currentControl != null && !this.display.currentControl.isDisposed()) {
                this.display.removeMouseHoverTimeout(this.display.currentControl.handle);
                this.display.currentControl.sendMouseEvent(7, 0, gdkEvent.time, x, y, false, state);
            }
            if (!this.isDisposed()) {
                this.display.currentControl = this;
                this.sendMouseEvent(6, 0, gdkEvent.time, x, y, false, state);
            }
        }
        int result = this.sendMouseEvent(5, 0, gdkEvent.time, x, y, gdkEvent.is_hint != 0, state) ? 0 : 1;
        return result;
    }

    int gtk_popup_menu(int widget) {
        if (!this.hasFocus()) {
            return 0;
        }
        int[] x = new int[1];
        int[] y = new int[1];
        this.gdk_window_get_device_position(0, x, y, null);
        return this.showMenu(x[0], y[0], 1) ? 1 : 0;
    }

    int gtk_preedit_changed(int imcontext) {
        this.display.showIMWindow(this);
        return 0;
    }

    int gtk_realize(int widget) {
        int imHandle = this.imHandle();
        if (imHandle != 0) {
            int window = this.gtk_widget_get_window(this.paintHandle());
            OS.gtk_im_context_set_client_window(imHandle, window);
        }
        if (this.backgroundImage != null) {
            this.setBackgroundPixmap(this.backgroundImage);
        }
        return 0;
    }

    int gtk_scroll_event(int widget, int eventPtr) {
        GdkEventScroll gdkEvent = new GdkEventScroll();
        OS.memmove(gdkEvent, eventPtr, GdkEventScroll.sizeof);
        switch (gdkEvent.direction) {
            case 0: {
                return this.sendMouseEvent(37, 0, 3, 1, true, gdkEvent.time, gdkEvent.x_root, gdkEvent.y_root, false, gdkEvent.state) ? 0 : 1;
            }
            case 1: {
                return this.sendMouseEvent(37, 0, -3, 1, true, gdkEvent.time, gdkEvent.x_root, gdkEvent.y_root, false, gdkEvent.state) ? 0 : 1;
            }
            case 2: {
                return this.sendMouseEvent(38, 0, 3, 0, true, gdkEvent.time, gdkEvent.x_root, gdkEvent.y_root, false, gdkEvent.state) ? 0 : 1;
            }
            case 3: {
                return this.sendMouseEvent(38, 0, -3, 0, true, gdkEvent.time, gdkEvent.x_root, gdkEvent.y_root, false, gdkEvent.state) ? 0 : 1;
            }
            case 4: {
                int result = 0;
                double[] delta_x = new double[1];
                double[] delta_y = new double[1];
                if (OS.gdk_event_get_scroll_deltas(eventPtr, delta_x, delta_y)) {
                    if (delta_x[0] != 0.0) {
                        int n = result = this.sendMouseEvent(38, 0, (int)(-3.0 * delta_x[0]), 0, true, gdkEvent.time, gdkEvent.x_root, gdkEvent.y_root, false, gdkEvent.state) ? 0 : 1;
                    }
                    if (delta_y[0] != 0.0) {
                        result = this.sendMouseEvent(37, 0, (int)(-3.0 * delta_y[0]), 1, true, gdkEvent.time, gdkEvent.x_root, gdkEvent.y_root, false, gdkEvent.state) ? 0 : 1;
                    }
                }
                return result;
            }
        }
        return 0;
    }

    int gtk_show_help(int widget, int helpType) {
        if (!this.hasFocus()) {
            return 0;
        }
        return this.sendHelpEvent(helpType) ? 1 : 0;
    }

    int gtk_style_set(int widget, int previousStyle) {
        if (this.backgroundImage != null) {
            this.setBackgroundPixmap(this.backgroundImage);
        }
        return 0;
    }

    int gtk_unrealize(int widget) {
        int imHandle = this.imHandle();
        if (imHandle != 0) {
            OS.gtk_im_context_set_client_window(imHandle, 0);
        }
        return 0;
    }

    int gtk_visibility_notify_event(int widget, int event) {
        if (OS.GTK_VERSION >= OS.VERSION(2, 17, 11)) {
            return 0;
        }
        GdkEventVisibility gdkEvent = new GdkEventVisibility();
        OS.memmove(gdkEvent, event, GdkEventVisibility.sizeof);
        int paintWindow = this.paintWindow();
        int window = gdkEvent.window;
        if (window == paintWindow) {
            if (gdkEvent.state == 2) {
                this.state |= 0x40;
            } else {
                if ((this.state & 0x40) != 0) {
                    int[] width = new int[1];
                    int[] height = new int[1];
                    this.gdk_window_get_size(window, width, height);
                    GdkRectangle rect = new GdkRectangle();
                    rect.width = width[0];
                    rect.height = height[0];
                    OS.gdk_window_invalidate_rect(window, rect, false);
                }
                this.state &= 0xFFFFFFBF;
            }
        }
        return 0;
    }

    void gtk_widget_set_has_window(int fixedHandle, boolean value) {
        if (OS.GTK_VERSION >= OS.VERSION(2, 18, 0)) {
            OS.gtk_widget_set_has_window(fixedHandle, value);
        } else {
            OS.gtk_fixed_set_has_window(fixedHandle, value);
        }
    }

    void gtk_widget_size_request(int widget, GtkRequisition requisition) {
        this.gtk_widget_get_preferred_size(widget, requisition);
    }

    public int internal_new_GC(GCData data) {
        int gc;
        this.checkWidget();
        int window = this.paintWindow();
        if (window == 0) {
            this.error(2);
        }
        if ((gc = data.cairo) != 0) {
            Cairo.cairo_reference(gc);
        } else {
            gc = OS.USE_CAIRO ? OS.gdk_cairo_create(window) : OS.gdk_gc_new(window);
        }
        if (gc == 0) {
            this.error(2);
        }
        if (data != null) {
            int mask = 0x6000000;
            if ((data.style & mask) == 0) {
                data.style |= this.style & (mask | 0x8000000);
            } else if ((data.style & 0x4000000) != 0) {
                data.style |= 0x8000000;
            }
            data.drawable = window;
            data.device = this.display;
            data.foreground = this.getForegroundColor();
            Control control = this.findBackgroundControl();
            if (control == null) {
                control = this;
            }
            data.background = control.getBackgroundColor();
            data.font = this.font != null ? this.font : this.defaultFont();
        }
        return gc;
    }

    int imHandle() {
        return 0;
    }

    public void internal_dispose_GC(int hDC, GCData data) {
        this.checkWidget();
        int gc = hDC;
        if (OS.USE_CAIRO) {
            Cairo.cairo_destroy(gc);
        } else {
            OS.g_object_unref(gc);
        }
    }

    public boolean isReparentable() {
        this.checkWidget();
        return true;
    }

    boolean isShowing() {
        if (!this.isVisible()) {
            return false;
        }
        Control control = this;
        while (control != null) {
            Point size = control.getSize();
            if (size.x == 0 || size.y == 0) {
                return false;
            }
            control = control.parent;
        }
        return true;
    }

    boolean isTabGroup() {
        int code;
        Control[] tabList = this.parent._getTabList();
        if (tabList != null) {
            int i = 0;
            while (i < tabList.length) {
                if (tabList[i] == this) {
                    return true;
                }
                ++i;
            }
        }
        if (((code = this.traversalCode(0, null)) & 0x60) != 0) {
            return false;
        }
        return (code & 0x18) != 0;
    }

    boolean isTabItem() {
        int code;
        Control[] tabList = this.parent._getTabList();
        if (tabList != null) {
            int i = 0;
            while (i < tabList.length) {
                if (tabList[i] == this) {
                    return false;
                }
                ++i;
            }
        }
        return ((code = this.traversalCode(0, null)) & 0x60) != 0;
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled() && this.parent.isEnabled();
    }

    boolean isFocusAncestor(Control control) {
        while (control != null && control != this && !(control instanceof Shell)) {
            control = control.parent;
        }
        return control == this;
    }

    public boolean isFocusControl() {
        this.checkWidget();
        Control focusControl = this.display.focusControl;
        if (focusControl != null && !focusControl.isDisposed()) {
            return this == focusControl;
        }
        return this.hasFocus();
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible() && this.parent.isVisible();
    }

    Decorations menuShell() {
        return this.parent.menuShell();
    }

    boolean mnemonicHit(char key) {
        return false;
    }

    boolean mnemonicMatch(char key) {
        return false;
    }

    void register() {
        int imHandle;
        super.register();
        if (this.fixedHandle != 0) {
            this.display.addWidget(this.fixedHandle, this);
        }
        if ((imHandle = this.imHandle()) != 0) {
            this.display.addWidget(imHandle, this);
        }
    }

    public void redraw() {
        this.checkWidget();
        this.redraw(false);
    }

    void redraw(boolean all) {
        if (!this.gtk_widget_get_visible(this.topHandle())) {
            return;
        }
        this.redrawWidget(0, 0, 0, 0, true, all, false);
    }

    public void redraw(int x, int y, int width, int height, boolean all) {
        this.checkWidget();
        if (!this.gtk_widget_get_visible(this.topHandle())) {
            return;
        }
        if ((this.style & 0x8000000) != 0) {
            x = this.getClientWidth() - width - x;
        }
        this.redrawWidget(x, y, width, height, false, all, false);
    }

    void redrawChildren() {
    }

    void redrawWidget(int x, int y, int width, int height, boolean redrawAll, boolean all, boolean trim) {
        if (!this.gtk_widget_get_realized(this.handle)) {
            return;
        }
        int window = this.paintWindow();
        GdkRectangle rect = new GdkRectangle();
        if (redrawAll) {
            int[] w = new int[1];
            int[] h = new int[1];
            this.gdk_window_get_size(window, w, h);
            rect.width = w[0];
            rect.height = h[0];
        } else {
            rect.x = x;
            rect.y = y;
            rect.width = width;
            rect.height = height;
        }
        OS.gdk_window_invalidate_rect(window, rect, all);
    }

    void release(boolean destroy) {
        Control next = null;
        Control previous = null;
        if (destroy && this.parent != null) {
            Control[] children = this.parent._getChildren();
            int index = 0;
            while (index < children.length) {
                if (children[index] == this) break;
                ++index;
            }
            if (index > 0) {
                previous = children[index - 1];
            }
            if (index + 1 < children.length) {
                next = children[index + 1];
                next.removeRelation();
            }
            this.removeRelation();
        }
        super.release(destroy);
        if (destroy && previous != null && next != null) {
            previous.addRelation(next);
        }
    }

    void releaseHandle() {
        super.releaseHandle();
        this.fixedHandle = 0;
        this.parent = null;
    }

    void releaseParent() {
        this.parent.removeControl(this);
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.display.currentControl == this) {
            this.display.currentControl = null;
        }
        this.display.removeMouseHoverTimeout(this.handle);
        int imHandle = this.imHandle();
        if (imHandle != 0) {
            OS.gtk_im_context_reset(imHandle);
            OS.gtk_im_context_set_client_window(imHandle, 0);
        }
        if (this.enableWindow != 0) {
            OS.gdk_window_set_user_data(this.enableWindow, 0);
            OS.gdk_window_destroy(this.enableWindow);
            this.enableWindow = 0;
        }
        this.redrawWindow = 0;
        if (this.menu != null && !this.menu.isDisposed()) {
            this.menu.dispose();
        }
        this.menu = null;
        this.cursor = null;
        this.toolTipText = null;
        this.layoutData = null;
        if (this.accessible != null) {
            this.accessible.internal_dispose_Accessible();
        }
        this.accessible = null;
        this.region = null;
    }

    void restackWindow(int window, int sibling, boolean above) {
        if (OS.GTK_VERSION >= OS.VERSION(2, 17, 11)) {
            OS.gdk_window_restack(window, sibling, above);
        } else {
            int xDisplay = OS.gdk_x11_drawable_get_xdisplay(window);
            int xWindow = OS.gdk_x11_drawable_get_xid(window);
            int xScreen = OS.XDefaultScreen(xDisplay);
            int flags = 96;
            XWindowChanges changes = new XWindowChanges();
            changes.sibling = OS.gdk_x11_drawable_get_xid(sibling);
            changes.stack_mode = above ? 0 : 1;
            OS.XReconfigureWMWindow(xDisplay, xWindow, xScreen, flags, changes);
        }
    }

    boolean sendDragEvent(int button, int stateMask, int x, int y, boolean isStateMask) {
        Event event = new Event();
        event.button = button;
        event.x = x;
        event.y = y;
        if ((this.style & 0x8000000) != 0) {
            event.x = this.getClientWidth() - event.x;
        }
        if (isStateMask) {
            event.stateMask = stateMask;
        } else {
            this.setInputState(event, stateMask);
        }
        this.postEvent(29, event);
        if (this.isDisposed()) {
            return false;
        }
        return event.doit;
    }

    void sendFocusEvent(int type) {
        Shell shell = this._getShell();
        Display display = this.display;
        display.focusControl = this;
        display.focusEvent = type;
        this.sendEvent(type);
        display.focusControl = null;
        display.focusEvent = 0;
        if (!shell.isDisposed()) {
            switch (type) {
                case 15: {
                    shell.setActiveControl(this);
                    break;
                }
                case 16: {
                    if (shell == display.activeShell) break;
                    shell.setActiveControl(null);
                }
            }
        }
    }

    boolean sendHelpEvent(int helpType) {
        Control control = this;
        while (control != null) {
            if (control.hooks(28)) {
                control.postEvent(28);
                return true;
            }
            control = control.parent;
        }
        return false;
    }

    boolean sendLeaveNotify() {
        return false;
    }

    boolean sendMouseEvent(int type, int button, int time, double x, double y, boolean is_hint, int state) {
        return this.sendMouseEvent(type, button, 0, 0, false, time, x, y, is_hint, state);
    }

    boolean sendMouseEvent(int type, int button, int count, int detail, boolean send, int time, double x, double y, boolean is_hint, int state) {
        if (!this.hooks(type) && !this.filters(type)) {
            return true;
        }
        Event event = new Event();
        event.time = time;
        event.button = button;
        event.detail = detail;
        event.count = count;
        if (is_hint) {
            event.x = (int)x;
            event.y = (int)y;
        } else {
            int window = this.eventWindow();
            int[] origin_x = new int[1];
            int[] origin_y = new int[1];
            OS.gdk_window_get_origin(window, origin_x, origin_y);
            event.x = (int)x - origin_x[0];
            event.y = (int)y - origin_y[0];
        }
        if ((this.style & 0x8000000) != 0) {
            event.x = this.getClientWidth() - event.x;
        }
        this.setInputState(event, state);
        if (send) {
            this.sendEvent(type, event);
            if (this.isDisposed()) {
                return false;
            }
        } else {
            this.postEvent(type, event);
        }
        return event.doit;
    }

    void setBackground() {
        if ((this.state & 0x2000) == 0 && this.backgroundImage == null) {
            if ((this.state & 0x8000) != 0) {
                this.setParentBackground();
            } else {
                this.setWidgetBackground();
            }
            this.redrawWidget(0, 0, 0, 0, true, false, false);
        }
    }

    public void setBackground(Color color) {
        this.checkWidget();
        if ((this.state & 0x2000) == 0 && color == null) {
            return;
        }
        GdkColor gdkColor = null;
        if (color != null) {
            if (color.isDisposed()) {
                this.error(5);
            }
            gdkColor = color.handle;
        }
        boolean set = false;
        if (OS.GTK3) {
            set = true;
        } else if (gdkColor == null) {
            int style = OS.gtk_widget_get_modifier_style(this.handle);
            set = (OS.gtk_rc_style_get_color_flags(style, 0) & 2) != 0;
        } else {
            GdkColor oldColor = this.getBackgroundColor();
            boolean bl = set = oldColor.pixel != gdkColor.pixel;
        }
        if (set) {
            this.state = color == null ? (this.state &= 0xFFFFDFFF) : (this.state |= 0x2000);
            this.setBackgroundColor(gdkColor);
            this.redrawChildren();
        }
    }

    void setBackgroundColor(int context, int handle, GdkRGBA rgba) {
        OS.gtk_widget_override_background_color(handle, 0, rgba);
    }

    void setBackgroundColorGradient(int context, int handle, GdkRGBA rgba) {
        String css = "* {\n";
        if (rgba != null) {
            String color = "rgba(" + (int)(rgba.red * 255.0) + "," + (int)(rgba.green * 255.0) + "," + (int)(rgba.blue * 255.0) + "," + (int)(rgba.alpha * 255.0) + ")";
            css = String.valueOf(css) + "background-image: -gtk-gradient (linear, 0 0, 0 1, color-stop(0, " + color + "), color-stop(1, " + color + "));\n";
        }
        css = String.valueOf(css) + "}\n";
        if (this.provider == 0) {
            this.provider = OS.gtk_css_provider_new();
            OS.gtk_style_context_add_provider(context, this.provider, 600);
            OS.g_object_unref(this.provider);
        }
        OS.gtk_css_provider_load_from_data(this.provider, Converter.wcsToMbcs(null, css, true), -1, null);
    }

    void setBackgroundColor(int handle, GdkColor color) {
        if (OS.GTK3) {
            GdkRGBA rgba = null;
            double alpha = 1.0;
            if (color == null && (this.state & 0x8000) != 0) {
                alpha = 0.0;
                Control control = this.findBackgroundControl();
                if (control == null) {
                    control = this;
                }
                color = control.getBackgroundColor();
            }
            if (color != null) {
                rgba = new GdkRGBA();
                rgba.alpha = alpha;
                rgba.red = (float)(color.red & 0xFFFF) / 65535.0f;
                rgba.green = (float)(color.green & 0xFFFF) / 65535.0f;
                rgba.blue = (float)(color.blue & 0xFFFF) / 65535.0f;
            }
            int context = OS.gtk_widget_get_style_context(handle);
            this.setBackgroundColor(context, handle, rgba);
            OS.gtk_style_context_invalidate(context);
            return;
        }
        int index = 0;
        int style = OS.gtk_widget_get_modifier_style(handle);
        int ptr = OS.gtk_rc_style_get_bg_pixmap_name(style, index);
        if (ptr != 0) {
            OS.g_free(ptr);
        }
        ptr = 0;
        String pixmapName = null;
        int flags = OS.gtk_rc_style_get_color_flags(style, index);
        if (color != null) {
            flags |= 2;
            pixmapName = "<none>";
        } else {
            flags &= 0xFFFFFFFD;
            if (this.backgroundImage == null && (this.state & 0x8000) != 0) {
                pixmapName = "<parent>";
            }
        }
        if (pixmapName != null) {
            byte[] buffer = Converter.wcsToMbcs(null, pixmapName, true);
            ptr = OS.g_malloc(buffer.length);
            OS.memmove(ptr, buffer, buffer.length);
        }
        OS.gtk_rc_style_set_bg_pixmap_name(style, index, ptr);
        OS.gtk_rc_style_set_bg(style, index, color);
        OS.gtk_rc_style_set_color_flags(style, index, flags);
        this.modifyStyle(handle, style);
    }

    void setBackgroundColor(GdkColor color) {
        this.setBackgroundColor(this.handle, color);
    }

    public void setBackgroundImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if (image == this.backgroundImage) {
            return;
        }
        this.backgroundImage = image;
        if (this.backgroundImage != null) {
            this.setBackgroundPixmap(this.backgroundImage);
            this.redrawWidget(0, 0, 0, 0, true, false, false);
        } else {
            this.setWidgetBackground();
        }
        this.redrawChildren();
    }

    void setBackgroundPixmap(Image image) {
        int window = this.gtk_widget_get_window(this.paintHandle());
        if (window != 0) {
            if (image.pixmap != 0) {
                OS.gdk_window_set_back_pixmap(window, image.pixmap, false);
            } else if (image.surface != 0 && OS.GTK3) {
                int pattern = Cairo.cairo_pattern_create_for_surface(image.surface);
                if (pattern == 0) {
                    SWT.error(2);
                }
                Cairo.cairo_pattern_set_extend(pattern, 1);
                OS.gdk_window_set_background_pattern(window, pattern);
                Cairo.cairo_pattern_destroy(pattern);
            }
        }
    }

    public void setCapture(boolean capture) {
        this.checkWidget();
    }

    public void setCursor(Cursor cursor) {
        this.checkWidget();
        if (cursor != null && cursor.isDisposed()) {
            this.error(5);
        }
        this.cursor = cursor;
        this.setCursor(cursor != null ? cursor.handle : 0);
    }

    void setCursor(int cursor) {
        int window = this.eventWindow();
        if (window != 0) {
            OS.gdk_window_set_cursor(window, cursor);
            if (!OS.GDK_WINDOWING_X11()) {
                OS.gdk_flush();
            } else {
                int xDisplay = OS.gdk_x11_display_get_xdisplay(OS.gdk_display_get_default());
                OS.XFlush(xDisplay);
            }
        }
    }

    public void setDragDetect(boolean dragDetect) {
        this.checkWidget();
        this.state = dragDetect ? (this.state |= 0x800000) : (this.state &= 0xFF7FFFFF);
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        if ((this.state & 0x10) == 0 == enabled) {
            return;
        }
        Control control = null;
        boolean fixFocus = false;
        if (!enabled && this.display.focusEvent != 16) {
            control = this.display.getFocusControl();
            fixFocus = this.isFocusAncestor(control);
        }
        this.state = enabled ? (this.state &= 0xFFFFFFEF) : (this.state |= 0x10);
        this.enableWidget(enabled);
        if (this.isDisposed()) {
            return;
        }
        if (enabled) {
            if (this.enableWindow != 0) {
                OS.gdk_window_set_user_data(this.enableWindow, 0);
                OS.gdk_window_destroy(this.enableWindow);
                this.enableWindow = 0;
            }
        } else {
            OS.gtk_widget_realize(this.handle);
            int parentHandle = this.parent.eventHandle();
            int window = this.parent.eventWindow();
            int topHandle = this.topHandle();
            GdkWindowAttr attributes = new GdkWindowAttr();
            GtkAllocation allocation = new GtkAllocation();
            this.gtk_widget_get_allocation(topHandle, allocation);
            attributes.x = allocation.x;
            attributes.y = allocation.y;
            attributes.width = (this.state & 0x200) != 0 ? 0 : allocation.width;
            attributes.height = (this.state & 0x400) != 0 ? 0 : allocation.height;
            attributes.event_mask = -32769;
            attributes.wclass = 1;
            attributes.window_type = 2;
            this.enableWindow = OS.gdk_window_new(window, attributes, 12);
            if (this.enableWindow != 0) {
                OS.gdk_window_set_user_data(this.enableWindow, parentHandle);
                if (!OS.GDK_WINDOWING_X11()) {
                    OS.gdk_window_raise(this.enableWindow);
                } else {
                    this.restackWindow(this.enableWindow, this.gtk_widget_get_window(topHandle), true);
                }
                if (this.gtk_widget_get_visible(topHandle)) {
                    OS.gdk_window_show_unraised(this.enableWindow);
                }
            }
        }
        if (fixFocus) {
            this.fixFocus(control);
        }
    }

    public boolean setFocus() {
        this.checkWidget();
        if ((this.style & 0x80000) != 0) {
            return false;
        }
        return this.forceFocus();
    }

    public void setFont(Font font) {
        int fontDesc;
        this.checkWidget();
        if ((this.state & 0x4000) == 0 && font == null) {
            return;
        }
        this.font = font;
        if (font == null) {
            fontDesc = this.defaultFont().handle;
        } else {
            if (font.isDisposed()) {
                this.error(5);
            }
            fontDesc = font.handle;
        }
        this.state = font == null ? (this.state &= 0xFFFFBFFF) : (this.state |= 0x4000);
        this.setFontDescription(fontDesc);
    }

    void setFontDescription(int font) {
        this.setFontDescription(this.handle, font);
    }

    public void setForeground(Color color) {
        this.checkWidget();
        if ((this.state & 0x1000) == 0 && color == null) {
            return;
        }
        GdkColor gdkColor = null;
        if (color != null) {
            if (color.isDisposed()) {
                this.error(5);
            }
            gdkColor = color.handle;
        }
        boolean set = false;
        if (OS.GTK3) {
            set = !this.getForeground().equals(color);
        } else if (gdkColor == null) {
            int style = OS.gtk_widget_get_modifier_style(this.handle);
            set = (OS.gtk_rc_style_get_color_flags(style, 0) & 1) != 0;
        } else {
            GdkColor oldColor = this.getForegroundColor();
            boolean bl = set = oldColor.pixel != gdkColor.pixel;
        }
        if (set) {
            this.state = color == null ? (this.state &= 0xFFFFEFFF) : (this.state |= 0x1000);
            this.setForegroundColor(gdkColor);
        }
    }

    void setForegroundColor(GdkColor color) {
        this.setForegroundColor(this.handle, color);
    }

    void setInitialBounds() {
        if ((this.state & 0x200) != 0 && (this.state & 0x400) != 0) {
            int topHandle = this.topHandle();
            GtkAllocation allocation = new GtkAllocation();
            if ((this.parent.style & 0x8000000) != 0) {
                if (OS.GTK_VERSION >= OS.VERSION(2, 18, 0)) {
                    allocation.x = this.parent.getClientWidth();
                } else {
                    OS.GTK_WIDGET_SET_X(topHandle, this.parent.getClientWidth());
                }
            } else if (OS.GTK_VERSION >= OS.VERSION(2, 18, 0)) {
                allocation.x = 0;
            } else {
                OS.GTK_WIDGET_SET_X(topHandle, 0);
            }
            if (OS.GTK_VERSION >= OS.VERSION(2, 18, 0)) {
                allocation.y = 0;
                if (OS.GTK3) {
                    OS.gtk_widget_set_visible(topHandle, true);
                }
                OS.gtk_widget_set_allocation(topHandle, allocation);
            } else {
                OS.GTK_WIDGET_SET_Y(topHandle, 0);
            }
        } else {
            this.resizeHandle(1, 1);
            this.forceResize();
        }
    }

    public void setMenu(Menu menu) {
        this.checkWidget();
        if (menu != null) {
            if ((menu.style & 8) == 0) {
                this.error(37);
            }
            if (menu.parent != this.menuShell()) {
                this.error(32);
            }
        }
        this.menu = menu;
    }

    void setOrientation(boolean create) {
        if ((this.style & 0x4000000) != 0 || !create) {
            int dir;
            int n = dir = (this.style & 0x4000000) != 0 ? 2 : 1;
            if (this.handle != 0) {
                OS.gtk_widget_set_direction(this.handle, dir);
            }
            if (this.fixedHandle != 0) {
                OS.gtk_widget_set_direction(this.fixedHandle, dir);
            }
        }
    }

    public void setOrientation(int orientation) {
        this.checkWidget();
        int flags = 0x6000000;
        if ((orientation & flags) == 0 || (orientation & flags) == flags) {
            return;
        }
        this.style &= ~flags;
        this.style |= orientation & flags;
        this.setOrientation(false);
        this.style &= 0xF7FFFFFF;
        this.checkMirrored();
    }

    public boolean setParent(Composite parent) {
        int height;
        this.checkWidget();
        if (parent == null) {
            this.error(4);
        }
        if (parent.isDisposed()) {
            this.error(5);
        }
        if (this.parent == parent) {
            return true;
        }
        if (!this.isReparentable()) {
            return false;
        }
        OS.gtk_widget_realize(parent.handle);
        int topHandle = this.topHandle();
        GtkAllocation allocation = new GtkAllocation();
        this.gtk_widget_get_allocation(topHandle, allocation);
        int x = allocation.x;
        int y = allocation.y;
        int width = (this.state & 0x200) != 0 ? 0 : allocation.width;
        int n = height = (this.state & 0x400) != 0 ? 0 : allocation.height;
        if ((this.parent.style & 0x8000000) != 0) {
            x = this.parent.getClientWidth() - width - x;
        }
        if ((parent.style & 0x8000000) != 0) {
            x = parent.getClientWidth() - width - x;
        }
        this.releaseParent();
        Shell newShell = parent.getShell();
        Shell oldShell = this.getShell();
        Decorations newDecorations = parent.menuShell();
        Decorations oldDecorations = this.menuShell();
        Menu[] menus = oldShell.findMenus(this);
        if (oldShell != newShell || oldDecorations != newDecorations) {
            this.fixChildren(newShell, oldShell, newDecorations, oldDecorations, menus);
            newDecorations.fixAccelGroup();
            oldDecorations.fixAccelGroup();
        }
        int newParent = parent.parentingHandle();
        OS.gtk_widget_reparent(topHandle, newParent);
        if (OS.GTK3) {
            OS.swt_fixed_move(newParent, topHandle, x, y);
        } else {
            OS.gtk_fixed_move(newParent, topHandle, x, y);
        }
        this.resizeHandle(width, height);
        GtkRequisition requisition = new GtkRequisition();
        this.gtk_widget_size_request(topHandle, requisition);
        allocation.x = x;
        allocation.y = y;
        allocation.width = width;
        allocation.height = height;
        OS.gtk_widget_size_allocate(topHandle, allocation);
        this.parent = parent;
        this.setZOrder(null, false, true);
        this.reskin(1);
        return true;
    }

    void setParentBackground() {
        this.setBackgroundColor(this.handle, null);
        if (this.fixedHandle != 0) {
            this.setBackgroundColor(this.fixedHandle, null);
        }
    }

    void setParentWindow(int widget) {
    }

    boolean setRadioSelection(boolean value) {
        return false;
    }

    public void setRedraw(boolean redraw) {
        this.checkWidget();
        if (redraw) {
            if (--this.drawCount == 0 && this.redrawWindow != 0) {
                int window = this.paintWindow();
                OS.gdk_window_hide(this.redrawWindow);
                OS.gdk_window_destroy(this.redrawWindow);
                OS.gdk_window_set_events(window, OS.gtk_widget_get_events(this.paintHandle()));
                this.redrawWindow = 0;
            }
        } else if (this.drawCount++ == 0 && this.gtk_widget_get_realized(this.handle)) {
            int window = this.paintWindow();
            Rectangle rect = this.getBounds();
            GdkWindowAttr attributes = new GdkWindowAttr();
            attributes.width = rect.width;
            attributes.height = rect.height;
            attributes.event_mask = 2;
            attributes.window_type = 2;
            this.redrawWindow = OS.gdk_window_new(window, attributes, 0);
            if (this.redrawWindow != 0) {
                int mouseMask = 13308;
                OS.gdk_window_set_events(window, OS.gdk_window_get_events(window) & ~mouseMask);
                OS.gdk_window_set_back_pixmap(this.redrawWindow, 0, false);
                OS.gdk_window_show(this.redrawWindow);
            }
        }
    }

    boolean setTabItemFocus(boolean next) {
        if (!this.isShowing()) {
            return false;
        }
        return this.forceFocus();
    }

    public void setTextDirection(int textDirection) {
        this.checkWidget();
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.setToolTipText(this._getShell(), string);
        this.toolTipText = string;
    }

    void setToolTipText(Shell shell, String newString) {
        if (OS.GTK_VERSION >= OS.VERSION(2, 12, 0)) {
            if (this.display.currentControl == this) {
                shell.setToolTipText(shell.handle, this.eventHandle(), newString);
            }
        } else {
            shell.setToolTipText(this.eventHandle(), newString);
        }
    }

    public void setTouchEnabled(boolean enabled) {
        this.checkWidget();
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        if ((this.state & 0x800) == 0 == visible) {
            return;
        }
        int topHandle = this.topHandle();
        if (visible) {
            this.sendEvent(22);
            if (this.isDisposed()) {
                return;
            }
            this.state &= 0xFFFFF7FF;
            if ((this.state & 0x600) == 0) {
                if (this.enableWindow != 0) {
                    OS.gdk_window_show_unraised(this.enableWindow);
                }
                OS.gtk_widget_show(topHandle);
            }
        } else {
            Control control = null;
            boolean fixFocus = false;
            if (this.display.focusEvent != 16) {
                control = this.display.getFocusControl();
                fixFocus = this.isFocusAncestor(control);
            }
            this.state |= 0x800;
            if (fixFocus) {
                if (OS.GTK3) {
                    this.gtk_widget_set_can_focus(topHandle, false);
                } else {
                    this.gtk_widget_set_visible(topHandle, false);
                }
                this.fixFocus(control);
                if (this.isDisposed()) {
                    return;
                }
                if (OS.GTK3) {
                    this.gtk_widget_set_can_focus(topHandle, true);
                } else {
                    this.gtk_widget_set_visible(topHandle, true);
                }
            }
            OS.gtk_widget_hide(topHandle);
            if (this.isDisposed()) {
                return;
            }
            if (this.enableWindow != 0) {
                OS.gdk_window_hide(this.enableWindow);
            }
            this.sendEvent(23);
        }
    }

    void setZOrder(Control sibling, boolean above, boolean fixRelations) {
        this.setZOrder(sibling, above, fixRelations, true);
    }

    void setZOrder(Control sibling, boolean above, boolean fixRelations, boolean fixChildren) {
        int index = 0;
        int siblingIndex = 0;
        int oldNextIndex = -1;
        Control[] children = null;
        if (fixRelations) {
            children = this.parent._getChildren();
            while (index < children.length) {
                if (children[index] == this) break;
                ++index;
            }
            if (sibling != null) {
                while (siblingIndex < children.length) {
                    if (children[siblingIndex] == sibling) break;
                    ++siblingIndex;
                }
            }
            this.removeRelation();
            if (index + 1 < children.length) {
                oldNextIndex = index + 1;
                children[oldNextIndex].removeRelation();
            }
            if (sibling != null) {
                if (above) {
                    sibling.removeRelation();
                } else if (siblingIndex + 1 < children.length) {
                    children[siblingIndex + 1].removeRelation();
                }
            }
        }
        int topHandle = this.topHandle();
        int siblingHandle = sibling != null ? sibling.topHandle() : 0;
        int window = this.gtk_widget_get_window(topHandle);
        if (window != 0) {
            int redrawWindow;
            int siblingWindow = 0;
            if (sibling != null) {
                siblingWindow = above && sibling.enableWindow != 0 ? this.enableWindow : OS.GTK_WIDGET_WINDOW(siblingHandle);
            }
            int n = redrawWindow = fixChildren ? this.parent.redrawWindow : 0;
            if (!OS.GDK_WINDOWING_X11() || siblingWindow == 0 && (!above || redrawWindow == 0)) {
                if (above) {
                    OS.gdk_window_raise(window);
                    if (redrawWindow != 0) {
                        OS.gdk_window_raise(redrawWindow);
                    }
                    if (this.enableWindow != 0) {
                        OS.gdk_window_raise(this.enableWindow);
                    }
                } else {
                    if (this.enableWindow != 0) {
                        OS.gdk_window_lower(this.enableWindow);
                    }
                    OS.gdk_window_lower(window);
                }
            } else {
                int siblingW = siblingWindow != 0 ? siblingWindow : redrawWindow;
                boolean stack_mode = above;
                if (redrawWindow != 0 && siblingWindow == 0) {
                    stack_mode = false;
                }
                this.restackWindow(window, siblingW, stack_mode);
                if (this.enableWindow != 0) {
                    this.restackWindow(this.enableWindow, window, true);
                }
            }
        }
        if (fixChildren) {
            if (above) {
                this.parent.moveAbove(topHandle, siblingHandle);
            } else {
                this.parent.moveBelow(topHandle, siblingHandle);
            }
        }
        if (!above && fixChildren) {
            this.parent.fixZOrder();
        }
        if (fixRelations) {
            index = sibling != null ? (above ? siblingIndex - (index < siblingIndex ? 1 : 0) : siblingIndex + (siblingIndex < index ? 1 : 0)) : (above ? 0 : children.length - 1);
            children = this.parent._getChildren();
            if (index > 0) {
                children[index - 1].addRelation(this);
            }
            if (index + 1 < children.length) {
                this.addRelation(children[index + 1]);
            }
            if (oldNextIndex != -1) {
                if (oldNextIndex <= index) {
                    --oldNextIndex;
                }
                if (oldNextIndex > 0 && oldNextIndex != index && oldNextIndex != index + 1) {
                    children[oldNextIndex - 1].addRelation(children[oldNextIndex]);
                }
            }
        }
    }

    void setWidgetBackground() {
        GdkColor color;
        GdkColor gdkColor = color = (this.state & 0x2000) != 0 ? this.getBackgroundColor() : null;
        if (this.fixedHandle != 0) {
            this.setBackgroundColor(this.fixedHandle, color);
        }
        this.setBackgroundColor(this.handle, color);
    }

    boolean showMenu(int x, int y) {
        return this.showMenu(x, y, 0);
    }

    boolean showMenu(int x, int y, int detail) {
        Event event = new Event();
        event.x = x;
        event.y = y;
        event.detail = detail;
        this.sendEvent(35, event);
        if (this.isDisposed()) {
            return false;
        }
        if (event.doit && this.menu != null && !this.menu.isDisposed()) {
            boolean hooksKeys = this.hooks(1) || this.hooks(2);
            this.menu.createIMMenu(hooksKeys ? this.imHandle() : 0);
            if (event.x != x || event.y != y) {
                this.menu.setLocation(event.x, event.y);
            }
            this.menu.setVisible(true);
            return true;
        }
        return false;
    }

    void showWidget() {
        this.state |= 0x600;
        int topHandle = this.topHandle();
        int parentHandle = this.parent.parentingHandle();
        this.parent.setParentWindow(topHandle);
        OS.gtk_container_add(parentHandle, topHandle);
        if (this.handle != 0 && this.handle != topHandle) {
            OS.gtk_widget_show(this.handle);
        }
        if ((this.state & 0x600) == 0 && this.fixedHandle != 0) {
            OS.gtk_widget_show(this.fixedHandle);
        }
        if (this.fixedHandle != 0) {
            this.fixStyle(this.fixedHandle);
        }
    }

    void sort(int[] items) {
        int length = items.length;
        int gap = length / 2;
        while (gap > 0) {
            int i = gap;
            while (i < length) {
                int j = i - gap;
                while (j >= 0) {
                    if (items[j] <= items[j + gap]) {
                        int swap = items[j];
                        items[j] = items[j + gap];
                        items[j + gap] = swap;
                    }
                    j -= gap;
                }
                ++i;
            }
            gap /= 2;
        }
    }

    public boolean traverse(int traversal) {
        this.checkWidget();
        Event event = new Event();
        event.doit = true;
        event.detail = traversal;
        return this.traverse(event);
    }

    public boolean traverse(int traversal, Event event) {
        this.checkWidget();
        if (event == null) {
            this.error(4);
        }
        return this.traverse(traversal, event.character, event.keyCode, event.keyLocation, event.stateMask, event.doit);
    }

    public boolean traverse(int traversal, KeyEvent event) {
        this.checkWidget();
        if (event == null) {
            this.error(4);
        }
        return this.traverse(traversal, event.character, event.keyCode, event.keyLocation, event.stateMask, event.doit);
    }

    boolean traverse(int traversal, char character, int keyCode, int keyLocation, int stateMask, boolean doit) {
        if (traversal == 0) {
            switch (keyCode) {
                case 27: {
                    traversal = 2;
                    doit = true;
                    break;
                }
                case 13: {
                    traversal = 4;
                    doit = true;
                    break;
                }
                case 0x1000002: 
                case 0x1000004: {
                    traversal = 64;
                    doit = false;
                    break;
                }
                case 0x1000001: 
                case 0x1000003: {
                    traversal = 32;
                    doit = false;
                    break;
                }
                case 9: {
                    traversal = (stateMask & 0x20000) != 0 ? 8 : 16;
                    doit = true;
                    break;
                }
                case 0x1000006: {
                    if ((stateMask & 0x40000) == 0) break;
                    traversal = 512;
                    doit = true;
                    break;
                }
                case 0x1000005: {
                    if ((stateMask & 0x40000) == 0) break;
                    traversal = 256;
                    doit = true;
                    break;
                }
                default: {
                    if (character == '\u0000' || (stateMask & 0x50000) != 65536) break;
                    traversal = 128;
                    doit = true;
                }
            }
        }
        Event event = new Event();
        event.character = character;
        event.detail = traversal;
        event.doit = doit;
        event.keyCode = keyCode;
        event.keyLocation = keyLocation;
        event.stateMask = stateMask;
        Shell shell = this.getShell();
        boolean all = false;
        switch (traversal) {
            case 2: 
            case 4: 
            case 256: 
            case 512: {
                all = true;
            }
            case 8: 
            case 16: 
            case 32: 
            case 64: {
                break;
            }
            case 128: {
                return this.translateMnemonic(event, null) || shell.translateMnemonic(event, this);
            }
            default: {
                return false;
            }
        }
        Control control = this;
        do {
            if (control.traverse(event)) {
                return true;
            }
            if (!event.doit && control.hooks(31)) {
                return false;
            }
            if (control == shell) {
                return false;
            }
            control = control.parent;
        } while (all && control != null);
        return false;
    }

    boolean translateMnemonic(Event event, Control control) {
        if (control == this) {
            return false;
        }
        if (!this.isVisible() || !this.isEnabled()) {
            return false;
        }
        event.doit = this == this.display.mnemonicControl || this.mnemonicMatch(event.character);
        return this.traverse(event);
    }

    boolean translateMnemonic(int keyval, GdkEventKey gdkEvent) {
        Decorations shell;
        int key = OS.gdk_keyval_to_unicode(keyval);
        if (key < 32) {
            return false;
        }
        if (gdkEvent.state == 0) {
            int code = this.traversalCode(keyval, gdkEvent);
            if ((code & 0x80) == 0) {
                return false;
            }
        } else {
            Shell shell2 = this._getShell();
            int mask = 13;
            if ((gdkEvent.state & mask) != OS.gtk_window_get_mnemonic_modifier(shell2.shellHandle)) {
                return false;
            }
        }
        if ((shell = this.menuShell()).isVisible() && shell.isEnabled()) {
            Event event = new Event();
            event.detail = 128;
            if (this.setKeyState(event, gdkEvent)) {
                return this.translateMnemonic(event, null) || shell.translateMnemonic(event, this);
            }
        }
        return false;
    }

    boolean translateTraversal(GdkEventKey keyEvent) {
        int detail = 0;
        int key = keyEvent.keyval;
        int code = this.traversalCode(key, keyEvent);
        boolean all = false;
        switch (key) {
            case 65307: {
                all = true;
                detail = 2;
                break;
            }
            case 65293: 
            case 65421: {
                all = true;
                detail = 4;
                break;
            }
            case 65056: 
            case 65289: {
                boolean next = (keyEvent.state & 1) == 0;
                detail = next ? 16 : 8;
                break;
            }
            case 65361: 
            case 65362: 
            case 65363: 
            case 65364: {
                boolean next;
                boolean bl = next = key == 65364 || key == 65363;
                if (this.parent != null && (this.parent.style & 0x8000000) != 0 && (key == 65361 || key == 65363)) {
                    next = !next;
                }
                detail = next ? 64 : 32;
                break;
            }
            case 65365: 
            case 65366: {
                all = true;
                if ((keyEvent.state & 4) == 0) {
                    return false;
                }
                detail = key == 65366 ? 512 : 256;
                break;
            }
            default: {
                return false;
            }
        }
        Event event = new Event();
        event.doit = (code & detail) != 0;
        event.detail = detail;
        event.time = keyEvent.time;
        if (!this.setKeyState(event, keyEvent)) {
            return false;
        }
        Shell shell = this.getShell();
        Control control = this;
        do {
            if (control.traverse(event)) {
                return true;
            }
            if (!event.doit && control.hooks(31)) {
                return false;
            }
            if (control == shell) {
                return false;
            }
            control = control.parent;
        } while (all && control != null);
        return false;
    }

    int traversalCode(int key, GdkEventKey event) {
        int code = 796;
        Shell shell = this.getShell();
        if (shell.parent != null) {
            code |= 2;
        }
        return code;
    }

    boolean traverse(Event event) {
        this.sendEvent(31, event);
        if (this.isDisposed()) {
            return true;
        }
        if (!event.doit) {
            return false;
        }
        switch (event.detail) {
            case 0: {
                return true;
            }
            case 2: {
                return this.traverseEscape();
            }
            case 4: {
                return this.traverseReturn();
            }
            case 16: {
                return this.traverseGroup(true);
            }
            case 8: {
                return this.traverseGroup(false);
            }
            case 64: {
                return this.traverseItem(true);
            }
            case 32: {
                return this.traverseItem(false);
            }
            case 128: {
                return this.traverseMnemonic(event.character);
            }
            case 512: {
                return this.traversePage(true);
            }
            case 256: {
                return this.traversePage(false);
            }
        }
        return false;
    }

    boolean traverseEscape() {
        return false;
    }

    boolean traverseGroup(boolean next) {
        Control root = this.computeTabRoot();
        Widget group = this.computeTabGroup();
        Widget[] list = root.computeTabList();
        int length = list.length;
        int index = 0;
        while (index < length) {
            if (list[index] == group) break;
            ++index;
        }
        if (index == length) {
            return false;
        }
        int start = index;
        int offset = next ? 1 : -1;
        while ((index = (index + offset + length) % length) != start) {
            Widget widget = list[index];
            if (widget.isDisposed() || !widget.setTabGroupFocus(next)) continue;
            return true;
        }
        if (group.isDisposed()) {
            return false;
        }
        return group.setTabGroupFocus(next);
    }

    boolean traverseItem(boolean next) {
        Control[] children = this.parent._getChildren();
        int length = children.length;
        int index = 0;
        while (index < length) {
            if (children[index] == this) break;
            ++index;
        }
        if (index == length) {
            return false;
        }
        int start = index;
        int offset = next ? 1 : -1;
        while ((index = (index + offset + length) % length) != start) {
            Control child = children[index];
            if (child.isDisposed() || !child.isTabItem() || !child.setTabItemFocus(next)) continue;
            return true;
        }
        return false;
    }

    boolean traverseReturn() {
        return false;
    }

    boolean traversePage(boolean next) {
        return false;
    }

    boolean traverseMnemonic(char key) {
        return this.mnemonicHit(key);
    }

    public void update() {
        this.checkWidget();
        this.update(false, true);
    }

    void update(boolean all, boolean flush) {
        if (!this.gtk_widget_get_visible(this.topHandle())) {
            return;
        }
        if (!this.gtk_widget_get_realized(this.handle)) {
            return;
        }
        int window = this.paintWindow();
        if (flush) {
            this.display.flushExposes(window, all);
        }
        OS.gdk_window_process_updates(window, all);
        OS.gdk_flush();
    }

    void updateBackgroundMode() {
        int oldState = this.state & 0x8000;
        this.checkBackground();
        if (oldState != (this.state & 0x8000)) {
            this.setBackground();
        }
    }

    void updateLayout(boolean all) {
    }

    int windowProc(int handle, int arg0, int user_data) {
        switch (user_data) {
            case 19: {
                boolean draw;
                if ((this.state & 0x40) != 0 || !OS.USE_CAIRO) break;
                Control control = this.findBackgroundControl();
                boolean bl = draw = control != null && control.backgroundImage != null;
                if (OS.GTK3 && !draw && (this.state & 2) != 0) {
                    GdkRGBA rgba = new GdkRGBA();
                    int context = OS.gtk_widget_get_style_context(handle);
                    OS.gtk_style_context_get_background_color(context, 0, rgba);
                    boolean bl2 = draw = rgba.alpha == 0.0;
                }
                if (!draw) break;
                if (OS.GTK3) {
                    int window;
                    int cairo = arg0;
                    GdkRectangle rect = new GdkRectangle();
                    OS.gdk_cairo_get_clip_rectangle(cairo, rect);
                    if (control == null) {
                        control = this;
                    }
                    if ((window = OS.gtk_widget_get_window(handle)) != 0) {
                        this.drawBackground(control, window, 0, 0, rect.x, rect.y, rect.width, rect.height);
                        break;
                    }
                    this.drawBackground(control, 0, cairo, 0, rect.x, rect.y, rect.width, rect.height);
                    break;
                }
                GdkEventExpose gdkEvent = new GdkEventExpose();
                OS.memmove(gdkEvent, arg0, GdkEventExpose.sizeof);
                int paintWindow = this.paintWindow();
                int window = gdkEvent.window;
                if (window != paintWindow) break;
                this.drawBackground(control, window, gdkEvent.region, gdkEvent.area_x, gdkEvent.area_y, gdkEvent.area_width, gdkEvent.area_height);
            }
        }
        return super.windowProc(handle, arg0, user_data);
    }
}

