/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.runtime.stepper.utils;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.persistence.utils.DataHelper;
import org.eclipse.tcf.te.runtime.services.ServiceManager;
import org.eclipse.tcf.te.runtime.services.interfaces.IService;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IStepContext;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IStepperOperationService;
import org.eclipse.tcf.te.runtime.stepper.job.StepperJob;

public final class StepperHelper {
    public static final IStepperOperationService getService(Object context, String operation) {
        IService[] services = ServiceManager.getInstance().getServices(context, IStepperOperationService.class, false);
        IStepperOperationService stepperOperationService = null;
        IService[] iServiceArray = services;
        int n = services.length;
        int n2 = 0;
        while (n2 < n) {
            IService service = iServiceArray[n2];
            if (service instanceof IStepperOperationService && ((IStepperOperationService)service).isHandledOperation(context, operation)) {
                stepperOperationService = (IStepperOperationService)service;
                break;
            }
            ++n2;
        }
        return stepperOperationService;
    }

    public static final void scheduleStepperJob(Object context, String operation, IStepperOperationService service, IPropertiesContainer data, ICallback callback, IProgressMonitor monitor) {
        IStepContext stepContext = service.getStepContext(context, operation);
        String stepGroupId = service.getStepGroupId(context, operation);
        String name = service.getStepGroupName(context, operation);
        boolean isCancelable = service.isCancelable(context, operation);
        boolean addToActionHistory = service.addToActionHistory(context, operation);
        IPropertiesContainer histData = service.getSpecialHistoryData(stepContext, operation, data);
        if (!addToActionHistory) {
            data.setProperty("org.eclipse.tcf.te.runtime.stepper.skip_last_run_history", true);
        }
        if (histData != null) {
            data.setProperty("org.eclipse.tcf.te.runtime.stepper.history_data", (Object)DataHelper.encodePropertiesContainer((IPropertiesContainer)histData));
        }
        if (stepGroupId != null && stepContext != null) {
            StepperJob job = new StepperJob(name != null ? name : "", stepContext, data, stepGroupId, operation, isCancelable, monitor == null);
            job.setJobCallback(callback);
            if (monitor != null) {
                job.run(monitor);
            } else {
                job.schedule();
            }
        }
    }
}

