/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.core.internal.operations;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.OpStreamOp;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.url.TcfURLConnection;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.utils.CacheManager;
import org.eclipse.tcf.te.tcf.filesystem.core.model.FSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.core.nls.Messages;

public class OpDownload
extends OpStreamOp {
    protected File[] dstFiles;
    protected FSTreeNode[] srcNodes;

    public OpDownload(File dstFile, FSTreeNode srcNode) {
        this(new File[]{dstFile}, new FSTreeNode[]{srcNode});
    }

    public OpDownload(File[] dstFiles, FSTreeNode[] srcNodes) {
        this.dstFiles = dstFiles;
        this.srcNodes = srcNodes;
    }

    public OpDownload(FSTreeNode ... srcNodes) {
        this.srcNodes = srcNodes;
        this.dstFiles = new File[srcNodes.length];
        int i = 0;
        while (i < srcNodes.length) {
            this.dstFiles[i] = CacheManager.getCacheFile(srcNodes[i]);
            ++i;
        }
    }

    @Override
    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        super.run(monitor);
        try {
            try {
                this.downloadFiles(this.dstFiles, this.srcNodes);
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
            }
            catch (MalformedURLException e) {
                throw new InvocationTargetException(e, e.getLocalizedMessage());
            }
            catch (IOException e) {
                throw new InvocationTargetException(e, e.getLocalizedMessage());
            }
        }
        finally {
            monitor.done();
        }
    }

    private void downloadFiles(File[] dstFiles, FSTreeNode[] srcNodes) throws IOException {
        byte[] data = new byte[5120];
        long totalSize = 0L;
        FSTreeNode[] fSTreeNodeArray = srcNodes;
        int n = srcNodes.length;
        int n2 = 0;
        while (n2 < n) {
            FSTreeNode node = fSTreeNodeArray[n2];
            totalSize += node.attr == null ? 0L : node.attr.size;
            ++n2;
        }
        int chunk_size = (int)totalSize / 100;
        int percentRead = 0;
        long bytesRead = 0L;
        int i = 0;
        while (i < srcNodes.length && !this.monitor.isCanceled()) {
            FSTreeNode node = srcNodes[i];
            long size = node.attr == null ? 0L : node.attr.size;
            MessageDigest digest = null;
            BufferedInputStream input = null;
            FilterOutputStream output = null;
            try {
                int length;
                URL url = node.getLocationURL();
                TcfURLConnection connection = (TcfURLConnection)url.openConnection();
                try {
                    digest = MessageDigest.getInstance("MD5");
                    input = new BufferedInputStream(new DigestInputStream(connection.getInputStream(), digest));
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    input = new BufferedInputStream(connection.getInputStream());
                }
                output = new BufferedOutputStream(new FileOutputStream(dstFiles[i]));
                String fileLength = this.formatSize(size);
                while ((length = input.read(data)) >= 0 && !this.monitor.isCanceled()) {
                    int percent;
                    ((BufferedOutputStream)output).write(data, 0, length);
                    ((BufferedOutputStream)output).flush();
                    if (chunk_size == 0 || (percent = (int)(bytesRead += (long)length) / chunk_size) == percentRead) continue;
                    this.monitor.worked(percent - percentRead);
                    percentRead = percent;
                    this.monitor.subTask(NLS.bind((String)Messages.OpDownload_Downloading, (Object[])new Object[]{node.name, this.formatSize(bytesRead), fileLength}));
                }
            }
            catch (Throwable throwable) {
                if (output != null) {
                    try {
                        output.close();
                    }
                    catch (Exception exception) {}
                }
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (Exception exception) {}
                }
                if (digest != null) {
                    this.updateNodeDigest(node, digest.digest());
                }
                throw throwable;
            }
            if (output != null) {
                try {
                    output.close();
                }
                catch (Exception exception) {}
            }
            if (input != null) {
                try {
                    input.close();
                }
                catch (Exception exception) {}
            }
            if (digest != null) {
                this.updateNodeDigest(node, digest.digest());
            }
            ++i;
        }
    }

    protected void updateNodeDigest(FSTreeNode node, byte[] digest) {
    }

    @Override
    public String getName() {
        String message = this.dstFiles.length == 1 ? NLS.bind((String)Messages.OpDownload_DownloadingSingleFile, (Object)this.dstFiles[0].getName()) : NLS.bind((String)Messages.OpDownload_DownloadingMultipleFiles, (Object)this.dstFiles.length);
        return message;
    }

    @Override
    public int getTotalWork() {
        return 100;
    }
}

