/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.ui.activator;

import java.net.URL;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.IExecutionListener;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tcf.te.tcf.filesystem.ui.interfaces.preferences.IPreferenceKeys;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.autosave.SaveAllListener;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.autosave.SaveListener;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.operations.FsClipboard;
import org.eclipse.tcf.te.ui.jface.images.AbstractImageDescriptor;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class UIPlugin
extends AbstractUIPlugin
implements IPreferenceKeys {
    private static UIPlugin plugin;
    private IExecutionListener saveListener;
    private IExecutionListener saveAllListener;
    private FsClipboard clipboard;

    public static UIPlugin getDefault() {
        return plugin;
    }

    public static String getUniqueIdentifier() {
        if (UIPlugin.getDefault() != null && UIPlugin.getDefault().getBundle() != null) {
            return UIPlugin.getDefault().getBundle().getSymbolicName();
        }
        return "org.eclipse.tcf.te.tcf.filesystem.ui";
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.clipboard = new FsClipboard();
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        if (commandService != null) {
            this.saveListener = new SaveListener();
            Command saveCmd = commandService.getCommand("org.eclipse.ui.file.save");
            saveCmd.addExecutionListener(this.saveListener);
            this.saveAllListener = new SaveAllListener();
            Command saveAllCmd = commandService.getCommand("org.eclipse.ui.file.saveAll");
            saveAllCmd.addExecutionListener(this.saveAllListener);
        }
    }

    public static FsClipboard getClipboard() {
        return UIPlugin.plugin.clipboard;
    }

    public void stop(BundleContext context) throws Exception {
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        if (commandService != null) {
            Command saveCmd = commandService.getCommand("org.eclipse.ui.file.save");
            saveCmd.removeExecutionListener(this.saveListener);
            Command saveAllCmd = commandService.getCommand("org.eclipse.ui.file.saveAll");
            saveAllCmd.removeExecutionListener(this.saveAllListener);
        }
        if (this.clipboard != null) {
            try {
                this.clipboard.dispose();
            }
            catch (SWTException sWTException) {}
        }
        this.clipboard = null;
        plugin = null;
        super.stop(context);
    }

    protected void initializeImageRegistry(ImageRegistry registry) {
        URL url = UIPlugin.getDefault().getBundle().getEntry("icons/obj16/folder.gif");
        registry.put("Folder", ImageDescriptor.createFromURL((URL)url));
        url = UIPlugin.getDefault().getBundle().getEntry("icons/obj16/root.gif");
        registry.put("Root", ImageDescriptor.createFromURL((URL)url));
        url = UIPlugin.getDefault().getBundle().getEntry("icons/obj16/rootdrive.gif");
        registry.put("RootDrive", ImageDescriptor.createFromURL((URL)url));
        url = UIPlugin.getDefault().getBundle().getEntry("icons/obj16/synch_synch.gif");
        registry.put("CompareEditor", ImageDescriptor.createFromURL((URL)url));
        url = UIPlugin.getDefault().getBundle().getEntry("icons/obj32/replace_confirm.png");
        registry.put("ReplaceFolderConfirm", ImageDescriptor.createFromURL((URL)url));
        url = UIPlugin.getDefault().getBundle().getEntry("icons/obj32/delete_readonly.png");
        registry.put("ConfirmReadOnlyDelete", ImageDescriptor.createFromURL((URL)url));
        url = UIPlugin.getDefault().getBundle().getEntry("icons/obj32/banner.png");
        registry.put("BannerImage", ImageDescriptor.createFromURL((URL)url));
        url = UIPlugin.getDefault().getBundle().getEntry("icons/obj16/error.gif");
        registry.put("ErrorImage", ImageDescriptor.createFromURL((URL)url));
        url = UIPlugin.getDefault().getBundle().getEntry("icons/obj16/refresh.gif");
        registry.put("RefreshImage", ImageDescriptor.createFromURL((URL)url));
    }

    public static Image getImage(String key) {
        return UIPlugin.getDefault().getImageRegistry().get(key);
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        return UIPlugin.getDefault().getImageRegistry().getDescriptor(key);
    }

    public static Image getSharedImage(AbstractImageDescriptor descriptor) {
        String imageKey;
        ImageRegistry registry = UIPlugin.getDefault().getImageRegistry();
        Image image = registry.get(imageKey = descriptor.getDecriptorKey());
        if (image == null) {
            registry.put(imageKey, (ImageDescriptor)descriptor);
            image = registry.get(imageKey);
        }
        return image;
    }

    public static boolean isAutoSaving() {
        IPreferenceStore preferenceStore = UIPlugin.getDefault().getPreferenceStore();
        boolean autoSaving = preferenceStore.getBoolean("PrefAutoSaving");
        return autoSaving;
    }

    public static boolean isExpandedPersisted() {
        IPreferenceStore preferenceStore = UIPlugin.getDefault().getPreferenceStore();
        boolean persisted = preferenceStore.getBoolean("PrefExpandedPersisted");
        return persisted;
    }

    public static boolean isInPlaceEditor() {
        IPreferenceStore preferenceStore = UIPlugin.getDefault().getPreferenceStore();
        boolean inPlaceEditor = preferenceStore.getBoolean("PrefRenamingInPlaceEditor");
        return inPlaceEditor;
    }

    public static boolean isCopyPermission() {
        IPreferenceStore preferenceStore = UIPlugin.getDefault().getPreferenceStore();
        boolean copyPermission = preferenceStore.getBoolean("PrefCopyPermission");
        return copyPermission;
    }

    public static boolean isCopyOwnership() {
        IPreferenceStore preferenceStore = UIPlugin.getDefault().getPreferenceStore();
        boolean copyOwnership = preferenceStore.getBoolean("PrefCopyOwnership");
        return copyOwnership;
    }
}

