/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.ui.internal.search;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tcf.te.tcf.filesystem.core.model.FSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.search.DateValidator;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.search.FSBaseSearchable;
import org.eclipse.tcf.te.tcf.filesystem.ui.nls.Messages;
import org.eclipse.tcf.te.ui.controls.BaseEditBrowseTextControl;
import org.eclipse.tcf.te.ui.controls.validator.Validator;
import org.eclipse.tcf.te.ui.search.TreeViewerSearchDialog;

public class FSModifiedSearchable
extends FSBaseSearchable {
    private static final int OPTION_NOT_REMEMBER = 0;
    private static final int OPTION_LAST_WEEK = 1;
    private static final int OPTION_LAST_MONTH = 2;
    private static final int OPTION_LAST_YEAR = 3;
    private static final int OPTION_SPECIFIED = 4;
    private static final long SECOND = 1000L;
    private static final long MINUTE = 60000L;
    private static final long HOUR = 3600000L;
    private static final long DAY = 86400000L;
    private static final long WEEK = 604800000L;
    private static final long MONTH = 2592000000L;
    private static final long YEAR = 31536000000L;
    private int choice;
    private long fromTime;
    private long toTime;
    private Button fBtnLmNotRem;
    private Button fBtnLmLastWeek;
    private Button fBtnLmPastMonth;
    private Button fBtnLmPastYear;
    private Button fBtnLmSpecified;
    private BaseEditBrowseTextControl txtLmFrom;
    private BaseEditBrowseTextControl txtLmTo;

    public void createAdvancedPart(TreeViewerSearchDialog dialog, Composite parent) {
        SelectionAdapter l = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FSModifiedSearchable.this.optionChecked(e);
            }
        };
        Composite modifiedComp = this.createSection(parent, Messages.FSModifiedSearchable_WhenModified);
        modifiedComp.setLayout((Layout)new GridLayout(4, false));
        this.fBtnLmNotRem = new Button(modifiedComp, 16);
        this.fBtnLmNotRem.setText(Messages.FSModifiedSearchable_DontRemember);
        this.fBtnLmNotRem.setSelection(true);
        GridData data = new GridData();
        data.horizontalSpan = 4;
        this.fBtnLmNotRem.setLayoutData((Object)data);
        this.fBtnLmNotRem.addSelectionListener((SelectionListener)l);
        this.fBtnLmLastWeek = new Button(modifiedComp, 16);
        this.fBtnLmLastWeek.setText(Messages.FSModifiedSearchable_LastWeek);
        data = new GridData();
        data.horizontalSpan = 4;
        this.fBtnLmLastWeek.setLayoutData((Object)data);
        this.fBtnLmLastWeek.addSelectionListener((SelectionListener)l);
        this.fBtnLmPastMonth = new Button(modifiedComp, 16);
        this.fBtnLmPastMonth.setText(Messages.FSModifiedSearchable_PastMonth);
        data = new GridData();
        data.horizontalSpan = 4;
        this.fBtnLmPastMonth.setLayoutData((Object)data);
        this.fBtnLmPastMonth.addSelectionListener((SelectionListener)l);
        this.fBtnLmPastYear = new Button(modifiedComp, 16);
        this.fBtnLmPastYear.setText(Messages.FSModifiedSearchable_PastYear);
        data = new GridData();
        data.horizontalSpan = 4;
        this.fBtnLmPastYear.setLayoutData((Object)data);
        this.fBtnLmPastYear.addSelectionListener((SelectionListener)l);
        this.fBtnLmSpecified = new Button(modifiedComp, 16);
        this.fBtnLmSpecified.setText(Messages.FSModifiedSearchable_SpecifyDates);
        data = new GridData();
        this.fBtnLmSpecified.setLayoutData((Object)data);
        this.fBtnLmSpecified.addSelectionListener((SelectionListener)l);
        Composite cmpFrom = new Composite(modifiedComp, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        cmpFrom.setLayout((Layout)layout);
        data = new GridData();
        cmpFrom.setLayoutData((Object)data);
        this.txtLmFrom = new BaseEditBrowseTextControl(null);
        this.txtLmFrom.setIsGroup(false);
        this.txtLmFrom.setHasHistory(false);
        this.txtLmFrom.setHideBrowseButton(true);
        this.txtLmFrom.setParentControlIsInnerPanel(true);
        this.txtLmFrom.setupPanel(cmpFrom);
        this.txtLmFrom.setEnabled(false);
        this.txtLmFrom.setEditFieldValidator((Validator)new DateValidator());
        Text text = (Text)this.txtLmFrom.getEditFieldControl();
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FSModifiedSearchable.this.datesModified();
            }
        });
        Label label = new Label(modifiedComp, 0);
        label.setText(Messages.FSModifiedSearchable_ToDate);
        Composite cmpTo = new Composite(modifiedComp, 0);
        layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        cmpTo.setLayout((Layout)layout);
        data = new GridData();
        cmpTo.setLayoutData((Object)data);
        this.txtLmTo = new BaseEditBrowseTextControl(null);
        this.txtLmTo.setIsGroup(false);
        this.txtLmTo.setHasHistory(false);
        this.txtLmTo.setHideBrowseButton(true);
        this.txtLmTo.setParentControlIsInnerPanel(true);
        this.txtLmTo.setupPanel(cmpTo);
        this.txtLmTo.setEnabled(false);
        this.txtLmTo.setEditFieldValidator((Validator)new DateValidator());
        text = (Text)this.txtLmTo.getEditFieldControl();
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FSModifiedSearchable.this.datesModified();
            }
        });
    }

    protected void datesModified() {
        this.fireOptionChanged();
    }

    public boolean isInputValid() {
        if (this.choice == 4 && this.txtLmFrom != null && this.txtLmTo != null) {
            boolean vFrom = this.txtLmFrom.isValid();
            boolean vTo = this.txtLmTo.isValid();
            if (vFrom) {
                String fromText = this.txtLmFrom.getEditFieldControlText().trim();
                this.fromTime = DateValidator.parseTimeInMillis(fromText);
            }
            if (vTo) {
                String toText = this.txtLmTo.getEditFieldControlText().trim();
                this.toTime = DateValidator.parseTimeInMillis(toText);
            }
            return vFrom && vTo;
        }
        return true;
    }

    protected void optionChecked(SelectionEvent e) {
        Object src = e.getSource();
        boolean specified = false;
        if (src == this.fBtnLmNotRem) {
            this.choice = 0;
        } else if (src == this.fBtnLmLastWeek) {
            this.choice = 1;
        } else if (src == this.fBtnLmPastMonth) {
            this.choice = 2;
        } else if (src == this.fBtnLmPastYear) {
            this.choice = 3;
        } else if (src == this.fBtnLmSpecified) {
            this.choice = 4;
            specified = true;
        }
        if (this.txtLmFrom != null) {
            this.txtLmFrom.setEnabled(specified);
        }
        if (this.txtLmTo != null) {
            this.txtLmTo.setEnabled(specified);
        }
        this.fireOptionChanged();
    }

    public boolean match(Object element) {
        if (element instanceof FSTreeNode) {
            FSTreeNode node = (FSTreeNode)element;
            long now = System.currentTimeMillis();
            switch (this.choice) {
                case 0: {
                    return true;
                }
                case 1: {
                    return node.attr.mtime > now - 604800000L;
                }
                case 2: {
                    return node.attr.mtime > now - 2592000000L;
                }
                case 3: {
                    return node.attr.mtime > now - 31536000000L;
                }
                case 4: {
                    return node.attr.mtime >= this.fromTime && node.attr.mtime < this.toTime;
                }
            }
        }
        return false;
    }
}

