/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.ui.internal.search;

import org.eclipse.tcf.te.tcf.filesystem.core.model.FSTreeNode;
import org.eclipse.tcf.te.ui.interfaces.ISearchMatcher;
import org.eclipse.tcf.te.ui.utils.StringMatcher;

public class FSTreeNodeMatcher
implements ISearchMatcher {
    private boolean fCaseSensitive;
    private boolean fMatchPrecise;
    private StringMatcher fStringMatcher;
    private int fTargetType;
    private String fTargetName;
    private boolean fIncludeSystem;
    private boolean fIncludeHidden;

    public FSTreeNodeMatcher(boolean caseSensitive, boolean matchPrecise, int targetType, String targetName, boolean includeSystem, boolean includeHidden) {
        this.fCaseSensitive = caseSensitive;
        this.fTargetName = targetName;
        this.fMatchPrecise = matchPrecise;
        if (!this.fMatchPrecise) {
            this.fStringMatcher = new StringMatcher(this.fTargetName, !this.fCaseSensitive, false);
        }
        this.fTargetType = targetType;
        this.fIncludeSystem = includeSystem;
        this.fIncludeHidden = includeHidden;
    }

    public boolean match(Object context) {
        if (context == null) {
            return false;
        }
        if (context instanceof FSTreeNode) {
            FSTreeNode node = (FSTreeNode)context;
            if (this.fTargetType == 1 && !node.isFile() || this.fTargetType == 2 && !node.isDirectory()) {
                return false;
            }
            if (!this.fIncludeSystem && node.isSystem()) {
                return false;
            }
            if (!this.fIncludeHidden && node.isHidden()) {
                return false;
            }
            String text = node.name;
            if (text != null) {
                if (this.fMatchPrecise) {
                    return this.fCaseSensitive ? text.equals(this.fTargetName) : text.equalsIgnoreCase(this.fTargetName);
                }
                return this.fStringMatcher.match(text);
            }
        }
        return false;
    }
}

