/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.ui.internal.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.OpCreate;
import org.eclipse.tcf.te.tcf.filesystem.core.model.FSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.wizards.NewNodeWizardPage;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.wizards.TargetSelectionPage;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.ui.views.editor.pages.AbstractTreeViewerExplorerEditorPage;
import org.eclipse.tcf.te.ui.wizards.AbstractWizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.navigator.CommonNavigator;

public abstract class NewNodeWizard
extends AbstractWizard
implements INewWizard {
    private FSTreeNode folder;
    private IPeerNode peer;
    private NewNodeWizardPage newPage;

    public NewNodeWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        super.init(workbench, selection);
        this.setWindowTitle(this.getTitle());
        if (!selection.isEmpty()) {
            Object element = selection.getFirstElement();
            if (element instanceof FSTreeNode) {
                this.folder = (FSTreeNode)element;
                if (this.folder.isFile()) {
                    this.folder = this.folder.getParent();
                }
                this.peer = this.folder.peerNode;
            } else if (element instanceof IPeerNode && this.hasFileSystem((IPeerNode)element)) {
                this.peer = (IPeerNode)element;
            }
        }
    }

    public boolean hasFileSystem(final IPeerNode peer) {
        if (Protocol.isDispatchThread()) {
            String services = null;
            services = peer.getStringProperty("services.remote");
            if (services != null) {
                String[] stringArray = services.split(",");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String service = stringArray[n2];
                    if (service != null && service.trim().equals("FileSystem")) {
                        return true;
                    }
                    ++n2;
                }
            }
            return false;
        }
        final boolean[] result = new boolean[1];
        Protocol.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                result[0] = NewNodeWizard.this.hasFileSystem(peer);
            }
        });
        return result[0];
    }

    public void addPages() {
        if (this.peer == null) {
            this.addPage((IWizardPage)new TargetSelectionPage());
        }
        this.newPage = this.createWizardPage();
        this.addPage((IWizardPage)this.newPage);
    }

    public boolean performFinish() {
        if (this.newPage != null) {
            this.newPage.saveWidgetValues();
            String name = this.newPage.getNodeName();
            FSTreeNode dest = this.newPage.getInputDir();
            final OpCreate create = this.getCreateOp(dest, name);
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    create.run(monitor);
                }
            };
            try {
                this.getContainer().run(false, false, runnable);
                final FSTreeNode newNode = create.getNode();
                this.getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        NewNodeWizard.this.selectNewNode(newNode);
                    }
                });
                return true;
            }
            catch (InvocationTargetException e) {
                this.newPage.setErrorMessage(e.getMessage());
            }
            catch (InterruptedException interruptedException) {}
        }
        return false;
    }

    void selectNewNode(FSTreeNode node) {
        TreeViewer viewer = this.getFocusedViewer();
        if (viewer != null) {
            viewer.refresh((Object)this.folder);
            StructuredSelection selection = new StructuredSelection((Object)node);
            viewer.setSelection((ISelection)selection, true);
        }
    }

    TreeViewer getFocusedViewer() {
        IWorkbenchPage page;
        IWorkbenchWindow window;
        IWorkbenchWindow iWorkbenchWindow = window = this.getWorkbench() != null ? this.getWorkbench().getActiveWorkbenchWindow() : null;
        if (window != null && (page = window.getActivePage()) != null) {
            IWorkbenchPart part = page.getActivePart();
            if (part instanceof FormEditor) {
                FormEditor formEditor = (FormEditor)part;
                IFormPage formPage = formEditor.getActivePageInstance();
                if (formPage instanceof AbstractTreeViewerExplorerEditorPage) {
                    AbstractTreeViewerExplorerEditorPage viewerPage = (AbstractTreeViewerExplorerEditorPage)formPage;
                    return (TreeViewer)viewerPage.getTreeControl().getViewer();
                }
            } else if (part instanceof CommonNavigator) {
                CommonNavigator navigator = (CommonNavigator)part;
                return navigator.getCommonViewer();
            }
        }
        return null;
    }

    protected abstract NewNodeWizardPage createWizardPage();

    protected abstract OpCreate getCreateOp(FSTreeNode var1, String var2);

    protected abstract String getTitle();

    public IPeerNode getPeer() {
        return this.peer;
    }

    public void setPeer(IPeerNode peer) {
        this.peer = peer;
        this.newPage.setPeer(peer);
    }

    public FSTreeNode getFolder() {
        return this.folder;
    }
}

