/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.locator.nodes;

import java.util.EventObject;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.core.utils.ConnectStateHelper;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.concurrent.util.ExecutorsUtil;
import org.eclipse.tcf.te.runtime.events.EventManager;
import org.eclipse.tcf.te.runtime.events.NotifyEvent;
import org.eclipse.tcf.te.runtime.interfaces.IConditionTester;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.model.ContainerModelNode;
import org.eclipse.tcf.te.runtime.properties.PropertiesContainer;
import org.eclipse.tcf.te.runtime.services.ServiceManager;
import org.eclipse.tcf.te.runtime.services.interfaces.IDelegateService;
import org.eclipse.tcf.te.runtime.services.interfaces.IService;
import org.eclipse.tcf.te.runtime.services.interfaces.ISimulatorService;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IStepperOperationService;
import org.eclipse.tcf.te.runtime.stepper.utils.StepperHelper;
import org.eclipse.tcf.te.runtime.utils.StatusHelper;
import org.eclipse.tcf.te.tcf.locator.activator.CoreBundleActivator;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNodeProvider;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.IPeerModelUpdateService;
import org.eclipse.tcf.te.tcf.locator.nls.Messages;
import org.eclipse.tcf.te.tcf.locator.utils.SimulatorUtils;
import org.osgi.framework.Bundle;

public class PeerNode
extends ContainerModelNode
implements IPeerNode,
IPeerNodeProvider {
    private final IPeerModel model;
    private String peerId;
    private boolean isValid = true;

    public PeerNode(IPeerModel model, IPeer peer) {
        Assert.isNotNull((Object)model);
        this.model = model;
        Assert.isNotNull((Object)peer);
        this.setProperty("instance", peer);
        this.setProperty("connectState", 1);
        this.peerId = peer.getID();
        Assert.isNotNull((Object)this.peerId);
        this.allowSetParentOnNonNullParent = true;
        this.suppressEventsOnNullParent = false;
        this.setChangeEventsEnabled(true);
    }

    @Override
    public IPeerNode getPeerNode() {
        return this;
    }

    protected final boolean checkThreadAccess() {
        return Protocol.isDispatchThread();
    }

    @Override
    public IPeerModel getModel() {
        return (IPeerModel)this.getAdapter(IPeerModel.class);
    }

    @Override
    public IPeer getPeer() {
        return (IPeer)this.getAdapter(IPeer.class);
    }

    @Override
    public String getPeerId() {
        return this.peerId;
    }

    public String getName() {
        return this.getPeer().getName();
    }

    @Override
    public boolean isValid() {
        IService[] services;
        AtomicBoolean valid = new AtomicBoolean(true);
        IService[] iServiceArray = services = ServiceManager.getInstance().getServices((Object)this, IDelegateService.class, false);
        int n = services.length;
        int n2 = 0;
        while (n2 < n) {
            IPeerNode.IDelegate delegate;
            IService service = iServiceArray[n2];
            if (service instanceof IDelegateService && (delegate = (IPeerNode.IDelegate)((IDelegateService)service).getDelegate((Object)this, IPeerNode.IDelegate.class)) != null && delegate.isVisible(this) && !delegate.isValid(this)) {
                valid.set(false);
                break;
            }
            ++n2;
        }
        if (this.isValid != valid.get()) {
            this.isValid = valid.get();
            this.fireChangeEvent("valid", new Boolean(this.isValid), new Boolean(valid.get()));
        }
        return this.isValid;
    }

    public Object getAdapter(final Class adapter) {
        final AtomicReference object = new AtomicReference();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                object.set(PeerNode.this.doGetAdapter(adapter));
            }
        };
        if (Protocol.isDispatchThread()) {
            runnable.run();
        } else {
            Protocol.invokeAndWait((Runnable)runnable);
        }
        return object.get() != null ? object.get() : super.getAdapter(adapter);
    }

    protected Object doGetAdapter(Class<?> adapter) {
        Assert.isTrue((boolean)this.checkThreadAccess(), (String)"Illegal Thread Access");
        if (IPeerModel.class.isAssignableFrom(adapter)) {
            return this.model;
        }
        Object peer = this.getProperty("instance");
        if (peer != null && adapter.isAssignableFrom(peer.getClass())) {
            return peer;
        }
        return null;
    }

    public String toString() {
        final StringBuilder buffer = new StringBuilder(this.getClass().getSimpleName());
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                IPeer peer = PeerNode.this.getPeer();
                buffer.append(": id=" + peer.getID());
                buffer.append(", name=" + peer.getName());
            }
        };
        if (Protocol.isDispatchThread()) {
            runnable.run();
        } else {
            Protocol.invokeAndWait((Runnable)runnable);
        }
        buffer.append(", " + super.toString());
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof PeerNode) {
            return this.getPeerId().equals(((PeerNode)obj).getPeerId());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.getPeerId().hashCode();
    }

    protected void postSetProperties(Map<String, ?> properties) {
        Assert.isTrue((boolean)this.checkThreadAccess(), (String)"Illegal Thread Access");
        Assert.isNotNull(properties);
        Assert.isNotNull((Object)this.getPeer());
        this.peerId = this.getPeer().getID();
        Assert.isNotNull((Object)this.peerId);
        super.postSetProperties(properties);
    }

    public void postSetProperty(String key, Object value, Object oldValue) {
        Assert.isTrue((boolean)this.checkThreadAccess(), (String)"Illegal Thread Access");
        Assert.isNotNull((Object)key);
        Assert.isNotNull((Object)this.getPeer());
        if ("instance".equals(key)) {
            this.peerId = this.getPeer().getID();
            Assert.isNotNull((Object)this.peerId);
        }
        super.postSetProperty(key, value, oldValue);
    }

    public boolean isVisible() {
        IService[] services;
        boolean visible;
        IPeer peer = this.getPeer();
        boolean bl = visible = peer != null && peer.getAttributes().containsKey("Visible") ? Boolean.valueOf((String)peer.getAttributes().get("Visible")) : true;
        if (visible && (services = ServiceManager.getInstance().getServices((Object)this, IDelegateService.class, false)) != null && services.length > 0) {
            IService[] iServiceArray = services;
            int n = services.length;
            int n2 = 0;
            while (n2 < n) {
                IPeerNode.IDelegate delegate;
                IService service = iServiceArray[n2];
                if (service instanceof IDelegateService && (delegate = (IPeerNode.IDelegate)((IDelegateService)service).getDelegate((Object)this, IPeerNode.IDelegate.class)) != null) {
                    return delegate.isVisible(this);
                }
                ++n2;
            }
        }
        return visible;
    }

    public int getConnectState() {
        final AtomicInteger state = new AtomicInteger(0);
        Protocol.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                if (PeerNode.this.getProperty("connectState") != null) {
                    state.set(PeerNode.this.getIntProperty("connectState"));
                }
            }
        });
        return state.get();
    }

    @Override
    public String getPeerType() {
        final AtomicReference type = new AtomicReference();
        Protocol.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                type.set((String)PeerNode.this.getPeer().getAttributes().get("Type"));
            }
        });
        return (String)type.get();
    }

    public boolean setConnectState(final int newState) {
        final AtomicBoolean result = new AtomicBoolean(false);
        if (this.isConnectStateChangeAllowed(newState)) {
            Protocol.invokeAndWait((Runnable)new Runnable(){

                @Override
                public void run() {
                    result.set(PeerNode.this.setProperty("connectState", newState));
                }
            });
        }
        return result.get();
    }

    public void changeConnectState(int action, ICallback callback, IProgressMonitor monitor) throws IllegalArgumentException {
        int oldState = this.getConnectState();
        if (!this.isConnectStateChangeActionAllowed(action)) {
            IllegalArgumentException e = new IllegalArgumentException("Cannot change state from '" + ConnectStateHelper.getConnectState((int)oldState) + "' using action '" + ConnectStateHelper.getConnectState((int)action) + "'.");
            if (callback != null) {
                callback.done((Object)this, StatusHelper.getStatus((Throwable)e));
            } else {
                throw e;
            }
        }
        String operation = null;
        int intermediateState = 0;
        switch (action) {
            case 11: {
                operation = "connect";
                intermediateState = -11;
                break;
            }
            case 1: {
                operation = "disconnect";
                intermediateState = -1;
                break;
            }
            case 21: {
                operation = "connectionLost";
                intermediateState = 21;
                break;
            }
            case -21: {
                operation = "connectionRecovering";
                intermediateState = -21;
            }
        }
        IStepperOperationService service = StepperHelper.getService((Object)this, (String)operation);
        if (service != null) {
            this.setConnectState(intermediateState);
            StepperHelper.scheduleStepperJob((Object)this, (String)operation, (IStepperOperationService)service, (IPropertiesContainer)new PropertiesContainer(), (ICallback)callback, (IProgressMonitor)monitor);
        } else if (callback != null) {
            callback.done((Object)this, StatusHelper.getStatus((Throwable)new NullPointerException("Missing stepper operation service for " + this.getName() + ".")));
        }
    }

    public boolean isConnectStateChangeActionAllowed(int action) {
        int state = this.getConnectState();
        switch (state) {
            case 11: {
                return this.isAllowedStateOrAction(action, 1, 21);
            }
            case -21: 
            case -12: 
            case -11: {
                return this.isAllowedStateOrAction(action, 1);
            }
            case 1: {
                return this.isValid() && this.isAllowedStateOrAction(action, 11);
            }
            case 21: {
                return this.isAllowedStateOrAction(action, -21);
            }
        }
        return false;
    }

    public boolean isConnectStateChangeAllowed(int newState) {
        int state = this.getConnectState();
        switch (state) {
            case 21: {
                return this.isAllowedStateOrAction(newState, -21);
            }
            case -21: {
                return this.isAllowedStateOrAction(newState, 11, -1, -2, 1);
            }
            case 11: {
                return this.isAllowedStateOrAction(newState, 21, 1, -1, -2);
            }
            case -11: {
                return this.isAllowedStateOrAction(newState, -12, 11, 1, -1, -2);
            }
            case -12: {
                return this.isAllowedStateOrAction(newState, 11, -1, -2, 1);
            }
            case 1: {
                return this.isAllowedStateOrAction(newState, 11, -11, -12);
            }
            case -1: {
                return this.isAllowedStateOrAction(newState, -2, 1);
            }
            case -2: {
                return this.isAllowedStateOrAction(newState, 1);
            }
            case 0: {
                return this.isAllowedStateOrAction(newState, 1);
            }
        }
        return false;
    }

    private boolean isAllowedStateOrAction(int stateOrAction, int ... allowedStatesOrActions) {
        int[] nArray = allowedStatesOrActions;
        int n = allowedStatesOrActions.length;
        int n2 = 0;
        while (n2 < n) {
            int allowedStateOrAction = nArray[n2];
            if (stateOrAction == allowedStateOrAction) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void onChannelOpened() {
    }

    public void onChannelClosed(Throwable error) {
        final AtomicBoolean connectionLost = new AtomicBoolean(true);
        if (SimulatorUtils.getSimulatorService(this) != null) {
            ExecutorsUtil.waitAndExecute((long)1000L, (IConditionTester)new IConditionTester(){

                public boolean isConditionFulfilled() {
                    Protocol.invokeAndWait((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            Object simProcess = PeerNode.this.getProperty(ISimulatorService.PROP_SIM_INSTANCE);
                            if (simProcess instanceof Process) {
                                try {
                                    ((Process)simProcess).exitValue();
                                    connectionLost.set(false);
                                }
                                catch (Exception exception) {}
                            } else {
                                connectionLost.set(false);
                            }
                        }
                    });
                    return !connectionLost.get();
                }

                public void cleanup() {
                }
            });
        }
        if (connectionLost.get() && this.isConnectStateChangeActionAllowed(21)) {
            Platform.getLog((Bundle)CoreBundleActivator.getDefault().getBundle()).log((IStatus)new Status(1, CoreBundleActivator.getUniqueIdentifier(), NLS.bind((String)Messages.PeerNode_info_connectionLost, (Object)this.getName())));
            this.changeConnectState(21, (ICallback)new Callback(){

                protected void internalDone(Object caller, IStatus status) {
                    Protocol.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            IPeerModelUpdateService service = PeerNode.this.getModel().getService(IPeerModelUpdateService.class);
                            service.updatePeerServices(PeerNode.this, null, null);
                        }
                    });
                    PeerNode.this.fireNotification(PeerNode.this.getConnectState());
                    if (status.isOK() && PeerNode.this.isConnectStateChangeAllowed(-21)) {
                        PeerNode.this.changeConnectState(-21, (ICallback)new Callback(){

                            protected void internalDone(Object caller, IStatus status) {
                                if (status.isOK()) {
                                    PeerNode.this.fireNotification(-21);
                                }
                            }
                        }, null);
                    }
                }
            }, null);
        } else if (this.isConnectStateChangeActionAllowed(1)) {
            Platform.getLog((Bundle)CoreBundleActivator.getDefault().getBundle()).log((IStatus)new Status(1, CoreBundleActivator.getUniqueIdentifier(), NLS.bind((String)Messages.PeerNode_info_connectionDisconnected, (Object)this.getName())));
            this.changeConnectState(1, (ICallback)new Callback(){

                protected void internalDone(Object caller, IStatus status) {
                    Protocol.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            IPeerModelUpdateService service = PeerNode.this.getModel().getService(IPeerModelUpdateService.class);
                            service.updatePeerServices(PeerNode.this, null, null);
                            PeerNode.this.fireNotification(1);
                        }
                    });
                }
            }, null);
        } else {
            Protocol.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    IPeerModelUpdateService service = PeerNode.this.getModel().getService(IPeerModelUpdateService.class);
                    service.updatePeerServices(PeerNode.this, null, null);
                }
            });
        }
    }

    protected void fireNotification(int state) {
        String message = null;
        switch (state) {
            case 21: {
                message = Messages.PeerNode_notification_message_connectionLost;
                break;
            }
            case -21: {
                message = Messages.PeerNode_notification_message_connectionRecovered;
                break;
            }
            case 1: {
                message = Messages.PeerNode_notification_message_disconnected;
            }
        }
        if (message != null) {
            PropertiesContainer properties = new PropertiesContainer();
            properties.setProperty("titleText", (Object)this.getName());
            properties.setProperty("titleImageId", (Object)this.getPeerType());
            properties.setProperty("descriptionText", (Object)message);
            NotifyEvent event = new NotifyEvent((Object)this.getModel(), null, (IPropertiesContainer)properties);
            EventManager.getInstance().fireEvent((EventObject)event);
        }
    }

    public void congestionLevel(int level) {
    }
}

