/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.processes.ui.editor.tree.columns;

import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.core.runtime.Assert;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.services.ServiceManager;
import org.eclipse.tcf.te.runtime.services.interfaces.IUIService;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.processes.core.model.interfaces.IPendingOperationNode;
import org.eclipse.tcf.te.tcf.processes.core.model.interfaces.IProcessContextNode;
import org.eclipse.tcf.te.tcf.processes.core.model.interfaces.runtime.IRuntimeModel;
import org.eclipse.tcf.te.tcf.processes.ui.interfaces.IProcessMonitorUIDelegate;
import org.eclipse.tcf.te.tcf.processes.ui.navigator.runtime.AbstractLabelProviderDelegate;

public class PPIDLabelProvider
extends AbstractLabelProviderDelegate {
    public String getText(Object element) {
        if (element instanceof IRuntimeModel || element instanceof IPendingOperationNode) {
            return "";
        }
        if (element instanceof IProcessContextNode) {
            final IProcessContextNode node = (IProcessContextNode)element;
            final AtomicLong ppid = new AtomicLong();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ppid.set(node.getSysMonitorContext().getPPID());
                }
            };
            Assert.isTrue((!Protocol.isDispatchThread() ? 1 : 0) != 0);
            Protocol.invokeAndWait((Runnable)runnable);
            String id = ppid.get() >= 0L ? Long.toString(ppid.get()) : "";
            IPeerNode peerNode = (IPeerNode)node.getAdapter(IPeerNode.class);
            IUIService service = peerNode != null ? (IUIService)ServiceManager.getInstance().getService((Object)peerNode, IUIService.class) : null;
            IProcessMonitorUIDelegate delegate = service != null ? (IProcessMonitorUIDelegate)service.getDelegate((Object)peerNode, IProcessMonitorUIDelegate.class) : null;
            String newId = delegate != null ? delegate.getText(element, "PPID", id) : null;
            return newId != null ? newId : id;
        }
        return "";
    }
}

