/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.processes.ui.handler;

import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.model.interfaces.IModelNode;
import org.eclipse.tcf.te.runtime.services.ServiceManager;
import org.eclipse.tcf.te.runtime.services.interfaces.IUIService;
import org.eclipse.tcf.te.runtime.statushandler.StatusHandlerUtil;
import org.eclipse.tcf.te.tcf.core.model.interfaces.IModel;
import org.eclipse.tcf.te.tcf.core.model.interfaces.services.IModelRefreshService;
import org.eclipse.tcf.te.tcf.core.model.interfaces.services.IModelUpdateService;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.processes.core.model.interfaces.IProcessContextNode;
import org.eclipse.tcf.te.tcf.processes.core.model.interfaces.runtime.IRuntimeModel;
import org.eclipse.tcf.te.tcf.processes.core.model.steps.TerminateStep;
import org.eclipse.tcf.te.tcf.processes.ui.help.IContextHelpIds;
import org.eclipse.tcf.te.tcf.processes.ui.interfaces.IProcessMonitorUIDelegate;
import org.eclipse.tcf.te.tcf.processes.ui.nls.Messages;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;

public class TerminateHandler
extends AbstractHandler
implements IElementUpdater {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            for (Object candidate : (IStructuredSelection)selection) {
                if (!(candidate instanceof IProcessContextNode)) continue;
                final IProcessContextNode process = (IProcessContextNode)candidate;
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        TerminateStep step = new TerminateStep();
                        step.executeTerminate(process, (ICallback)new Callback(){

                            protected void internalDone(Object caller, IStatus status) {
                                if (status.getSeverity() != 4) {
                                    IModel model = (IModel)process.getParent(IModel.class);
                                    Assert.isNotNull((Object)model);
                                    ((IModelUpdateService)model.getService(IModelUpdateService.class)).remove((IModelNode)process);
                                } else {
                                    final IStatus realStatus = status;
                                    IModel model = (IModel)process.getParent(IModel.class);
                                    Assert.isNotNull((Object)model);
                                    ((IModelRefreshService)model.getService(IModelRefreshService.class)).refresh((IModelNode)process, (ICallback)new Callback(){

                                        protected void internalDone(Object caller, IStatus status) {
                                            IPeerNode node = ((IRuntimeModel)process.getParent(IRuntimeModel.class)).getPeerNode();
                                            IUIService service = (IUIService)ServiceManager.getInstance().getService((Object)node, IUIService.class);
                                            IProcessMonitorUIDelegate delegate = service != null ? (IProcessMonitorUIDelegate)service.getDelegate((Object)node, IProcessMonitorUIDelegate.class) : null;
                                            String text = delegate != null ? delegate.getMessage("TerminateHandler_terminateFailed") : null;
                                            String template = NLS.bind((String)(text != null ? text : Messages.TerminateHandler_terminateFailed), (Object)process.getName(), (Object)Messages.PossibleCause);
                                            StatusHandlerUtil.handleStatus((IStatus)realStatus, (Object)process, (String)template, null, (String)IContextHelpIds.MESSAGE_TERMINATE_FAILED, (Object)((Object)TerminateHandler.this), null);
                                        }
                                    });
                                }
                            }
                        });
                    }
                };
                Protocol.invokeLater((Runnable)runnable);
            }
        }
        return null;
    }

    public void updateElement(UIElement element, Map parameters) {
        IWorkbenchPart part;
        IWorkbenchPartSite site = (IWorkbenchPartSite)parameters.get("org.eclipse.ui.part.IWorkbenchPartSite");
        if (site != null && (part = site.getPart()) instanceof IEditorPart) {
            IProcessMonitorUIDelegate delegate;
            IEditorInput editorInput = ((IEditorPart)part).getEditorInput();
            IPeerNode node = editorInput != null ? (IPeerNode)editorInput.getAdapter(IPeerNode.class) : null;
            IUIService service = (IUIService)ServiceManager.getInstance().getService((Object)node, IUIService.class);
            IProcessMonitorUIDelegate iProcessMonitorUIDelegate = delegate = service != null ? (IProcessMonitorUIDelegate)service.getDelegate((Object)node, IProcessMonitorUIDelegate.class) : null;
            if (delegate != null) {
                String tooltip;
                String text = delegate.getMessage("TerminateHandler_updateElement_text");
                if (text != null) {
                    element.setText(text);
                }
                if ((tooltip = delegate.getMessage("TerminateHandler_updateElement_tooltip")) != null) {
                    element.setTooltip(tooltip);
                }
            }
        }
    }
}

