/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.notifications.internal.popup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tcf.te.runtime.events.NotifyEvent;
import org.eclipse.tcf.te.ui.notifications.internal.popup.NotificationPopup;
import org.eclipse.tcf.te.ui.notifications.nls.Messages;
import org.eclipse.ui.PlatformUI;

public class PopupNotificationSink {
    private static final long DELAY_OPEN = 1000L;
    private static final boolean runSystem = true;
    NotificationPopup popup;
    final List<NotifyEvent> cancelledNotifications = new ArrayList<NotifyEvent>();
    private final Set<NotifyEvent> notifications = new HashSet<NotifyEvent>();
    final Set<NotifyEvent> currentlyNotifying = Collections.synchronizedSet(this.notifications);
    private final Job openJob = new Job(Messages.PopupNotificationSink_Popup_Notifier_Job_Label){

        protected IStatus run(IProgressMonitor monitor) {
            try {
                if (Platform.isRunning() && PlatformUI.getWorkbench() != null && PlatformUI.getWorkbench().getDisplay() != null && !PlatformUI.getWorkbench().getDisplay().isDisposed()) {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            if ((this).PopupNotificationSink.this.popup != null && (this).PopupNotificationSink.this.popup.getReturnCode() == 1) {
                                List<NotifyEvent> notifications = (this).PopupNotificationSink.this.popup.getNotifications();
                                for (NotifyEvent notification : notifications) {
                                    if ((this).PopupNotificationSink.this.cancelledNotifications.contains(notification)) continue;
                                    (this).PopupNotificationSink.this.cancelledNotifications.add(notification);
                                }
                            }
                            Iterator<NotifyEvent> it = (this).PopupNotificationSink.this.currentlyNotifying.iterator();
                            while (it.hasNext()) {
                                NotifyEvent notification;
                                notification = it.next();
                                if (!(this).PopupNotificationSink.this.cancelledNotifications.contains(notification)) continue;
                                it.remove();
                            }
                            Class<PopupNotificationSink> clazz = PopupNotificationSink.class;
                            synchronized (PopupNotificationSink.class) {
                                if ((this).PopupNotificationSink.this.currentlyNotifying.size() > 0) {
                                    PopupNotificationSink.this.showPopup();
                                }
                                // ** MonitorExit[var1_1] (shouldn't be in output)
                                return;
                            }
                        }
                    });
                }
            }
            finally {
                if (PopupNotificationSink.this.popup != null) {
                    this.schedule(PopupNotificationSink.this.popup.getDelayClose() / 2L);
                }
            }
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            return Status.OK_STATUS;
        }
    };

    public PopupNotificationSink() {
        this.openJob.setSystem(true);
    }

    private void cleanNotified() {
        this.currentlyNotifying.clear();
    }

    public void notify(NotifyEvent[] events) {
        Assert.isNotNull((Object)events);
        this.currentlyNotifying.addAll(Arrays.asList(events));
        if (!this.openJob.cancel()) {
            try {
                this.openJob.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.openJob.schedule(1000L);
    }

    public void showPopup() {
        if (this.popup != null) {
            this.popup.close();
        }
        Shell shell = new Shell(PlatformUI.getWorkbench().getDisplay());
        this.popup = new NotificationPopup(shell);
        ArrayList<NotifyEvent> toDisplay = new ArrayList<NotifyEvent>(this.currentlyNotifying);
        Collections.sort(toDisplay);
        this.popup.setContents(toDisplay);
        this.cleanNotified();
        this.popup.setBlockOnOpen(false);
        this.popup.open();
    }
}

