/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.terminals.serial.launcher;

import java.text.DateFormat;
import java.util.Date;
import org.eclipse.core.runtime.Assert;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.services.ServiceManager;
import org.eclipse.tcf.te.runtime.services.interfaces.ITerminalService;
import org.eclipse.tcf.te.ui.controls.BaseDialogPageControl;
import org.eclipse.tcf.te.ui.terminals.interfaces.IConfigurationPanel;
import org.eclipse.tcf.te.ui.terminals.interfaces.IMementoHandler;
import org.eclipse.tcf.te.ui.terminals.launcher.AbstractLauncherDelegate;
import org.eclipse.tcf.te.ui.terminals.serial.controls.SerialWizardConfigurationPanel;
import org.eclipse.tcf.te.ui.terminals.serial.launcher.SerialMementoHandler;
import org.eclipse.tcf.te.ui.terminals.serial.nls.Messages;

public class SerialLauncherDelegate
extends AbstractLauncherDelegate {
    private final IMementoHandler mementoHandler = new SerialMementoHandler();

    public boolean needsUserConfiguration() {
        return true;
    }

    public IConfigurationPanel getPanel(BaseDialogPageControl parentControl) {
        return new SerialWizardConfigurationPanel(parentControl);
    }

    public void execute(IPropertiesContainer properties, ICallback callback) {
        ITerminalService terminal;
        Assert.isNotNull((Object)properties);
        String terminalTitle = this.getTerminalTitle(properties);
        if (terminalTitle != null) {
            properties.setProperty("title", (Object)terminalTitle);
        }
        if (!properties.containsKey("hasDisconnectButton")) {
            properties.setProperty("hasDisconnectButton", true);
        }
        if ((terminal = (ITerminalService)ServiceManager.getInstance().getService(ITerminalService.class)) != null) {
            terminal.openConsole(properties, callback);
        }
    }

    private String getTerminalTitle(IPropertiesContainer properties) {
        String port = properties.getStringProperty("serial.device");
        if (port != null) {
            DateFormat format = DateFormat.getDateTimeInstance(3, 3);
            String date = format.format(new Date(System.currentTimeMillis()));
            return NLS.bind((String)Messages.SerialLauncherDelegate_terminalTitle, (Object[])new String[]{port, date});
        }
        return Messages.SerialLauncherDelegate_terminalTitle_default;
    }

    public Object getAdapter(Class adapter) {
        if (IMementoHandler.class.equals((Object)adapter)) {
            return this.mementoHandler;
        }
        return super.getAdapter(adapter);
    }
}

