/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.rcp.databinding.xwt.model;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.xml.AbstractDocumentObject;
import org.eclipse.wb.internal.core.utils.xml.DocumentAttribute;
import org.eclipse.wb.internal.core.utils.xml.DocumentElement;
import org.eclipse.wb.internal.rcp.databinding.model.BindableInfo;
import org.eclipse.wb.internal.rcp.databinding.xwt.model.BindingInfo;
import org.eclipse.wb.internal.rcp.databinding.xwt.model.IDocumentEditor;
import org.eclipse.wb.internal.rcp.databinding.xwt.model.beans.XmlElementBeanBindableInfo;
import org.eclipse.wb.internal.rcp.databinding.xwt.model.widgets.WidgetBindableInfo;

public class ElementDocumentEditor
implements IDocumentEditor {
    private final BindingInfo m_binding;
    private final DocumentElement m_element;
    private final List<AttributeEditor> m_editors = Lists.newArrayList();

    public ElementDocumentEditor(BindingInfo binding, DocumentElement element) {
        this.m_binding = binding;
        this.m_element = element;
        this.m_editors.add(new AttributeEditor("ElementName"){

            protected String getValue() throws Exception {
                if (ElementDocumentEditor.this.m_binding.getModel() instanceof WidgetBindableInfo) {
                    WidgetBindableInfo model = (WidgetBindableInfo)ElementDocumentEditor.this.m_binding.getModel();
                    return model.getReference();
                }
                return null;
            }
        });
        this.m_editors.add(new AttributeEditor("Path"){

            protected String getValue() throws Exception {
                if (ElementDocumentEditor.this.m_binding.getModel() instanceof WidgetBindableInfo) {
                    return ElementDocumentEditor.this.m_binding.getModelProperty().getPresentation().getText();
                }
                BindableInfo modelProperty = (BindableInfo)ElementDocumentEditor.this.m_binding.getModelProperty();
                String property = StringUtils.remove((String)modelProperty.getReference(), (char)'\"');
                XmlElementBeanBindableInfo model = (XmlElementBeanBindableInfo)ElementDocumentEditor.this.m_binding.getModel();
                if (!model.isDataContext()) {
                    property = "{StaticResource " + property + "}";
                }
                return property;
            }
        });
        this.m_editors.add(new AttributeEditor("Mode"){

            protected String getValue() throws Exception {
                return ElementDocumentEditor.this.m_binding.getMode() == 0 ? null : BindingInfo.MODES[ElementDocumentEditor.this.m_binding.getMode()];
            }
        });
        this.m_editors.add(new AttributeEditor("UpdateSourceTrigger"){

            protected String getValue() throws Exception {
                return ElementDocumentEditor.this.m_binding.getTriger() == 0 ? null : BindingInfo.TRIGGERS[ElementDocumentEditor.this.m_binding.getTriger()];
            }
        });
    }

    public void add() throws Exception {
        throw new UnsupportedOperationException();
    }

    public void delete() throws Exception {
        this.m_binding.modify(new RunnableEx(){

            public void run() throws Exception {
                ElementDocumentEditor.this.m_element.remove();
            }
        });
    }

    public void update() throws Exception {
        boolean updates = false;
        for (AttributeEditor editor : this.m_editors) {
            updates |= editor.update();
        }
        updates |= this.m_binding.getConverter().update();
        if (updates |= this.m_binding.getValidator().update()) {
            this.m_binding.modify(new RunnableEx(){

                public void run() throws Exception {
                    for (AttributeEditor editor : ElementDocumentEditor.this.m_editors) {
                        editor.save();
                    }
                    ElementDocumentEditor.this.m_binding.getConverter().applyChanges((AbstractDocumentObject)ElementDocumentEditor.this.m_element);
                    ElementDocumentEditor.this.m_binding.getValidator().applyChanges((AbstractDocumentObject)ElementDocumentEditor.this.m_element);
                }
            });
        }
    }

    public int getDefinitionOffset() {
        return this.m_element.getOffset() + this.m_element.getTag().length() + 1;
    }

    private abstract class AttributeEditor {
        static final int ADD = 1;
        static final int REMOVE = 2;
        static final int UPDATE = 3;
        private final String m_name;
        private DocumentAttribute m_attribute;
        private boolean m_update;
        private String m_value;
        private int m_command;

        public AttributeEditor(String name) {
            this.m_name = name;
            for (DocumentAttribute attribute : ElementDocumentEditor.this.m_element.getDocumentAttributes()) {
                if (!name.equalsIgnoreCase(attribute.getName())) continue;
                this.m_attribute = attribute;
                break;
            }
        }

        public boolean update() throws Exception {
            this.m_value = this.getValue();
            if (this.m_attribute == null) {
                if (this.m_value == null) {
                    this.clear();
                } else {
                    this.m_update = true;
                    this.m_command = 1;
                }
            } else if (this.m_value == null) {
                this.m_update = true;
                this.m_command = 2;
            } else if (this.m_value.equals(this.m_attribute.getValue())) {
                this.clear();
            } else {
                this.m_update = true;
                this.m_command = 3;
            }
            return this.m_update;
        }

        public void save() throws Exception {
            if (this.m_update) {
                switch (this.m_command) {
                    case 1: {
                        this.m_attribute = ElementDocumentEditor.this.m_element.setAttribute(this.m_name, this.m_value);
                        break;
                    }
                    case 2: {
                        ElementDocumentEditor.this.m_element.removeDocumentAttribute(this.m_attribute);
                        this.m_attribute = null;
                        break;
                    }
                    case 3: {
                        this.m_attribute.setValue(this.m_value);
                    }
                }
                this.clear();
            }
        }

        private void clear() {
            this.m_update = false;
            this.m_command = 0;
            this.m_value = null;
        }

        protected abstract String getValue() throws Exception;
    }
}

