/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.model.layout.grid;

import java.util.List;
import org.eclipse.wb.core.model.AbstractComponentInfo;
import org.eclipse.wb.draw2d.geometry.Rectangle;
import org.eclipse.wb.internal.swt.model.layout.grid.GridDataInfo;
import org.eclipse.wb.internal.swt.model.layout.grid.GridLayoutInfo;
import org.eclipse.wb.internal.swt.model.util.surround.LayoutSurroundSupport;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GridLayoutSurroundSupport
extends LayoutSurroundSupport {
    static final String CELLS_KEY = "SurroundSupport_CELLS";
    private final GridLayoutInfo m_layout;
    private Rectangle m_enclosingCells;

    public GridLayoutSurroundSupport(GridLayoutInfo layout) {
        super(layout);
        this.m_layout = layout;
    }

    @Override
    protected boolean validateComponents(List<ControlInfo> components) throws Exception {
        if (!super.validateComponents(components)) {
            return false;
        }
        this.m_enclosingCells = GridLayoutSurroundSupport.getCells(components.get(0));
        for (ControlInfo component : components) {
            this.m_enclosingCells.union(GridLayoutSurroundSupport.getCells(component));
        }
        for (ControlInfo control : this.m_layout.getControls()) {
            if (components.contains(control) || this.m_layout.isFiller(control) || !this.m_enclosingCells.intersects(GridLayoutSurroundSupport.getCells(control))) continue;
            return false;
        }
        return true;
    }

    protected void addContainer(CompositeInfo container, List<ControlInfo> components) throws Exception {
        container.putArbitraryValue(CELLS_KEY, this.m_enclosingCells);
        int targetRow = this.m_layout.getRows().size();
        this.m_layout.command_CREATE(container, 0, false, targetRow, false);
        this.m_layout.setRemoveEmptyColumnsRows(false);
    }

    protected void moveDone(CompositeInfo container, List<ControlInfo> components) throws Exception {
        super.moveDone((AbstractComponentInfo)container, components);
        this.m_layout.setRemoveEmptyColumnsRows(true);
        this.m_layout.command_setCells(container, this.m_enclosingCells, true);
        GridDataInfo gridData = GridLayoutInfo.getGridData(container);
        gridData.setHorizontalAlignment(4);
        gridData.setVerticalAlignment(4);
        this.m_layout.command_normalizeSpanning();
    }

    static Rectangle getCells(ControlInfo control) throws Exception {
        GridDataInfo gridData = GridLayoutInfo.getGridData(control);
        return new Rectangle(gridData.x, gridData.y, gridData.width, gridData.height);
    }
}

