/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.macro.declaration;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.Collection;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend.core.macro.ConditionUtils;
import org.eclipse.xtend.core.macro.declaration.JvmClassDeclarationImpl;
import org.eclipse.xtend.core.xtend.XtendFile;
import org.eclipse.xtend.lib.macro.declaration.ClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.CompilationUnit;
import org.eclipse.xtend.lib.macro.declaration.ConstructorDeclaration;
import org.eclipse.xtend.lib.macro.declaration.FieldDeclaration;
import org.eclipse.xtend.lib.macro.declaration.InterfaceDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MemberDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableConstructorDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableFieldDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableInterfaceDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableMemberDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableMethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableTypeParameterDeclaration;
import org.eclipse.xtend.lib.macro.declaration.TypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.TypeParameterDeclaration;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.xbase.lib.CollectionExtensions;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.validation.ReadAndWriteTracking;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MutableJvmClassDeclarationImpl
extends JvmClassDeclarationImpl
implements MutableClassDeclaration {
    public void markAsRead() {
        CompilationUnit _compilationUnit = this.getCompilationUnit();
        ReadAndWriteTracking _readAndWriteTracking = _compilationUnit.getReadAndWriteTracking();
        JvmGenericType _delegate = (JvmGenericType)this.getDelegate();
        _readAndWriteTracking.markReadAccess((EObject)_delegate);
    }

    public MutableMethodDeclaration findDeclaredMethod(String name, TypeReference ... parameterTypes) {
        MethodDeclaration _findDeclaredMethod = super.findDeclaredMethod(name, parameterTypes);
        return (MutableMethodDeclaration)_findDeclaredMethod;
    }

    public MutableFieldDeclaration findDeclaredField(String name) {
        FieldDeclaration _findDeclaredField = super.findDeclaredField(name);
        return (MutableFieldDeclaration)_findDeclaredField;
    }

    public MutableConstructorDeclaration findDeclaredConstructor(TypeReference ... parameterTypes) {
        ConstructorDeclaration _findDeclaredConstructor = super.findDeclaredConstructor(parameterTypes);
        return (MutableConstructorDeclaration)_findDeclaredConstructor;
    }

    @Override
    public Iterable<? extends MutableMethodDeclaration> getDeclaredMethods() {
        Iterable<MethodDeclaration> _declaredMethods = super.getDeclaredMethods();
        return _declaredMethods;
    }

    @Override
    public Iterable<? extends MutableFieldDeclaration> getDeclaredFields() {
        Iterable<FieldDeclaration> _declaredFields = super.getDeclaredFields();
        return _declaredFields;
    }

    @Override
    public Iterable<? extends MutableClassDeclaration> getDeclaredClasses() {
        Iterable<ClassDeclaration> _declaredClasses = super.getDeclaredClasses();
        return _declaredClasses;
    }

    @Override
    public Iterable<? extends MutableConstructorDeclaration> getDeclaredConstructors() {
        Iterable<ConstructorDeclaration> _declaredConstructors = super.getDeclaredConstructors();
        return _declaredConstructors;
    }

    @Override
    public Iterable<? extends MutableInterfaceDeclaration> getDeclaredInterfaces() {
        Iterable<InterfaceDeclaration> _declaredInterfaces = super.getDeclaredInterfaces();
        return _declaredInterfaces;
    }

    public MutableTypeDeclaration getDeclaringType() {
        TypeDeclaration _declaringType = super.getDeclaringType();
        return (MutableTypeDeclaration)_declaringType;
    }

    @Override
    public Iterable<? extends MutableMemberDeclaration> getDeclaredMembers() {
        Iterable<MemberDeclaration> _declaredMembers = super.getDeclaredMembers();
        return _declaredMembers;
    }

    public Iterable<? extends MutableTypeParameterDeclaration> getTypeParameters() {
        Iterable<? extends TypeParameterDeclaration> _typeParameters = super.getTypeParameters();
        return _typeParameters;
    }

    public void setStrictFloatingPoint(boolean isStrictFloatingPoint) {
        JvmGenericType _delegate = (JvmGenericType)this.getDelegate();
        _delegate.setStrictFloatingPoint(isStrictFloatingPoint);
    }

    public void setAbstract(boolean isAbstract) {
        JvmGenericType _delegate = (JvmGenericType)this.getDelegate();
        _delegate.setAbstract(isAbstract);
    }

    public void setFinal(boolean isFinal) {
        JvmGenericType _delegate = (JvmGenericType)this.getDelegate();
        _delegate.setFinal(isFinal);
    }

    public void setStatic(boolean isStatic) {
        JvmGenericType _delegate = (JvmGenericType)this.getDelegate();
        _delegate.setStatic(isStatic);
    }

    public void setExtendedClass(TypeReference superclass) {
        boolean _notEquals_1;
        boolean _notEquals;
        ConditionUtils.checkInferredTypeReferences("extended class", superclass);
        JvmTypeReference _xifexpression = null;
        boolean bl = _notEquals = !Objects.equal((Object)superclass, null);
        if (_notEquals) {
            CompilationUnit _compilationUnit = this.getCompilationUnit();
            _xifexpression = _compilationUnit.toJvmTypeReference(superclass);
        } else {
            CompilationUnit _compilationUnit_1 = this.getCompilationUnit();
            TypeReferences _typeReferences = _compilationUnit_1.getTypeReferences();
            CompilationUnit _compilationUnit_2 = this.getCompilationUnit();
            XtendFile _xtendFile = _compilationUnit_2.getXtendFile();
            _xifexpression = _typeReferences.getTypeForName(Object.class, (Notifier)_xtendFile, new JvmTypeReference[0]);
        }
        JvmTypeReference newTypeRef = _xifexpression;
        JvmGenericType _delegate = (JvmGenericType)this.getDelegate();
        EList _superTypes = _delegate.getSuperTypes();
        Functions.Function1<JvmTypeReference, Boolean> _function = new Functions.Function1<JvmTypeReference, Boolean>(){

            public Boolean apply(JvmTypeReference it) {
                JvmType _type_1;
                boolean _isInterface;
                boolean _not;
                boolean _and = false;
                JvmType _type = it.getType();
                _and = !(_type instanceof JvmGenericType) ? false : (_not = !(_isInterface = ((JvmGenericType)(_type_1 = it.getType())).isInterface()));
                return _and;
            }
        };
        JvmTypeReference oldType = (JvmTypeReference)IterableExtensions.findFirst((Iterable)_superTypes, (Functions.Function1)_function);
        boolean bl2 = _notEquals_1 = !Objects.equal((Object)oldType, null);
        if (_notEquals_1) {
            JvmGenericType _delegate_1 = (JvmGenericType)this.getDelegate();
            EList _superTypes_1 = _delegate_1.getSuperTypes();
            _superTypes_1.remove((Object)oldType);
        }
        JvmGenericType _delegate_2 = (JvmGenericType)this.getDelegate();
        EList _superTypes_2 = _delegate_2.getSuperTypes();
        _superTypes_2.add((Object)newTypeRef);
    }

    public void setImplementedInterfaces(Iterable<? extends TypeReference> superInterfaces) {
        ConditionUtils.checkIterable(superInterfaces, "superIntefaces");
        ConditionUtils.checkInferredTypeReferences("implemented interface", (TypeReference[])Conversions.unwrapArray(superInterfaces, TypeReference.class));
        JvmGenericType _delegate = (JvmGenericType)this.getDelegate();
        EList _superTypes = _delegate.getSuperTypes();
        Functions.Function1<JvmTypeReference, Boolean> _function = new Functions.Function1<JvmTypeReference, Boolean>(){

            public Boolean apply(JvmTypeReference it) {
                boolean _and = false;
                JvmType _type = it.getType();
                if (!(_type instanceof JvmGenericType)) {
                    _and = false;
                } else {
                    boolean _isInterface;
                    JvmType _type_1 = it.getType();
                    _and = _isInterface = ((JvmGenericType)_type_1).isInterface();
                }
                return _and;
            }
        };
        Iterable oldInterfaces = IterableExtensions.filter((Iterable)_superTypes, (Functions.Function1)_function);
        JvmGenericType _delegate_1 = (JvmGenericType)this.getDelegate();
        EList _superTypes_1 = _delegate_1.getSuperTypes();
        CollectionExtensions.removeAll((Collection)_superTypes_1, (Iterable)oldInterfaces);
        JvmGenericType _delegate_2 = (JvmGenericType)this.getDelegate();
        EList _superTypes_2 = _delegate_2.getSuperTypes();
        Functions.Function1<TypeReference, JvmTypeReference> _function_1 = new Functions.Function1<TypeReference, JvmTypeReference>(){

            public JvmTypeReference apply(TypeReference it) {
                CompilationUnit _compilationUnit = MutableJvmClassDeclarationImpl.this.getCompilationUnit();
                return _compilationUnit.toJvmTypeReference(it);
            }
        };
        Iterable _map = IterableExtensions.map(superInterfaces, (Functions.Function1)_function_1);
        Iterables.addAll((Collection)_superTypes_2, (Iterable)_map);
    }

    public MutableTypeParameterDeclaration addTypeParameter(String name, TypeReference ... upperBounds) {
        ConditionUtils.checkJavaIdentifier(name, "name");
        ConditionUtils.checkIterable((Iterable)Conversions.doWrapArray((Object)upperBounds), "upperBounds");
        ConditionUtils.checkInferredTypeReferences("parameter type", upperBounds);
        JvmTypeParameter param = TypesFactory.eINSTANCE.createJvmTypeParameter();
        param.setName(name);
        JvmGenericType _delegate = (JvmGenericType)this.getDelegate();
        EList _typeParameters = _delegate.getTypeParameters();
        _typeParameters.add((Object)param);
        TypeReference[] typeReferenceArray = upperBounds;
        int n = upperBounds.length;
        int n2 = 0;
        while (n2 < n) {
            TypeReference upper = typeReferenceArray[n2];
            CompilationUnit _compilationUnit = this.getCompilationUnit();
            JvmTypeReference typeRef = _compilationUnit.toJvmTypeReference(upper);
            JvmUpperBound jvmUpperBound = TypesFactory.eINSTANCE.createJvmUpperBound();
            jvmUpperBound.setTypeReference(typeRef);
            EList _constraints = param.getConstraints();
            _constraints.add((Object)jvmUpperBound);
            ++n2;
        }
        CompilationUnit _compilationUnit = this.getCompilationUnit();
        TypeParameterDeclaration _typeParameterDeclaration = _compilationUnit.toTypeParameterDeclaration(param);
        return (MutableTypeParameterDeclaration)_typeParameterDeclaration;
    }
}

